# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LiDARForestryHeight
                                 A QGIS plugin. LiDAR Forestry Height 
                                 generates a DEM with the forest height, 
                                 calculated from a classified LiDAR point
                                 cloud using LasPy Library
                                 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-09-24
        copyright            : (C) 2019 by PANOimagen S.L.
        email                : info@panoimagen.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from __future__ import unicode_literals

import os
import tempfile

class DirAndPaths(object):
    
    def __init__(self, file_name, out_path):
    
        self.base_name, _ = os.path.splitext(file_name)
        self.file_templates(self.base_name)
        self.out_path = out_path
        self.set_temp_dir()
        self.set_output_dir()
        
        
    def file_templates (self, base_name):
        
        self.templates = {'las_raw': '{}_raw.las',
                          'las_terrain': '{}_terrain.las',
                          'las_surfaces': '{}_surfaces.las',
                          'dtm': '{}_terrain_dem.tif',
                          'dsm': '{}_surfaces_dem.tif',
                          'height': '{}_heights_dem.tif'}
    
    def set_temp_dir(self):
    
        self.temp_dirs = {}
        self.temp_full_paths = {}
        
        self.temp_dirs['temp_dir'] = tempfile.mkdtemp()
        
        self.temp_full_paths['las_raw'] = os.path.join(
            self.temp_dirs['temp_dir'], 
            self.templates['las_raw'].format(self.base_name))
        
        self.temp_full_paths['las_terrain'] = os.path.join(
            self.temp_dirs['temp_dir'], 
            self.templates['las_terrain'].format(self.base_name))
        
        self.temp_full_paths['las_surfaces'] = os.path.join(
            self.temp_dirs['temp_dir'], 
            self.templates['las_surfaces'].format(self.base_name))
            
    def create_dir(self, directory):
        """Create the specified folder
        """
        if not os.path.exists(directory):
            os.makedirs(directory)

    def remove_temp_file(self, full_path):
        """Remove the specified file
        """
        if os.path.exists(full_path):
            os.remove(full_path)
            
    def remove_temp_dir(self, directory):
        """Remove the specified folder
        """
        if os.path.exists(directory):
            os.rmdir(directory)
    
    def set_output_dir(self):
        
        self.out_dirs = {}
        self.out_paths = {}
        
        intermediate_folder = os.path.join(self.out_path, 'intermediate_results')       
        
        self.out_dirs['las'] = os.path.join(intermediate_folder, 'las')
        self.out_dirs['dem'] = os.path.join(intermediate_folder, 'dem')
        self.out_dirs['height'] = self.out_path
        
        self.out_paths['las_raw'] = os.path.join(self.out_dirs['las'],
            self.templates['las_raw'].format(self.base_name))
        
        self.out_paths['las_terrain'] = os.path.join(self.out_dirs['las'],
            self.templates['las_terrain'].format(self.base_name))
        
        self.out_paths['las_surfaces'] = os.path.join(self.out_dirs['las'],
            self.templates['las_surfaces'].format(self.base_name))
        
        self.out_paths['dtm'] = os.path.join(self.out_dirs['dem'],
            self.templates['dtm'].format(self.base_name))
        
        self.out_paths['dsm'] = os.path.join(self.out_dirs['dem'],
            self.templates['dsm'].format(self.base_name))
            
        self.out_paths['height'] = os.path.join(self.out_dirs['height'],
               self.templates['height'].format(self.base_name))