# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LiDARForestryHeight
                                 A QGIS plugin. LiDAR Forestry Height 
                                 generates a DEM with the forest height, 
                                 calculated from a classified LiDAR point
                                 cloud using LasPy Library
                                 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-09-24
        copyright            : (C) 2019 by PANOimagen S.L.
        email                : info@panoimagen.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDialog

import platform
import os

try:
    from . import version
except ImportError:
    class version(object):
        VERSION = "devel"

uiFilePath = os.path.abspath(
        os.path.join(os.path.dirname(__file__), 'dlgabout.ui'))
FormClass = uic.loadUiType(uiFilePath)[0]

class DlgAbout(QDialog, FormClass):

    def __init__(self, parent=None):
        QDialog.__init__(self, parent)
        self.setupUi(self)

        repo_url = (u'<address><b>https://github.com/PANOimagen/LiDARForestryHeight' +
                    u'</address></b>')

        tracker_url = (u'<address><b>https://github.com/PANOimagen/LiDARForestryHeight' +
                       u'</address></b><br>')

        panoi_url = u'<address><b>www.panoimagen.com</address></b><br>'
        
        repository_info = (u'Code repository: {}<br>Bug Tracker: {}'.format(
                repo_url, tracker_url))
        
        contact_info = (u'<h3>Copyright (C) 2019  by PANOimagen S.L.</h3>' +
                        u'PANOimagen S.L. La Rioja (Spain) -- {}'.format(
                                panoi_url))
                                
        plugin_description = ('This plugin has being developed by PANOimagen' +
                              u' S.L. and serves to generate DEM with the height' +
                              u' of forests<br>stands. This calculation is done' +
                              u' by the difference between a DSM and a DTM' +
                              u' (Digital Surface Model and Digital<br>Terrain Model' +
                              u' respectively).\nFor more' +
                              u' information, please, read metadata/' +
                              u'readme and/or contact the author.')
        
        external_dependencies = ('This plugin needs the <b> LasPy Library' +
                                 u'</b> for LiDAR processing, see the' + 
                                 u' corresponding licenses:<br>' +
                                 u'<b>LasPy Library</b> (BSD License):<b><address>' +
                                 u'https://github.com/laspy/laspy' +
                                 u'</address></b><br>' +
                                 u'<br>' +
                                 u' The plugin uses <b>LasZip</b> to uncompress' +
                                 u' laz files. See the' + 
                                 u' corresponding licenses:<br>' +
                                 u'<b>LasZip Library</b> (LGPL License):<b><address>' +
                                 u'https://laszip.org/')
        
        license_info = (u'<h3>License:' +
                        u'</h3>This program is free software' +
                        u' you can redistribute it and/or modify it under' +
                        u' the terms of the GNU General<br>Public License as' +
                        u' published by the Free Software Foundation, either' +
                        u' version 3 of the License, or (at your<br>option)' +
                        u' any later version.<br><br>This program is' +
                        u' distributed in the hope that it will be useful,' +
                        u' but WITHOUT ANY WARRANTY; without even<br>the' +
                        u' implied warranty of MERCHANTABILITY or FITNESS' +
                        u' FOR A PARTICULAR PURPOSE.  See the GNU General' +
                        u'<br>Public License for more details.<br><br>' +
                        u'You should have received a copy of the GNU' +
                        u' General Public License along with this program.' +
                        u' If not, see:<br><address><b>https://www.gnu.org/' +
                        u'licenses/</address></b>.')        
        self.codeRepoLabel.setText(repository_info)
        self.contactLabel.setText(contact_info)
        self.descriptionLabel.setText(plugin_description)
        self.libraryUsedLabel.setText(external_dependencies)
        self.licenseLabel.setText(license_info)
        self.versionLabel.setText(u'<h2>LiDAR Forestry Height<\h2>' +
                                  u' Version {}'.format(
                                          version.VERSION))