# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LecoS
                                 A QGIS plugin
 Contains analytical functions for landscape analysis
                             -------------------
        begin                : 2012-09-06
        copyright            : (C) 2012 by Martin Jung
        email                : martinjung@zoho.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.core import *
from qgis.gui import *
from qgis.analysis import *

# import Ui
from ui.dlg_landscapestatistics import Ui_Lecos
#from ui.dlg_LCoverPerFeature import Ui_BatchCover
from ui.dlg_DiversityDialog import Ui_DivDialog
# Import functions and metrics
import lecos_functions as func
import landscape_statistics as lcs

# Check if dependencies can be loaded
try:
    import numpy, scipy, gdal, ogr
except ImportError:
    QMessageBox.warning( self, self.tr( "LecoS: Warning" ),
                           self.tr( "For this plugin to run please install the python modules 'numpy', 'scipy','gdal' and 'ogr'" ) )
import subprocess              
from os import path

# create the dialog controls and set up the user interface from Designer.
class LecosDialog(QDialog, Ui_Lecos):
    def __init__(self, iface):
        # Initialize the Dialog
        QDialog.__init__( self )
        self.setupUi(self)
        self.iface = iface
        
        # Get and set current pixelsize
        if self.cbRaster.currentIndex() == -1:
            self.sp_cellsize.setEnabled( False )
        else:
            self.sp_cellsize.setEnabled( True )
            self.cellSizer( self.cbRaster.currentText() )
        
        #Change on Rasterfile
        QObject.connect( self.cbRaster, SIGNAL( "currentIndexChanged( QString )" ), self.cellSizer)
                        
        # Save File
        QObject.connect( self.where2Save, SIGNAL( "clicked()" ), self.selectSaveFile )
        QObject.connect( self.rbDirect, SIGNAL( "clicked()" ), self.savetoggle )
        QObject.connect( self.rbSAVE, SIGNAL( "clicked()" ), self.savetoggle )


        # Change on Metric-Tabs
        QObject.connect( self.SingleMetric, SIGNAL( "currentIndexChanged( QString )" ), self.showFunctionHelp)
        QObject.connect( self.btn_right, SIGNAL( "clicked()" ), self.switchR )
        QObject.connect( self.btn_left, SIGNAL( "clicked()" ), self.switchL )
        QObject.connect( self.SelectAll, SIGNAL( "stateChanged( int )" ), self.SelectAllInListL )
        QObject.connect( self.SelectAll_2, SIGNAL( "stateChanged( int )" ), self.SelectAllInListR )

        
        # Button box 
        QObject.connect( self.btn_About, SIGNAL( "clicked()" ), self.showAbout )
        self.AcceptButton = self.bt_Accept.button( QDialogButtonBox.Ok )
        self.closeButton = self.bt_Accept.button( QDialogButtonBox.Cancel )
        
        # Manage current Raster-Layers
        self.Startup()
    
    # Shows the help for a single function
    def showFunctionHelp( self, name ):
        #self.SingleMetricHelp.clear()
        text = lcs.returnHelp(name,self.SingleMetricHelp)

    # Update Cellsize if a valid raster-file is selected
    def cellSizer( self, rasterName ):
        if rasterName != -1:
            pixelSize = func.getRasterLayerByName( rasterName ).rasterUnitsPerPixel()
            self.sp_cellsize.setEnabled( True )
            self.sp_cellsize.setValue( pixelSize )        
    
    # Save radio button
    def savetoggle( self ):
        if self.rbDirect.isChecked():
            self.SaveCsv.setEnabled( False )
            self.where2Save.setEnabled( False )
        elif self.rbSAVE.isChecked():
            self.SaveCsv.setEnabled( True )
            self.where2Save.setEnabled( True )
        
    # Where to save the csv
    def selectSaveFile( self ):   
        lastUsedDir = func.lastUsedDir()
        fileName = QFileDialog.getSaveFileName( self, self.tr( "Save data as" ),\
        lastUsedDir, "CSV files (*.csv *.CSV)" )
        if fileName.isEmpty():
            return
        func.setLastUsedDir( fileName )
        # ensure the user never ommited the extension from the file name
        if not fileName.toLower().endsWith( ".csv" ):
            fileName += ".csv"
        self.SaveCsv.setText( fileName )
        self.SaveCsv.setEnabled( True ) 
        
    # Manage Layout and startup parameters
    def Startup( self ):
        # Unable unused fields
        self.SaveCsv.setEnabled( False )
        self.where2Save.setEnabled( False )
        self.SingleMetricHelp.setEnabled( False )
        
        # Load in raster files
        self.cbRaster.addItems( func.getRasterLayersNames() )
        
        # Display functions
        self.SingleMetric.addItems( lcs.listStatistics() )
        self.showFunctionHelp( self.SingleMetric.currentText() )
        self.list_left.addItems( lcs.listStatistics() )
        self.rlistCounter.setText( str(self.list_left.count()) )
        self.rlistCounter_2.setText( str(self.list_right.count()) )
        
        self.MetricTab.setCurrentIndex( 0 ) # Startup on single metric tab
        self.MetricTab.setTabEnabled(2,False) # Disable Custom Tab
        
    # Switch Items on the several Metric Tab to the Right
    def switchR( self ):
        items = self.list_left.selectedItems()
        for item in items:
            n = self.list_left.row(item)    # get the index/row of the item
            i = self.list_left.takeItem(n)  # pop
            self.list_right.addItem(i)      # add to right QListWidget
            self.list_left.removeItemWidget( item ) # remove from left QListWidget
            #update counter
        self.rlistCounter.setText( str(self.list_left.count()) )
        self.rlistCounter_2.setText( str(self.list_right.count()) )
                
    # Switch Items on the several Metric Tab to the Left
    def switchL( self ):
        items = self.list_right.selectedItems()
        for item in items:
            n = self.list_right.row(item)    # get the index/row of the item
            i = self.list_right.takeItem(n)  # pop
            self.list_left.addItem(i)      # add to left QListWidget
            self.list_right.removeItemWidget( item ) # remove from right QListWidget
            #update counter
        self.rlistCounter.setText( str(self.list_left.count()) )
        self.rlistCounter_2.setText( str(self.list_right.count()) )

    # Select all Items in left List
    def SelectAllInListL ( self, state ):
        if state == Qt.Checked:
            allitems = self.list_left.findItems("*", Qt.MatchWrap | Qt.MatchWildcard)
            for item in allitems:
                item.setSelected( True )
        elif state == Qt.Unchecked:
            self.list_left.clearSelection()
                    
    # Select all Items in right List
    def SelectAllInListR ( self, state ):
        if state == Qt.Checked:
            allitems = self.list_right.findItems("*", Qt.MatchWrap | Qt.MatchWildcard)
            for item in allitems:
                item.setSelected( True )        
        elif state == Qt.Unchecked:
            self.list_right.clearSelection()
    
    # Show About Dialog
    def showAbout( self ):
        func.AboutDlg()
    
    # Accept current selection and metric
    def accept( self ):
        # check minimal input parameters
        if self.cbRaster.currentIndex() == -1:
            QMessageBox.warning( self, self.tr( "LecoS: Warning" ),
                           self.tr( "Please load a classified landcover layer into QGis first" ) )
            return
        if self.rbSAVE.isChecked():
            if self.SaveCsv.text().isEmpty():
                QMessageBox.warning( self, self.tr( "LecoS: Warning" ),
                            self.tr( "Please select where to save the results" ) )
                return
            if path.exists(self.SaveCsv.text()):
                QMessageBox.warning( self, self.tr( "LecoS: Warning" ),
                            self.tr( "File already exisits. Please select another path or delete file" ) )
                return
        if self.sp_cellsize.value() == 0:
            QMessageBox.warning( self, self.tr( "LecoS: Warning" ),
                           self.tr( "Please entry a correct cellsize (greater zero)" ) )
            return
        
        # Values and Preset
        self.progressBar.setRange( 0, 4)
        self.progressBar.setValue( 0 ) # pb start
        raster = func.getRasterLayerByName( self.cbRaster.currentText() )
        rasterPath = raster.source()
        dataPath = self.SaveCsv.text()
        cellsize = self.sp_cellsize.value()
            
        ## Calculate Single, several or custom metric
        what = self.MetricTab.currentIndex()
        # Single
        if(what == 0):
            if len(self.SingleMetric.currentText()) >= 5:
                classes, array = lcs.f_landcover(rasterPath)
                self.progressBar.setValue( self.progressBar.value() + 1 )
                # Looping through all classes
                res = []
                res_tit = ["Class"]
                for cl in classes:
                    cl_array = numpy.copy(array) # new working array
                    cl_array[array!=cl] = 0
                    labeled_array, num_features = lcs.f_ccl(cl_array)
                    name, result = lcs.execSingleMetric(self.SingleMetric.currentText(),array,labeled_array,num_features,cellsize,cl)
                    
                    self.progressBar.setValue( self.progressBar.value() + 1 )
                    # Append Values to result class and table name array
                    r = [cl, result]
                    if len(res) == 0:
                        res.append(r)
                    else:
                        no_class_in_array = True
                        for id, item in enumerate(res):
                            if item[0] == cl:
                                res[id].append(result)
                                no_class_in_array = False
                        if no_class_in_array:
                            res.append(r)
                            
                    if res_tit.count(name) == 0:
                        res_tit.append(name)
            else:
                QMessageBox.warning( self, self.tr( "LecoS: Warning" ),
                           self.tr( "Please select a valid single metric" ) )

        # Several
        elif(what == 1):
            metrics = []
            allitems = self.list_right.findItems("*", Qt.MatchWrap | Qt.MatchWildcard)
            if len(allitems)==0:
                QMessageBox.warning( self, self.tr( "LecoS: Warning" ), self.tr( "Please select at least one item from the left list" ) )
                return
            for item in allitems:
                metrics.append(unicode(item.text()))
            classes, array = lcs.f_landcover(rasterPath)
            self.progressBar.setValue( self.progressBar.value() + 1 )
            # Looping through all classes
            res = []
            res_tit = ["Class"]
            for m in metrics:
                for cl in classes:
                    cl_array = numpy.copy(array) # new working array
                    cl_array[array!=cl] = 0
                    labeled_array, num_features = lcs.f_ccl(cl_array)
                    name, result = lcs.execSingleMetric(m,array,labeled_array,num_features,cellsize,cl)
                        
                    self.progressBar.setValue( self.progressBar.value() + 1 )
                    # Append Values to result class and table name array
                    r = [cl, result]
                    if len(res) == 0:
                        res.append(r)
                    else:
                        no_class_in_array = True
                        for id, item in enumerate(res):
                            if item[0] == cl:
                                res[id].append(result)
                                no_class_in_array = False
                        if no_class_in_array:
                            res.append(r)
                            
                    if res_tit.count(name) == 0:
                        res_tit.append(name)
            
        # Custom
        elif(what == 2):
            # TODO: Create Custom GUI surface
            pass
        
        self.progressBar.setValue( self.progressBar.value() + 1 )
        # Write results
        if self.rbSAVE.isChecked():
            func.saveToCSV(res,res_tit,dataPath)
        else:
            func.ShowResultTableDialog(res_tit, res)
        self.progressBar.setValue( self.progressBar.value() + 1 )
        self.close()
        
# Gui for displaying certain diversity indices
class DivDialog(QDialog, Ui_DivDialog):
    def __init__(self, iface):
        # Initialize the Dialog
        QDialog.__init__( self )
        self.setupUi(self)
        self.iface = iface
        
        # Add Diversity Indices
        self.div = ["Shannon Index","Simpson Index", "Eveness"]
        self.cbDivselect.addItems( self.div )
        
        # Configure Connectors
        self.AcceptButton = self.btn_ok.button( QDialogButtonBox.Ok )
        self.closeButton = self.btn_ok.button( QDialogButtonBox.Cancel )
        QObject.connect( self.AcceptButton, SIGNAL( "clicked()" ), self.go )
        
        self.startup()
    
    # Configure GUI
    def startup(self):
        # Load in raster files
        self.cbRaster.addItems( func.getRasterLayersNames() )
    
    # Calculates Diversity indices    
    def go(self):
        if self.cbRaster.currentIndex() == -1:
            QMessageBox.warning( self, self.tr( "DivDialog: Warning" ),
                           self.tr( "Please load and select a classified raster first" ) )
            return
        raster = func.getRasterLayerByName( self.cbRaster.currentText() )
        rasterPath = raster.source()
        seldiv = unicode( self.cbDivselect.currentText() )
        classes, array = lcs.f_landcover(rasterPath)
        nodata = lcs.f_returnNoDataValue(rasterPath)
        if seldiv == "Shannon Index":
            r = lcs.f_returnDiversity( array, classes, nodata, "shannon")
        elif seldiv == "Simpson Index":
            r = lcs.f_returnDiversity( array, classes, nodata, "simpson")
        elif seldiv == "Eveness":
            r = lcs.f_returnDiversity( array, classes, nodata, "eveness")
        
        self.output(r,seldiv)
    
    # Creates a small output dialog
    def output(self, result, index):
        dlg = QDialog()
        dlg.setWindowTitle( QApplication.translate( "Diversity Results", "Results", "Window title" ) )
        lines = QVBoxLayout( dlg )
        lab = QLabel( QApplication.translate( "Diversity Results", "<b>Results for "+index+":</b>" ) )
        lines.addWidget( lab )
        res = QLineEdit()
        res.setText(str(result))
        lines.addWidget( res )

        btnClose = QPushButton( QApplication.translate( "Diversity Results", "Close" ) )
        lines.addWidget( btnClose )
        QObject.connect( btnClose, SIGNAL( "clicked()" ), dlg, SLOT( "close()" ) )

        dlg.exec_()

# Gui for batch computing Landcover for vector features
"""
class BatchDialog(QDialog, Ui_BatchCover):
    def __init__(self, iface):
        # Initialize the Dialog
        QDialog.__init__( self )
        self.setupUi(self)
        self.iface = iface

        # Connects
        QObject.connect( self.cb_Raster, SIGNAL( "currentIndexChanged( QString )" ), self.cellsizer)
        QObject.connect( self.cb_Raster, SIGNAL( "currentIndexChanged( QString )" ), self.loadClasses)
        QObject.connect( self.cb_Vector, SIGNAL( "currentIndexChanged( QString )" ), self.featureCount)

        # Button box 
        self.AcceptButton = self.startButtons.button( QDialogButtonBox.Ok )
        QObject.connect( self.AcceptButton, SIGNAL( "clicked()" ), self.go )
        self.closeButton = self.startButtons.button( QDialogButtonBox.Cancel )
        
        #Startup
        self.startup()
    
    # Startup function
    def startup(self):
         # Load in raster and vector files
        vec = [""] + func.getVectorLayersNames()
        ras = [""] + func.getRasterLayersNames()
        self.cb_Raster.addItems( ras )
        self.cb_Vector.addItems( vec )
        
        # Set Class Labels and boxes invisible
        self.classLabel.setVisible( False )
        self.header1.setVisible( False )
        self.header2.setVisible( False )

    
    # Resets the cellsizer
    def cellsizer(self, rasterName):
        if rasterName != "":
            pixelSize = func.getRasterLayerByName( rasterName ).rasterUnitsPerPixel()
            self.sp_cellsizer.setEnabled( True )
            self.sp_cellsizer.setValue( pixelSize )
    
    # Get Raster classes
    def loadClasses(self, rasterName):
        if rasterName != "":
             # Set Class Labels and boxes invisible
            self.classLabel.setVisible( True )
            self.header1.setVisible( True )
            self.header2.setVisible( True )
            self.raster = func.getRasterLayerByName( rasterName )
            self.rasterPath = self.raster.source()
            self.classes, self.array = lcs.f_landcover(self.rasterPath)
            self.position = 0
            for cl in self.classes:
                classSP = QSpinBox()    
                classSP.setValue(int(cl))
                classSP.setEnabled( False )
                className = QLineEdit()
                className.setText(str(cl)+"_Cover")
                self.classGrid.addWidget(classSP,self.position,0)
                self.classGrid.addWidget(className,self.position,1)
                self.position += 1
        else:
            # Set Class Labels and boxes invisible
            self.classLabel.setVisible( False )
            self.header1.setVisible( False )
            self.header2.setVisible( False )
            for i in range(self.classGrid.count()): self.classGrid.itemAt(i).widget().close()
            self.position = 0
            
            
            
    # Show feature count
    def featureCount(self, vectorName):
        if vectorName != "":
            # Load vector data
            self.vector = func.getVectorLayerByName( self.cb_Vector.currentText() )
            self.vectorPath = self.vector.source()
            nf = self.vector.featureCount()
            self.ch_selected.setText("loop through features ("+str(nf)+")")
        else:
            self.ch_selected.setText("loop through features (0)")

    
    # Runs the routine
    def go(self):
        if self.cb_Raster.currentIndex() == 0:
            QMessageBox.warning( self, self.tr( "Batch computing: Warning" ),
                           self.tr( "Please load and select a classified raster first" ) )
            return
        if self.cb_Vector.currentIndex() == 0:
            QMessageBox.warning( self, self.tr( "Batch computing: Warning" ),
                           self.tr( "Please load and select a vector shape" ) )
            return
        
        #ext = self.vector.extent() 
        #t = (ext.xMinimum(),ext.yMinimum(),ext.xMaximum(),ext.yMaximum())
        #lcs.f_MaskPolygonAsRaster(t,self.vectorPath,self.rasterPath,1,"2")
        #return
        
        if not self.ch_selected.isChecked():
            for cl in self.classes:
                ext = self.vector.extent() 
                t = (ext.xMinimum(),ext.yMinimum(),ext.xMaximum(),ext.yMaximum())
                masked_array = lcs.f_MaskPolygonAsRaster(t,self.vectorPath,self.rasterPath,cl)
                cl_array = numpy.copy(self.array) # new working array
                eq_arr = numpy.equal(cl_array,masked_array)
                cl_array[cl_array!=int(cl)] = 0
                cl_array[eq_arr] = 0
                res_array = cl_array + masked_array
                #print cl_shape, masked_array.shape
                #print "count:",numpy.count_nonzero(cl_array), numpy.count_nonzero(res_array)
                print "unique:",numpy.unique(masked_array), numpy.unique(res_array)
                print cl, float(numpy.sum(res_array[res_array==cl+1])) #/ float(numpy.count_nonzero(res_array))
                #49268 = 1
        else:
            provider = self.vector.dataProvider()
            feat = QgsFeature()
            allAttrs = provider.attributeIndexes()
            provider.select(allAttrs)
            while provider.nextFeature(feat):
                geom = feat.geometry()
                ext = geom.boundingBox()  #get bounding box as QgsRectangle
                t = (ext.xMinimum(),ext.yMinimum(),ext.xMaximum(),ext.yMaximum())
                for cl in self.classes:
                    masked_array = lcs.f_MaskPolygonAsRaster(t,self.vectorPath,self.rasterPath,1)
                    cl_array = numpy.copy(self.array) # new working array
                    cl_array[cl_array!=int(cl)] = 0
                    cl_array[cl_array != masked_array] = 0
                    labeled_array, num_features = lcs.f_ccl(cl_array)
                    res_array = labeled_array + masked_array
                    
                    print numpy.unique(masked_array), numpy.count_nonzero(masked_array)
                    #print numpy.unique(res_array)
                    #print cl, float(numpy.sum(res_array[res_array==cl+1])) #/ float(numpy.count_nonzero(res_array))
    
                    
                    
        #for line, cl in enumerate(self.classes):
        #    
        #    # Add class to vector attribute table
        #    cl_fieldname = self.classGrid.itemAtPosition(line,1).widget.text()
        #    self.vector.addAttribute(cl_fieldname,"Real")
"""
