# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LecoS
                                 A QGIS plugin
 Contains analytical functions for landscape analysis
                              -------------------
        begin                : 2012-09-06
        copyright            : (C) 2012 by Martin Jung
        email                : martinjung@zoho.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources_rc.py
from ui import resources_rc
# Import the code for the dialogs
from lecos_dlg import LecosDialog
# Import small Div Dialog
from lecos_dlg import DivDialog

# Import functions for about Dialog
import lecos_functions as func

class LecoS( object ):
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        
        # initialize plugin directory
        self.plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins/LecoS"

    def initGui(self):
        # Create action that will start the LecoS Plugin
        self.actionLecoS = QAction(QIcon(self.plugin_dir+"/icons/icon.png"),\
            u"Land cover statistics", self.iface.mainWindow())
        QObject.connect(self.actionLecoS, SIGNAL("triggered()"), self.run)
                      
        # Create action for small diversity dialog
        self.actionDivDlg = QAction(QIcon(self.plugin_dir+"/icons/icon_diversity.png"),\
            u"Diversity indices for Raster", self.iface.mainWindow())
        QObject.connect(self.actionDivDlg, SIGNAL("triggered()"), self.runDiv)
        
        # Create action for about dialog
        self.actionAbout = QAction(QIcon(self.plugin_dir+"/icons/about.png"),\
            u"About", self.iface.mainWindow())
        QObject.connect(self.actionAbout, SIGNAL("triggered()"), self.displayAboutDlg)
        
        # check if Raster menu available
        if hasattr(self.iface, "addPluginToRasterMenu"):
            # Raster menu and toolbar available
            self.iface.addRasterToolBarIcon(self.actionLecoS)
            self.iface.addRasterToolBarIcon(self.actionDivDlg)
            self.iface.addRasterToolBarIcon(self.actionAbout)
            self.iface.addPluginToRasterMenu("&Landscape Ecology", self.actionLecoS)
            self.iface.addPluginToRasterMenu("&Landscape Ecology", self.actionDivDlg)
            self.iface.addPluginToRasterMenu("&Landscape Ecology", self.actionAbout)
        else:
            # no menu, place plugin under Plugins menu and toolbox as usual
            self.iface.addToolBarIcon(self.actionLecoS)
            self.iface.addToolBarIcon(self.actionDivDlg)
            self.iface.addToolBarIcon(self.actionAbout)
            self.iface.addPluginToMenu(u"&Landscape Ecology", self.actionLecoS)
            self.iface.addPluginToMenu(u"&Landscape Ecology", self.actionDivDlg)
            self.iface.addPluginToMenu(u"&Landscape Ecology", self.actionAbout)
    
    def unload(self):
        # check if Raster menu available and remove our buttons from appropriate
        if hasattr(self.iface, "addPluginToRasterMenu"):
            self.iface.removePluginRasterMenu("&Landscape Ecology",self.actionLecoS)
            self.iface.removePluginRasterMenu("&Landscape Ecology",self.actionDivDlg)
            self.iface.removePluginRasterMenu("&Landscape Ecology",self.actionAbout)
            self.iface.removeRasterToolBarIcon(self.actionLecoS)
            self.iface.removeRasterToolBarIcon(self.actionDivDlg)
            self.iface.removeRasterToolBarIcon(self.actionAbout)
        else:
            # Remove the plugin menu item and icon
            self.iface.removePluginMenu(u"&Landscape Ecology",self.actionLecoS)
            self.iface.removePluginMenu(u"&Landscape Ecology",self.actionDivDlg)
            self.iface.removePluginMenu(u"&Landscape Ecology",self.actionAbout)
            self.iface.removeToolBarIcon(self.actionLecoS)
            self.iface.removeToolBarIcon(self.actionDivDlg)
            self.iface.removeToolBarIcon(self.actionAbout)

    # run method that performs all the real work
    def run(self):
        # create and show the dialog
        dlg = LecosDialog( self.iface )
        # show the dialog
        dlg.show()
        result = dlg.exec_()

    # Executes small Diversity gui
    def runDiv(self):
        dlg = DivDialog( self.iface )
        dlg.show()
        result = dlg.exec_()
    
    # Displays About Dialog
    def displayAboutDlg(self):
        func.AboutDlg()
    