# LayoutZoomPlugin

![License](https://img.shields.io/github/license/MostafaShiyari/LayoutZoomPlugin)
![Stars](https://img.shields.io/github/stars/MostafaShiyari/LayoutZoomPlugin?style=social)
![Release](https://img.shields.io/github/v/release/MostafaShiyari/LayoutZoomPlugin)

A powerful QGIS plugin for creating and editing map layouts with specific scale and position.

---

## 🧭 Overview

This plugin provides two main functionalities:

1. **Create new layouts** from templates with custom scales and center points  
2. **Edit existing layouts** by modifying map item scales and positions

---

## ✨ Features

- **Template-based Layout Creation:** Create new layouts from QGIS template files (`.qpt`)  
- **Existing Layout Editing:** Modify map items in existing project layouts  
- **Scale Management:** Set custom map scales with common presets  
- **Point Selection:** Interactive map point selection for center positioning  
- **Data-defined Scale Handling:** Automatic handling of data-defined scale overrides  
- **QGIS 3.x Compatible:** Works with QGIS version 3.0 and above  

---

## ⚙️ Installation

1. **Download the plugin files**  
2. Copy the plugin folder to your QGIS plugin directory:

   - **Windows:**  
     `C:\Users\[Username]\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\`
   - **Linux:**  
     `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
   - **macOS:**  
     `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`

3. Enable the plugin in QGIS:  
   `Plugins → Manage and Install Plugins → Installed`

---

## 🚀 Usage

### Create New Layout from Template
1. Click **"Create New Layout from Template"**  
2. Select a template from the list or browse for a `.qpt` file  
3. Choose a map item and set the desired scale  
4. Select the center point on the map  
✅ The layout will be created with your specifications.

### Edit Existing Layout
1. Click **"Edit Existing Layout"**  
2. Select a layout from your project  
3. Choose a map item to modify  
4. Set new scale and select center point  
✅ Changes will be applied immediately.

---

## 🧩 Requirements

- QGIS 3.0 or higher  
- Python 3.x  

---

## 🖼️ Screenshots
*(Add your screenshots here)*

---

## 🛠️ Support

For issues and feature requests, please create an issue in this repository.

---

## 📜 License

This plugin is released under the **MIT License**.
