# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CartoDBDialog
                                 A QGIS plugin
 CartoDB plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-03-19
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Jan Vrobel
        email                : vrobel.jan@seznam.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from PyQt5 import uic
from PyQt5 import QtWidgets, QtCore
from qgis.core import *
from PyQt5.QtGui import  QRegExpValidator,QBrush, QColor, QPixmap
from PyQt5.QtWidgets import QMessageBox, QTreeWidgetItemIterator, QTreeWidgetItem, QComboBox, QPushButton,  QDesktopWidget,  QCheckBox, QTableWidgetItem, QTableWidget, QButtonGroup, QLineEdit, QWidget, QVBoxLayout
from PyQt5.QtCore import QObject, pyqtSignal, Qt, QRegExp
from qgis.PyQt.QtCore import QPoint
import threading
import requests
import xml.etree.ElementTree as ET
import traceback
from .currentComposition import CurrentComposition
from .layman_utils import ProxyStyle
from distutils.version import LooseVersion
from .layman_qfield import Qfield   
from distutils.version import LooseVersion  



# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'dlg_currentComposition.ui'))

dialog_running = False
class CurrentCompositionDialog(QtWidgets.QDialog, FORM_CLASS):
    permissionInfo = pyqtSignal(bool,list, int)
    progressDone = pyqtSignal()
    progressStart = pyqtSignal()
    onRefreshCurrentForm = pyqtSignal()
    qfieldUpdate = pyqtSignal()
    def __init__(self,utils, isAuthorized, URI, layman, parent=None):
        """Constructor."""
        global dialog_running
        super(CurrentCompositionDialog, self).__init__(parent)
        if dialog_running:
            return
        dialog_running = True
        self.setObjectName("CurrentMapDialog")
        self.utils = utils
        self.isAuthorized = isAuthorized       
        self.URI = URI
        self.layman = layman
        self.pushButton_CreateCompositionConnected = False
        self.layerServices = {}
        app = QtWidgets.QApplication.instance() 
        main_window = self.layman.iface.mainWindow() 
        desktop = QDesktopWidget()
        screen_rect = desktop.screenGeometry(main_window)
        dialog_rect = self.frameGeometry()
        x = (screen_rect.width() - dialog_rect.width()) // 2
        y = (screen_rect.height() - dialog_rect.height()) // 2
        dialog_rect.moveTopLeft(screen_rect.topLeft() + QPoint(x-100, y))
        self.move(dialog_rect.topLeft())
        # set to top flag
        #self.setWindowFlags(self.windowFlags() | Qt.WindowStaysOnTopHint)        
        proxy_style = ProxyStyle(app.style())
        self.setStyle(proxy_style)
        self.setupUi(self)
        self.globalRead = {}
        self.globalWrite = {}  
        self.qfield = Qfield(self.utils)
        self.qfield.setURI(self.URI) 
        self.qfieldWorking = True
        self.setUi()
    
        
         
        
    def connectEvents(self):
        self.permissionInfo.connect(self.afterPermissionDone)
        self.progressDone.connect(self._onProgressDone)
        self.progressStart.connect(self._onProgressStart)
        self.onRefreshCurrentForm.connect(self.on_layers_removed) 
        self.qfieldUpdate.connect(self.UpdateQfield)

           
    def setStackWidget(self, option, refresh = True): 
        if option == "main":       
            self.page1.setVisible(True)
            self.page2.setVisible(False)
            self.page3.setVisible(False)
            self.page4.setVisible(False)
            self.page5.setVisible(False)
            if refresh:
                self.refreshCurrentForm()
            else:
                self.setVisibilityForCurrent(True)                
        if option == "permissions": 
            self.page1.setVisible(False)
            self.page2.setVisible(True)
            self.page3.setVisible(False)
            self.page4.setVisible(False)
            self.page5.setVisible(False)
            self.setPermissionsUI(self.layman.current)  
        if option == "metadata": 
            self.page1.setVisible(False)
            self.page2.setVisible(False)
            self.page3.setVisible(False)
            self.page4.setVisible(True)
            self.page5.setVisible(False)
            self.setMetadataUI() 
        if option == "new": 
            self.page1.setVisible(False)
            self.page2.setVisible(False)
            self.page3.setVisible(True)
            self.page4.setVisible(False)
            self.page5.setVisible(False)
            self.setNewUI()    
        if option == "props": 
            self.page1.setVisible(False)
            self.page2.setVisible(False)
            self.page3.setVisible(False)
            self.page4.setVisible(False)
            self.page5.setVisible(True)
            self.setLayerPropertiesUI()     
                                       
            
    def setUi(self):    
        QgsProject.instance().layerWasAdded.connect(self.on_layers_added)  
        QgsProject.instance().layerRemoved.connect(self.on_layers_removed)     
        self.connectEvents()  
        self.permissionsConnected = False
        self.layman.dlg_current = self
        self.utils.recalculateDPI()
        self.pushButton_setPermissions.clicked.connect(lambda: self.setStackWidget("permissions"))
        self.pushButton_back.clicked.connect(lambda: self.setStackWidget("main", False))  
        self.pushButton_editMeta.clicked.connect(lambda: self.setStackWidget("metadata"))  
        self.pushButton_new.clicked.connect(lambda: self.setStackWidget("new"))        
        self.pushButton_new.show()
        self.setVisibilityForCurrent(False)
        self.label_readonly.hide()
        self.label_log.hide()        
        self.label_raster.hide()
        self.treeWidget_layers.header().resizeSection(0,230)  
        self.pushButton_qfield.clicked.connect(self.exportToQfield)       
        if self.layman.current != None:
            self.layman.instance.refreshComposition()
            composition = self.layman.instance.getComposition()        
            self.setVisibilityForCurrent(True)
            self.pushButton_copyUrl.clicked.connect(lambda: self.copyCompositionUrl())
            layerList = list()
            serviceList = list()
            try:                
                self.setWindowTitle(self.tr("Composition: ")+composition['title'])
            except:
                print("titulek nenačten")          
            
            try:                
                len(composition['layers'])
            except:            
             
                return
            self.refreshCurrentForm()
            if self.layman.laymanUsername != self.layman.instance.getWorkspace():             
                self.setVisibilityForCurrent(True)
        else:
            self.pushButton_new.setEnabled(True)
        if not self.isAuthorized:      
            self.setVisibilityForCurrent(False)
        if not self.pushButton_save.receivers(self.pushButton_save.clicked) > 0:          
            self.pushButton_close2.clicked.connect(lambda: self.close())                  
            self.pushButton_save.clicked.connect(lambda: self.updateComposition())
            #self.pushButton_save.clicked.connect(lambda: threading.Thread(target=self.updateComposition).start())
            self.checkBox_all.stateChanged.connect(self.checkAllLayers)
            self.pushButton_delete.clicked.connect(lambda: self.deleteCurrentMap())                     
            self.treeWidget_layers.itemChanged.connect(lambda: self.layersWasModified())       
            self.treeWidget_layers.itemChanged.connect(self.checkCheckbox)
        self.progressBar_loader.hide()  
        if not self.layman.qfieldReady:
            self.pushButton_qfield.setEnabled(False)
        self.show()
        result = self.exec_()  
    def UpdateQfield(self):
        self.progressStart.emit() 
        self.layman.qfieldWorking = True       
        myLayers = self.layman.instance.getOnlyMyLayers()
        if self.utils.containsWmsOrWfs():
            layersToUpdate = self.utils.filterTitlesByAccessRights(myLayers)
        else:
            layersToUpdate = None           
        if layersToUpdate:   
            msgbox = QMessageBox(QMessageBox.Question, "Layman", self.tr("QField does not support private layers. Would you like to set these layers as public?"))
            msgbox.addButton(QMessageBox.Yes)
            msgbox.addButton(QMessageBox.No)
            msgbox.setDefaultButton(QMessageBox.No)
            msgbox.setWindowFlags(msgbox.windowFlags() | Qt.WindowStaysOnTopHint)
            reply = msgbox.exec()                                                 
            if (reply == QMessageBox.Yes):
                print(layersToUpdate)
                self.utils.updateLayerAccessRights(self.utils.filterTitlesByAccessRights(layersToUpdate))
                self.utils.removeAuthcfg(layersToUpdate)        
        self.utils.saveUnsavedLayers()  
        try:
            QgsProject.instance().layerWasAdded.disconnect()
        except TypeError as e:
            print(f"Chyba při odpojování on_layers_added: {e}")
        try:
            QgsProject.instance().layerRemoved.disconnect()
        except TypeError as e:
            print(f"Chyba při odpojování on_layers_added: {e}")        
        # threading.Thread(target=self.qfieldThread).start()        
        name = self.layman.current            
        self.qfield.selectedLayers = self.getCheckedLayerNames()
        permissions = self.layman.instance.getAllPermissions()
        permission = "true" if 'EVERYONE' in permissions['read'] else "false"   
        response = self.qfield.createQProject(self.layman.instance.getName(), self.layman.instance.getDescription(), permission)
        res = response.json()
        if response.status_code == 201:
            self.utils.showQgisBar([" Projekt by úspěšně vytvořen."," Project was successfully created."], Qgis.Success)    
        elif 'code' in res and res['code'] == 'project_already_exists':            
            convertedProjectPath = self.qfield.convertQProject()            
            self.utils.showQgisBar([" Aktualizuji project QField."," Update QField project"], Qgis.Success)          
            project_id = self.qfield.getProjectByName(name)              
            qfieldFiles = self.qfield.getProjectFiles(project_id).json()  
            layersToDelete = self.qfield.selectedLayers
            layersToPost = self.qfield.findLayersToPost(self.layman.instance.getLayerList(), qfieldFiles)                        
            filesToCheck = self.qfield.filesToCheck(qfieldFiles)         
            local_hashes = self.utils.create_local_files_hash_dict(convertedProjectPath)               
            self.qfield.postMultipleFiles(project_id, convertedProjectPath)    
            self.syncFiles(local_hashes,filesToCheck, layersToPost, layersToDelete, project_id)                              
        self.layman.current = name
        QgsProject.instance().layerWasAdded.connect(self.on_layers_added)
        QgsProject.instance().layerRemoved.connect(self.on_layers_removed)  
        self.layman.qfieldWorking = False  
        self.layman.stylesToUpdate = set()  
        self.onRefreshCurrentForm.emit()       
        self.progressDone.emit()   
    def exportToQfield(self):            
        self.updateComposition(qfield = True)
       
    def qfieldThread(self):
        name = self.layman.current            
        self.qfield.selectedLayers = self.getCheckedLayerNames()
        permissions = self.layman.instance.getAllPermissions()
        permission = "true" if 'EVERYONE' in permissions['read'] else "false"   
        response = self.qfield.createQProject(self.layman.instance.getName(), self.layman.instance.getDescription(), permission)
        res = response.json()
        if response.status_code == 201:
            self.utils.showMessageSignal.emit([" Projekt by úspěšně vytvořen."," Project was successfully created."], Qgis.Success)    
        elif 'code' in res and res['code'] == 'project_already_exists':            
            convertedProjectPath = self.qfield.convertQProject()            
            self.utils.showMessageSignal.emit([" Aktualizuji project QField."," Update QField project"], Qgis.Success)          
            project_id = self.qfield.getProjectByName(name)              
            qfieldFiles = self.qfield.getProjectFiles(project_id).json()  
            layersToDelete = self.qfield.selectedLayers
            layersToPost = self.qfield.findLayersToPost(self.layman.instance.getLayerList(), qfieldFiles)                        
            filesToCheck = self.qfield.filesToCheck(qfieldFiles)         
            local_hashes = self.utils.create_local_files_hash_dict(convertedProjectPath)               
            self.qfield.postMultipleFiles(project_id, convertedProjectPath)    
            self.syncFiles(local_hashes,filesToCheck, layersToPost, layersToDelete, project_id)                              
        self.layman.current = name        
        QgsProject.instance().layerWasAdded.connect(self.on_layers_added)
        QgsProject.instance().layerRemoved.connect(self.on_layers_removed)  
        self.layman.qfieldWorking = False          
        self.layman.stylesToUpdate = set()  
        self.onRefreshCurrentForm.emit()       
        self.progressDone.emit() 
    def syncFiles(self, local_files_hashes, server_files_hashes, layers_to_post, layers_to_delete, project_id):      
        for filename, local_hash in local_files_hashes.items():
            fullpath = filename          
            filename = self.utils.get_filename_with_extension(filename) 
            server_hash = server_files_hashes.get(filename)       
            if local_hash != server_hash and server_hash != None:             
                print(f"File {filename} was changed, sending to server.")   
                self.qfield.postProjectFile(project_id, fullpath)   
            elif filename in layers_to_post:                             
                self.qfield.postProjectFile(project_id, fullpath)
            # self.qfield.postProjectFile(project_id, fullpath)                
            # elif filename in layers_to_delete:
            #     self.qfield.deleteProjectFile(project_id, fullpath)                                       
    
        for file in layers_to_delete:
            self.qfield.deleteProjectFile(project_id, file+".gpkg") 
    def setVisibilityForCurrent(self, visible):           
        if self.layman.instance is None:
            self.pushButton_editMeta.setEnabled(False)   
            self.pushButton_setPermissions.setEnabled(False)
            self.pushButton_delete.setEnabled(False)              
            self.pushButton_save.setEnabled(False)
            self.pushButton_copyUrl.setEnabled(False)   
            self.pushButton_qfield.setEnabled(False)
            self.pushButton_new.setEnabled(True)
            self.label_readonly.hide()
            self.pushButton_new.show()              
            return
        if self.layman.laymanUsername != self.layman.instance.getWorkspace() and visible == True:
            self.pushButton_editMeta.setEnabled(False)   
            self.pushButton_setPermissions.setEnabled(False)
            self.pushButton_delete.setEnabled(False)              
            self.pushButton_save.setEnabled(False)
            self.pushButton_copyUrl.setEnabled(True) 
            if self.layman.qfieldReady:  
                self.pushButton_qfield.setEnabled(False)
            self.pushButton_new.setEnabled(True)
            self.label_readonly.show()
            self.pushButton_new.show()   
            self.checkBox_all.setEnabled(False) 
        else:  
            self.pushButton_new.show()       
            self.pushButton_new.setEnabled(visible)
            self.pushButton_setPermissions.setEnabled(visible)      
            self.pushButton_editMeta.setEnabled(visible)            
            self.pushButton_save.setEnabled(visible)
            self.pushButton_delete.setEnabled(visible)     
            self.pushButton_copyUrl.setEnabled(visible)             
            if self.layman.qfieldReady: 
                self.pushButton_qfield.setEnabled(visible)
            self.checkBox_all.setEnabled(visible)
    def refreshCurrentForm(self, layerAdded = None):
        self.pushButton_new.show()  
        if self.layman.instance == None:
            return
        composition = self.layman.instance.getComposition()
        if self.layman.current != None:           
            try:
                writePermissions = self.layman.instance.getAllPermissions()['write']
            except:
                writePermissions = []
                print("get permissions failed")                
            if self.layman.laymanUsername not in writePermissions:                    
                    self.treeWidget_layers.setEnabled(False)               
                    self.pushButton_editMeta.setEnabled(False)
                    self.pushButton_setPermissions.setEnabled(False)                    
                    self.pushButton_save.setEnabled(False)
                    self.pushButton_delete.setEnabled(False)
                    self.pushButton_setPermissions.setEnabled(False)
                    self.pushButton_qfield.setEnabled(False) 
                    self.label_readonly.show()  
            else:   
                self.label_readonly.hide()                 
                self.layman.instance.refreshComposition()                     
                self.pushButton_editMeta.setEnabled(True)
                self.pushButton_new.setEnabled(True)
                self.pushButton_setPermissions.setEnabled(True)                        
                self.pushButton_save.setEnabled(True)
                self.pushButton_delete.setEnabled(True)
                if self.layman.qfieldReady:
                    self.pushButton_qfield.setEnabled(True) 
                else:
                    self.pushButton_qfield.setEnabled(False)     
                self.pushButton_copyUrl.setEnabled(True) 
        
        
        try:
            self.setWindowTitle("Kompozice: " + composition['title']) if self.layman.locale == "cs" else self.setWindowTitle("Composition: " + composition['title'])
        except:
            print("titulek nenačten")
        self.treeWidget_layers.clear()
        layerList = list()
        serviceList = list()
        self.layman.instance.refreshComposition()        
        for i in reversed(range (0, len(composition['layers']))):                
            layerList.append(self.utils.removeUnacceptableChars(composition['layers'][i]['title']))
            serviceList.append(composition['layers'][i]['className'])
        layers = QgsProject.instance().mapLayers().values()        
        layersInCanvas = []
        self.layerIds = list()
        layersArr = list()
        layers = self.getLayersOrder()
     
        for layer in layers:
            layersArr.append(layer)

        if layerAdded:
            layersArr.append(layerAdded)
        for layer in layersArr:  
            self.layerIds.append([self.utils.removeUnacceptableChars(layer.name()), layer.id()])
            layerType = layer.type()                
            item = QTreeWidgetItem()
            item.setText(0, layer.name())               
            layersInCanvas.append(self.utils.removeUnacceptableChars(layer.name()))          
            if self.utils.removeUnacceptableChars(layer.name()) in layerList:
                i = layerList.index(self.utils.removeUnacceptableChars(layer.name()))               
                if serviceList[i] == self.layman.vectorService:                       
                    item.setText(1, "WFS")
                if serviceList[i] == self.layman.rasterService:                       
                    item.setText(1, "WMS")
                if serviceList[i] == 'XYZ':                        
                    item.setText(1, "XYZ")
                item.setCheckState(0,2)                
                item.setToolTip(0,self.tr("This layer is displayed and is part of the loaded composition."))                           
            else:
                item.setCheckState(0,0)     
                item.setToolTip(0,self.tr("This layer is not part of the composition."))
            
               
            
                if isinstance(layer, QgsRasterLayer):
                    item.setText(1, "WMS")
                if isinstance(layer, QgsVectorLayer):                
                    item.setText(1, "WMS")
                if layer.type() == QgsMapLayer.VectorLayer and layer.dataProvider().name() == 'WFS':
                    item.setText(1, "WFS") 
                self.setGuiForItem(item)
                if layerType == QgsMapLayer.VectorLayer:
                    try:
                        layer.editingStopped.disconnect()
                    except:
                        print("connect to stopEditing not exists")            
            self.treeWidget_layers.addTopLevelItem(item)        
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)     
        notActive = set(layerList) - set(layersInCanvas)  
        
        for layer in notActive:            
            item = QTreeWidgetItem()
            
            if self.layman.locale == "cs":
                item.setText(0,layer + " (Smazána z projektu)")
                item.setFlags(item.flags() & ~Qt.ItemIsUserCheckable)
                item.setData(0, QtCore.Qt.CheckStateRole, None)
            else:
                item.setText(0, layer + " (Removed from canvas)")
                item.setFlags(item.flags() & ~Qt.ItemIsUserCheckable)
                item.setData(0, QtCore.Qt.CheckStateRole, None)
            
            brush = QBrush()
            brush.setColor(QColor(255,17,0))
            item.setForeground(0,brush)
            item.setCheckState(0,0)            
            item.setToolTip(0,self.tr("This layer does not appear in the QGIS map window, but is included in the composition."))     
            self.treeWidget_layers.addTopLevelItem(item)
            self.layersWasModified()           
        self.addAvailableServices(layersArr,iterator, notActive)
                
    def qfieldLogin(self):
        self.layman.run_QfieldLoginDialog()
        
    def checkAllLayers(self, checked):
        if checked:
            self.checkBox_all.setText("Odebrat vše") if self.layman.locale == "cs" else self.checkBox_all.setText("Uncheck all layers")        
            iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
            while iterator.value():
                item = iterator.value()
                item.setCheckState(0,2)                
                self.layerServices[self.utils.removeUnacceptableChars(item.text(0))] = self.layman.rasterService
                iterator +=1
     
        if not checked:
            self.checkBox_all.setText("Vybrat vše") if self.layman.locale == "cs" else self.checkBox_all.setText("Check all layers")                   
            iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
            while iterator.value():           
                item = iterator.value()
                item.setCheckState(0,0)                
                self.layerServices = {}
                iterator +=1    

    def checkCheckbox(self, item, column):        
        combobox = self.treeWidget_layers.itemWidget(item,2)
        if combobox is not None:            
            if item.checkState(column) == 2:                
                if item.text(2) != "":
                    combobox.setCurrentIndex(2)
                else:
                    combobox.setCurrentIndex(1)
            if item.checkState(column) == 0:
                combobox.setCurrentIndex(2) 

    def getCheckedLayerNames(self):
        checkedLayers = []      
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        while iterator.value():
            item = iterator.value()     
            if item.checkState(0) == 0:             
                checkedLayers.append(item.text(0))
            iterator += 1
        return checkedLayers     
                                 
    def getLayersOrder(self):
        bridge = self.layman.iface.layerTreeCanvasBridge()
        root = bridge.rootGroup()
        return root.layerOrder()                
    def addAvailableServices(self, layersArr, iterator, notActive):
        urlServer = self.URI.replace("/client", "")
        data = self.utils.getLayers()
        while iterator.value():
            item = iterator.value()                
            cell = QComboBox()         
            cellServices = QComboBox()
            for layer in layersArr:                
                if self.utils.removeUnacceptableChars(layer.name()) == self.utils.removeUnacceptableChars(item.text(0)) and cellServices.count() == 0:
                    if isinstance(layer, QgsRasterLayer) and "geoserver" in layer.dataProvider().dataSourceUri():
                        cellServices.addItems(['WMS','WFS'])
                    elif isinstance(layer, QgsRasterLayer) and "geoserver" not  in layer.dataProvider().dataSourceUri():
                        cellServices.addItems(['WMS'])
                    elif isinstance(layer, QgsVectorLayer) and layer.dataProvider().name() != 'WFS':
                        cellServices.addItems(['WMS','WFS'])
                    elif isinstance(layer, QgsVectorLayer) and layer.dataProvider().name() == 'WFS' and urlServer not in layer.dataProvider().uri().uri():
                        cellServices.addItems(['WFS'])         
                    elif isinstance(layer, QgsVectorLayer) and layer.dataProvider().name() == 'WFS' and urlServer in layer.dataProvider().uri().uri():
                        cellServices.addItems(['WFS', 'WMS'])                                                        

            if (self.layman.instance.isLayerInComposition(self.utils.removeUnacceptableChars(item.text(0)))):
                if self.layman.locale == "cs":
                    cell.addItems(['Beze změny','Přepsat data','Smazat'])
                else:
                    cell.addItems(['No change','Overwrite geometry','Remove'])
            elif item.text(0).replace(" (Smazána z projektu)", "").replace(" (Removed from canvas)", "") in  notActive:
                if self.layman.locale == "cs":
                    cell.addItems(['Beze změny','Smazat'])
                else:
                    cell.addItems(['No change','Remove'])                        
            else:
                if self.utils.checkExistingLayers(item.text(0), data): ##and self.utils.checkExistingLayer(item.text(0)):           
                    if self.layman.locale == "cs":
                        cell.addItems(['Beze změny','Přidat ze serveru','Přidat a přepsat'])
                    else:
                        cell.addItems(['No change','Add from server','Add and overwrite' ])
                # elif self.utils.checkExistingLayers(item.text(0), data):
                #     if self.layman.locale == "cs":
                #         cell.addItems(['Beze změny','Přidat ze serveru'])
                #     else:
                #         cell.addItems(['No change','Add from server'])                       
                else:
                    if self.layman.locale == "cs":
                        cell.addItems(['Beze změny','Přidat'])
                    else:
                        cell.addItems(['No change','Add'])

            self.treeWidget_layers.setItemWidget(item,2, cell)
            self.treeWidget_layers.setItemWidget(item,1, cellServices)        
                                            
            if self.layman.instance.getServiceForLayer(item.text(0)) in (["HSLayers.Layer.WMS", "WMS", "XYZ"]):
                cellButton = QPushButton("...", None)                
                cellButton.clicked.connect(lambda: self.setStackWidget("props"))
                self.treeWidget_layers.setItemWidget(item,3, cellButton)
            ##
            iterator +=1
            self.treeWidget_layers.itemWidget(item,1).setCurrentText(item.text(1)) 
    def comboBoxChanged(self, text):        
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        try:
            while iterator.value():
                item = iterator.value()
                if item.checkState(0) == 0 and (self.treeWidget_layers.itemWidget(item,2).currentText() == "Add from server" or self.treeWidget_layers.itemWidget(item,2).currentText() == "Přidat ze serveru" or self.treeWidget_layers.itemWidget(item,2).currentText() == "Add and overwrite" or  self.treeWidget_layers.itemWidget(item,2).currentText() == 'Přidat' or self.treeWidget_layers.itemWidget(item,2).currentText() == "Přidat a přepsat" or self.treeWidget_layers.itemWidget(item,2).currentText() == 'Add'  ):
                    item.setCheckState(0,2)                  
                iterator +=1
        except:
            print("neni v canvasu")                        
            
    def updateComposition(self, checkD = True, thread = True, qfield = False):   
        self.progressStart.emit()     
        self.currentSet = list()
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        try:
            while iterator.value():
                item = iterator.value()
                self.currentSet.append([item.text(0),self.treeWidget_layers.itemWidget(item,1).currentText(),self.treeWidget_layers.itemWidget(item,2).currentText()])
                iterator +=1
        except:
            print("neni v canvasu")     
        if self.duplicateLayers():           
            self.showInfoDialogOnTop(self.tr("Duplicity in layer names!"))
            return         
        composition = self.layman.instance.getComposition()
        layerList = []
        for i in range (0, len(composition['layers'])):
            layerList.append(self.utils.removeUnacceptableChars(composition['layers'][i]['title']))  
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        while iterator.value():
            item = iterator.value()
            self.itemClick(item,0) ## check for subgroups
            if item.checkState(0) == 2 and  self.utils.removeUnacceptableChars(item.text(0)) not in layerList:                
                lay = QgsProject.instance().mapLayersByName(item.text(0))[0]
                lay.styleChanged.connect(self.layman.layerStyleToUpdate)
            iterator +=1
        if thread:            
            threading.Thread(target=lambda: self.updateCompositionThread(qfield)).start()
        else:  
            self.updateCompositionThread()          
        # self.progressBar_loader.show()
        self.pushButton_save.setEnabled(False)     
                
        
    def duplicateLayers(self):
        layerList = set()
        duplicity = list()
        ret = False

        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        while iterator.value():
            item = iterator.value()
            if item.text(0) in layerList and item.checkState(0) == 2:
                print("duplicity" + item.text(0))
                duplicity.append(item.text(0))
            if item.checkState(0) == 2:
                layerList.add(item.text(0))
                print("append" + item.text(0))            
            iterator +=1
        while iterator.value():
            item = iterator.value()
            if item.text(0) in duplicity:                
                item.setForeground(0, QColor(255,18,0))
                ret = True
            else:                
                item.setForeground(0, QColor(0,0,0))
            iterator +=1        
        return ret                
    def itemClick(self, item, col):
        if item.checkState(0) == 2 and self.checkIfLayerIsInMoreGroups(QgsProject.instance().mapLayersByName(item.text(0))[0]):            
            self.showInfoDialogOnTop(self.tr("Layer ") + item.text(0) +self.tr(" is nested in two groups. Only parent group will be saved."))          
     
            
    def checkIfLayerIsInMoreGroups(self, layer):
        root = QgsProject.instance().layerTreeRoot()
        tree_layer = root.findLayer(layer.id())
        if tree_layer:
            layer_parent = tree_layer.parent()

            if layer_parent:                
                group_parent = layer_parent.parent() 
                test = layer_parent.name() or 'root'
                if test == 'root':
                    return False
                if group_parent:                    
                    test = group_parent.name() or 'root'
                    if test == 'root':
                        return False
                    else:
                        return True            
    def updateCompositionThread(self, qfield = False):
             
        composition = self.layman.instance.getComposition()
        i= 0
        for item in self.currentSet:
            service = self.layman.instance.getServiceForLayer(item[0])
            if service in ("HSLayers.Layer.WMS", "WMS") and item[1] == "WFS":                      
                self.layerServices[self.utils.removeUnacceptableChars(item[0])] = self.layman.wms_wfs3(item[0], i, item[1])       
            if service in ("OpenLayers.Layer.Vector","Vector") and item[1] == "WMS":                
                self.layerServices[self.utils.removeUnacceptableChars(item[0])] = self.layman.wms_wfs3(item[0], i, item[1])
            i = i +1    
        
        duplicityCheck = self.saveMapLayers()
        if not duplicityCheck:
            QgsMessageLog.logMessage("layersLoaded")            
            return
        self.modified = False 
        if len(self.layman.stylesToUpdate) > 0:
            layerList = set()
            for layer in self.layman.stylesToUpdate:
                layerList.add(self.utils.removeUnacceptableChars(layer.name()))
            for lay in composition['layers']:
                if self.utils.removeUnacceptableChars(lay['title']) in layerList:
                    try:
                        self.layman.updateLayerStyle(lay['title'], lay['workspace'])
                    except:
                        self.layman.updateLayerStyle(lay['title'], self.layman.laymanUsername) ## pokud je starší typ kompozice
                    try:
                        self.layman.stylesToUpdate.remove(QgsProject.instance().mapLayersByName(lay['title'])[0])
                    except:
                        print("neni v poli")
        
        self.layman.updateLayerPropsInComposition() 
        self.layman.syncOrder2(self.getLayersOrder())          
        self.layman.patchMap2()                
        self.layman.writeValuesToProject(self.URI, composition['name'])  
        self.layman.showExportInfo.emit("F")        
        self.onRefreshCurrentForm.emit()    
        self.progressDone.emit()           
        if qfield:
            self.qfieldUpdate.emit()            
    def saveMapLayers(self):
        layerList = list()
        layerCheckedList = list()
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        while iterator.value():
            item = iterator.value()
            if item.checkState(0) == 2:
                layerCheckedList.append(item.text(0))
            iterator +=1  
        composition = self.layman.instance.getComposition()  
        for i in range (0, len(composition['layers'])):       
            layerList.append(self.utils.removeUnacceptableChars(composition['layers'][i]['title']))
        composition = self.layman.instance.getComposition()
        self.processingRequest = True
        layers = list()
        iterator = QTreeWidgetItemIterator(self.treeWidget_layers, QTreeWidgetItemIterator.All)
        while iterator.value():
            item = iterator.value()         
            if item.checkState(0) == 2 and  self.utils.removeUnacceptableChars(item.text(0)) not in layerList:           
                if not self.layman.checkLayerInCurrentCompositon(item.text(0)):  
                    layer = QgsProject.instance().mapLayersByName(item.text(0))[0]
                    if (isinstance(layer, QgsVectorLayer)): 
                        layers.append(layer)                        
                    else:
                        layers.append(layer)          

            elif item.checkState(0) == 2 and  self.utils.removeUnacceptableChars(item.text(0))  in layerList:
                for it in self.currentSet:                                 
                    if (it[2] =='Overwrite geometry'  or it[2] == "Přepsat data") and it[0] == item.text(0):
                        layer = QgsProject.instance().mapLayersByName(item.text(0))[0]
                        if layer.type() == QgsMapLayer.VectorLayer:
                            self.layman.postRequest(layer.name(), True)
            elif item.checkState(0) == 0 and item.text(0) not in layerCheckedList and self.treeWidget_layers.itemWidget(item,2).currentText() in ("Smazat", "Remove"):  ## může být zaškrnut i jinde, pak nemažem                                        
                pom = 0             
                for i in range (0, len(composition['layers'])):
                    i = i - pom
                                      

                    if self.utils.removeUnacceptableChars(composition['layers'][i]['title']) == self.utils.removeUnacceptableChars(item.text(0).split(" (")[0]):
                        del composition['layers'][i]
                        pom = pom + 1
            iterator +=1
        uniq = self.checkUniqueName(layers)      
        if uniq:
            if len(layers) > 0:          
                newLayers = list()                
                for item in self.currentSet:                    
                    layersFromServer = list() 
                    if item[2] == "Add from server" or item[2] == "Přidat ze serveru":
                        for layer in layers:                                                    
                   
                            if layer.name() == item[0]:                               
                                self.layman.addExistingLayerToComposition(layer.name(),composition,item[1].lower(), layer)
                                layers.remove(layer)
                    
                    if item[2] == "Add and overwrite" or item[2] =='Add' or item[2] == "Přidat a přepsat" or item[2] =='Přidat':
                        for layer in layers:
                            if layer.name() == item[0]:
                                newLayers.append(layer)
                if len(newLayers) > 0:                                   
                    self.layman.addLayerToComposition(composition, layers, self.currentSet)            
            return True
        else:
            QgsMessageLog.logMessage("uniqLayers")
            return False        
    def checkUniqueName(self, layers):
        layerList = list()
        for layer in layers:
            layerList.append(layer.name())
        if(len(set(layerList)) == len(layerList)):
            return True
        else:
            return False        
    def layersWasModified(self):
        self.modified = True  
    def collectPermissionsAndSave(self, tab_widget, map):
        self.failed = []
        read_access = []
        write_access = []

        if self.radioButton_readPublic.isChecked():
            read_access = ['EVERYONE']
        else:
            table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by user"))
            if table_widget:
                self.collectAccessFromTable(table_widget, read_access, "read")
            if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):    
                role_table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by role"))
                if role_table_widget:
                    self.collectAccessFromTable(role_table_widget, read_access, "read")

        if self.radioButton_writePublic.isChecked():
            write_access = ['EVERYONE']
        else:
            table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by user"))
            if table_widget:
                self.collectAccessFromTable(table_widget, write_access, "write")
            if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):    
                role_table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by role"))
                if role_table_widget:
                    self.collectAccessFromTable(role_table_widget, write_access, "write")

        if self.layman.laymanUsername not in write_access:
            write_access.append(self.layman.laymanUsername)
        if self.layman.laymanUsername not in read_access:
            read_access.append(self.layman.laymanUsername)

        data = {
            'access_rights.read': self.utils.listToString(read_access),
            'access_rights.write': self.utils.listToString(write_access)
        }
        
 
        map = self.utils.removeUnacceptableChars(map)      
        url = self.URI+'/rest/'+self.layman.laymanUsername+'/maps/'+map
        response = requests.patch(url, data = data,  headers = self.utils.getAuthHeader(self.utils.authCfg))                
        if (response.status_code != 200):
            self.failed.append(map)          
        if len(self.failed) == 0:       
            self.permissionInfo.emit(True, self.failed, 0)                
        else:
            self.permissionInfo.emit(False, self.failed, 0)          
    def getTableWidgetByTabName(self, tab_widget, tab_name):
      
        for i in range(tab_widget.count()):
            if tab_widget.tabText(i) == tab_name:
                return tab_widget.widget(i)
        return None
                    
    def collectAccessFromTable(self, table_widget, access_list, type):
        for row in range(table_widget.rowCount()):
            item = table_widget.item(row, 3)  
            if item is not None:  
                username = item.text()
                if type == "read":
                    read_checkbox = table_widget.cellWidget(row, 1)
                    if read_checkbox.isChecked():                        
                        access_list.append(username)
                if type == "write":                    
                    write_checkbox = table_widget.cellWidget(row, 2)
                    if write_checkbox.isChecked():
                        access_list.append(username)                       
                                                 
    def getRoles(self):
        uri = self.URI + "/rest/roles"
        r = self.utils.requestWrapper("GET", uri, payload = None, files = None)
        res = self.utils.fromByteToJson(r.content)
        return res
    def removeTabByTitle(self, tab_widget, title):
        index = 0
        while index < tab_widget.count():
            if tab_widget.tabText(index) == title:
                tab_widget.removeTab(index)
            else:
                index += 1  
    def populatePermissionsWidget(self, tab_widget, user_dict, read_access, write_access):     
        self.removeTabByTitle(tab_widget, self.tr("Permissions by user"))
        if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
            self.removeTabByTitle(tab_widget, self.tr("Permissions by role"))
        if "EVERYONE" in user_dict:
            del user_dict["EVERYONE"]
        self.setEveryonePermissionsRadiobuutons(True if "everyone" in [name.lower() for name in read_access] else False,True if "everyone" in [name.lower() for name in write_access] else False)        
        user_widget = QTableWidget()
        user_widget.verticalHeader().setVisible(False)
        self.utils.setTableWidgetNotBorder(user_widget)
        self.globalRead.clear()
        self.globalWrite.clear()       
        for username in user_dict.keys():  
            self.globalRead[username] = username in read_access
            self.globalWrite[username] = username in write_access
    ### add users
       
        num_columns = 4  
        user_widget.setRowCount(len(user_dict))
        user_widget.setColumnCount(num_columns)  
        user_widget.setHorizontalHeaderLabels([self.tr('User'), self.tr('Read'), self.tr('Write'), self.tr('Nick')])
        everyone_read_checked = "everyone" in [name.lower() for name in read_access]
        everyone_write_checked = "everyone" in [name.lower() for name in write_access]
        for row, (username, full_name) in enumerate(user_dict.items()):
            user_widget.setItem(row, 0, QTableWidgetItem(full_name + " ("+username+")"))            
            read_checkbox = QCheckBox()
            write_checkbox = QCheckBox() 
            write_checkbox.setStyleSheet("margin-left:50%; margin-right:50%;") 
            read_checkbox.setStyleSheet("margin-left:50%; margin-right:50%;")                 
            write_checkbox.stateChanged.connect(lambda state, rc=read_checkbox: rc.setChecked(True) if state else rc.isChecked())
            read_checkbox.stateChanged.connect(lambda state, wc=write_checkbox: wc.setChecked(False) if state == 0 else None)               
            if username == self.layman.laymanUsername:
                read_checkbox.setDisabled(True)
                write_checkbox.setDisabled(True)
            user_widget.setCellWidget(row, 1, read_checkbox)
            user_widget.setCellWidget(row, 2, write_checkbox)            
            if username in write_access:
                write_checkbox.setChecked(True)
                read_checkbox.setChecked(True)
            else:
                read_checkbox.setChecked(username in read_access)
            if everyone_read_checked:                  
                read_checkbox.setChecked(True)    
                read_checkbox.setEnabled(False)  
            if everyone_write_checked:                  
                write_checkbox.setChecked(True) 
                write_checkbox.setEnabled(False)                             
            user_widget.setItem(row, 3, QTableWidgetItem(username))
            user_widget.setColumnHidden(3, True)
            user_widget.resizeColumnToContents(0)
        self.userFilterLineEdit = QLineEdit()
        self.userFilterLineEdit.setPlaceholderText(self.tr("Filter users..."))
        self.userFilterLineEdit.textChanged.connect(self.filterRecords)     
        userTab = QWidget()
        userLayout = QVBoxLayout()
        userLayout.addWidget(self.userFilterLineEdit)  
        userLayout.addWidget(user_widget)  
        userTab.setLayout(userLayout)    
        tab_widget.addTab(userTab, self.tr("Permissions by user"))
    ### add roles
        if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
            num_columns = 4  
            role_widget = QTableWidget()
            role_widget.verticalHeader().setVisible(False)
            self.utils.setTableWidgetNotBorder(role_widget)
            role_widget.setRowCount(len(user_dict))
            role_widget.setColumnCount(num_columns)  
            role_widget.setHorizontalHeaderLabels([self.tr('Role'), self.tr('Read'), self.tr('Write'), self.tr('Nick')])
            roles = self.getRoles()
            self.roles = roles
            row = 0
            for rolename in (roles):    
                if rolename == "EVERYONE":
                    continue
                self.globalRead[rolename] = rolename in read_access
                self.globalWrite[rolename] = rolename in write_access
                role_widget.setItem(row, 0, QTableWidgetItem(rolename))   
                read_checkbox = QCheckBox()
                write_checkbox = QCheckBox()  
                write_checkbox.setStyleSheet("margin-left:50%; margin-right:50%;") 
                read_checkbox.setStyleSheet("margin-left:50%; margin-right:50%;")   
                write_checkbox.stateChanged.connect(lambda state, rc=read_checkbox: rc.setChecked(True) if state else None)
                read_checkbox.stateChanged.connect(lambda state, wc=write_checkbox: wc.setChecked(False) if state == 0 else None)
                role_widget.setCellWidget(row, 1, read_checkbox)
                role_widget.setCellWidget(row, 2, write_checkbox) 
                if rolename in write_access:
                    write_checkbox.setChecked(True)
                    read_checkbox.setChecked(True)
                    self.globalWrite[rolename] = True
                else:
                    if rolename in read_access:
                        self.globalRead[rolename] = True
                    read_checkbox.setChecked(rolename in read_access)      
                if everyone_read_checked:                  
                    read_checkbox.setChecked(True)   
                    read_checkbox.setEnabled(False)  
                if everyone_write_checked:                  
                    write_checkbox.setChecked(True)    
                    write_checkbox.setEnabled(False)                        
                role_widget.setItem(row, 3, QTableWidgetItem(rolename))         
                role_widget.setColumnHidden(3, True)
                role_widget.resizeColumnToContents(0)
                row = row + 1
            roleTab = QWidget()
            roleLayout = QVBoxLayout()
            self.roleFilterLineEdit = QLineEdit()
            self.roleFilterLineEdit.setPlaceholderText(self.tr("Filter roles..."))
            self.roleFilterLineEdit.textChanged.connect(self.filterRecords)  
            roleLayout.addWidget(self.roleFilterLineEdit)  
            roleLayout.addWidget(role_widget)  
            roleTab.setLayout(roleLayout)      
            tab_widget.addTab(roleTab, self.tr("Permissions by role"))  

    def setEveryonePermissionsRadiobuutons(self, public_read, public_write):            
        self.radioButton_readPublic.setChecked(public_read)
        self.radioButton_readPrivate.setChecked(not public_read)        
        self.radioButton_writePublic.setChecked(public_write)
        self.radioButton_writePrivate.setChecked(not public_write)  
           

    def getUserWidget(self):
        user_tab_index = 0 
        user_tab = self.tabWidget.widget(user_tab_index)  
        if user_tab is not None and hasattr(user_tab, 'layout') and user_tab.layout() is not None:          
            for i in range(user_tab.layout().count()):
                widget = user_tab.layout().itemAt(i).widget()              
                if isinstance(widget, QTableWidget):
                    return widget
        return None
    def getRoleWidget(self):
        user_tab_index = 1  
        user_tab = self.tabWidget.widget(user_tab_index)  
        if user_tab is not None and hasattr(user_tab, 'layout') and user_tab.layout() is not None:          
            for i in range(user_tab.layout().count()):
                widget = user_tab.layout().itemAt(i).widget()       
                if isinstance(widget, QTableWidget):
                    return widget
        return None
    def getWidgetByTabName(self, tab_widget, tab_name):
        for i in range(tab_widget.count()):
            if tab_widget.tabText(i) == tab_name:               
                container_widget = tab_widget.widget(i)               
                if container_widget.layout() and container_widget.layout().count() > 0:             
                    for j in range(container_widget.layout().count()):                  
                        widget = container_widget.layout().itemAt(j).widget()                     
                        if isinstance(widget, QTableWidget):                           
                            return widget
        return None
    def filterRecords(self):
        user_filter_text = self.userFilterLineEdit.text().lower()
        if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
            role_filter_text = self.roleFilterLineEdit.text().lower()
        user_widget = self.getUserWidget()
        if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
            role_widget = self.getRoleWidget()
       
        if isinstance(user_widget, QTableWidget):
            for row in range(user_widget.rowCount()):
                item = user_widget.item(row, 0)
                if item:
                    user_widget.setRowHidden(row, user_filter_text not in item.text().lower())
        if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
            if isinstance(role_widget, QTableWidget):
                for row in range(role_widget.rowCount()):
                    item = role_widget.item(row, 0)
                    if item:
                        role_widget.setRowHidden(row, role_filter_text not in item.text().lower())
         
    def updatePermissions(self, permissionType, isPublic):
        user_widget = self.getWidgetByTabName(self.tabWidget, self.tr("Permissions by user"))
        if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
            role_widget = self.getWidgetByTabName(self.tabWidget, self.tr("Permissions by role"))       
        if permissionType == 'read':
            if isPublic:               
                self.updateWidgetPermissions(user_widget, 'read', True)
                if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
                    self.updateWidgetPermissions(role_widget, 'read', True)
            else:     
                self.globalUpdateFromPermissions(user_widget, 'read', self.globalRead)
                if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
                    self.globalUpdateFromPermissions(role_widget, 'read', self.globalRead)          
                if self.radioButton_writePublic.isChecked():
                    self.radioButton_writePrivate.setChecked(True)

        elif permissionType == 'write':        
            if isPublic:              
                self.radioButton_readPublic.setChecked(True)
                self.updateWidgetPermissions(user_widget, 'write', True)
                if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
                    self.updateWidgetPermissions(role_widget, 'write', True)               
            else:              
                self.globalUpdateFromPermissions(user_widget, 'write', self.globalWrite)
                if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
                    self.globalUpdateFromPermissions(role_widget, 'write', self.globalWrite)

     
        if self.radioButton_writePrivate.isChecked() and self.radioButton_readPublic.isChecked():
            self.updateWidgetPermissions(user_widget, 'read', True)
            if LooseVersion(self.layman.laymanVersion) >= LooseVersion("1.23.0"):
                self.updateWidgetPermissions(role_widget, 'read', True)  

    def updateQfieldPermissions(self, tab_widget, map):        
        if not self.layman.qfieldReady:
            return
        read_access, write_access = self.getUserPermissions(tab_widget) 
        read_access = self.utils.transformUsernames(read_access)   
        write_access = self.utils.transformUsernames(write_access) 
        existingUsers = self.qfield.getAllUsers().json()   
        users_write = self.utils.findCommonUsers(write_access, existingUsers)
        users_read = self.utils.findCommonUsers(read_access, existingUsers)
        users_write_set = set(users_write)  
        users_read = [user for user in users_read if user not in users_write_set]        
        self.qfield.qfieldPermissionsJunction(self.qfield.findProjectByName(map), users_write, users_read, self.layman.laymanUsername)   

    def getUserPermissions(self, tab_widget):    
        read_access = []
        write_access = []
        if self.radioButton_readPublic.isChecked():
            read_access = ['EVERYONE']
        else:
            table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by user"))
            if table_widget:
                self.collectAccessFromTable(table_widget, read_access, "read")
            role_table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by role"))
            if role_table_widget:
                self.collectAccessFromTable(role_table_widget, read_access, "read")

        if self.radioButton_writePublic.isChecked():
            write_access = ['EVERYONE']
        else:
            table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by user"))
            if table_widget:
                self.collectAccessFromTable(table_widget, write_access, "write")
            role_table_widget = self.getWidgetByTabName(tab_widget, self.tr("Permissions by role"))
            if role_table_widget:
                self.collectAccessFromTable(role_table_widget, write_access, "write")
        if self.layman.laymanUsername not in write_access:
            write_access.append(self.layman.laymanUsername)
        if self.layman.laymanUsername not in read_access:
            read_access.append(self.layman.laymanUsername)    
        return  [read_access,write_access]         
    
    def alignCheckboxesInTable(self, table_widget, count):
        for row in range(count):
            for col in [1, 2]:       
                checkbox = QCheckBox()
                checkbox.setStyleSheet("margin-left:50%; margin-right:50%;")  
                checkbox_item = QTableWidgetItem()
                checkbox_item.setFlags(Qt.ItemIsEnabled)  
                checkbox_item.setTextAlignment(Qt.AlignCenter) 
                table_widget.setCellWidget(row, col, checkbox)
                table_widget.setItem(row, col, checkbox_item)
    def updateWidgetPermissions(self, widget, permissionType, isPublic):
        if widget is None:
            return
        rowCount = widget.rowCount()
        for row in range(rowCount):
            read_checkbox = widget.cellWidget(row, 1)  
            write_checkbox = widget.cellWidget(row, 2)  
            if permissionType == 'write' and isPublic:
                if write_checkbox is not None:                   
                    write_checkbox.setChecked(True) 
                    write_checkbox.setEnabled(False)
                if read_checkbox is not None:
                    read_checkbox.setChecked(True)  
                    read_checkbox.setEnabled(False)

         
            elif permissionType == 'read' and isPublic:
                if read_checkbox is not None:
                    read_checkbox.setChecked(True)
                    read_checkbox.setEnabled(False)

        
            else:
                if permissionType == 'write' and write_checkbox is not None:
                    write_checkbox.setChecked(False)  
                if permissionType == 'read' and read_checkbox is not None:
                    read_checkbox.setChecked(False)                              
  

    def globalUpdateFromPermissions(self, widget, permissionType, permissionsDict):            
        if widget is None:
            return
        rowCount = widget.rowCount()  
        for row in range(rowCount):   
            try:
                user_or_role = widget.item(row, 3).text() 
            except:
                return          
            checkbox = widget.cellWidget(row, 1 if permissionType == 'read' else 2)       
            if checkbox is not None and user_or_role in permissionsDict:          
                if user_or_role == self.layman.laymanUsername:
                    checkbox.setChecked(True)
                    checkbox.setEnabled(False)
                else:     
                    checkbox.setChecked(permissionsDict[user_or_role])
                    checkbox.setEnabled(True) 
            elif checkbox is not None and user_or_role in self.roles:                    
                checkbox.setChecked(False)
                checkbox.setEnabled(True)         
    def setPermissionsUI(self, mapName): 
        group1 = QButtonGroup(self)
        group2 = QButtonGroup(self)
        group1.addButton(self.radioButton_readPublic)
        group1.addButton(self.radioButton_readPrivate)
        group2.addButton(self.radioButton_writePrivate)
        group2.addButton(self.radioButton_writePublic)
        uri = self.URI + "/rest/users"
        usersDict = dict()
        if self.layman.locale == "cs":
            usersDict['EVERYONE'] = 'VŠICHNI'
        else:
            usersDict['EVERYONE'] = 'EVERYONE'
        usersDictReversed = dict()
        usernameList = list()
        usernameList.append('EVERYONE')
        if self.layman.locale == "cs":
            usersDictReversed['EVERYONE'] = 'VŠICHNI'
        else:
            usersDictReversed['EVERYONE'] = 'EVERYONE'   
        r = self.utils.requestWrapper("GET", uri, payload = None, files = None)
        res = self.utils.fromByteToJson(r.content)
        userCount = len(res)      
        for i in range (0, userCount):           
            usersDict[res[i]['name'] if res[i]['name'] !="" else res[i]['username']] = res[i]['username']
            usersDictReversed[res[i]['username']] = res[i]['name'] if res[i]['name'] !="" else res[i]['username']    
            usernameList.append(res[i]['username'])   
        mapName = self.utils.removeUnacceptableChars(mapName)
        uri = self.URI + "/rest/"+self.layman.laymanUsername+"/maps/"+mapName        
        r = self.utils.requestWrapper("GET", uri, payload = None, files = None)
        res = self.utils.fromByteToJson(r.content)      
        self.populatePermissionsWidget(self.tabWidget, usersDictReversed, res['access_rights']['read'], res['access_rights']['write']) 
        self.radioButton_readPublic.toggled.connect(lambda: self.updatePermissions('read', self.radioButton_readPublic.isChecked()))
        self.radioButton_writePublic.toggled.connect(lambda: self.updatePermissions('write', self.radioButton_writePublic.isChecked()))  
        if not self.permissionsConnected:           
            self.pushButton_save_permissions.clicked.connect(lambda:  self.progressBar_loader.show())      
            self.pushButton_save_permissions.clicked.connect(lambda: threading.Thread(target=self.collectPermissionsAndSave, args=(self.tabWidget, mapName)).start()) 
            self.pushButton_save_permissions.clicked.connect(lambda: threading.Thread(target=self.updateQfieldPermissions, args=(self.tabWidget, mapName)).start())                  
            self.permissionsConnected = True    
            
    def checkAddedItemDuplicity(self, type, usernameList):
        itemsTextListRead = [] 
        for i in range(self.listWidget_read.count()):
            current_item = self.listWidget_read.item(i) 
            hidden_item = current_item.data(Qt.UserRole) 
            if hidden_item is not None:
                itemsTextListRead.append(hidden_item.text())    
        itemsTextListWrite = [] 
        for i in range(self.listWidget_write.count()):
            current_item = self.listWidget_write.item(i) 
            hidden_item = current_item.data(Qt.UserRole) 
            if hidden_item is not None:
                itemsTextListWrite.append(hidden_item.text())
        allItems = [self.comboBox_users.itemText(i) for i in range(self.comboBox_users.count())]      
        if self.comboBox_users.currentText() in allItems:
            if type == "read":
              
                if ((usernameList[self.comboBox_users.currentIndex()] not in itemsTextListRead)): 
                    current_item = QtWidgets.QListWidgetItem(self.comboBox_users.currentText())                   
                    self.listWidget_read.addItem(current_item)
                    hidden_text = usernameList[self.comboBox_users.currentIndex()]
                    self.setHiddenItem(current_item, hidden_text)   
                    return True
                else:                    
                    self.showInfoDialogOnTop(self.tr("This user already exists in the list!"))                            
                    return False
            else: 
                if ((usernameList[self.comboBox_users.currentIndex()] not in itemsTextListWrite) and type == "write"):               
                    return True
                else: 
                    self.showInfoDialogOnTop(self.tr("This user already exists in the list!"))                                    
                    return False   
    def setHiddenItem(self,item, hidden_text):     
        hidden_item = QtWidgets.QListWidgetItem(hidden_text)
        hidden_item.setHidden(True)
        item.setData(Qt.UserRole, hidden_item)                 
    def showInfoDialogOnTop(self, text):
        msgbox = QMessageBox()     
        msgbox.setWindowTitle("Layman")
        msgbox.setText(text)
        msgbox.setIcon(QMessageBox.Information)
        msgbox.addButton(QMessageBox.Ok)
        msgbox.setWindowFlags(msgbox.windowFlags() | Qt.WindowStaysOnTopHint)
        msgbox.exec()                                  
    def removeWritePermissionList(self):
        self.deleteItem(self.listWidget_read.currentItem().text())
        self.listWidget_read.removeItemWidget(self.listWidget_read.takeItem(self.listWidget_read.currentRow()))
    def deleteItem(self, itemName):
        items_list = self.listWidget_write.findItems(itemName, Qt.MatchExactly)
        for item in items_list:
            r = self.listWidget_write.row(item)
            self.listWidget_write.takeItem(r)               
    def checkPermissionButtons(self):
        name = self.utils.getUserName()
        try:
            if self.listWidget_read.currentItem().text() == name:
                self.pushButton_removeRead.setEnabled(False)
            else:
                self.pushButton_removeRead.setEnabled(True)
        except:
            self.pushButton_removeRead.setEnabled(False)
            print("neni vybrana polozka")
        try:
            if self.listWidget_write.currentItem().text() == name:
                self.pushButton_removeWrite.setEnabled(False)
            else:
                self.pushButton_removeWrite.setEnabled(True)
        except:
            self.pushButton_removeWrite.setEnabled(False)
            print("neni vybrana polozka")     
    
                
    def afterPermissionDone(self, success, failed, info):
        self.progressBar_loader.hide()             
        if success:            
            self.showInfoDialogOnTop(self.tr("Permissions was saved successfully."))                
        else:            
            self.showInfoDialogOnTop(self.tr("Permissions was not saved for layer: ") + str(failed).replace("[","").replace("]",""))   
                    
    def setMetadataUI(self):       
        composition = self.layman.instance.getComposition()
        self.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        self.lineEdit_name.hide() 
        self.pushButton_save.setEnabled(False)
        self.pushButton_back_3.clicked.connect(lambda: self.setStackWidget("main", False))                
        self.lineEdit_name.setText(composition['name'])
        self.lineEdit_abstract.setText(composition['abstract'])
        self.lineEdit_title.setText(composition['title'])
        self.lineEdit_units.setText(composition['units'])
        self.lineEdit_scale.setText(str(composition['scale']))
        self.lineEdit_user.setText(composition['user']['name'])
        self.lineEdit_xmin.setText(str(composition['extent'][0]))
        self.lineEdit_xmax.setText(str(composition['extent'][2]))
        self.lineEdit_ymin.setText(str(composition['extent'][1]))
        self.lineEdit_ymax.setText(str(composition['extent'][3]))       
        self.comboBox_epsg.addItems([value.split(":")[1] for value in self.layman.supportedEPSG])
        if 'projection' in composition:            
            self.comboBox_epsg.setCurrentText(composition['projection'].replace("epsg:",""))
        self.lineEdit_xmin.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_xmax.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_ymin.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_ymax.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))  
        self.pushButton_save_meta.clicked.connect(lambda: self.progressBar_loader.show())      
        self.pushButton_save_meta.clicked.connect(lambda: self.modifyMeta())
        self.pushButton_range_2.clicked.connect(lambda: self.setRangeFromCanvas())
        self.pushButton_range.clicked.connect(lambda: self.setExtentFromLayers())       
        self.pushButton_range.setToolTip(self.tr("Gets spatial range information from wms capatibilies."))
        self.pushButton_range_2.setToolTip(self.tr("Gets spatial range information from QGIS canvas."))



        if not self.isAuthorized:
            self.pushButton_save_meta.setEnabled(False)
            self.pushButton_range.setEnabled(False)
            self.pushButton_range_2.setEnabled(False)
                          
                          
    def modifyMeta(self):      
        self.progressStart.emit() 
        self.layman.project.crsChanged.disconnect()
        composition = self.layman.instance.getComposition()    
        self.compositionDict = self.utils.fillCompositionDict()
        self.compositionDict[composition['name']] = self.lineEdit_title.text()    
        composition['abstract'] = self.lineEdit_abstract.text()
        composition['title'] = self.lineEdit_title.text()
        #src = QgsProject.instance().crs()
        src = QgsCoordinateReferenceSystem(int(composition['projection'].split(":")[1])) 
        epsg = self.comboBox_epsg.currentText()
        dest = QgsCoordinateReferenceSystem(int(epsg))
        tform = QgsCoordinateTransform(src, dest, QgsProject.instance())              
        #transformace extentu   
        coords = self.utils.tranformCoords(float(self.lineEdit_xmin.text().replace(",",".")), float(self.lineEdit_xmax.text().replace(",",".")), float(self.lineEdit_ymin.text().replace(",",".")), float(self.lineEdit_ymax.text().replace(",",".")),src,dest)
        coords = self.utils.tranformCoords(composition['nativeExtent'][0], composition['nativeExtent'][2], composition['nativeExtent'][1], composition['nativeExtent'][3], src, dest) 
                    
        #nativeCoords = self.tranformCoords(float(self.lineEdit_xmin.text().replace(",",".")), float(self.lineEdit_xmax.text().replace(",",".")), float(self.lineEdit_ymin.text().replace(",",".")), float(self.lineEdit_ymax.text().replace(",",".")), 4326)
        composition['nativeExtent'][0] = float(coords[0])
        composition['nativeExtent'][2] = float(coords[1])
        composition['nativeExtent'][1] = float(coords[2])
        composition['nativeExtent'][3] = float(coords[3])
        composition["extent"] =  [float(self.lineEdit_xmin.text().replace(",",".")),float(self.lineEdit_ymin.text().replace(",",".")),float(self.lineEdit_xmax.text().replace(",",".")),float(self.lineEdit_ymax.text().replace(",","."))]
        #composition["nativeExtent"] =  [float(nativeCoords[0]),float(nativeCoords[2]),float(nativeCoords[1]),float(nativeCoords[3])]
        center = tform.transform(QgsPointXY(self.layman.iface.mapCanvas().extent().center().x(), self.layman.iface.mapCanvas().extent().center().y()))
        composition['center'][0] = float(center.x())
        composition['center'][1] = float(center.y())
        if composition['projection'] != "epsg:" + epsg:
            self.layman.project.setCrs(QgsCoordinateReferenceSystem('EPSG:'+epsg))
            composition['projection'] = "epsg:" + epsg
        response = self.layman.patchMap2()
        self.label_log.hide()
        if (response.status_code == 200):
            self.utils.showQgisBar([" Metadata byla úspěšně upravena."," Map metadata was saved successfully."], Qgis.Success)             
        else:
            self.utils.showErr.emit([" Metadata nebyla upravena.", " Map metadata was not saved."], "code: " + str(response.status_code), str(response.content), Qgis.Warning, "")            

        self.setStackWidget("main", False)
        composition = self.layman.instance.getComposition()
        try:
            if self.layman.locale == "cs":
                self.setWindowTitle("Kompozice: "+composition['title'])
            else:
                self.setWindowTitle("Composition: "+composition['title'])
        except:
            pass                          
        self.progressDone.emit()
        self.layman.project.crsChanged.connect(self.layman.crsChanged)
    def _onProgressDone(self):
        self.progressBar_loader.hide()    
    def _onProgressStart(self):
        self.progressBar_loader.show()             
        
    def setExtentFromLayers(self):

        composition = self.layman.instance.getComposition()
        xmin = None
        xmax = None
        ymin = None
        ymax = None
        initRun = True
        url = self.URI+'/client/geoserver/'+self.layman.laymanUsername+'/ows?service=wms&version=1.1.1&request=GetCapabilities'        
        r = self.utils.requestWrapper("GET", url, payload = None, files = None)      
        names = list()
        renge = list()
        tree = ET.ElementTree(ET.fromstring(r.content))
        root = tree.getroot()
        for name in  root.findall("./Capability/Layer/Layer/Name"):      
            names.append(name.text)
        for name in  root.findall("./Capability/Layer/Layer/LatLonBoundingBox"):           
            renge.append(name.attrib)
        for i in range(len(composition['layers'])):
            className = composition['layers'][i]['className']
            if className in ('HSLayers.Layer.WMS','OpenLayers.Layer.Vector', 'WMS', 'Vector'):
                name = self.utils.removeUnacceptableChars(composition['layers'][i]['title'])    
                for i in range (0, len(names)):
                    if names[i] == name:
                        print("matched")
                        if initRun:
                            ymax = renge[i]['maxy']
                            xmax = renge[i]['maxx']
                            ymin = renge[i]['miny']
                            xmin = renge[i]['minx']
                            initRun = False
                        if renge[i]['maxy'] > ymax:                            
                            ymax = renge[i]['maxy']
                        if renge[i]['maxx'] > xmax:                            
                            xmax = renge[i]['maxx']
                        if renge[i]['miny'] < ymin:                            
                            ymin = renge[i]['miny']
                        if renge[i]['minx'] < xmin:                            
                            xmin = renge[i]['minx']
        if (xmin == None or xmax == None or ymin == None or ymax==None):            
            self.showInfoDialogOnTop(self.tr("A record of the layers spatial extent for the selected composition was not found!"))
        else:
            self.lineEdit_xmin.setText(str(xmin))
            self.lineEdit_xmax.setText(str(xmax))
            self.lineEdit_ymin.setText(str(ymin))
            self.lineEdit_ymax.setText(str(ymax))

    def setRangeFromCanvas(self):        
        ext = self.layman.iface.mapCanvas().extent()
        coords = self.tranformCoords(ext.xMinimum(), ext.xMaximum(), ext.yMinimum(), ext.yMaximum())
        self.lineEdit_xmin.setText(str(coords[0]))
        self.lineEdit_xmax.setText(str(coords[1]))
        self.lineEdit_ymin.setText(str(coords[2]))
        self.lineEdit_ymax.setText(str(coords[3]))        
    def tranformCoords(self, xmin, xmax, ymin, ymax, dest = 4326):
        src = QgsProject.instance().crs()
        dest = QgsCoordinateReferenceSystem(dest)
        tform = QgsCoordinateTransform(src, dest, QgsProject.instance())
        max = tform.transform(QgsPointXY(float(xmax),float(ymax)))
        min = tform.transform(QgsPointXY(float(xmin),float(ymin)))        
        return [min.x(), max.x(), min.y(), max.y()]       
    def copyCompositionUrl(self, composition=None): 
        if not composition:
            url = self.layman.instance.getUrl()
        else:
            if "client" in self.URI:
                url = self.URI+'/rest/'+self.treeWidget.selectedItems()[0].text(1)+'/maps/'+self.layman.getNameByTitle(self.treeWidget.selectedItems()[0].text(0))+'/file'
            else:  
                url = self.URI+'/client/rest/'+self.treeWidget.selectedItems()[0].text(1)+'/maps/'+self.layman.getNameByTitle(self.treeWidget.selectedItems()[0].text(0))+'/file'            
        try: 
            self.utils.copyToClipboard(url)
            self.utils.showQgisBar([" URL uloženo do schránky."," URL saved to clipboard."], Qgis.Success)       
        except Exception as e:
            info = str(e)
            allInfo = traceback.format_exception(etype=type(e), value=e, tb=e.__traceback__) 
            print([" URL nebylo uloženo do schránky."," URL was not saved to clipboard."],info, allInfo)
            self.utils.showErr.emit([" URL nebylo uloženo do schránky."," URL was not saved to clipboard."],info, str(allInfo), Qgis.Warning, "")        
            
    def setNewUI(self): 
         
        self.treeWidget.clear()
        self.pushButton_new.hide()      
        layers = QgsProject.instance().mapLayers().values()     
        self.treeWidget.itemClicked.connect(self.setExtent)
        for layer in layers:         
            if (layer.type() == QgsMapLayer.VectorLayer):
                item = QTreeWidgetItem([layer.name()])
                self.treeWidget.addTopLevelItem(item)
        ext = self.layman.iface.mapCanvas().extent()
        self.pushButton_back_2.clicked.connect(lambda: self.setStackWidget("main", False))     
        self.lineEdit_3.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_4.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_5.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_6.setValidator(QRegExpValidator(QRegExp(r"^-?\d*[.,]?\d*$")))
        self.lineEdit_2.editingFinished.connect(self.checkNameCreateMap)
        self.lineEdit_2.textEdited.connect(self.checkForChars)
        projectPath = QgsProject.instance().fileName()
        if projectPath != "":
            projectName = os.path.basename(projectPath).split(".")[0]           
            self.lineEdit_2.setText(projectName)
        self.lineEdit_3.setText(str(ext.xMinimum()))
        self.lineEdit_4.setText(str(ext.xMaximum()))
        self.lineEdit_5.setText(str(ext.yMinimum()))
        self.lineEdit_6.setText(str(ext.yMaximum()))
        self.pushButton_editMeta.setEnabled(False)   
        self.pushButton_setPermissions.setEnabled(False)
        self.pushButton_delete.setEnabled(False)              
        self.pushButton_save.setEnabled(False)
        self.pushButton_qfield.setEnabled(False)
        self.pushButton_copyUrl.setEnabled(False)
        self.pushButton_defaultExtent.clicked.connect(lambda: self.setDefaultExtent(ext))       
        self.setStyleSheet("#DialogBase {background: #f0f0f0 ;}") 
        if not self.pushButton_CreateCompositionConnected:                        
            self.pushButton_CreateComposition.clicked.connect(lambda: self.createComposition(self.lineEdit_2.text(),self.textEdit_description.toPlainText(), True))
            self.pushButton_CreateCompositionConnected = True
        
    def setExtent(self, it, col):
        layer = QgsProject.instance().mapLayersByName(it.text(0))
        ext = layer[0].extent()       
        xmin = ext.xMinimum()
        xmax = ext.xMaximum()
        ymin = ext.yMinimum()
        ymax = ext.yMaximum()
        if QgsProject.instance().crs().authid() == 'EPSG:5514' and layer[0].crs().authid() == 'EPSG:4326':                    
            max = self.utils.krovakToWgs(xmax, ymax)
            min = self.utils.krovakToWgs(xmin, ymin)
            xmin = min[0]
            xmax = max[0]
            ymin = min[1]
            ymax = max[1]
        if QgsProject.instance().crs().authid() == 'EPSG:4326' and layer[0].crs().authid() == 'EPSG:5514':             
            max = self.utils.wgsToKrovak(xmax, ymax)
            min = self.utils.wgsToKrovak(xmin, ymin)
            xmin = min[0]
            xmax = max[0]
            ymin = min[1]
            ymax = max[1]
        self.lineEdit_3.setText(str(xmin))
        self.lineEdit_4.setText(str(xmax))
        self.lineEdit_5.setText(str(ymin))
        self.lineEdit_6.setText(str(ymax))        
        self.label_4.setText(self.tr("Extent of layer: ") + it.text(0))        
    def checkNameCreateMap(self):
        text = self.lineEdit_2.text()
        if text != "":
            text = self.utils.removeUnacceptableChars(text)            
            url = self.URI + "/rest/"+self.layman.laymanUsername+"/maps/"+str(text)+"/file"
            r = requests.get(url, headers = self.utils.getAuthHeader(self.layman.authCfg)) 
            res = r.json()       
            e = False          
            try:
                if res['code'] == 2:
                    ch = False
                else:
                    ch = True
            except:
                ch = True
                e = True ## kdyz nevraci rescode tak je to v poradku 
            if (not e):
                self.pushButton_CreateComposition.setEnabled(True)              
            else:
                self.pushButton_CreateComposition.setEnabled(False)              
                self.utils.showQgisBar([" Kompozice s tímto jménem již existuje"," Composition name already exists!"], Qgis.Warning) 
                
    def checkForSpecialChars(self, s):
        special_characters = "!@#$%^&*()+?=,<>/"
        if any(c in special_characters for c in s):
            return True
        else:
            return False
        
    def checkForChars(self, string):
        if self.checkForSpecialChars(string):           
            self.showInfoDialogOnTop(self.tr("Unsupported char."))
        else:
            self.pushButton_CreateComposition.setEnabled(True)                      
            
    def createComposition(self,  title, abstract, setCurrent = False):         
        self.compositionDict = self.utils.fillCompositionDict()
        if QgsProject.instance().crs().authid() not in self.layman.supportedEPSG:            
            self.showInfoDialogOnTop(self.tr("Project EPSG is not supported."))
            return
        if (title == ""):            
            self.showInfoDialogOnTop(self.tr("Name is not filled!"))
            return                
        else:
            name = self.utils.removeUnacceptableChars(title)
            data = self.layman.getEmptyComposite(name,title, abstract) 
            self.layman.importCleanComposite(data)          
            if setCurrent:                
                self.layman.current = name
                self.layman.selectedWorkspace = self.layman.laymanUsername
                url = self.URI+'/rest/'+self.layman.selectedWorkspace+'/maps/'+name+'/file'  
                r = self.utils.requestWrapper("GET", url, payload = None, files = None)
                data = r.json()        
                self.layman.instance = CurrentComposition(self.URI, name, self.layman.selectedWorkspace, self.utils.getAuthHeader(self.layman.authCfg),self.layman.laymanUsername)
                self.layman.instance.setComposition(data)
                self.compositionDict[name] = title                
                prj = QgsProject().instance()
                QgsProject().instance().setTitle(title)
                root = prj.layerTreeRoot()  
                self.prj=QgsProject.instance()                    
                QgsProject.instance().setTitle(title)  
                self.pushButton_editMeta.setEnabled(True)   
                self.pushButton_setPermissions.setEnabled(True)
                self.pushButton_delete.setEnabled(True)              
                self.pushButton_save.setEnabled(True)
                self.pushButton_copyUrl.setEnabled(True)
                self.label_readonly.hide()
                self.treeWidget_layers.setEnabled(True)   
        self.setStackWidget("main", True)                         
    def setDefaultExtent(self, ext):
        self.lineEdit_3.setText(str(ext.xMinimum()))
        self.lineEdit_4.setText(str(ext.xMaximum()))
        self.lineEdit_5.setText(str(ext.yMinimum()))
        self.lineEdit_6.setText(str(ext.yMaximum()))                
    def setGuiForItem(self, item):
        if item.text(1) == "GEOJSON":            
            item.setToolTip(1,self.tr("Layer loaded from a local geojson file."))
        if item.text(1) == "SHP":            
            item.setToolTip(1,self.tr("Layer loaded from a local SHP file."))
        if item.text(1) == "MEMORY":            
            item.setToolTip(1,self.tr("Layer stored in QGIS memory. It will be deleted after QGIS is turned off."))
        if item.text(1) == "WMS":            
            item.setToolTip(1,self.tr("A layer loaded over a WMS service that provides data in a raster format. It is possible to change this service to a WFS vector service using the button."))
        if item.text(1) == "WFS":            
            item.setToolTip(1,self.tr("A layer loaded over a WFS service that provides data in a vector format. It is possible to change this service to a WMS raster service using the button. Changes in this layer are saved to the server."))
        if item.text(1) == "OGR":            
            item.setToolTip(1,self.tr("Vector layer loaded from a local file.") )     
    def on_layers_removed(self):      
        if self.objectName() == "CurrentCompositionDialog":
            self.refreshCurrentForm()  
    def on_layers_added(self, layer):     
        if self.objectName() == "CurrentCompositionDialog":                
            self.refreshCurrentForm(layer)   
                           
    def setLayerPropertiesUI(self):             
        self.pushButton_back_4.clicked.connect(lambda: self.setStackWidget("main", False)) 
        layerName = self.treeWidget_layers.selectedItems()[0].text(0)      
        self.label_name.setText(layerName)
        self.pushButton_save_props.clicked.connect(lambda: self.saveCompositionLayerChanges(layerName))        
        composition = self.layman.instance.getComposition()           
        for layer in composition['layers']:
            if layer['title'] == layerName:              
                self.checkBox_singleTile.setCheckState(2) if layer['singleTile'] == True else self.checkBox_singleTile.setCheckState(0)
                if "base" in layer:
                    self.checkBox_baseLayer.setCheckState(2) if layer['base'] == True else self.checkBox_singleTile.setCheckState(0)
                if "greyscale" in layer:
                    self.checkBox_greyScale.setCheckState(2) if layer['greyscale'] == True else self.checkBox_greyScale.setCheckState(0)
                else:
                    self.checkBox_greyScale.setCheckState(0)    
                self.label_opacity.setText(str(layer['opacity'] * 100) + " %")
                self.label_max.setText("None" if not layer['maxResolution'] else "1:"+str(self.utils.resolutionToScale(layer['maxResolution'])))
                self.label_min.setText("1:"+str(int(self.utils.resolutionToScale(layer['minResolution']))))                
                self.checkBox_visibility.setChecked(True if layer['visibility'] else False) 
                self.label_path.setText(str(layer['path']))   
                
    def setGrayScaleForLayer(self, layer):       
        if  isinstance(layer, QgsRasterLayer):
            pipe = layer.pipe()
            if self.checkBox_greyScale.checkState() == 2:
                pipe.hueSaturationFilter().setGrayscaleMode(1)
            if self.checkBox_greyScale.checkState() == 0:
                pipe.hueSaturationFilter().setGrayscaleMode(0)
            layer.triggerRepaint()
    def saveCompositionLayerChanges(self, name):
        composition = self.layman.instance.getComposition()
        if self.checkBox_singleTile.checkState() == 2:
            composition['layers'][self.layman.instance.getLayerOrderByTitle(name)]['singleTile'] = True
        else:
            composition['layers'][self.layman.instance.getLayerOrderByTitle(name)]['singleTile'] = False
        if self.checkBox_baseLayer.checkState() == 2:
            composition['layers'][self.layman.instance.getLayerOrderByTitle(name)]['base'] = True
        else:
            composition['layers'][self.layman.instance.getLayerOrderByTitle(name)]['base'] = False
        if self.checkBox_greyScale.checkState() == 2:
            composition['layers'][self.layman.instance.getLayerOrderByTitle(name)]['greyscale'] = True
        else:
            composition['layers'][self.layman.instance.getLayerOrderByTitle(name)]['greyscale'] = False
        response = self.layman.patchMap2()
        if  response.status_code == 200:
            self.utils.showQgisBar([" Změny byly uloženy."," Changes was saved."], Qgis.Success)  
        else:
            self.utils.showErr.emit([" Změny nebyly uloženy.", " Changes was not saved."], "code: " + str(response.status_code), str(response.content), Qgis.Warning, "")            
        self.setGrayScaleForLayer(QgsProject.instance().mapLayersByName(name)[0])                            
    def deleteQfieldProject(self, name):
        project_id = self.qfield.getProjectByName(name)  
        if project_id is not None:
            self.qfield.deleteProject(project_id)
    def deleteCurrentMap(self):
        composition = self.layman.instance.getComposition()        
        msgbox = QMessageBox(QMessageBox.Question, self.tr("Delete map"), self.tr("Do you want really delete this composition?"))
        msgbox.addButton(QMessageBox.Yes)
        msgbox.addButton(QMessageBox.No)
        msgbox.setDefaultButton(QMessageBox.No)
        msgbox.setWindowFlags(msgbox.windowFlags() | Qt.WindowStaysOnTopHint)
        reply = msgbox.exec()
        if (reply == QMessageBox.Yes):
            self.deleteQfieldProject(composition['name'])
            url = self.URI+'/rest/'+self.layman.laymanUsername+'/maps/'+composition['name']           
            response = self.utils.requestWrapper("DELETE", url, payload = None, files = None)
            if (response.status_code == 200):
                self.utils.showQgisBar([" Kompozice  " + composition['name'] + " byla úspešně smazána."," Composition  " + composition['name'] + " was sucessfully deleted."], Qgis.Success)  
            else:
                self.utils.showErr.emit([" Kompozice  " + composition['name'] + " nebyla smazána.", " Composition  " + composition['name'] + " was not sucessfully deleted."], "code: " + str(response.status_code), str(response.content), Qgis.Warning)               

            self.layman.instance = None
            self.layman.current = None
            self.close()           
    def setWritePermissionList(self, usernameList):
        allItems = [self.comboBox_users.itemText(i) for i in range(self.comboBox_users.count())]    
        if self.comboBox_users.currentText() in allItems:
            if self.checkAddedItemDuplicity("write", usernameList):
                itemsTextListRead = [] 
                for i in range(self.listWidget_read.count()):
                    current_item = self.listWidget_read.item(i) 
                    hidden_item = current_item.data(Qt.UserRole) 
                    if hidden_item is not None:
                        itemsTextListRead.append(hidden_item.text())              
                if (usernameList[self.comboBox_users.currentIndex()] in itemsTextListRead):
                    current_item = QtWidgets.QListWidgetItem(self.comboBox_users.currentText())  
                    self.listWidget_write.addItem(current_item)
                    hidden_text = usernameList[self.comboBox_users.currentIndex()]
                    self.setHiddenItem(current_item, hidden_text)   
                    print("1")
                else:  
                    current_item = QtWidgets.QListWidgetItem(self.comboBox_users.currentText())
                    self.listWidget_read.addItem(current_item)                    
                    hidden_text = usernameList[self.comboBox_users.currentIndex()]
                    self.setHiddenItem(current_item, hidden_text)     

                    current_item = QtWidgets.QListWidgetItem(self.comboBox_users.currentText())             
                    self.listWidget_write.addItem(current_item)
                    hidden_text = usernameList[self.comboBox_users.currentIndex()]
                    self.setHiddenItem(current_item, hidden_text) 
                    print("2")   
    def reject(self):
        super().reject()   
        global dialog_running 
        dialog_running = False      
        self.layman.currentOpened = False
        self.qfieldWorking = False
        self.onRefreshCurrentForm.disconnect() 
        try:
            QgsProject.instance().layerWasAdded.disconnect()  
            QgsProject.instance().layerRemoved.disconnect()
        except:
            print("not connected")            
        
        
