 # -*- coding: utf-8 -*-
"""
/***************************************************************************
 Layman
                                 A QGIS plugin
 Layman
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-02-15
        git sha              : $Format:%H$
        copyright            : (C) 2019 by jan vrobel
        email                : vrobel.jan@seznam.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json
import tempfile
import os
import threading
import io



from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt, QFileSystemWatcher, QRegExp,QDir,QUrl, QByteArray 
from PyQt5.QtGui import QIcon, QPixmap, QRegExpValidator, QDoubleValidator
from PyQt5.QtWidgets import QAction, QTreeWidget,QTreeWidgetItemIterator, QTreeWidgetItem, QMessageBox, QLabel, QProgressDialog, QDialog, QProgressBar,QListWidgetItem, QAbstractItemView
from PyQt5.QtNetwork import QNetworkRequest, QNetworkAccessManager
# Initialize Qt resources from file resources.py
from .resources import *
import re
#from .flaskServer import *
from multiprocessing import Process
from pathlib import Path 
import processing
# Import the code for the DockWidget
from builtins import str
from builtins import range
from builtins import object
import json
import zipfile
from zipfile import ZipFile
import tempfile
import configparser
import shutil
import uuid
import csv
import copy
import ctypes, sys
import webbrowser
from .Layman_dockwidget import LaymanDockWidget
import os.path
import tempfile
import qgis.core
from qgis.core import *
import platform
import os
import qgis.utils
import qgis.gui
from qgis.gui import QgsMapCanvas
from qgis.core import QgsApplication
from qgis.utils import iface
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QWidget, QInputDialog, QLineEdit, QFileDialog
import requests
import tempfile
import time
from urllib.request import urlopen
import subprocess
import threading
#from flask import Flask, request, jsonify
import base64
import hashlib
import html
import re
import urllib.parse
from .ogr2ogr import main
## forms
from .dlg_GetLayers import GetLayersDialog
from .dlg_importMap import ImportMapDialog
from .dlg_deleteMap import DeleteMapDialog
from .dlg_importLayer import ImportLayerDialog
from .dlg_addLayer import AddLayerDialog
from .dlg_addMap import AddMapDialog
from .dlg_createComposite import CreateCompositeDialog
from .dlg_deleteLayerFromMap import DeleteLayerFromMapDialog
from .dlg_editMap import EditMapDialog
from .dlg_ConnectionManager import ConnectionManagerDialog
from .dlg_userInfo import UserInfoDialog
from .dlg_setPermission import SetPermissionDialog




class Layman:
    """QGIS Plugin Implementation."""
    
    


    
        #•t = threading.Thread(target=lambda: app.run(host='0.0.0.0', port=7001)).start()
    def __init__(self, iface):
        """Constructor.
        
        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
       
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__) 
        
        ## init global variables
      #  global filename 
    
        self.client_id = None
        self.filename = None
        self.layerName = None
        self.client_secret = None
        self.username = 'browser'
        self.EPSG = 'EPSG:3857'
        self.composite = None
        self.thread1 = None
        self.compositeList = []
        self.compositeListOld = []
        self.CHUNK_SIZE = 1048576 ## s touto hodnotou pracuje layman klient (cca 1MB soubor)
        self.URI = None
        self.access_token = None
        self.expires_in = None
        self.refresh_token = None
        self.laymanUsername = ""
        self.authHeader = None
        self.code_verifier = None
        self.code_challenge = None
        self.Agrimail = ""
        self.loadedInMemory = False
        self.liferayServer = None
        self.laymanServer = None
        self.mapsChanged = set()
        self.authCfg =""
        self.authCfg = "957je05"
        self.importedLayer = None
        self.batchLength = 0
        self.focusedLayer = None
        self.done = 0
        self.millis = 0
        self.version = "1.0.0"
        self.initFiles()
        self.firstStart = True
        self.mixedLayers = list()
      #  self.uri = 'http://layman.lesprojekt.cz/rest/'
        self.iface.layerTreeView().currentLayerChanged.connect(lambda: self.layerChanged())
       # self.iface.layerTreeView().currentLayerChanged.connect(lambda: self.getActiveLayer())
        self.processingList = []
        self.writeState(0)
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "state.txt" 
        self.watcherState = QFileSystemWatcher()
        self.watcherState.addPath(path)
        #self.watcherState.fileChanged.connect(self.notifySuccess)
        self.watcherState.fileChanged.connect(self.processingWorker)        
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt" 
        #self.watcher = QFileSystemWatcher()
        #self.watcher.addPath(path)
        #self.watcher.fileChanged.connect(self.authOptained)
        try:
            from flask import Flask, request, jsonify
            self.dependencies = True
        except:
            #self.dependencies = False
            self.dependencies = True
        if os.path.isfile(path):

            self.authFileTime =os.path.getmtime(path)
        #print(self.authFileTime)
        #print(os.path.getmtime(path))
        else:
            self.authFileTime = 0
     #   global dlgGetLayers 
        self.dlgGetLayers= GetLayersDialog()
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Layman_{}.qm'.format(locale))
        self.locale = locale
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Layman')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'Layman')
        self.toolbar.setObjectName(u'Layman')
        QgsApplication.messageLog().messageReceived.connect(self.write_log_message)
        
        #print "** INITIALIZING Atlas"

        self.pluginIsActive = False
        self.dockwidget = None
        ## prepare temp dir
        tempDir = tempfile.gettempdir() + os.sep + "atlas" 
        try:
            os.mkdir(tempDir)
            print("Directory " , tempDir ,  " Created ") 
        except FileExistsError:
            print("Directory " , tempDir ,  " already exists")


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Layman', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        #icon_path = ':/plugins/Atlas/icon.png'
        #self.add_action(
        #    icon_path,
        #    text=self.tr(u''),
        #    callback=self.run,
        #    parent=self.iface.mainWindow())
        #self.first_start = True

        ################## user
        self.textbox = QLabel(self.iface.mainWindow())
        # Set width
        self.textbox.setFixedWidth(140)
        # Add textbox to toolbar
        self.txtAction = self.toolbar.addWidget(self.textbox)
        # Set tooltip
        self.txtAction.setToolTip(self.tr(u'Current Row Number'))
        # Set callback
        self.textbox.setText("Layman")

        ################ end usericon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'login.png'
        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'login.png'
        self.menu_Connection = self.add_action(
            icon_path,
            text=self.tr(u'Login'),
            callback=self.run_login,
            enabled_flag=True,
            parent=self.iface.mainWindow())


        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'save.png'
        self.menu_saveLocalFile = self.add_action(
            icon_path,
            text=self.tr(u'Save as to JSON and SLD'),
            callback=self.saveLocalFile,
            enabled_flag=False,
            parent=self.iface.mainWindow())

        self.first_start = True
        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'file.png'
        self.menu_loadJson = self.add_action(
            icon_path,
            text=self.tr(u'Load from JSON'),
            callback=self.loadLocalFile,
            enabled_flag=False,
            parent=self.iface.mainWindow())
        self.first_start = True

        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'layers-up.png'
        self.menu_ImportLayerDialog = self.add_action(
            icon_path,
            text=self.tr(u'Export layer to server'),
            callback=self.run_ImportLayerDialog,
            enabled_flag=False,
            parent=self.iface.mainWindow())  
        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'layers-down.png'
        self.menu_AddLayerDialog = self.add_action(
            icon_path,
            text=self.tr(u'Load layer from server'),
            callback=self.run_AddLayerDialog,
            enabled_flag=False,
            parent=self.iface.mainWindow()) 
        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'upload-map.png'
        self.menu_ImportMapDialog = self.add_action(
            icon_path,
            text=self.tr(u'Manage maps'),
            callback=self.run_ImportMapDialog,
            enabled_flag=False,
            parent=self.iface.mainWindow())  
        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'download_map.png'
        self.menu_AddMapDialog = self.add_action(
            icon_path,
            text=self.tr(u'Load map from server'),
            callback=self.run_AddMapDialog,
            enabled_flag=False,
            parent=self.iface.mainWindow())   
        
        #icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'delete.png'
        #self.menu_DeleteMapDialog = self.add_action(
        #    icon_path,
        #    text=self.tr(u'Delete map'),
        #    callback=self.run_DeleteMapDialog,
        #    enabled_flag=False,
        #    parent=self.iface.mainWindow())  
        #icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'globus.png'
        #self.menu_CreateCompositeDialog = self.add_action(
        #    icon_path,
        #    text=self.tr(u'Create map'),
        #    callback=self.run_CreateCompositeDialog,
        #    enabled_flag=False,
        #    parent=self.iface.mainWindow())
        icon_path = self.plugin_dir + os.sep + 'icons' + os.sep + 'account.svg'
        self.menu_UserInfoDialog = self.add_action(
            icon_path,
            text=self.tr(u'User info'),
            callback=self.run_UserInfoDialog,
            enabled_flag=False,
            parent=self.iface.mainWindow())
    #--------------------------------------------------------------------------
    def run_UserInfoDialog(self):
        self.dlg = UserInfoDialog() 
        self.dlg.show()
        self.dlg.pushButton_logout.setStyleSheet("#pushButton_logout {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_logout:hover{background: #66ab27 ;}")
        self.dlg.pushButton_update.setStyleSheet("#pushButton_update {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_update:hover{background: #66ab27 ;}#pushButton_update:disabled{background: #64818b ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        userEndpoint = self.URI + "/rest/current-user"
        r = requests.get(url = userEndpoint,  headers = self.getAuthHeader(self.authCfg))
        res = r.text
        res = self.fromByteToJson(r.content)
        self.dlg.pushButton_logout.clicked.connect(lambda: self.logout())
        self.dlg.pushButton_update.clicked.connect(lambda: self.updatePlugin())
        print(res['claims'])
        self.dlg.label_layman.setText(res['claims']['preferred_username'])
        self.dlg.label_server.setText(self.liferayServer)
        self.dlg.label_agrihub.setText(res['claims']['email'])
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        self.dlg.label_version.setText(self.getVersion())
        versionCheck = self.checkVersion()
        self.dlg.label_avversion.setText(versionCheck[1])
        if versionCheck[0] == True:
            self.dlg.label_avversion.hide()
            self.dlg.label_5.hide()
            self.dlg.pushButton_update.setEnabled(False)
    def run_SetMapPermission(self, mapName):
        self.dlg = SetPermissionDialog() 
        self.dlg.show()
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.pushButton_addRead.setStyleSheet("#pushButton_addRead {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addRead:hover{background: #66ab27 ;}#pushButton_addRead:disabled{background: #64818b ;}")
        self.dlg.pushButton_removeRead.setStyleSheet("#pushButton_removeRead {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_removeRead:hover{background: #66ab27 ;}#pushButton_removeRead:disabled{background: #64818b ;}")
        self.dlg.pushButton_save.setStyleSheet("#pushButton_save {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_save:hover{background: #66ab27 ;}#pushButton_save:disabled{background: #64818b ;}")
        self.dlg.pushButton_addWrite.setStyleSheet("#pushButton_addWrite {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addWrite:hover{background: #66ab27 ;}#pushButton_addWrite:disabled{background: #64818b ;}")
        self.dlg.pushButton_removeWrite.setStyleSheet("#pushButton_removeWrite {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_removeWrite:hover{background: #66ab27 ;}#pushButton_removeWrite:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}#pushButton_close:disabled{background: #64818b ;}")
        uri = self.URI + "/rest/users"
        usersDict = dict()
        usersDict['EVERYONE'] = 'EVERYONE'
        usersDictReversed = dict()
        usersDictReversed['EVERYONE'] = 'EVERYONE'
        r= requests.get(uri)
        res = self.fromByteToJson(r.content)
        userCount = len(res)
        ##nabit combobox
        self.dlg.comboBox_users.addItem('EVERYONE')
        for i in range (0, userCount):
            #print(res[i]['name'])
            #print(res[i]['username'])
            usersDict[res[i]['name']] = res[i]['username'] 
            usersDictReversed[res[i]['username']] = res[i]['name'] 
            self.dlg.comboBox_users.addItem(res[i]['name'])
        ##nabit listView
        mapName = self.removeUnacceptableChars(mapName)
        uri = self.URI + "/rest/"+self.laymanUsername+"/maps/"+mapName
        
        r= requests.get(uri,headers = self.getAuthHeader(self.authCfg))
        res = self.fromByteToJson(r.content)
      
        lenRead = len(res['access_rights']['read'])
        lenWrite = len(res['access_rights']['write'])
        for i in range (0, lenRead):
            self.dlg.listWidget_read.addItem(usersDictReversed[res['access_rights']['read'][i]])
        for i in range (0, lenWrite):
            self.dlg.listWidget_write.addItem(usersDictReversed[res['access_rights']['write'][i]])
        self.dlg.pushButton_save.clicked.connect(lambda: self.updatePermissions([mapName], usersDict, "maps"))
        self.dlg.pushButton_addRead.clicked.connect(lambda: self.dlg.listWidget_read.addItem(self.dlg.comboBox_users.currentText()))
        self.dlg.pushButton_addWrite.clicked.connect(lambda: self.setWritePermissionList())
    
        self.dlg.pushButton_removeRead.clicked.connect(lambda: self.removeWritePermissionList())
        self.dlg.pushButton_removeWrite.clicked.connect(lambda: self.dlg.listWidget_write.removeItemWidget(self.dlg.listWidget_write.takeItem(self.dlg.listWidget_write.currentRow())))
        
        self.dlg.rejected.connect(lambda: self.afterCloseEditMapDialog())  
    def run_SetPermission(self, layerName):
        self.dlg = SetPermissionDialog() 
        self.dlg.show()
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.pushButton_addRead.setStyleSheet("#pushButton_addRead {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addRead:hover{background: #66ab27 ;}#pushButton_addRead:disabled{background: #64818b ;}")
        self.dlg.pushButton_removeRead.setStyleSheet("#pushButton_removeRead {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_removeRead:hover{background: #66ab27 ;}#pushButton_removeRead:disabled{background: #64818b ;}")
        self.dlg.pushButton_save.setStyleSheet("#pushButton_save {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_save:hover{background: #66ab27 ;}#pushButton_save:disabled{background: #64818b ;}")
        self.dlg.pushButton_addWrite.setStyleSheet("#pushButton_addWrite {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addWrite:hover{background: #66ab27 ;}#pushButton_addWrite:disabled{background: #64818b ;}")
        self.dlg.pushButton_removeWrite.setStyleSheet("#pushButton_removeWrite {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_removeWrite:hover{background: #66ab27 ;}#pushButton_removeWrite:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}#pushButton_close:disabled{background: #64818b ;}")       
        uri = self.URI + "/rest/users"
        usersDict = dict()
        usersDict['EVERYONE'] = 'EVERYONE'
        usersDictReversed = dict()
        usersDictReversed['EVERYONE'] = 'EVERYONE'
        r= requests.get(uri)
        res = self.fromByteToJson(r.content)
        userCount = len(res)
        ##nabit combobox
        self.dlg.comboBox_users.addItem('EVERYONE')
        for i in range (0, userCount):
            #print(res[i]['name'])
            #print(res[i]['username'])
            usersDict[res[i]['name']] = res[i]['username'] 
            usersDictReversed[res[i]['username']] = res[i]['name'] 
            self.dlg.comboBox_users.addItem(res[i]['name'])
        ##nabit listView
        print(len(layerName))
        if (len(layerName) == 1):            
            layerName[0] = self.removeUnacceptableChars(layerName[0])
            uri = self.URI + "/rest/"+self.laymanUsername+"/layers/"+layerName[0]
        
            r= requests.get(uri,headers = self.getAuthHeader(self.authCfg))
            res = self.fromByteToJson(r.content)
      
            lenRead = len(res['access_rights']['read'])
            lenWrite = len(res['access_rights']['write'])
            for i in range (0, lenRead):
                self.dlg.listWidget_read.addItem(usersDictReversed[res['access_rights']['read'][i]])
            for i in range (0, lenWrite):
                self.dlg.listWidget_write.addItem(usersDictReversed[res['access_rights']['write'][i]])
        self.dlg.pushButton_save.clicked.connect(lambda: self.updatePermissions(layerName, usersDict, "layers"))
        self.dlg.pushButton_addRead.clicked.connect(lambda: self.dlg.listWidget_read.addItem(self.dlg.comboBox_users.currentText()))
        self.dlg.pushButton_addWrite.clicked.connect(lambda: self.setWritePermissionList())
    
        self.dlg.pushButton_removeRead.clicked.connect(lambda: self.removeWritePermissionList())
        self.dlg.pushButton_removeWrite.clicked.connect(lambda: self.dlg.listWidget_write.removeItemWidget(self.dlg.listWidget_write.takeItem(self.dlg.listWidget_write.currentRow())))
        
        self.dlg.rejected.connect(lambda: self.afterCloseEditMapDialog()) 
        
    def run_EditMap(self, x):
        self.dlg = EditMapDialog()      
        self.dlg.pushButton_save.setStyleSheet("#pushButton_save {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_save:hover{background: #66ab27 ;}#pushButton_save:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        
       
        self.dlg.lineEdit_name.hide()
        self.dlg.label_2.hide()
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.lineEdit_name.setText(self.compositeList[x]['name'])
        self.dlg.lineEdit_abstract.setText(self.compositeList[x]['abstract'])
        self.dlg.lineEdit_title.setText(self.compositeList[x]['title'])
        self.dlg.lineEdit_units.setText(self.compositeList[x]['units'])
        self.dlg.lineEdit_scale.setText(str(self.compositeList[x]['scale']))
        self.dlg.lineEdit_user.setText(self.compositeList[x]['user']['name'])
        self.dlg.lineEdit_xmin.setText(self.compositeList[x]['extent'][0])
        self.dlg.lineEdit_xmax.setText(self.compositeList[x]['extent'][2])
        self.dlg.lineEdit_ymin.setText(self.compositeList[x]['extent'][1])
        self.dlg.lineEdit_ymax.setText(self.compositeList[x]['extent'][3])
        self.dlg.rejected.connect(lambda: self.afterCloseEditMapDialog()) 
        self.dlg.pushButton_save.clicked.connect(lambda: self.modifyMap(x))
        self.dlg.rejected.connect(lambda: self.afterCloseCompositeDialog())
        self.dlg.show()
        result = self.dlg.exec_()

    def run_DeleteLayerFromMap(self):
        self.dlg = DeleteLayerFromMapDialog()
        self.dlg.pushButton.clicked.connect(lambda: self.deteteLayerFromComposite(self.dlg.listWidget.currentRow(),self.compositeList[self.dlg.listWidget.currentRow()]['layers'][self.dlg.listWidget_listLayers2.currentRow()]['params']['LAYERS']))
        
       
        layers = QgsProject.instance().mapLayers().values()
        
        for i in range (0, len(self.compositeList)):
            self.dlg.listWidget.addItem(self.compositeList[i]['name'])
       # self.dlg.pushButton.setEnabled(False)
        self.dlg.listWidget.itemClicked.connect(self.listCompositeLayers)
        self.dlg.listWidget_listLayers2.itemClicked.connect(self.showThumbnail)   
        

       # self.dlg.listWidget_listMaps.itemClicked.connect(self.enableButton)    
        self.dlg.show()
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        result = self.dlg.exec_()
    def getActiveLayer(self):
        layer = iface.activeLayer()
        self.layerOldName = layer.name()
        QMessageBox.information(None, "Layman", self.layerOldName )
        self.focusedLayer = layer
    def initFiles(self):
        tempFileFolder = tempfile.gettempdir() + os.sep + "atlas"
        if not os.path.exists(tempFileFolder):
            os.makedirs(tempFileFolder)
        if os.path.exists(tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt") == False:
            open(tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt", "w").close
        if os.path.exists(tempfile.gettempdir() + os.sep + "atlas" + os.sep + "state.txt") == False:
            open(tempfile.gettempdir() + os.sep + "atlas" + os.sep + "state.txt", "w").close
    def run_CreateCompositeDialog(self, fromImport = False):
        self.dlg = CreateCompositeDialog()
        
        self.dlg.label_info.hide()
        self.dlg.label_2.hide()
        self.dlg.lineEdit.hide()
        self.dlg.pushButton_CreateComposition.clicked.connect(lambda: self.createComposite(self.dlg.lineEdit.text(),self.dlg.lineEdit_2.text()))              
        layers = QgsProject.instance().mapLayers().values()
        self.dlg.treeWidget.itemClicked.connect(self.setExtent)
        for layer in layers:
           # self.dlg.listWidget_listLayers.addItem(layer.name())
            if (layer.type() == QgsMapLayer.VectorLayer):
                item = QTreeWidgetItem([layer.name()]) 
            
                    
                self.dlg.treeWidget.addTopLevelItem(item)
        ext = iface.mapCanvas().extent()
        self.dlg.lineEdit.setValidator(QRegExpValidator(QRegExp("[a-z]{1}[a-z0-9]{1,30}")))      
        self.dlg.lineEdit_2.editingFinished.connect(self.checkNameCreateMap)
        self.dlg.lineEdit_3.setText(str(ext.xMinimum()))
        self.dlg.lineEdit_4.setText(str(ext.xMaximum()))
        self.dlg.lineEdit_5.setText(str(ext.yMinimum()))
        self.dlg.lineEdit_6.setText(str(ext.yMaximum()))
        self.dlg.pushButton_defaultExtent.clicked.connect(lambda: self.setDefaultExtent(ext))              
        self.dlg.pushButton_defaultExtent.setStyleSheet("#pushButton_defaultExtent {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_defaultExtent:hover{background: #66ab27 ;}#pushButton_defaultExtent:disabled{background: #64818b ;}")
        self.dlg.pushButton_CreateComposition.setStyleSheet("#pushButton_CreateComposition {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_CreateComposition:hover{background: #66ab27 ;}#pushButton_CreateComposition:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}")
        
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")

        self.dlg.show()
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        if (fromImport):
            self.dlg.rejected.connect(lambda: self.afterCloseCompositeDialog())
        result = self.dlg.exec_()


    def run_ImportMapDialog(self):        
        self.dlg = ImportMapDialog()
        self.dlg.label_import.hide()
        self.dlg.radioButton_wms.setChecked(True)
        self.dlg.radioButton_wfs.setChecked(False)
        self.dlg.label_5.hide()
        if self.locale == "cs":
            self.dlg.label_thumbnail.setText('          Náhled vrstvy')
        else:
            self.dlg.label_thumbnail.setText('          Layer preview')
        #self.dlg.listWidget_listLayers2.hide()
        self.dlg.pushButton_deleteMap.setEnabled(False)
        self.dlg.pushButton_editMeta.setEnabled(False)
        self.dlg.pushButton_addRaster.setEnabled(False)
        self.dlg.pushButton_up.setEnabled(False)
        self.dlg.pushButton_setMapPermissions.setEnabled(False)
        self.dlg.pushButton_down.setEnabled(False)
        self.dlg.pushButton_deleteLayers.setEnabled(False)
       # self.dlg.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.dlg.pushButton.clicked.connect(lambda: self.addLayerToComposite(self.dlg.listWidget.currentRow()))   
        self.dlg.pushButton_deleteMap.clicked.connect(lambda: self.deleteMap(self.dlg.listWidget.currentItem().text(),self.dlg.listWidget.currentRow()))
       # self.dlg.pushButton_deleteMap.clicked.connect(lambda: self.deleteMapFromCanvas(self.dlg.listWidget.currentRow())) 
        self.dlg.pushButton_up.clicked.connect(lambda: self.reorderLayers(self.dlg.listWidget_listLayers.currentRow(), 1, self.dlg.listWidget.currentRow()))
        self.dlg.pushButton_down.clicked.connect(lambda: self.reorderLayers(self.dlg.listWidget_listLayers.currentRow(), -1, self.dlg.listWidget.currentRow()))
        self.dlg.pushButton_saveOrder.clicked.connect(lambda: self.saveReorder(self.dlg.listWidget.currentRow()))
        self.dlg.pushButton_setMapPermissions.clicked.connect(lambda: self.showMapPermissionsDialog(self.dlg.listWidget.currentItem().text()))
        
        #if not self.loadedInMemory:
        self.threadComposites = threading.Thread(target=self.loadCompositesThread)
        self.threadComposites.start()
        #else:
        #    self.loadCompositesThread()
        self.checkServiceAvailability()
        self.dlg.mMapLayerComboBox.currentIndexChanged.connect(lambda: self.checkServiceAvailability())
        self.dlg.pushButton_addMap.clicked.connect(lambda: self.showAddMapDialog())
        
        self.dlg.progressBar.hide()   
        self.dlg.pushButton_saveOrder.hide()
        self.dlg.label_6.hide()
        self.dlg.comboBox_wms.hide()
        self.dlg.pushButton_addWMS.hide()
        self.dlg.pushButton.setEnabled(False)
        self.dlg.pushButton.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'plus.png'))
        self.dlg.pushButton_addMap.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'plus.png'))
        self.dlg.pushButton_addRaster.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'plus.png'))
        self.dlg.pushButton_deleteLayers.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'minus.png'))
        self.dlg.pushButton_deleteMap.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'minus.png'))
        self.dlg.pushButton_editMeta.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'edit.png'))
        self.dlg.pushButton_setMapPermissions.setIcon(QIcon(self.plugin_dir + os.sep + 'icons' + os.sep + 'edit.png'))
        self.dlg.listWidget.itemClicked.connect(self.refreshLayerListReversed)
        self.dlg.listWidget.itemClicked.connect(lambda: self.dlg.pushButton_deleteMap.setEnabled(True))
        self.dlg.listWidget.itemClicked.connect(lambda: self.dlg.pushButton_editMeta.setEnabled(True))
        self.dlg.listWidget.itemClicked.connect(lambda: self.dlg.pushButton_addRaster.setEnabled(True))
        self.dlg.listWidget.itemClicked.connect(lambda: self.dlg.pushButton_up.setEnabled(True))
        self.dlg.listWidget.itemClicked.connect(lambda: self.dlg.pushButton_down.setEnabled(True))
        self.dlg.listWidget.itemClicked.connect(lambda: self.dlg.pushButton_setMapPermissions.setEnabled(True))
        self.dlg.listWidget_listLayers.itemClicked.connect(lambda: self.dlg.pushButton_down.setEnabled(True))
        self.dlg.listWidget_listLayers.itemClicked.connect(lambda: self.dlg.pushButton_up.setEnabled(True))
        self.dlg.listWidget_listLayers.itemClicked.connect(lambda: self.dlg.pushButton_deleteLayers.setEnabled(True))
        self.dlg.listWidget.itemClicked.connect(lambda: self.setListLayer())

        self.dlg.rejected.connect(lambda: self.saveReorder())
        
       # self.dlg.setEnabled(False)
        #
        self.dlg.pushButton_addRaster.setEnabled(False)
        self.dlg.pushButton_addWMS.setEnabled(False)
        self.add = self.dlg.pushButton_addMap.isEnabled()
        self.deleteM = self.dlg.pushButton_deleteMap.isEnabled()
        self.editM = self.dlg.pushButton_editMeta.isEnabled()
        self.up = self.dlg.pushButton_up.isEnabled()
        self.down = self.dlg.pushButton_down.isEnabled()
        self.deleteL = self.dlg.pushButton_deleteLayers.isEnabled()
        self.post = self.dlg.pushButton.isEnabled()
        self.addR = self.dlg.pushButton_addRaster.isEnabled()
        self.importMapEnvironmnet(False)
       
        self.dlg.pushButton_editMeta.clicked.connect(lambda: self.showEditMapDialog(self.dlg.listWidget.currentRow()))
     ###########nacitam vrstvy z laymana do comboboxu
        self.loadExternalWMS()
        self.dlg.pushButton_addWMS.clicked.connect(lambda: self.addExternalWMSToComposite(self.dlg.comboBox_wms.currentText()))
        self.dlg.pushButton_addRaster.clicked.connect(lambda: self.addExistingLayerToComposite(self.dlg.comboBox_raster.currentText(), "raster"))
        #### nahrát mapy ze serveru do comboboxu
        self.dlg.comboBox_raster.currentIndexChanged.connect(lambda: self.dlg.pushButton_addRaster.setEnabled(True))
      
        self.dlg.pushButton_loadMap.clicked.connect(lambda: self.readMapJson(self.dlg.comboBox_loadMap.currentText(), 'WMS'))
        self.dlg.pushButton_loadMapWFS.clicked.connect(lambda: self.readMapJson(self.dlg.comboBox_loadMap.currentText(), 'WFS'))
        self.dlg.pushButton_loadMapWFS.hide()
        self.dlg.pushButton_loadMap.hide()
        self.dlg.comboBox_loadMap.hide()
     #############
        self.dlg.pushButton.setEnabled(False)
        self.dlg.pushButton_deleteLayers.setEnabled(False)
        self.dlg.listWidget_listLayers.itemClicked.connect(self.showSmallThumbnail)
      #  self.dlg.listWidget_listLayers.itemClicked.connect(self.showThumbnail)
        self.dlg.listWidget.itemClicked.connect(self.enableButton)          
        self.dlg.pushButton_deleteLayers.clicked.connect(lambda: self.deteteLayerFromComposite(self.dlg.listWidget.currentRow(),self.dlg.listWidget_listLayers.currentRow(), self.dlg.listWidget_listLayers.currentItem().text()))    
       # self.form()
        self.dlg.show()
        self.dlg.progressBar_loader.show() 
        self.dlg.label_loading.show() 
        #self.dlg.pushButton_close.clicked.connect(lambda: self.saveReorder(self.dlg.listWidget.currentRow()))
        #self.dlg.pushButton_close.clicked.connect(lambda: self.saveReorder())
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.pushButton_saveOrder.setEnabled(False)
        self.dlg.pushButton_down.setStyleSheet("#pushButton_down {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_down:hover{background: #66ab27 ;}#pushButton_down:disabled{background: #64818b ;}")
        self.dlg.pushButton_up.setStyleSheet("#pushButton_up {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_up:hover{background: #66ab27 ;}#pushButton_up:disabled{background: #64818b ;}")
        self.dlg.pushButton.setStyleSheet("#pushButton {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton:hover{background: #66ab27 ;}#pushButton:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}#pushButton_close:disabled{background: #64818b ;}")
        self.dlg.pushButton_deleteLayers.setStyleSheet("#pushButton_deleteLayers {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_deleteLayers:hover{background: #66ab27 ;}#pushButton_deleteLayers:disabled{background: #64818b ;}")
        self.dlg.pushButton_deleteMap.setStyleSheet("#pushButton_deleteMap {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_deleteMap:hover{background: #66ab27 ;}#pushButton_deleteMap:disabled{background: #64818b ;}")
        self.dlg.pushButton_addRaster.setStyleSheet("#pushButton_addRaster {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addRaster:hover{background: #66ab27 ;}#pushButton_addRaster:disabled{background: #64818b ;}")
        self.dlg.pushButton_addMap.setStyleSheet("#pushButton_addMap {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addMap:hover{background: #66ab27 ;}#pushButton_addMap:disabled{background: #64818b ;}")
        self.dlg.pushButton_editMeta.setStyleSheet("#pushButton_editMeta {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_editMeta:hover{background: #66ab27 ;}#pushButton_editMeta:disabled{background: #64818b ;}")
        self.dlg.pushButton_loadMapWFS.setStyleSheet("#pushButton_loadMapWFS {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_loadMapWFS:hover{background: #66ab27 ;}#pushButton_loadMapWFS:disabled{background: #64818b ;}")
        self.dlg.pushButton_addWMS.setStyleSheet("#pushButton_addWMS {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_addWMS:hover{background: #66ab27 ;}#pushButton_addWMS:disabled{background: #64818b ;}")
        self.dlg.pushButton_loadMap.setStyleSheet("#pushButton_loadMap {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_loadMap:hover{background: #66ab27 ;}#pushButton_loadMap:disabled{background: #64818b ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        self.dlg.pushButton_saveOrder.setStyleSheet("#pushButton_saveOrder {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_saveOrder:hover{background: #66ab27 ;}#pushButton_saveOrder:disabled{background: #64818b ;}")
        self.dlg.pushButton_saveOrder.setStyleSheet("#pushButton_saveOrder {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_saveOrder:hover{background: #66ab27 ;}#pushButton_saveOrder:disabled{background: #64818b ;}")
        self.dlg.pushButton_setMapPermissions.setStyleSheet("#pushButton_setMapPermissions {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_setMapPermissions:hover{background: #66ab27 ;}#pushButton_setMapPermissions:disabled{background: #64818b ;}")
        
        

        result = self.dlg.exec_()
    def importMapEnvironmnet(self,enabled):
        time.sleep(1)
        if enabled:
            
            self.dlg.pushButton_deleteMap.setEnabled(self.deleteM)
            self.dlg.pushButton_editMeta.setEnabled(self.editM)
            self.dlg.pushButton_setMapPermissions.setEnabled(self.editP)
            self.dlg.pushButton_up.setEnabled(self.up)
            self.dlg.pushButton_down.setEnabled(self.down)
            self.dlg.pushButton_deleteLayers.setEnabled(self.deleteL)
          #  self.dlg.pushButton.setEnabled(self.post)
            self.dlg.pushButton.setEnabled(True)
           # self.dlg.pushButton.setEnabled(True)
            try:
                self.dlg.pushButton_addMap.setEnabled(self.add)
                self.dlg.pushButton_addRaster.setEnabled(self.addR)
            except:
                pass
        else:
            self.add = self.dlg.pushButton_addMap.isEnabled()
            self.dlg.pushButton_addMap.setEnabled(False)
            self.deleteM = self.dlg.pushButton_deleteMap.isEnabled()
            self.dlg.pushButton_deleteMap.setEnabled(False)
            self.editM = self.dlg.pushButton_editMeta.isEnabled()
            self.editP = self.dlg.pushButton_setMapPermissions.isEnabled()
            self.dlg.pushButton_editMeta.setEnabled(False)
            self.dlg.pushButton_setMapPermissions.setEnabled(False)
            self.up = self.dlg.pushButton_up.isEnabled()
            self.dlg.pushButton_up.setEnabled(False)
            self.down = self.dlg.pushButton_down.isEnabled()
            self.dlg.pushButton_down.setEnabled(False)
            self.deleteL = self.dlg.pushButton_deleteLayers.isEnabled()
            self.dlg.pushButton_deleteLayers.setEnabled(False)
            self.post = self.dlg.pushButton.isEnabled()
            self.dlg.pushButton.setEnabled(False)
            self.addR = self.dlg.pushButton_addRaster.isEnabled()
            self.dlg.pushButton_addRaster.setEnabled(False)

    def loadExternalWMS(self):
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            layerType = layer.type()    
            if layerType == QgsMapLayer.RasterLayer:
                if(str(layer)[-5:-2] == "wms"):
                   # if not (self.isXYZ(layer.name())):
                    self.dlg.comboBox_wms.addItem(layer.name())
                    #self.dlg.pushButton_addWMS.setEnabled(True)
                    self.WMSenable = True
                    
                else:
                    self.WMSenable = False

    def isNewCompositeAdded(self):
        reload = False
        url = self.URI+'/rest/'+self.laymanUsername+'/maps'
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        res = self.fromByteToJson(r.content)
       
           
        lay = set()
        for i in range (0, len(self.compositeList)):
            lay.add(self.compositeList[i]['name'])
        for i in res: 
            if not i['name'] in lay:
                #print("founded")
                reload = True
   
        return reload
        
    def loadCompositesThread(self):
        #self.dlg.listWidget.setSelectionMode(QAbstractItemView.NoSelection)
        if not self.loadedInMemory:
            self.loadAllCompositesT() 
        else:            
            if (self.isNewCompositeAdded()):
                print("reload")
                self.loadAllCompositesT()                
                       
        layers = QgsProject.instance().mapLayers().values() 
        entries = list()
        for i in range (0, len(self.compositeList)):
           
            entries.append(self.compositeList[i]['title'])
        self.dlg.listWidget.addItems(entries)
        url = self.URI+'/rest/'+self.laymanUsername+'/layers'
        #print(url)
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        #print(r.content)
        try:
            data = r.json()
        except:
            QgsMessageLog.logMessage("errConnection")
        for row in range(0, len(data)):          
            #self.dlg.comboBox_raster.addItem(data[row]['name'])
            self.dlg.comboBox_raster.addItem(data[row]['title'])
            self.dlg.comboBox_raster.setCurrentIndex(0)
        url = self.URI+'/rest/'+self.laymanUsername+'/maps'
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        data = r.json()
        
        for row in range(0, len(data)):            
            self.dlg.comboBox_loadMap.addItem(data[row]['name'])
        ##self.dlg.refresh()
        #self.dlg.listWidget.update()
        #self.refreshLayerList()
        time.sleep(2)
        QgsMessageLog.logMessage("successLoadComp")
       # try:
       #     self.dlg.label_loading.hide() 
       #     self.dlg.progressBar_loader.hide() 
       #     #self.dlg.listWidget.setSelectionMode(QAbstractItemView.SingleSelection)
       #     self.importMapEnvironmnet(True)
       # except:
       #     pass
       ## self.dlg.setEnabled(True)
    def run_DeleteMapDialog(self):
        self.dlg = DeleteMapDialog()
        self.refreshListWidgetMaps()
        self.dlg.pushButton.setEnabled(False)
        self.dlg.treeWidget.itemClicked.connect(self.enableButton) 
        self.dlg.pushButton.clicked.connect(lambda: self.deleteMapFromServer(self.dlg.treeWidget.selectedItems()[0].text(0)))
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.show()
        result = self.dlg.exec_()
    def run_ImportLayerDialog(self):
        self.dlg = ImportLayerDialog()
        
      #  self.dlg.pushButton.clicked.connect(lambda: self.postRequest(self.dlg.treeWidget.currentItem().text(0)))

        self.dlg.pushButton.clicked.connect(lambda: self.callPostRequest(self.dlg.treeWidget.selectedItems()))
       
        self.dlg.progressBar.hide() 
        self.dlg.label_import.hide()
        self.dlg.pushButton.setEnabled(False)
       # self.dlg.treeWidget.itemClicked.connect(self.enableButton)  
        self.dlg.treeWidget.itemPressed.connect(self.enableButtonImport)
        self.dlg.treeWidget.itemClicked.connect(self.onItemClicked)
        self.dlg.treeWidget.itemSelectionChanged.connect(lambda: self.disableExport())
        self.dlg.treeWidget.setCurrentItem(self.dlg.treeWidget.topLevelItem(0),0)
        layers = QgsProject.instance().mapLayers().values()
        mix = list()
        for layer in layers:           
            if (layer.type() == QgsMapLayer.VectorLayer):
                layerType = 'vector layer'
            else:
                layerType = 'raster layer'            
            item = QTreeWidgetItem([layer.name(), layerType]) 
           # print(layer.name())
            #print(self.mixedLayers)
            #print(mix)
            if (layerType == 'vector layer'):
                if (layer.name() in self.mixedLayers and layer.name() in mix):
                    pass
                elif (layer.name() in self.mixedLayers and layer.name() not in mix):
                    self.dlg.treeWidget.addTopLevelItem(item)
                    mix.append(layer.name())
                else:
                    self.dlg.treeWidget.addTopLevelItem(item)
        self.dlg.setWindowModality(Qt.ApplicationModal)

        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}")
        self.dlg.pushButton.setStyleSheet("#pushButton {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton:hover{background: #66ab27 ;}#pushButton:disabled{background: #64818b ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")

        self.dlg.show()
        #self.dlg.rejected.connect(lambda: self.setBatchLengthZero()) 
        
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        result = self.dlg.exec_()
    def setBatchLengthZero(self):
        self.batchLength = 0
    def run_login(self):
        
        
        self.dlg = ConnectionManagerDialog()
      
        self.dlg.show()
        self.dlg.pushButton_Dependencies.hide()
        if not self.dependencies:
            self.dlg.pushButton_Connect.hide()
            self.dlg.pushButton_Dependencies.show()
            self.dlg.comboBox_server.setEnabled(False)
            self.dlg.lineEdit_userName.setEnabled(False)
        self.dlg.progressBar.hide()
        self.dlg.pushButton_Connect.setEnabled(False) 
        self.dlg.pushButton_Dependencies.clicked.connect(lambda: self.install())
        path = self.plugin_dir + os.sep + "server_list.txt"
        servers = self.csvToArray(path)
        self.dlg.label_APIKey_2.setToolTip("Username is important only with first login")
        #print(servers)
        
        for i in range (0,len(servers)):
          #  print(servers[i][0])
            self.dlg.comboBox_server.addItem(servers[i][0].replace("www.", "").replace("https://", ""))

        self.setServers(servers, 0) ## nastavujeme prvni server 
        self.dlg.comboBox_server.currentIndexChanged.connect(lambda: self.setServers(servers, self.dlg.comboBox_server.currentIndex()))
        if (os.path.isfile(os.getenv("HOME") + os.sep + ".layman" + os.sep +'layman_user.INI')):
            config = self.loadIni()
            if len(config['DEFAULT']['login']) > 0:
                self.Agrimail = config['DEFAULT']['login']
                self.dlg.pushButton_Connect.setEnabled(True) 
            #self.dlg.lineEdit_userName.setText(config['DEFAULT']['login'] + "@lesprojekt.cz")  
            self.dlg.lineEdit_userName.setText(config['DEFAULT']['login'])  
            try:
                for i in range (0, self.dlg.comboBox_server.count()):                
                    #print(self.dlg.comboBox_server.itemText(i))
                    if(self.dlg.comboBox_server.itemText(i) == config['DEFAULT']['server'].replace("www.", "").replace("https://", "")):
                        self.dlg.comboBox_server.setCurrentIndex(i)
                self.dlg.lineEdit_AgriID.setText(config['DEFAULT']['id']) 
                self.dlg.lineEdit_server.setText(config['DEFAULT']['server']) 
                self.dlg.lineEdit_serverLayman.setText(config['DEFAULT']['layman']) 
            except:
                print("udaj v ini nenalezen")
        else:
            try:
                os.makedirs(os.getenv("HOME") + os.sep + ".layman")
            except:
                print("layman directory already exists")
            #self.dlg.lineEdit_userName.setText("@lesprojekt.cz")
            self.dlg.pushButton_Connect.setEnabled(True) 
       

        
        self.dlg.lineEdit_userName.textChanged.connect(self.checkUsername)
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.pushButton_Connect.clicked.connect(lambda: self.openAuthLiferayUrl2())
        self.dlg.pushButton_Continue.clicked.connect(lambda: self.getToken())
        self.dlg.pushButton_Continue.setEnabled(False)    
        registerSuffix = "/home?p_p_id=com_liferay_login_web_portlet_LoginPortlet&p_p_lifecycle=0&p_p_state=maximized&p_p_mode=view&saveLastPath=false&_com_liferay_login_web_portlet_LoginPortlet_mvcRenderCommandName=%2Flogin%2Fcreate_account"
        self.dlg.comboBox_server.currentTextChanged.connect(self.setReg)
        self.dlg.label_sign.setOpenExternalLinks(True)
        if self.locale == "cs":
            self.dlg.label_sign.setText('<a href="https://'+self.dlg.comboBox_server.currentText().replace('https://','').replace('home','')+registerSuffix+'">Registrovat</a>')
        else:
            self.dlg.label_sign.setText('<a href="https://'+self.dlg.comboBox_server.currentText().replace('https://','').replace('home','')+registerSuffix+'">Register</a>')
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}")
        self.dlg.pushButton_Connect.setStyleSheet("#pushButton_Connect {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_Connect:hover{background: #66ab27 ;}")
        self.dlg.pushButton_Continue.setStyleSheet("#pushButton_Continue {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_Continue:hover{background: #66ab27 ;} #pushButton_Continue:disabled{background: #64818b ;}")
        self.dlg.pushButton_Dependencies.setStyleSheet("#pushButton_Dependencies {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_Dependencies:hover{background: #66ab27 ;} #pushButton_Dependencies:disabled{background: #64818b ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        result = self.dlg.exec_()
        self.dlg.rejected.connect(lambda: self.loginReject())
    def run_AddMapDialog(self):        
        self.dlg = AddMapDialog()
        
        
        
        self.dlg.pushButton.setEnabled(False)
        self.dlg.pushButton_mapWFS.setEnabled(False)
        self.dlg.pushButton_mapWFS.setEnabled(True)
        self.dlg.pushButton.hide()
        self.dlg.pushButton_mapWFS.hide()
        self.dlg.label_info.hide()
     
        self.dlg.treeWidget.itemClicked.connect(self.showThumbnailMap)
        self.dlg.treeWidget.itemClicked.connect(self.enableButton)
        self.dlg.treeWidget.itemClicked.connect(self.enableLoadMapButtons)
        

        self.dlg.pushButton.clicked.connect(lambda: self.readMapJson(self.dlg.treeWidget.selectedItems()[0].text(0), 'WMS'))
        self.dlg.pushButton_mapWFS.clicked.connect(lambda: self.readMapJson(self.dlg.treeWidget.selectedItems()[0].text(0), 'WFS'))
        self.dlg.pushButton_map.clicked.connect(lambda: self.readMapJson(self.dlg.treeWidget.selectedItems()[0].text(0), 'WFS'))
        

        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        self.dlg.pushButton_map.setStyleSheet("#pushButton_map {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_map:hover{background: #66ab27 ;}#pushButton_map:disabled{background: #64818b ;}")
        self.dlg.pushButton_mapWFS.setStyleSheet("#pushButton_mapWFS {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_mapWFS:hover{background: #66ab27 ;}#pushButton_mapWFS:disabled{background: #64818b ;}")
        self.dlg.pushButton.setStyleSheet("#pushButton {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton:hover{background: #66ab27 ;}#pushButton:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}#pushButton_close:disabled{background: #64818b ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")

        self.dlg.show()
        self.dlg.progressBar_loader.show() 
        self.dlg.label_loading.show() 
        self.threadLayers = threading.Thread(target=self.loadMapsThread)
        self.threadLayers.start()
        result = self.dlg.exec_()
    def loadMapsThread(self):
        url = self.URI+'/rest/'+self.laymanUsername+'/maps'
       
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
       
        data = r.json()
        
        
        for row in range(0, len(data)):
            url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+data[row]['name']+'/file'
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
           
            d = r.json()
                 
            item = QTreeWidgetItem([d['title']])            
            self.dlg.treeWidget.addTopLevelItem(item)
        time.sleep(1)
        QgsMessageLog.logMessage("loadMaps")
        
    def run_AddLayerDialog(self):
        
        self.dlg = AddLayerDialog()
        self.dlg.pushButton_layerRedirect.hide()
        self.dlg.pushButton_layerRedirect.setEnabled(False)
        self.dlg.pushButton.setEnabled(False)
        self.dlg.pushButton_wfs.setEnabled(False)
        self.dlg.pushButton_delete.setEnabled(False)
        self.dlg.pushButton_setPermissions.setEnabled(False)
        self.threadLayers = threading.Thread(target=self.loadLayersThread)
        self.threadLayers.start()

        
        #self.dlg.pushButton_delete.clicked.connect(lambda: self.layerDelete(self.dlg.treeWidget.selectedItems()[0].text(0)))    
        self.dlg.pushButton_delete.clicked.connect(lambda: self.callDeleteLayer(self.dlg.treeWidget.selectedItems()))    
        self.dlg.pushButton_layerRedirect.clicked.connect(lambda: self.layerInfoRedirect(self.dlg.treeWidget.selectedItems()[0].text(0)))
        self.dlg.pushButton.clicked.connect(lambda: self.readLayerJson(self.dlg.treeWidget.selectedItems(), "WMS"))
        self.dlg.pushButton_wfs.clicked.connect(lambda: self.readLayerJson(self.dlg.treeWidget.selectedItems(), "WFS"))
        self.dlg.treeWidget.itemClicked.connect(self.showThumbnail)  
        self.dlg.treeWidget.itemClicked.connect(self.enableDeleteButton) 
        self.dlg.treeWidget.itemSelectionChanged.connect(self.checkSelectedCount)
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        #self.dlg.setWindowModality(Qt.ApplicationModal)
        self.dlg.pushButton_setPermissions.clicked.connect(lambda: self.showPermissionsDialog(self.dlg.treeWidget.selectedItems()))
        self.dlg.pushButton_delete.setStyleSheet("#pushButton_delete {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_delete:hover{background: #66ab27 ;}#pushButton_delete:disabled{background: #64818b ;}")
        self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}#pushButton_close:disabled{background: #64818b ;}")
        self.dlg.pushButton_delete.setStyleSheet("#pushButton_delete {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_delete:hover{background: #66ab27 ;}#pushButton_delete:disabled{background: #64818b ;}")
        self.dlg.pushButton.setStyleSheet("#pushButton {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton:hover{background: #66ab27 ;}#pushButton:disabled{background: #64818b ;}")
        self.dlg.pushButton_wfs.setStyleSheet("#pushButton_wfs {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_wfs:hover{background: #66ab27 ;}#pushButton_wfs:disabled{background: #64818b ;}")
        self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        self.dlg.pushButton_setPermissions.setStyleSheet("#pushButton_setPermissions {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_setPermissions:hover{background: #66ab27 ;}#pushButton_setPermissions:disabled{background: #64818b ;}")

        self.dlg.progressBar_loader.show() 
        self.dlg.label_loading.show() 
        self.dlg.show()
        result = self.dlg.exec_()

    def loadLayersThread(self):
        #if not self.loadedInMemory:
        #    self.loadAllComposites()
        url = self.URI+'/rest/'+self.laymanUsername+'/layers'
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))    
        data = r.json()
        
        for row in range(0, len(data)): 
           
            
            try:

                item = QTreeWidgetItem([data[row]['title']])    
                
                title = data[row]['title']
                if title == None or title == "" or title == "null":
                    item = QTreeWidgetItem([data[row]['name']])       
                self.dlg.treeWidget.addTopLevelItem(item)               
                
            except:
               
                item = QTreeWidgetItem([self.getLayerTitle(data[row]['name'])])
                self.dlg.treeWidget.addTopLevelItem(item)
        QgsMessageLog.logMessage("layersLoaded")
        
    def addExternalWMSToComposite(self, name):
        #layer = QgsProject.instance().mapLayersByName(name)[0]
        #params = layer.dataProvider().dataSourceUri().split("&")
        #layers = list()
        #for p in params:
        #    #print(p)
        #    param = p.split("=")                
        #    if(str(param[0]) == "crs"):
        #        crs = (param[1])
        #    if(str(param[0]) == "format"):
        #        format = (param[1])   
        #        print(format)
        #    if(str(param[0]) == "url"):
        #        url = (param[1])   
        #        print(url) 
        #    if(str(param[0]) == "layers"):
        #        layers.append(param[1])   
        #     #   print(layers)    
       
        self.addExistingLayerToComposite(name, "wms")
    def listToString(self, s):     
       
        str1 = "," 
        return (str1.join(s)) 
    def updatePermissions(self,layerName, userDict, type):
        
        itemsTextListRead =  [str(self.dlg.listWidget_read.item(i).text()) for i in range(self.dlg.listWidget_read.count())]
        itemsTextListWrite =  [str(self.dlg.listWidget_write.item(i).text()) for i in range(self.dlg.listWidget_write.count())]
        userNamesRead = list()
        for pom in itemsTextListRead:
            userNamesRead.append(userDict[pom])
        userNamesWrite = list()
        for pom in itemsTextListWrite:
            userNamesWrite.append(userDict[pom])
        data = {'access_rights.read': self.listToString(userNamesRead),   'access_rights.write': self.listToString(userNamesWrite)}
        #data = {'access_rights':  read}
        status = True
        for layer in layerName:
            layer = self.removeUnacceptableChars(layer)
            response = requests.patch(self.URI+'/rest/'+self.laymanUsername+'/'+type+'/'+layer, data = data,  headers = self.getAuthHeader(self.authCfg))
            print(response.content)
            if (response.status_code != 200):
                status = False

        if (status):
            if self.locale == "cs":                
                QMessageBox.information(None, "Uloženo", "Práva byly úspěšně uloženy.")
            else:
                QMessageBox.information(None, "Saved", "Permissions was saved successfully.")
        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Chyba", "Práva k vrstvě nebyly uloženy!")               
            else:
                QMessageBox.information(None, "Error", "Permissions was not saved!")                 
    
    def disableExport(self):
        #print(self.dlg.treeWidget.currentItem())
       # print(self.dlg.treeWidget.selectedItems())
        if self.dlg.treeWidget.selectedItems() == []:
            self.dlg.pushButton.setEnabled(False)
        else:
            self.dlg.pushButton.setEnabled(True)


    def showExistingLayers(self,x):
 
        self.dlg.listWidget_listLayers.clear()    
        for i in range (0,len(self.compositeList[self.dlg.listWidget.currentRow()]['layers'])):         
               
            self.dlg.listWidget_listLayers.addItem(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
    #--------------------------- slots---------------------
   # @QtCore.pyqtSlot(QtWidgets.QTreeWidgetItem, int)
    def onItemClicked(self, it, col):     
        if (it.text(1) == 'raster layer'):
            self.dlg.pushButton.setEnabled(False)
        else:
            self.dlg.pushButton.setEnabled(True)
    def setExtent(self, it, col):
        layer = QgsProject.instance().mapLayersByName(it.text(0))
        ext = layer[0].extent()
        xmin = ext.xMinimum()
        xmax = ext.xMaximum()
        ymin = ext.yMinimum()
        ymax = ext.yMaximum()
        self.dlg.lineEdit_3.setText(str(xmin))
        self.dlg.lineEdit_4.setText(str(xmax))
        self.dlg.lineEdit_5.setText(str(ymin))
        self.dlg.lineEdit_6.setText(str(ymax))
        self.dlg.label_4.setText("Extent of canvas: " + it.text(0))
    def checkSelectedCount(self):
        if (len(self.dlg.treeWidget.selectedItems()) > 1):
            self.dlg.pushButton_setPermissions.setEnabled(True)
            self.dlg.pushButton_wfs.setEnabled(True)
            self.dlg.pushButton_delete.setEnabled(True)
            self.dlg.pushButton.setEnabled(True)
        else:
            self.dlg.pushButton_setPermissions.setEnabled(True)
            self.dlg.pushButton_wfs.setEnabled(True)
            self.dlg.pushButton_delete.setEnabled(True)
            self.dlg.pushButton.setEnabled(True)
        
    def enableDeleteButton(self, item, col):
        self.dlg.pushButton.setEnabled(True)
        self.dlg.pushButton_wfs.setEnabled(True)
        self.dlg.pushButton_layerRedirect.setEnabled(True)
        self.dlg.pushButton_delete.setEnabled(True)
        self.dlg.pushButton_setPermissions.setEnabled(True)
        self.checkSelectedCount()

    def enableButton(self, item, col):
        
        
        self.dlg.pushButton.setEnabled(True)
        self.dlg.pushButton_mapWFS.setEnabled(True)
       # self.dlg.pushButton_map.setEnabled(True)
        self.dlg.pushButton_deleteLayers.setEnabled(True)
        self.dlg.pushButton_editMeta.setEnabled(True)
        self.dlg.pushButton_setMapPermissions.setEnabled(True)
        self.dlg.pushButton_addRaster.setEnabled(True)   
        try:
            if (self.WMSenable):
                self.dlg.pushButton_addWMS.setEnabled(True)
        except:
            pass

    def saveReorder(self):
        for x in self.mapsChanged:
           
            self.importMap(x, 'mov')
        print("changes saved to server")
        #self.dlg.pushButton_saveOrder.setEnabled(False)
    def getVersion(self):
        config = configparser.ConfigParser()
        config.read(os.path.join(self.plugin_dir ,'metadata.txt'))
        version = config.get('general', 'version')
        return(version)
    def checkUsername(self, name):
        n = name.split("@")
        if(len(n[0]) > 0):
            self.dlg.pushButton_Connect.setEnabled(True) 
            #self.Agrimail = n[0]
            self.Agrimail = name
        else:
            self.dlg.pushButton_Connect.setEnabled(False) 

    def setListLayer(self):
        count = self.dlg.listWidget_listLayers.count()
        if count == 0:
            self.dlg.pushButton_deleteLayers.setEnabled(False)
            self.dlg.pushButton_up.setEnabled(False)
            self.dlg.pushButton_down.setEnabled(False)
        else:
            self.dlg.listWidget_listLayers.setCurrentRow(0)
            self.dlg.pushButton_deleteLayers.setEnabled(True)
            self.dlg.pushButton_up.setEnabled(True)
            self.dlg.pushButton_down.setEnabled(True)
    def checkLoadedMap(self, name):
       
        loaded = False
        for i in range (0, len(self.compositeList)):
            if self.compositeList[i]['name'] == name:
                loaded = True
            
        return loaded 
                   
    def csvToArray(self, path):
        results = []
        with open(path) as csvfile:
            reader = csv.reader(csvfile,delimiter=',') # change contents to floats
            for row in reader: # each row is a list
                results.append(row)
        return results
    def setReg(self, str):
        registerSuffix = "/home?p_p_id=com_liferay_login_web_portlet_LoginPortlet&p_p_lifecycle=0&p_p_state=maximized&p_p_mode=view&saveLastPath=false&_com_liferay_login_web_portlet_LoginPortlet_mvcRenderCommandName=%2Flogin%2Fcreate_account"
        if self.locale == "cs":
            self.dlg.label_sign.setText('<a href="https://'+self.dlg.comboBox_server.currentText().replace('https://','').replace('home','')+registerSuffix+'">Registrovat</a>')
        else:
            self.dlg.label_sign.setText('<a href="https://'+self.dlg.comboBox_server.currentText().replace('https://','').replace('home','')+registerSuffix+'">Register</a>')
    def loginReject(self):
        if self.dlg.pushButton_Continue.isEnabled():
            self.getToken()
        else:
            self.dlg.close()
    def logout(self):
        self.disableEnvironment()
        self.textbox.setText("Layman")
        userEndpoint = self.URI+ "/rest/current-user"    
        r = requests.delete(url = userEndpoint, headers = self.getAuthHeader(self.authCfg))
       
        self.dlg.close()
        self.textbox.setText("Layman")
        ## flush variables
        self.loadedInMemory = False
        self.compositeList = []
        self.compositeListOld = []
       # self.flaskThread.join()
       # self.thread1.join() ## ukončujeme vlákno, které se stará o refresh tokenů OAUTH
    def disableEnvironment(self):
        self.menu_saveLocalFile.setEnabled(False)
        self.menu_loadJson.setEnabled(False)
        self.menu_ImportLayerDialog.setEnabled(False)
        self.menu_AddLayerDialog.setEnabled(False) 
        self.menu_AddMapDialog.setEnabled(False)       
        self.menu_ImportLayerDialog.setEnabled(False)
        self.menu_ImportMapDialog.setEnabled(False)    
        self.menu_UserInfoDialog.setEnabled(False)
    def setServers(self, servers, i):        
        self.URI = servers[i][1]
        self.liferayServer = servers[i][0]
        self.client_id = servers[i][2]
        try:
            self.client_secret = servers[i][3]
            self.authCfg = servers[i][4]
        except:
            pass # old version compatibility
      
    def enableLoadMapButtons(self, item):
        self.dlg.pushButton_mapWFS.setEnabled(True)
    def enableButtonImport(self, item, column):
        if (len(self.dlg.treeWidget.selectedItems()) > 0):
            self.dlg.pushButton.setEnabled(True)
        else:
            self.dlg.pushButton.setEnabled(False)


    def enableButton(self, item):
        try:
            if (self.WMSenable):
                self.dlg.pushButton_addWMS.setEnabled(True)
        except:
            pass
        try: ## addMap nemá combobox
            if (self.dlg.mMapLayerComboBox.count() > 0):
                #self.dlg.pushButton.setEnabled(True) 
                #self.dlg.pushButton_mapWFS.setEnabled(True)
                self.dlg.pushButton_map.setEnabled(True)
            else:
                self.dlg.pushButton.setEnabled(False)
        except:
            self.dlg.pushButton.setEnabled(True) ## addMap nemá combobox nastavujeme funkční tlačítko

        #try:
        #    self.dlg.pushButton_deleteLayers.setEnabled(True) # pro formulář importMap
        #except:
        #    pass
    def listCompositeLayers(self, it):    
         self.dlg.listWidget_listLayers2.clear()    
         for i in range (0,len(self.compositeList[self.dlg.listWidget.currentRow()]['layers'])):    
            
            self.dlg.listWidget_listLayers2.addItem(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
    def deleteLayerThrowCompositions(self, name, title):
        
        name = self.removeUnacceptableChars(name).lower()
        for x in range (0,len(self.compositeList)):
            
            for i in range (0,len(self.compositeList[x]['layers'])): 
                 try: 
                     if (name == self.removeUnacceptableChars(self.compositeList[x]['layers'][i]['title'])):
                        inComposite = True
                        print("inComposite")
                 
                    
                        threading.Thread(target=lambda: self.deteteLayerFromCompositeThread(x, i, name, title)).start()
                 except:
                     print("nesprávný formát kompozice: " + name)
    def checkLayersInComopsitions(self, name):
        name = self.removeUnacceptableChars(name)
        #print("remove" + name)
        inComposite = False
        for x in range (0,len(self.compositeList)):           
            for i in range (0,len(self.compositeList[x]['layers'])): 
                try: ## osetreni pokud neni vrstva v korektnim tvaru na laymanu - apliakce nespadne
                    if (name == self.compositeList[x]['layers'][i]['params']['LAYERS']):
                        inComposite = True                      
                except:
                    pass
                try: ## osetreni pokud neni vrstva v korektnim tvaru na laymanu - apliakce nespadne
                    if (name == self.compositeList[x]['layers'][i]['protocol']['LAYERS']):
                        inComposite = True                      
                except:
                    pass
        return inComposite


    def refreshCompositeList(self):
        self.dlg.listWidget.clear()
        
        
        for i in range (0, len(self.compositeList)):
           # self.dlg.listWidget.addItem(self.compositeList[i]['name'])
           self.dlg.listWidget.addItem(self.compositeList[i]['title'])
 

    def refreshLayerList(self):
        self.dlg.listWidget_listLayers.clear()
        for i in (range (0,len(self.compositeList[self.dlg.listWidget.currentRow()]['layers']))):
            self.dlg.listWidget_listLayers.addItem(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
            #print(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])

    def refreshLayerListNonReversed(self):
        self.dlg.listWidget_listLayers.clear()
        for i in range (0,len(self.compositeList[self.dlg.listWidget.currentRow()]['layers'])):
            self.dlg.listWidget_listLayers.addItem(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
    #        print(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
    def refreshLayerListReversed(self):
        self.dlg.listWidget_listLayers.clear()
        for i in range (len(self.compositeList[self.dlg.listWidget.currentRow()]['layers'])-1,-1,-1):
            #self.dlg.listWidget_listLayers.addItem(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
            self.dlg.listWidget_listLayers.addItem(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['title'])
            #print(self.compositeList[self.dlg.listWidget.currentRow()]['layers'][i]['params']['LAYERS'])
        try:
            self.dlg.listWidget_listLayers.setCurrentRow(0)
        except:
            self.dlg.pushButton_deleteLayers.setEnabled(False)
            self.dlg.pushButton_up.setEnabled(False)
            self.dlg.pushButton_down.setEnabled(False)
    def transformLayer(self, layer):
        path = tempFile = tempfile.gettempdir() + os.sep + layer.name()
        parameter = {'INPUT': layer, 'TARGET_CRS': 'EPSG:4326', 'OUTPUT': path}
        processing.run('qgis:reprojectlayer', parameter)
        return path
    def refreshListWidgetMaps(self):
        self.dlg.treeWidget.clear()
        url = self.URI+'/rest/'+self.laymanUsername+'/maps'
      
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        
        data = r.json()  
       
        for row in range(0, len(data)):                
            item = QTreeWidgetItem([data[row]['name']])           
            self.dlg.treeWidget.addTopLevelItem(item)

    def showAddMapDialog(self):
        self.old_dlg = self.dlg
        self.run_CreateCompositeDialog(True)      
        
       
    ### connect
    def afterCloseCompositeDialog(self):        
        self.dlg = self.old_dlg
        self.refreshCompositeList()

    def afterCloseEditMapDialog(self):
        self.dlg = self.old_dlg

    def showMapPermissionsDialog(self, x):        
        self.old_dlg = self.dlg        
        self.run_SetMapPermission(x)
    def showPermissionsDialog(self, x):        
        self.old_dlg = self.dlg
        names = list() 
        for i in range (0, len(self.dlg.treeWidget.selectedItems())):
            names.append(self.dlg.treeWidget.selectedItems()[i].text(0))  
        self.run_SetPermission(names)
    def showEditMapDialog(self, x):        
        self.old_dlg = self.dlg
        self.run_EditMap(x)
            ############### pravdepodobne půjde smazat
    def refreshItems(self):
  
         self.dlg.listWidget_listLayers.clear()    
         for i in range (0,len(self.compositeList)):            
           # self.dlg.listWidget_listLayers.addItem(self.compositeList[i]['name'])
           self.dlg.listWidget_listLayers.addItem(self.compositeList[i]['title'])

    def saveEditedToComposite(self,x):        
        self.compositeList[x]['abstract'] =  self.dlg.lineEdit_abstract.text()  
        self.compositeList[x]['title'] =  self.dlg.lineEdit_title.text() 
    def callDeleteLayer(self, layers):
        #print("len" + str(len(layers)))
        items = list()
        for i in range (0, len(self.dlg.treeWidget.selectedItems())):
            items.append(self.dlg.treeWidget.selectedItems()[i].text(0))
        print(items)
        for j in range (0, len(items)):
            self.layerDelete(items[j])
    def layerDelete(self, name):
        title = name
        if self.locale == "cs":
            msgbox = QMessageBox(QMessageBox.Question, "Delete layer", "Chcete opravdu smazat vrstvu "+str(name)+"?")
        else:
            msgbox = QMessageBox(QMessageBox.Question, "Delete layer", "Do you want delete layer "+str(name)+"?")
        msgbox.addButton(QMessageBox.Yes)
        msgbox.addButton(QMessageBox.No)
        msgbox.setDefaultButton(QMessageBox.No)
        reply = msgbox.exec()
        if (reply == QMessageBox.Yes):
            if (self.checkLayersInComopsitions(name) == True):
                if self.locale == "cs":
                    msgbox = QMessageBox(QMessageBox.Question, "Delete layer", "Tato vrstva je obsažena v některých mapových kompozicích. Pokud budete pokračovat, bude smazána také z těchto kompozic.")
                else:
                    msgbox = QMessageBox(QMessageBox.Question, "Delete layer", "This layers is included in other compositions. It will be deleted from every composition.")
                msgbox.addButton(QMessageBox.Yes)
                msgbox.addButton(QMessageBox.No)
                msgbox.setDefaultButton(QMessageBox.No)
                reply = msgbox.exec()                
                if (reply == QMessageBox.Yes):
                   
                    name = self.removeUnacceptableChars(name).lower()   
                    threading.Thread(target=lambda: self.layerDeleteThread(name)).start()
                    self.dlg.progressBar_loader.show() 
                    #try:
                    self.deleteLayerThrowCompositions(name, title)
                    #except:
                    #    pass
                
            else:    
                name = self.removeUnacceptableChars(name).lower()   
                threading.Thread(target=lambda: self.layerDeleteThread(name)).start()
                self.dlg.progressBar_loader.show() 
            
          
    def layerDeleteThread(self, name):       
        url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+name    
        response = requests.delete(url, headers = self.getAuthHeader(self.authCfg))
     
        self.deleteItemFromTreeWidget(name)
        QgsMessageLog.logMessage("delLay")
    def deleteItemFromTreeWidget(self,name):
        #print(name)
        iterator= QTreeWidgetItemIterator(self.dlg.treeWidget);
        items = []
        while iterator.value():
            item = iterator.value()
            iterator+=1           
            if (self.removeUnacceptableChars(item.text(0)) == self.removeUnacceptableChars(name)):
                print("vyhodit")
            else:
                items.append(item.text(0))
        self.dlg.treeWidget.clear()
        for i in items:
            item = QTreeWidgetItem([i])
            self.dlg.treeWidget.addTopLevelItem(item)
       
        
    def addLayerRefresh(self):
        self.dlg.treeWidget.clear()
        url = self.URI+'/rest/'+self.laymanUsername+'/layers'
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))     
        data = r.json()
        for row in range(0, len(data)):    
      
            item = QTreeWidgetItem([self.getLayerTitle(data[row]['name'])])
            self.dlg.treeWidget.addTopLevelItem(item)
    def checkIfMapExist(self, name):
        url = self.URI + "/rest/"+self.laymanUsername+"/maps/"+str(name)+"/file"
       
        r = requests.get(url, headers = self.getAuthHeader(self.authCfg))
        

        if (r.status_code == 404):
            return False
        else:
            return True

    def reorderLayers(self, pos, order, x):
        self.dlg.pushButton_saveOrder.setEnabled(True)
        self.compositeList[x]['layers']
        i = 0
        compositeLength = len(self.compositeList[x]['layers'])
        self.mapsChanged.add(x)
        if (pos + order < 0):
            if self.locale == "cs":
                QMessageBox.information(None, "Error", "Vrstva je již na vrcholu kompozice!")
            else:
                QMessageBox.information(None, "Error", "Layer is already on the top level!")
            
        elif( pos + order == compositeLength):
            if self.locale == "cs":
                QMessageBox.information(None, "Error", "Vrstva je již na spodu kompozice!")
            else:
                QMessageBox.information(None, "Error", "Layer is already on the bottom level!")

        else:
       

            for lay in self.compositeList[x]['layers']:
              
                z = len(self.compositeList[x]['layers'])-1 - pos
                if i == z:

                    pom = self.compositeList[x]['layers'][z]
                    self.compositeList[x]['layers'][z] = self.compositeList[x]['layers'][z - order]
                    self.compositeList[x]['layers'][z - order] = pom     

                i = i + 1
           
           
            
            self.refreshLayerListReversed()
            self.dlg.listWidget_listLayers.setCurrentRow(pos + order)

    def showThumbnail(self, it):
        try:
            layer = it.text(0) ##pro QTreeWidget
        except:
            layer = it.text()##pro listWidget
        try:
            layer = self.removeUnacceptableChars(layer)
            url = self.URI+'/rest/' +self.laymanUsername+'/layers/'+layer+'/thumbnail'    
            print("thubmnailURL" + url)
            #data = urlopen(url).read()
            r = requests.get(url, headers = self.getAuthHeader(self.authCfg))
            data = r.content
            #print(data)
            pixmap = QPixmap(200, 200)
            pixmap.loadFromData(data)
            smaller_pixmap = pixmap.scaled(200, 200, Qt.KeepAspectRatio, Qt.FastTransformation)
            self.dlg.label_thumbnail.setPixmap(smaller_pixmap)
            self.dlg.label_thumbnail.setAlignment(Qt.AlignCenter)
        except:
            self.dlg.label_thumbnail.setText('  Unable to load thumbnail.')
    def showSmallThumbnail(self, it):
        try:
            layer = it.text(0) ##pro QTreeWidget
        except:
            layer = it.text()##pro listWidget
        try:
            layer = self.removeUnacceptableChars(layer)
            url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+layer+'/thumbnail'
            print("thubmnailURL" + url)
            #data = urlopen(url).read()
            #print(data)
            r = requests.get(url, headers = self.getAuthHeader(self.authCfg))
            data = r.content
            pixmap = QPixmap(170, 170)
            pixmap.loadFromData(data)
            smaller_pixmap = pixmap.scaled(170, 170, Qt.KeepAspectRatio, Qt.FastTransformation)
            self.dlg.label_thumbnail.setPixmap(smaller_pixmap)
            self.dlg.label_thumbnail.setAlignment(Qt.AlignCenter)
        except:
            self.dlg.label_thumbnail.setText('  Unable to load thumbnail.')

    def showThumbnailMap(self, it):
        try:
            map = it.text(0) ##pro QTreeWidget
        except:
            map = it.text()##pro listWidget
        
        try:
            map = self.removeUnacceptableChars(str(map))
            url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+str(map).lower()+'/thumbnail'    
          
            data = urlopen(url).read()
            pixmap = QPixmap(100, 100)
            pixmap.loadFromData(data)
            smaller_pixmap = pixmap.scaled(100, 100, Qt.KeepAspectRatio, Qt.FastTransformation)
            self.dlg.label_thumbnail.setPixmap(smaller_pixmap)
           # self.dlg.label_thumbnail.setAlignment(Qt.AlignCenter)
        except:
            self.dlg.label_thumbnail.setText('       Unable to load thumbnail.')
    def setup_oauth(self, authcfg_id, authcfg_name):
        """Setup oauth configuration to access OAuth API,
        return authcfg_id on success, None on failure
        """
        #cfgjson = {
        #"accessMethod": 0,
        #"apiKey": "",
        #"clientId": self.client_id,
        #"clientSecret": "secret-401774e6-769c-42b5-42ac-1c1763e619f",
        #"configType": 1,
        #"description": "",
        #"grantFlow": 0,
        #"id": "esa2024",
        #"name": "auth",
        #"objectName": "",
        #"password": "",
        #"persistToken": False,
        #"queryPairs": {
        #},
        #"redirectPort": 7070,
        #"redirectUrl": "",
        #"refreshTokenUrl": "",
        #"requestTimeout": 60,
        #"requestUrl": self.liferayServer + "/o/oauth2/authorize", 
        #"scope": "",
        #"tokenUrl": self.liferayServer + "/o/oauth2/token",
        #"username": "",
        #"version": 1
        #}
        
        cfgjson = {
        "accessMethod": 0,
        "apiKey": "",
        "clientId": self.client_id,
        "clientSecret": self.client_secret,
        "configType": 1,
        "description": "",
        "grantFlow": 0,
        "id": "esa2024",
        "name": "auth",
        "objectName": "",
        "password": "",
        "persistToken": False,
        "queryPairs": {
        },
        "redirectPort": 7070,
        "redirectUrl": "client/oauthn2-liferay/callback",
        "refreshTokenUrl": "",
        "requestTimeout": 60,
        "requestUrl": self.liferayServer + "/o/oauth2/authorize", 
        "scope": "",
        "tokenUrl": self.liferayServer + "/o/oauth2/token",
        "username": "",
        "version": 1
        }

        if authcfg_id not in QgsApplication.authManager().availableAuthMethodConfigs():
            authConfig = QgsAuthMethodConfig('OAuth2')
            authConfig.setId(authcfg_id)
            authConfig.setName(authcfg_name)
            authConfig.setUri(self.liferayServer)
            authConfig.setConfig('oauth2config', json.dumps(cfgjson))
            if QgsApplication.authManager().storeAuthenticationConfig(authConfig):
                return authcfg_id
        else:
            authConfig = QgsAuthMethodConfig()
            QgsApplication.authManager().loadAuthenticationConfig(authcfg_id, authConfig, True)
            authConfig.setName(authcfg_name)
            authConfig.setUri(self.liferayServer)
            authConfig.setConfig('oauth2config', json.dumps(cfgjson))
            if QgsApplication.authManager().updateAuthenticationConfig(authConfig):
                return authcfg_id
        return None
    def checkNameCreateMap(self):
        text = self.dlg.lineEdit_2.text()
        if text != "":
            text = self.removeUnacceptableChars(text)
           
            ### map check
            url = self.URI + "/rest/"+self.laymanUsername+"/maps/"+str(text)+"/file"
           
            r = requests.get(url, headers = self.getAuthHeader(self.authCfg))
         
            res = r.json()
          
            ch = True
            e = False
            try:
                if res['code'] == 2:
                    ch = False
                else:
                    ch = True
            except:
                ch = True
                e = True ## kdyz nevraci rescode tak je to v poradku

            if not ch:
                self.dlg.pushButton_CreateComposition.setEnabled(False)
                self.dlg.label_info.show()
                if self.locale == "cs":
                    self.dlg.label_info.setText("Nepřípustný znak v názvu!")
                else:
                    self.dlg.label_info.setText("Unacceptable char in title!")
            elif (not e):            
                self.dlg.pushButton_CreateComposition.setEnabled(True)
                self.dlg.label_info.hide()
            
            else:
                self.dlg.pushButton_CreateComposition.setEnabled(False)
                self.dlg.label_info.show()
                if self.locale == "cs":
                    self.dlg.label_info.setText("Kompozice s tímto jménem již existuje!")
                else:
                    self.dlg.label_info.setText("Composition name already exists!")
            ##
            self.dlg.label_info.setStyleSheet("color: red;")

            #if (self.checkIfMapExist(text)):
            #    self.dlg.pushButton_CreateComposition.setEnabled(False)
            #    self.dlg.label_info.show()
            
            #else:
            #    self.dlg.pushButton_CreateComposition.setEnabled(True)
            #    self.dlg.label_info.hide()
        #----------------------------------------------------------
    def readLayerJson(self,layerName, service):
        #self.threadAddMap = threading.Thread(target=lambda: self.readLayerJsonThread(layerName,service))
        #self.threadAddMap.start()
        for i in range (0, len(self.dlg.treeWidget.selectedItems())):
            name = self.dlg.treeWidget.selectedItems()[i].text(0)        
            self.readLayerJsonThread(name,service)
    
    def readLayerJsonThread(self, layerName,service):
        if self.checkLayerOnLayman(layerName):
            layerNameTitle =layerName
            layerName = self.removeUnacceptableChars(layerName)
            url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+layerName  
           
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
            data = r.json()
            if (service == "WMS"):
               
                try:
                    wmsUrl = data['wms']['url']
                except:
                    QgsMessageLog.logMessage("wrongLoaded")
                    return
                format = 'png'
                epsg = 'EPSG:4326' 
                self.loadWms(wmsUrl, layerName,layerNameTitle, format, epsg) 
            if (service == "WFS"):
                try:
                    wfsUrl = data['wfs']['url']
                except:
                    QgsMessageLog.logMessage("wrongLoaded")
                    return
                print("loading WFS")
                self.loadWfs(wfsUrl, layerName, layerNameTitle) 
        else:
            QgsMessageLog.logMessage("readJson")
    def write_log_message(self,message, tag, level):
        #print(message)
        if message == "errConnection":
            if self.locale == "cs":
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Připojení k serveru selhalo!"), Qgis.Warning, duration=3)               
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Connection with server failed!"), Qgis.Warning, duration=3)
        if message == "successLoadComp":
            try:
                self.dlg.label_loading.hide() 
                self.dlg.progressBar_loader.hide() 
                #self.dlg.listWidget.setSelectionMode(QAbstractItemView.SingleSelection)
                self.importMapEnvironmnet(True)
            except:
                pass
        if message == "compositionLoaded":
            try:
                self.menu_ImportMapDialog.setEnabled(True) 
            except:
                if self.locale == "cs":
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice nebyly nahrány!"), Qgis.Warning, duration=3)               
                else:
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Compositions was not loaded!"), Qgis.Warning, duration=3)
        if message == "layersLoaded":
            #time.sleep(2)
            try:
                self.dlg.progressBar_loader.hide() 
                self.dlg.label_loading.hide() 
            except:
                pass
        if message == "readJson":
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Something went wrong with this layer: ")
            else:
                QMessageBox.information(None, "Layman", "Nelze nahrát vrstva: ")
        if message == "authOptained":
            self.authOptained()
            self.getToken()
            try:
                self.dlg.progressBar.hide() 
            except:
                pass
        if message == "layerDeleteFromCompositeWrong":
            if self.locale == "cs":
            
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Vrsta v kompozici nebyla úspěšně smazána."), Qgis.Warning, duration=3)
            else:
           
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Layer in composition was not successfully deleted."), Qgis.Warning, duration=3)
        if message == "refreshComposite":
            try:
                self.refreshCompositeList()        ## pouze pro import Form     
            except:
                pass
        if message == "loadMaps":
            try:
                self.dlg.progressBar_loader.hide() 
                self.dlg.label_loading.hide()
            except:
                print("chyba")
        if message == "delLayComposite":
            try:
                self.dlg.progressBar.hide() 
                self.dlg.label_import.hide()
                self.refreshLayerListReversed()
            except:
                print("chyba")

        if message == "export":
            try:
                threadsB = set()
                for thread in threading.enumerate(): 
                    threadsB.add(thread.name)              
                if(self.ThreadsA == threadsB):
                    self.dlg.progressBar.hide() 
                    self.dlg.label_import.hide()
                

            except:
                pass
            #try: ## některé formuláře nemají progress bar
            #    self.dlg.progressBar.hide() 
            #    self.dlg.label_import.hide() 
            #    self.importMapEnvironmnet(True)
            #    pass
            #except:
            #    pass
                
            #try:
            #    self.dlg.pushButton.setEnabled(True)
            #except:
            #    pass
          
        if message == "exportPatch":
            try:
                threadsB = set()
                for thread in threading.enumerate(): 
                    threadsB.add(thread.name)
              
                if(self.ThreadsA == threadsB):
                    self.dlg.progressBar.hide() 
                    self.dlg.label_import.hide()
                

            except:
                pass
            try: ## některé formuláře nemají progress bar
                ## resime situaci kdy se dela patch v kompozici
                self.dlg.pushButton.setEnabled(True)
                self.dlg.pushButton_deleteMap.setEnabled(True)
                self.dlg.pushButton_editMeta.setEnabled(True)
                self.dlg.pushButton_setMapPermissions.setEnabled(True)
                self.dlg.pushButton_down.setEnabled(True)
                self.dlg.pushButton_up.setEnabled(True)
                self.dlg.pushButton_deleteLayers.setEnabled(True)
                self.dlg.pushButton_up.setEnabled(True)
                self.dlg.pushButton_addRaster.setEnabled(True)
                self.dlg.progressBar.hide() 
                self.dlg.label_import.hide() 
                
                
            except:
                pass
                
            #try:
            #    self.dlg.pushButton.setEnabled(True)
            #except:
            #    pass    
        if message == "delLay":
            try:
                self.dlg.label_thumbnail.setText(' ')
            except:
                pass
            try:
                if not (self.threadLayers.is_alive()):
                    
                    self.dlg.progressBar_loader.hide()
                    
            except:
                pass
            #self.loadLayersThread()
                       
                
        if message[0:8] == "imports_":
            if self.locale == "cs":               
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Vrstva: "+message[8:100]+" byla úspěšně nahrána "), Qgis.Success, duration=3)
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Layer: "+message[8:100]+" was successfully imported"), Qgis.Success, duration=3)
            done = 0
        
            for i in range (0, len(self.processingList)):
                if self.processingList[i][2] == 1:                    
                    self.processingList[i][2] = 2
                   # print(self.processingList)
                    done = done + 1
            try:
                if self.locale == "cs":
                    self.dlg.label_progress.setText("Úspěšně exportováno: " +  str(self.uploaded) + " / " + str(self.batchLength) )
                else:
                    self.dlg.label_progress.setText("Sucessfully exported: " +  str(self.uploaded) + " / " + str(self.batchLength) )
            except:
                pass
        if message[0:8] == "importn_":
            if self.locale == "cs":
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Vrstva: "+message[8:100]+" nebyla úspěšně nahrána "), Qgis.Warning, duration=3)
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Layer: "+message[8:100]+" was not imported successfully"), Qgis.Warning, duration=3)
            done = 0
        
            for i in range (0, len(self.processingList)):
                if self.processingList[i][2] == 1:
                   
                    self.processingList[i][2] = 2
                    #print(self.processingList)
                    done = done + 1
            #try:
            #    if self.locale == "cs":
            #        self.dlg.label_progress.setText("Úspěšně exportováno: " +  str(self.uploaded) + " / " + str(self.batchLength) )
            #    else:
            #        self.dlg.label_progress.setText("Sucessfully exported: " +  str(self.uploaded) + " / " + str(self.batchLength) )
            #except:
            #    pass
        if message == "addRaster":
            try:
                self.dlg.progressBar.hide() 
                self.dlg.label_import.hide()
                
            except:
                pass
            
            try:    
                self.dlg.pushButton_addRaster.setEnabled(True)
                self.importMapEnvironmnet(True)
             
            except:
                pass # pro formulár kde neni progressbar
            
            try:
                self.dlg.label_thumbnail.setText(' ')
            except:
                pass
        if message == "wrongLoaded": 
            if self.locale == "cs":
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Připojení se serverem selhalo!"), Qgis.Warning, duration=3)
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Connection with server failed!"), Qgis.Warning, duration=3)
    def loadAllComposites(self):
        url = self.URI+'/rest/' + self.laymanUsername + '/maps'
        
        try:
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        except:
            if self.locale == "cs":
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Připojení k serveru selhalo!"), Qgis.Warning, duration=3)               
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Connection with server failed!"), Qgis.Warning, duration=3)
        try:
            data = r.json()  
            
        except:
            if self.locale == "cs":
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Připojení k serveru selhalo!"), Qgis.Warning, duration=3)               
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Connection with server failed!"), Qgis.Warning, duration=3)
            return
        for i in data:
           # print(i['name'])
            url = self.URI+'/rest/' + self.laymanUsername + '/maps/'+i['name']+'/file'  
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
            try:
                map = r.json()
            except:
                if self.locale == "cs":
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Připojení k serveru selhalo!"), Qgis.Warning, duration=3)              
                else:
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Connection with server failed!"), Qgis.Warning, duration=3)
            self.compositeList.append (map)
        self.loadedInMemory = True
    def loadAllCompositesT(self):
        self.compositeList = list()
        ##QgsMessageLog.logMessage("test")
        url = self.URI+'/rest/' + self.laymanUsername + '/maps'
                
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))        
        try:
            data = r.json()  
            
        except:
            QgsMessageLog.logMessage("errConnection")
            QgsMessageLog.logMessage(url)
            self.disableEnvironment()
            return
        for i in data:
            
            url = self.URI+'/rest/' + self.laymanUsername + '/maps/'+i['name']+'/file'  
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
            try:
                map = r.json()
            except:
                QgsMessageLog.logMessage("errConnection")
                QgsMessageLog.logMessage(map)
                self.disableEnvironment()
                return
            self.compositeList.append (map)
        self.loadedInMemory = True
        QgsMessageLog.logMessage("compositionLoaded")
    
    def readMapJson(self,name, service):
        #self.dlg.progressBar_loader.show() 
        #self.dlg.label_loading.show()
    
        
        self.readMapJsonThread(name,service)
 
    
    def readMapJsonThread(self,name, service):
        nameWithDiacritics = name        
        name = self.removeUnacceptableChars(name)
        
        #if not self.checkLoadedMap(name): ## je nactena mapa?
        if False: ## je nactena mapa?    
      #  if True:
          
            url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+name   +'/file'     
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
            data = r.json()   
            #print(data)
        
            self.addComposite(data,service, name)
            QgsMessageLog.logMessage("refreshComposite")
            
        
        else:
            print("debug in readMapJson - false")
            url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+name+'/file'     
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
            data = r.json() 
            ## rozvetveni zdali chce uzivatel otevrit kompozici v novem projektu
            layers = iface.mapCanvas().layers() ## pokud neexistuej vrstva otazka nema smysl
            if len(layers) > 0:
                if self.locale == "cs":
                    msgbox = QMessageBox(QMessageBox.Question, "Layman", "Chcete otevřít kompozici v novém QGIS projektu?")
                else:
                    msgbox = QMessageBox(QMessageBox.Question, "Layman", "Do you want open composition in new QGIS project?")
                msgbox.addButton(QMessageBox.Yes)
                msgbox.addButton(QMessageBox.No)
                msgbox.setDefaultButton(QMessageBox.No)
                reply = msgbox.exec()
                if (reply == QMessageBox.Yes):
                    iface.newProject()
                    self.loadService2(data,service, name)
                else:
                    self.loadService2(data,service, name)
            else:
                self.loadService2(data,service, name)
        
    def deleteMapFromServer(self,name):        
        
        url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+name    
        response = requests.delete(url, headers = self.getAuthHeader(self.authCfg))
       # print(response)
        if (response.status_code == 200):
            if self.locale == "cs":
            #    QMessageBox.information(None, "Message", "Kompozice byla úspěsně smazána.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + name + " byla úspešně smazána."), Qgis.Success, duration=3)
            else:
            #    QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + name + " was sucessfully deleted."), Qgis.Success, duration=3)
        else:
            if self.locale == "cs":
            #    QMessageBox.information(None, "Message", "Kompozice byla úspěsně smazána.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + name + " nebyla úspešně smazána."), Qgis.Warning, duration=3)
            else:
            #    QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + name + " was not sucessfully deleted."), Qgis.Warning, duration=3)
       # self.refreshMapList()            
        self.refreshListWidgetMaps() ## pro treewidget
        
      
    def deleteMap(self,name, x):   
        if self.locale == "cs":
            msgbox = QMessageBox(QMessageBox.Question, "Delete map", "Chcete opravdu smazat kompozici "+name+"?")
        else:
            msgbox = QMessageBox(QMessageBox.Question, "Delete map", "Do you want really delete composition "+name+"?")
        msgbox.addButton(QMessageBox.Yes)
        msgbox.addButton(QMessageBox.No)
        msgbox.setDefaultButton(QMessageBox.No)
        reply = msgbox.exec()
        if (reply == QMessageBox.Yes):
            name = self.removeUnacceptableChars(name)
            url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+name    
            response = requests.delete(url, headers = self.getAuthHeader(self.authCfg))
            #print(response)
            #print(response.content)
            if (response.status_code == 200):
                if self.locale == "cs":
                #    QMessageBox.information(None, "Message", "Kompozice byla úspěsně smazána.")
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + name + " byla úspešně smazána."), Qgis.Success, duration=3)
                else:
                #    QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + name + " was sucessfully deleted."), Qgis.Success, duration=3)
            else:
                if self.locale == "cs":
                #    QMessageBox.information(None, "Message", "Kompozice byla úspěsně smazána.")
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + name + " nebyla úspešně smazána."), Qgis.Warning, duration=3)
                else:
                #    QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + name + " was not sucessfully deleted."), Qgis.Warning, duration=3)
            del (self.compositeList[x])        
            self.refreshCompositeList()## pro import map form
            self.dlg.listWidget_listLayers.clear()
      
        
        
      
    def deleteMapandLayers(self,name, x):        
        try:
            url = self.URI+'/rest/'+self.laymanUsername+'/maps/'+name    
            response = requests.delete(url, headers = self.getAuthHeader(self.authCfg))
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Kompozice byla úspěšně smazána.")
            else:
                QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
            
      
        except:
            if self.locale == "cs":
                QMessageBox.information(None, "Warning", "Deleting composition failed.")
            else:
                QMessageBox.information(None, "Warning", "Mazání kompozice selhalo.")
        #self.refreshItems()
        self.deleteMapFromCanvas(x)
        self.dlg.listWidget_listLayers.clear()
        self.dlg.pushButton_deleteLayers.setEnabled(False)
        self.dlg.pushButton.setEnabled(False)
        self.dlg.pushButton_deleteMap.setEnabled(False)
        self.refreshCompositeList()

    def deleteMapFromCanvas(self, x):
        for i in range (0,len(self.compositeList[x]['layers'])):  #[0]['params']['LAYERS']:
            name = self.compositeList[x]['layers'][i]['params']['LAYERS']
            lay = QgsProject.instance().mapLayersByName(name)[0]
            if (lay != None and lay.type() != QgsMapLayer.VectorLayer):
                QgsProject.instance().removeMapLayer(lay.id())
        del (self.compositeList[x])

    def deleteLayerFromCanvas(self, name):        
        lay = QgsProject.instance().mapLayersByName(name)[0]        
        if (lay != None and lay.type() != QgsMapLayer.VectorLayer):
            QgsProject.instance().removeMapLayer(lay.id())
        
        
    def getSelectedLayers(self):
        arr = self.dlg.listWidget_listLayers2.selectedItems()
        layers = []
        for a in arr:
            layer = QgsProject.instance().mapLayersByName(a.text())
            for lay in layer:

                if (lay.type() == QgsMapLayer.VectorLayer):
                    layers.append(lay)
            
        return layers
    def run_getLayer(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            
            
        self.dlgGetLayers.items.clear()
        # show the dialog
        self.dlgGetLayers.show()
        data= self.getExistingLayers()
        for x in range(len(data)):
           # print(data[x]['name'])
            self.dlgGetLayers.items.addItem(data[x]['name'])
        # Run the dialog event loop
        
        result = self.dlgGetLayers.exec_()
       
        
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
           
            print ("test tlacitka")
   
    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING Atlas"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

       # self.flaskThread.terminate() ## killing daemons
       # self.thread1.terminate()
        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD Atlas"
      ## killing daemons
        #self.thread1.terminate()
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Layman'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------
    def bounds(self, layers):

        extent = None
        for layer in layers:
            if layer.type() == 0:
                transform = QgsCoordinateTransform(layer.crs(), QgsCoordinateReferenceSystem('EPSG:4326'), QgsProject.instance()) # WGS 84 / UTM zone 33N
                try:
                    layerExtent = transform.transform(layer.extent())
                except QgsCsException:
                    print("exception in transform layer srs")
                    layerExtent = QgsRectangle(-180, -90, 180, 90)
                if extent is None:
                    extent = layerExtent
                else:
                    extent.combineExtentWith(layerExtent)

        return (extent.xMinimum(), extent.yMinimum(), extent.xMaximum(), extent.yMaximum())
    def copySymbols(self,symbol, tempPath, fileNames):
        for i in range(symbol.symbolLayerCount()):
            sl = symbol.symbolLayer(i)
            if isinstance(sl, QgsSvgMarkerSymbolLayer):
                symbolPath = sl.path();
                shutil.copy(symbolPath, tempPath)
                print("Copying " + str(sl.path()))
                fileNames.append(tempPath + os.sep + os.path.basename(symbolPath))
            else:
                print("Ignoring " + str(sl))

    def setDefaultExtent (self, ext):        
        self.dlg.lineEdit_3.setText(str(ext.xMinimum()))
        self.dlg.lineEdit_4.setText(str(ext.xMaximum()))
        self.dlg.lineEdit_5.setText(str(ext.yMinimum()))
        self.dlg.lineEdit_6.setText(str(ext.yMaximum()))

    def setWritePermissionList(self):
        itemsTextListRead =  [str(self.dlg.listWidget_read.item(i).text()) for i in range(self.dlg.listWidget_read.count())]
        if (self.dlg.comboBox_users.currentText() in itemsTextListRead):
            self.dlg.listWidget_write.addItem(self.dlg.comboBox_users.currentText())
        else:
            self.dlg.listWidget_write.addItem(self.dlg.comboBox_users.currentText())
            self.dlg.listWidget_read.addItem(self.dlg.comboBox_users.currentText())
    def removeWritePermissionList(self):
        self.deleteItem(self.dlg.listWidget_read.currentItem().text())
        self.dlg.listWidget_read.removeItemWidget(self.dlg.listWidget_read.takeItem(self.dlg.listWidget_read.currentRow()))
        #self.dlg.listWidget_write.removeItemWidget(self.dlg.listWidget_write.takeItem(self.dlg.listWidget_write.currentRow()))
        
    def deleteItem(self, itemName):
       
        items_list = self.dlg.listWidget_write.findItems(itemName,QtCore.Qt.MatchExactly)
        
        for item in items_list:
            r = self.dlg.listWidget_write.row(item)
            self.dlg.listWidget_write.takeItem(r)    
    def loadJsonLayer(self, fileName):    
        name = (os.path.splitext(os.path.basename(fileName))[0])
        vlayer = QgsVectorLayer(fileName, name,"ogr")
        sldPath = os.path.splitext(fileName[:-4])[0] + ".sld"
        qmlPath = os.path.splitext(fileName[:-4])[0] + ".qml"
        
        sldExists = os.path.isfile(sldPath)
        qmlExists = os.path.isfile(qmlPath)
        if (qmlExists):
            print("qml loaded")
            vlayer.loadNamedStyle(qmlPath)
        elif (sldExists):
            vlayer.loadSldStyle(os.path.splitext(fileName)[0]+ ".sld")
            print("sld loaded")
        QgsProject.instance().addMapLayer(vlayer)
        vlayer.triggerRepaint()
    def checkLoadedLayer(self):
        layers = iface.layerTreeView().selectedLayers()
        if (len(layers) > 0):
            self.json_export()    
        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Není načtena vrstva!")
            else:
                QMessageBox.information(None, "Message", "You must load layer first!")
    def tranformExtent(self, ext):
        src = QgsProject.instance().crs()
        dest = QgsCoordinateReferenceSystem(4326)
        tform = QgsCoordinateTransform(src, dest, QgsProject.instance())
        transfomedExtent = tform.transform(ext)
        return transfomedExtent


    def getEmptyComposite(self, compositeName, compositeTitle):        
        compositeEPSG  = "epsg:4326"        
        if (self.dlg.lineEdit_3.text() == "" or self.dlg.lineEdit_4.text() == "" or self.dlg.lineEdit_5.text() == "" or self.dlg.lineEdit_6.text() == ""):
           ext = iface.mapCanvas().extent() 
           ext = (self.tranformExtent(ext))
           xmin = ext.xMinimum()
           xmax = ext.xMaximum()
           ymin = ext.yMinimum()
           ymax = ext.yMaximum()
           print(ymax)
        else:   
           xmin = self.dlg.lineEdit_3.text()
           xmax = self.dlg.lineEdit_4.text()
           ymin = self.dlg.lineEdit_5.text()
           ymax = self.dlg.lineEdit_6.text()  
           src = QgsProject.instance().crs()
           dest = QgsCoordinateReferenceSystem(4326)
           tform = QgsCoordinateTransform(src, dest, QgsProject.instance())
           #print(xmax,ymax)
           #print(xmin,ymin)
           max = tform.transform(QgsPointXY(float(xmax),float(ymax)))
           min = tform.transform(QgsPointXY(float(xmin),float(ymin)))
           xmin = min.x()
           xmax = max.x()
           ymin = min.y()
           ymax = max.y()
        center = tform.transform(QgsPointXY(iface.mapCanvas().extent().center().x(), iface.mapCanvas().extent().center().y()))
        abstract = self.dlg.lineEdit_7.text()        
        comp = {"abstract":abstract,"center":[center.x(),center.y()],"current_base_layer":{"title":"Composite_base_layer"},"extent":[str(xmin),str(ymin),str(xmax),str(ymax)],"groups":{"guest":"w"},"layers":[],"name":compositeName,"projection":compositeEPSG,"scale":1,"title":compositeTitle,"units":"m","user":{"email":"","name":self.laymanUsername}}
        #print(comp)
        self.dlg.close()
       ## iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + compositeName + " byla úspešně vytvořena."), Qgis.Success, duration=3)
        return comp
    def loadLocalFile(self):
        options = QFileDialog.Options()
        dialog = QFileDialog()
        dialog.setStyleSheet("QPushButton {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} QPushButton:hover{background: #66ab27 ;}QPushButton:disabled{background: #64818b ;}");
        try:
            if self.locale == "cs":
                fileName = dialog.getOpenFileName(None,"Načíst soubor", "","GeoJson Files (*.geojson);;Json Files (*.json)", options=options)
            else:
                fileName = dialog.getOpenFileName(None,"Load file", "","GeoJson Files (*.geojson);;Json Files (*.json)", options=options)

            print ("načítám json ze souboru:" + fileName[0])
            if (fileName[0] != ""):
                self.loadJsonLayer(fileName[0])
        except:
            pass
    def modifyMap(self, x):        
        name = self.removeUnacceptableChars(self.dlg.lineEdit_title.text())
        #self.compositeList[x]['name'] = self.dlg.lineEdit_name.text()
        self.compositeList[x]['name'] = name
        self.compositeList[x]['abstract'] = self.dlg.lineEdit_abstract.text()
        self.compositeList[x]['title'] = self.dlg.lineEdit_title.text()
        src = QgsProject.instance().crs()
        dest = QgsCoordinateReferenceSystem(4326)
        tform = QgsCoordinateTransform(src, dest, QgsProject.instance())
        #transformace extentu
     

        self.compositeList[x]['extent'][0] = self.dlg.lineEdit_xmin.text()
        self.compositeList[x]['extent'][2] = self.dlg.lineEdit_xmax.text()
        self.compositeList[x]['extent'][1] = self.dlg.lineEdit_ymin.text()
        self.compositeList[x]['extent'][3] = self.dlg.lineEdit_ymax.text()
   
        center = tform.transform(QgsPointXY(iface.mapCanvas().extent().center().x(), iface.mapCanvas().extent().center().y()))
        self.compositeList[x]['center'][0] = center.x()
        self.compositeList[x]['center'][1] = center.y()
        #print(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'])       
        oldName = self.dlg.lineEdit_name.text()
        response = requests.delete(self.URI+'/rest/'+self.laymanUsername+'/maps/'+oldName,headers = self.getAuthHeader(self.authCfg))
       
        self.dlg.close()
        self.afterCloseEditMapDialog()
        self.importMap(x, 'mod')
        
        try:
            self.refreshCompositeList()
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Map metadata was saved successfully."), Qgis.Success, duration=3)
        except:
            pass
        
        
    def saveLocalFile(self):
        
        layer = self.iface.activeLayer()       
        print(layer.commitChanges()) ## změny uloženy
        path = iface.activeLayer().dataProvider().dataSourceUri()
        path = path.split("|")[0].replace("'","")
        if (layer == None):
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Není načtena vrstva!")
            else:
                QMessageBox.information(None, "Message", "You must load layer first!")
        else:
           # defaultDir = QDir().home()
            defaultDir = os.path.dirname(path)
            #print(defaultDir)
            #print(defaultDir +os.sep+ str(layer.name()) + ".geojson")
            #print(QDir().homePath() +os.sep+ str(layer.name()) + ".geojson")
            dialog = QFileDialog()
            dialog.setFileMode(1)
            dialog.setDirectory(defaultDir)
            #print(dialog.directory().path())
           # layer_name = dialog.getSaveFileName(None, "Save file", QDir().homePath() +os.sep+ str(layer.name()) + ".geojson", "*.geojson")        
            if self.locale == "cs":
                layer_name = dialog.getSaveFileName(None, "Uložit soubor", defaultDir +os.sep+ str(layer.name()) + ".geojson", "*.geojson")   
            else:
                layer_name = dialog.getSaveFileName(None, "Save file", defaultDir +os.sep+ str(layer.name()) + ".geojson", "*.geojson")   
            
            self.json_export_local(layer_name[0], layer)

    def json_export_local(self, layer_name, lay):     
        import shutil
        filePath = self.getTempPath(layer_name)  
        ogr_driver_name = "GeoJSON" 
        project = QgsProject.instance()
        fileNames = []
        ## zde musí být zajištěna vektorová vrstva
        layer = lay        
        layerType = layer.type()
        if layerType == QgsMapLayer.VectorLayer:

            renderer = layer.renderer()
            hasIcon = False
            if isinstance(renderer, QgsSingleSymbolRenderer):

                self.copySymbols(renderer.symbol(), tempfile.gettempdir(), fileNames)
                hasIcon = True


            layerCrs = qgis.utils.iface.activeLayer().crs().authid()
            crs = QgsCoordinateReferenceSystem(layerCrs)          
            result2 = qgis.core.QgsVectorFileWriter.writeAsVectorFormat(layer, layer_name, "utf-8", crs, ogr_driver_name) # export jsonu do souboru
            
            if(result2[0] == 2): ## testujeme zda není soubor otevřený v jiném procesu / návratový kod 2
                
                tempFile = self.getTempPath(os.path.basename(layer_name.replace(".geojson", "") ))
                print(tempFile)
                #QMessageBox.information(None, "Layman", "It is not possible overwrite this file. File is already open in other process.")  
                sld_temp_filename = tempFile.replace("geojson", "sld") 
                qml_temp_filename = tempFile.replace("geojson", "qml")
                layer.saveSldStyle(sld_temp_filename)
                layer.saveNamedStyle(qml_temp_filename)
                result2 = qgis.core.QgsVectorFileWriter.writeAsVectorFormat(layer, tempFile, "utf-8", crs, ogr_driver_name)
                print(result2)
                if(result2[0] == 2):
                    if self.locale == "cs":
                        QMessageBox.information(None, "Layman", "Soubor není možné přepsat. Je již otevřený jiným procesem.")  
                    else:
                        QMessageBox.information(None, "Layman", "It is not possible overwrite this file. File is already open in other process.")  
                    return
                if os.path.basename(layer_name.replace(".geojson", "")) != '':
                    QgsProject.instance().removeMapLayer(layer.id())
                    print(tempFile, layer_name)
                    shutil.copy(tempFile, layer_name)
                    shutil.copy(sld_temp_filename, layer_name.replace(".geojson", ".sld"))
                    shutil.copy(qml_temp_filename, layer_name.replace(".geojson", ".qml"))
                    self.loadJsonLayer(layer_name)
                
            else:                
                sld_filename = layer_name.replace("geojson", "sld")     
                qml_filename = layer_name.replace("geojson", "qml") 
                result3 = False
                layer.saveSldStyle(sld_filename)
                layer.saveNamedStyle(qml_filename)

    def json_export(self, layer_name):     

        filePath = self.getTempPath(self.removeUnacceptableChars(layer_name).lower())  
        ogr_driver_name = "GeoJSON"     
        project = QgsProject.instance()
        fileNames = []      
        layer = QgsProject.instance().mapLayersByName(layer_name)[0]       
        
        layerType = layer.type()
        if layerType == QgsMapLayer.VectorLayer:

            renderer = layer.renderer()
            hasIcon = False
            if isinstance(renderer, QgsSingleSymbolRenderer):
                self.copySymbols(renderer.symbol(), tempfile.gettempdir(), fileNames)
                hasIcon = True
            #layerCrs = qgis.utils.iface.activeLayer().crs().authid()
            layerCrs = layer.crs().authid()
            crs = QgsCoordinateReferenceSystem(layerCrs)# původně bylo
            layer_filename = filePath 
            ## transform test
            parameter = {'INPUT': layer, 'TARGET_CRS': 'EPSG:4326', 'OUTPUT': layer_filename}
            processing.run('qgis:reprojectlayer', parameter)
            ## transforma test
          #  result2 = qgis.core.QgsVectorFileWriter.writeAsVectorFormat(layer, layer_filename, "utf-8", crs, ogr_driver_name) # export jsonu do souboru

            sld_filename = filePath.replace("geojson", "sld").lower()            
            result3 = False
            layer.saveSldStyle(sld_filename)
    def json_exportMix(self, layer):    
    
        filePath = self.getTempPath(self.removeUnacceptableChars(layer.name() + str(layer.geometryType())).lower())  
        ogr_driver_name = "GeoJSON"     
        project = QgsProject.instance()
        fileNames = []              
        
        layerType = layer.type()
        if layerType == QgsMapLayer.VectorLayer:

            renderer = layer.renderer()
            hasIcon = False
            if isinstance(renderer, QgsSingleSymbolRenderer):

                self.copySymbols(renderer.symbol(), tempfile.gettempdir(), fileNames)
                hasIcon = True


            #layerCrs = qgis.utils.iface.activeLayer().crs().authid()
            layerCrs = layer.crs().authid()
            crs = QgsCoordinateReferenceSystem(layerCrs)# původně bylo
            layer_filename = filePath 
            ## transform test
            parameter = {'INPUT': layer, 'TARGET_CRS': 'EPSG:4326', 'OUTPUT': layer_filename}
            processing.run('qgis:reprojectlayer', parameter)
            ## transforma test
          #  result2 = qgis.core.QgsVectorFileWriter.writeAsVectorFormat(layer, layer_filename, "utf-8", crs, ogr_driver_name) # export jsonu do souboru

            sld_filename = filePath.replace("geojson", "sld").lower()            
            result3 = False
            layer.saveSldStyle(sld_filename)
        return layer_filename
    def checkValidAttributes(self, layer_name):
        layers = QgsProject.instance().mapLayersByName(layer_name)
        if len(layers) > 1:
            for l in layers:
                if (isinstance(l, QgsVectorLayer)):
                   
                    layers.clear()
                    layers.append(l)
                    break
        isValid = True
        pom =layers[0].getFeature(1)        
        for nam in pom.fields().names():
            if (nam == ''):
                isValid = False
        return isValid


    def checkWgsExtent(self, layer):
        WgsXmax = 180
        WgsXmin = -180
        WgsYmax = 90
        WgsYmin = -90
        extent = layer.extent()
        if (extent.xMaximum() > WgsXmax or extent.xMinimum() < WgsXmin or extent.yMaximum() > WgsYmax or extent.yMinimum() < WgsYmin ):
            return False
        else:
            return True
    
    def mergeGeojsons(self, paths, output, layerName):
        feats = list()
        #top = """
        #{
        #"type": "FeatureCollection",
        #"name": "jan_vrobelmix",
        #"crs": { "type": "name", "properties": { "name": "urn:ogc:def:crs:EPSG::3857" } },
        #"features": ["""
        #"crs": { "type": "name", "properties": { "name": "urn:ogc:def:crs:EPSG::3857" } },
        top = '''
        {
        "type": "FeatureCollection",
        "name": "'''+layerName+'''",        
        "crs": { "type": "name", "properties": { "name": "urn:ogc:def:crs:EPSG:3857" } },
        "features": ['''
        bottom = """]
        }
        """
        for path in paths:
            with open(path) as json_file:
                data = json.load(json_file)
                for p in data['features']:
                   
                    feats.append(p)
          
        #print(top + str(feats)[1:-1] + bottom) 

        text_file = open(output, "w")
        text_file.write((top + str(feats)[1:-1] + bottom).replace("'", "\""))
        text_file.close()
    def callPostRequest(self, layers):    
       # self.processingList = []        
        #if self.batchLength == 0:
        #    self.batchLength = self.batchLength + len(layers)
        self.ThreadsA = set()
        for thread in threading.enumerate(): 
            self.ThreadsA.add(thread.name)
        self.uploaded = 0
        self.batchLength = len(layers)
        if self.locale == "cs":
            self.dlg.label_progress.setText("úspěšně exportováno: 0 / " + str(len(layers)) )
        else:
            self.dlg.label_progress.setText("Sucessfully exported 0 / " + str(len(layers)) )
        #else:
        #    self.batchLength = self.batchLength + len(layers)
        #    if self.locale == "cs":
        #        self.dlg.label_progress.setText("úspěšně exportováno: "+str(self.done)+" / " + str(self.batchLength) )
        #    else:
        #        self.dlg.label_progress.setText("Sucessfully exported "+str(self.done)+" / " + str(self.batchLength) )
        for item in layers:
            print (item.text(0))
            
            
                

            self.postRequest(item.text(0))
        #self.dlg.label_progress.setText("")
    def setCurrentLayer(name):
        layers = QgsProject.instance().mapLayersByName(name) 
        if(len(layers) >1):
            layerss = QgsProject.instance().mapLayers().values()    
            i = 0
            for layer in layerss:  
                if layers[0].name == layer.name():
                    if (i == item.currentIndex()):
                        i = i + 1
                        break
                    i = i + 1
        return i
    def transformLayer(self, layer):
        layer = iface.activeLayer()
        crsSrc = layer.crs()
        print(crsSrc.authid())
        crsDest = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
        print(crsSrc, crsDest)
        xform = QgsCoordinateTransform(crsSrc, crsDest, 5514, 4326)
        feats=[]

        if (layer.geometryType() == 0):
            destLayer = QgsVectorLayer("Point?crs=EPSG:4326","lay","memory")
        if (layer.geometryType() == 1):
            destLayer = QgsVectorLayer("Linestring?crs=EPSG:4326","lay","memory")
        if (layer.geometryType() == 2):
            destLayer = QgsVectorLayer("Polygon?crs=EPSG:4326","lay","memory")

        for f in layer.getFeatures():
            g = f.geometry()
    
            g.transform(xform)
            print(g)
            f.setGeometry(g)
            feats.append(f)
    
        destLayer.dataProvider().addFeatures(feats)
        return destLayer
    def patchThread(self, layer_name, data,q, progress):
        #print("layername: " + layer_name)
        #print(self.removeUnacceptableChars(layer_name))
        #print(self.mixedLayers)
        
        if layer_name in self.mixedLayers:
            layers = QgsProject.instance().mapLayersByName(layer_name)  
            paths = list()
            for layer in layers:
                print(paths.append(self.json_exportMix(layer)))
            self.mergeGeojsons(paths, self.getTempPath(self.removeUnacceptableChars(layer.name())),self.removeUnacceptableChars(layer.name()))

        else:
            self.json_export(layer_name)
        #self.json_export(layer_name)     
           
        geoPath = self.getTempPath(self.removeUnacceptableChars(layer_name))
        #try:
        if (os.path.getsize(geoPath) > self.CHUNK_SIZE):
            self.postInChunks(layer_name, "patch")                          
        else:
            self.patchLayer(layer_name, data)
        #time.sleep(1)
        if progress:
            
            self.importedLayer = layer_name
            self.processingList[q][2] = 1
            response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/' + self.removeUnacceptableChars(layer_name), headers = self.getAuthHeader(self.authCfg))
            
            if (response.status_code == 200):
                try:
                    self.uploaded = self.uploaded + 1
                except:
                    pass
                QgsMessageLog.logMessage("imports_"+layer_name)
                
            else:
                QgsMessageLog.logMessage("importn_"+layer_name)
           ## self.writeState(1)
            QgsMessageLog.logMessage("exportPatch")
            
            #iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Layer  " + layer_name + " was imported successfully."), Qgis.Success, duration=3)

    def postThread(self, layer_name,data, q,progress):
        if layer_name in self.mixedLayers:
            layers = QgsProject.instance().mapLayersByName(layer_name)  
            paths = list()
            for layer in layers:
                paths.append(self.json_exportMix(layer))
            self.mergeGeojsons(paths, self.getTempPath(self.removeUnacceptableChars(layer.name()))),self.removeUnacceptableChars(layer.name())

        else:
            self.json_export(layer_name)
        #### transform test
        #path = self.transformLayer(layer_name)
        ######
        sldPath = self.getTempPath(self.removeUnacceptableChars(layer_name)).replace("geojson", "sld")
        geoPath = self.getTempPath(self.removeUnacceptableChars(layer_name))
        if (os.path.getsize(geoPath) > self.CHUNK_SIZE):
            self.postInChunks(layer_name, "post")
        else:
            if(os.path.isfile(sldPath)): ## existuje sld?
                files = [('file', open(geoPath, 'rb')), ('sld', open(sldPath, 'rb'))]
            else:
                files = {'file': (geoPath, open(geoPath, 'rb')),} 

    

            response = requests.post(self.URI+'/rest/'+self.laymanUsername+'/layers', files=files, data = data, headers = self.getAuthHeader(self.authCfg))
          
        #time.sleep(1.5)
        if progress:

           # QgsMessageLog.logMessage("export")
            response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/' + self.removeUnacceptableChars(layer_name), headers = self.getAuthHeader(self.authCfg))
         
            if (response.status_code == 200):
                try:
                    self.uploaded = self.uploaded + 1
                except:
                    pass
                QgsMessageLog.logMessage("imports_"+layer_name)
            else:
                QgsMessageLog.logMessage("importn_"+layer_name)
            self.importedLayer = layer_name
            self.processingList[q][2] = 1
            #self.writeState(1)
            QgsMessageLog.logMessage("export")
            
            #QMessageBox.information(None, "Message", "Layer exported sucessfully.")
    def postRequest(self, layer_name):     
        nameCheck = True
        validExtent = True
        layers = QgsProject.instance().mapLayersByName(layer_name)         
        layers[0].setName(layer_name)
        if len(layers) > 1:
            for l in layers:
                if (isinstance(l, QgsVectorLayer)):                   
                    layers.clear()
                    layers.append(l)
                    break
        
        

        if (re.match('[0-9]{1}', layer_name)): ## nesmí být nesmysl v názvu na prvním místě
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Není povoleno číslo v prvním znaku.")
            else:
                QMessageBox.information(None, "Layman", "Number in first character is not allowed.")
            nameCheck = False
        
     


        #if not self.checkWgsExtent(layers[0]):
        if False:
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Prostorový rozsah vrstvy je mimo rozsah WGS 84. (EPSG: 4326)")
            else:
                QMessageBox.information(None, "Layman", "Extent of layer is out of WGS 84 range. (EPSG: 4326)")
            validExtent = False

        if (nameCheck and validExtent):
                     
           # crs = layers[0].crs().authid()
            crs = "EPSG:3857"
          #  data = { 'name' :  str(layer_name).lower(), 'title' : str(layer_name), 'crs' : str(crs) } 
            data = { 'name' :  str(layer_name).lower(), 'title' : str(layer_name)} 
           # data = { 'name' :  str(layer_name).lower(), 'title' : str(layer_name), 'crs' : str(crs) } 
            if (self.checkValidAttributes(layer_name)):
                if (self.checkExistingLayer(layer_name)):
                    
                    #print("vrstva již existuje")
                    if self.locale == "cs":
                        msgbox = QMessageBox(QMessageBox.Question, "Layman", "Vrstva "+layer_name+" již na serveru existuje. Chcete přepsat její geometrii?")
                    else:
                        msgbox = QMessageBox(QMessageBox.Question, "Layman", "Layer "+layer_name+" already exists in server. Do you want overwrite it´s geometry?")
                    msgbox.addButton(QMessageBox.Yes)
                    msgbox.addButton(QMessageBox.No)
                    msgbox.setDefaultButton(QMessageBox.No)
                    reply = msgbox.exec()
                    if (reply == QMessageBox.Yes):
                        self.dlg.progressBar.show() 
                        self.dlg.label_import.show()
                        q = self.setProcessingItem(layer_name)
                        threading.Thread(target=lambda: self.patchThread(layer_name,data, q, True)).start()
                        #print("vrstva již existuje")
                        
                    else:
                        self.batchLength = self.batchLength - 1 
                else:
            
                    self.layerName = layer_name
                   # if (self.checkEpsg(layer_name)):
                    if(True): ##Pravděpodobně nebude třeba testovat EPSG, pokud se detekuje, je vrstva transformována. 
                      #  print (layer_name)
                        self.dlg.progressBar.show() 
                        self.dlg.label_import.show()
                        q = self.setProcessingItem(layer_name)
                        threading.Thread(target=lambda: self.postThread(layer_name,data, q,True)).start()    
                    #        if response.status_code == 200:
                    #            iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Layer  " + layer_name + " was imported successfully."), Qgis.Success, duration=3)
                    #        else:
                    #            iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Layer  " + layer_name + " was not imported."), Qgis.Warning, duration=3)
                    else:
                        if self.locale == "cs":
                            QMessageBox.information(None, "Layman", "Použijte EPSG:4326")
                        else:
                            QMessageBox.information(None, "Layman", "Use EPSG:4326")
            else:
                if self.locale == "cs":
                    QMessageBox.information(None, "Layman", "Vrstva "+layer_name+" nemá atributy!")
                else:
                    QMessageBox.information(None, "Layman", "Layer "+layer_name+" does not have attributes!")
    def setProcessingItem(self, layer_name):
        queue = len(self.processingList)
        self.processingList.append([queue, layer_name, 0])
        return queue
    def postRequest2(self, layer_name):     
        nameCheck = True
        validExtent = True
        layers = QgsProject.instance().mapLayersByName(layer_name)         
        layers[0].setName(layer_name)
        if len(layers) > 1:
            for l in layers:
                if (isinstance(l, QgsVectorLayer)):                   
                    layers.clear()
                    layers.append(l)
                    break
        
        

        if (re.match('[0-9]{1}', layer_name)): ## nesmí být nesmysl v názvu na prvním místě
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Není povoleno číslo v prvním znaku.")
            else:
                QMessageBox.information(None, "Layman", "Number in first character is not allowed.")
            nameCheck = False
        
        #print(layer_name)


        if not self.checkWgsExtent(layers[0]):
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Prostorový rozsah vrstvy je mimo rozsah WGS 84. (EPSG: 4326)")
            else:
                QMessageBox.information(None, "Layman", "Extent of layer is out of WGS 84 range. (EPSG: 4326)")
            validExtent = False

        if (nameCheck and validExtent):
                     
            crs = layers[0].crs().authid()
            crs = "EPSG:4326"
            data = { 'name' :  str(layer_name).lower(), 'title' : str(layer_name), 'crs' : str(crs) } 
            
            if (self.checkValidAttributes(layer_name)):
                if (self.checkExistingLayer(layer_name)):
                    
                   # print("vrstva již existuje")
                    if self.locale == "cs":
                        msgbox = QMessageBox(QMessageBox.Question, "Layman", "Vrstva "+layer_name+" již na serveru existuje. Chcete přepsat její geometrii?")
                    else:
                        msgbox = QMessageBox(QMessageBox.Question, "Layman", "Layer "+layer_name+" already exists in server. Do you want overwrite it´s geometry?")
                    msgbox.addButton(QMessageBox.Yes)
                    msgbox.addButton(QMessageBox.No)
                    msgbox.setDefaultButton(QMessageBox.No)
                    reply = msgbox.exec()
                    if (reply == QMessageBox.Yes):
                     
                        threading.Thread(target=lambda: self.patchThread(layer_name,data, False)).start()
                        #print("vrstva již existuje")
                        
                    else:
                        pass
                else:
            
                    self.layerName = layer_name
                   # if (self.checkEpsg(layer_name)):
                    if(True): ##Pravděpodobně nebude třeba testovat EPSG, pokud se detekuje, je vrstva transformována. 
                      #  print (layer_name)
                        self.dlg.progressBar.show() 
                        self.dlg.label_import.show()
                        threading.Thread(target=lambda: self.postThread(layer_name,data, False)).start()    
                  
                    else:
                        if self.locale == "cs":
                            QMessageBox.information(None, "Layman", "Použijte EPSG:4326")
                        else:
                            QMessageBox.information(None, "Layman", "Use EPSG:4326")
            else:
                if self.locale == "cs":
                    QMessageBox.information(None, "Layman", "Vrstva "+layer_name+" nemá atributy!")
                else:
                    QMessageBox.information(None, "Layman", "Layer "+layer_name+" does not have attributes!")

    def addExistingLayerToComposite(self, name, type):
        #self.dlg.label_loading.show() 
        #self.dlg.progressBar_loader.show()
        
        nameInList = name
        oldname = name
        name = self.removeUnacceptableChars(name).lower()
        self.dlg.pushButton_addRaster.setEnabled(False)
        x = self.dlg.listWidget.currentRow()
        if self.checkLayerOnLayman(name):
            inComposite = name in self.isRasterLayerInComposite(x, name)
            if not(inComposite):
                if (type == "raster"):
                    self.threadAddRaster = threading.Thread(target=lambda: self.addExistingLayerToCompositeThread(nameInList,x))
                    self.threadAddRaster.start()
                if (type == "wms"): 
                    
                    #nameInList = nameInList.split(" ")[0]
                    threading.Thread(target=lambda: self.addExistingWMSLayerToCompositeThread(name, nameInList,x)).start()
                    
                self.dlg.progressBar.show() 
                self.dlg.label_import.show()
            else:
                if self.locale == "cs":
                    QMessageBox.information(None, "Message", "Kompozice již obsahuje vrstvu "+name+"!")
                else:
                    QMessageBox.information(None, "Message", "Composition already include layer "+name+"!")
        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Nelze načíst vrstvu: "+name)
            else:
                QMessageBox.information(None, "Layman", "Something went wrong with this layer: "+name)
    def processingWorker(self): ## self.processingList[i][2] hodnoty 0 v procesu, 1 importováno, 2 vypsaná notifikace
        done = 0
        
        #for i in range (0, len(self.processingList)):
        #    if self.processingList[i][2] == 1:
        #        if self.locale == "cs":
        #            iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Vrstva "+self.processingList[i][1]+" byla úspěšně importována"), Qgis.Success, duration=3)
        #        else:
        #            iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Layer "+self.processingList[i][1]+" was imported sucessfully"), Qgis.Success, duration=3)
        #        self.processingList[i][2] = 2
        #        print(self.processingList)
        #        done = done + 1
        #if self.done == done and not self.firstStart:
        #    if self.locale == "cs":
        #        iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Vrstva nebyla úspěšně importována"), Qgis.Warning, duration=3)
        #    else:
        #        iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Layer was not imported sucessfully"), Qgis.Warning, duration=3)
        #self.done = done
        #try:
        #    if not self.firstStart:

        #        if self.locale == "cs":
        #            self.dlg.label_progress.setText("Úspěšně exportováno: " +  str(self.done) + " / " + str(self.batchLength) )
        #        else:
        #            self.dlg.label_progress.setText("Sucessfully exported: " +  str(self.done) + " / " + str(self.batchLength) )
        #    else:
        #        self.firstStart = False
        #except:
        #    pass
    def addExistingLayerToCompositeThread(self, title, x):
        name = self.removeUnacceptableChars(title).lower()
        response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/'+str(name), headers = self.getAuthHeader(self.authCfg))
        res = self.fromByteToJson(response.content)
        #print(res)
        wmsUrl = res['wms']['url']
        
        self.existLayer = False
        #self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(title),"className":"HSLayers.Layer.WMS","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"url": wmsUrl ,"params":{"LAYERS": str(name),"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"image/png","FROMCRS":"EPSG:3857","VERSION":"1.3.0"},"ratio":1.5,"dimensions":{}})
        if (self.dlg.radioButton_wms.isChecked()):
            self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(title),"className":"HSLayers.Layer.WMS","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"opacity":1,"url": wmsUrl ,"params":{"LAYERS": str(name),"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"image/png","VERSION":"1.3.0"},"ratio":1.5,"singleTile": True,"visibility": True,"dimensions":{}})
        if (self.dlg.radioButton_wfs.isChecked()):
            self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(title),"className":"OpenLayers.Layer.Vector","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"name": str(name),"opacity":1 ,"protocol":{"format": "hs.format.WFS","url": wmsUrl,"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"image/png","VERSION":"1.3.0"},"ratio":1.5,"visibility": True,"dimensions":{}})
        self.importMap(x, 'add', 1)
        self.refreshLayerListReversed()
           
        #self.dlg.label_loading.hide() 
        
        #self.dlg.progressBar_loader.hide()
        time.sleep(1)
        QgsMessageLog.logMessage("addRaster")
    def isXYZ(self, name):
        layer = QgsProject.instance().mapLayersByName(name)[0]
        params = layer.dataProvider().dataSourceUri().split("&")
        layers = list()
        for p in params:
            #param = p.split("=")  
            print(p)
            if(str(p) == "type=xyz"):
                return True

        return False
    def addExistingWMSLayerToCompositeThread(self, title,nameInList, x):
        print("nameInList"+ nameInList)
        name = self.removeUnacceptableChars(title).lower()
        #response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/'+str(name), verify=False)
        #res = self.fromByteToJson(response.content)
        #print(res)
       # wmsUrl = res['wms']['url']
        layer = QgsProject.instance().mapLayersByName(nameInList)[0]
        params = layer.dataProvider().dataSourceUri().split("&")
        if not (self.isXYZ(layer.name())):
            params = layer.dataProvider().dataSourceUri().split("&")
            layers = list()
            for p in params:
                #print(p)
                param = p.split("=")                
                if(str(param[0]) == "crs"):
                    crs = (param[1])
                if(str(param[0]) == "format"):
                    format = (param[1])   
                   # print(format)
                if(str(param[0]) == "url"):
                    url = (param[1])   
                    #print(url) 
                if(str(param[0]) == "layers"):
                    layers.append(param[1])   
                 #   print(layers) 
                    #   
                    #      
            if (len(layers) == 1):
                layers = str(layers).replace("[", "").replace("]", "").replace("'", "")
            else:
                layers = str(layers).replace("'", "")           
            self.existLayer = False
            self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(nameInList).replace("'", ""),"className":"HSLayers.Layer.WMS","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"url": url ,"params":{"LAYERS": layers,"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":format,"VERSION":"1.3.0"},"ratio":1.5,"dimensions":{}})
           
            self.importMap(x, 'add', 1)
            self.refreshLayerListReversed()
           
            #self.dlg.label_loading.hide() 
        
            #self.dlg.progressBar_loader.hide()
        else:
            for p in params:
                param = p.split("=")  
                #print(p)
                if(param[0] == "url"):
                    url = param[1] 
            crs = layer.crs().authid()    
            self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(nameInList).replace("'", ""),"className":"XYZ","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"url": url ,"params":{"LAYERS": "","INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"","VERSION":"1.3.0"},"ratio":1.5,"dimensions":{}})    
           
            self.importMap(x, 'add', 1)
            self.refreshLayerListReversed()
        time.sleep(1)
        QgsMessageLog.logMessage("addRaster")
    def getSLD(self, layer_name):
        response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/' + self.removeUnacceptableChars(layer_name)+ '/style', headers = self.getAuthHeader(self.authCfg))
        #response = requests.get('https://layman.lesprojekt.cz/rest/lay3/layers/' + layer_name+ '/style') test
        tempf = tempfile.gettempdir() + os.sep +self.removeUnacceptableChars(layer_name)+ ".sld"
        #print(tempf)
        with open(tempf, 'wb') as f:
            f.write(response.content)
        #print(response.status_code)
        #print("sld")
        return response.status_code
        
    def addExistingMapToMemory(self, name):
        response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/maps/'+str(name), headers = self.getAuthHeader(self.authCfg))
        res = self.fromByteToJson(response.content)
        print(res)
        wmsUrl = res['wms']['url']
        
        x = self.dlg.listWidget.currentRow()


        self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(name),"className":"HSLayers.Layer.WMS","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"url": wmsUrl ,"params":{"LAYERS": str(name),"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"image/png","VERSION":"1.3.0"},"ratio":1.5,"dimensions":{}})
        self.importMap(x, 'add', 1)
        self.refreshLayerList()

    def layerInfoRedirect(self, name):
        url = self.URI+'/rest/'+self.laymanUsername+"/layers/" + name
        print(url)
        response = requests.get(url, headers = self.getAuthHeader(self.authCfg))
        r = self.fromByteToJson(response.content)
        try:
            url = r['metadata']['record_url']
            webbrowser.open(url, new=2) ## redirect na micku pro více info
        except:
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Odkaz není k dispozici.")
            else:
                QMessageBox.information(None, "Layman", "Link is unavailable.")
    def checkLayerOnLayman(self, layer_name):
        url = self.URI+'/rest/'+self.laymanUsername+"/layers/"+layer_name
        print(url)
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        #print(r.content)        
        try:
            data = r.json()
        
            if data['wms']['status'] == 'NOT_AVAILABLE' or data['wms']['status'] == 'PENDING':
                return False
            else:
                return True
        except:
            return True # validní vrstva nemá status

    def checkServiceAvailability(self):
        try:
            if (isinstance(self.dlg.mMapLayerComboBox.currentLayer(),QgsRasterLayer)):
                self.dlg.radioButton_wfs.setEnabled(False)
            else:
                self.dlg.radioButton_wfs.setEnabled(True)
        except:
            pass
    def addLayerToComposite(self,x):
        if (isinstance(self.dlg.mMapLayerComboBox.currentLayer(),QgsRasterLayer)):            
            print("External WMS detected")
            self.addExternalWMSToComposite(self.dlg.mMapLayerComboBox.currentLayer().name())
        if (isinstance(self.dlg.mMapLayerComboBox.currentLayer(),QgsVectorLayer)):
            self.dlg.pushButton.setEnabled(False)
            self.compositeListOld = copy.deepcopy(self.compositeList) ## list pred upravou pro vraceni zmen
            #layers = self.getSelectedLayers() #odkomentovat pro zapnuti nacitani vrstev z listwidgetu
            layers = []
            layers.append(self.dlg.mMapLayerComboBox.currentLayer())
            successful = 0
            print (len(layers))
            #try:
            #    step = self.getProgressBarStep(len(layers))
            #except:
            #    if self.locale == "cs":
            #        QMessageBox.information(None, "Layman", "Není vybrána žádná vrstva!")
            #    else:
            #        QMessageBox.information(None, "Layman", "No layer selected!")
        
            for i in range (0, len(layers)):
                print(type(layers[i]))           
            
                print (self.isLayerInComposite(x))
                print (layers[i].name() in self.isLayerInComposite(x))
                inComposite = layers[i].name() in self.isLayerInComposite(x)
                layerName = self.removeUnacceptableChars(layers[i].name()).lower()
                if (self.checkExistingLayer(layers[i].name()) and inComposite):
                    j = self.getLayerInCompositePosition(x)
                    print("j je: " + str(j))
                
            
             
                    self.postRequest(layers[i].name())
                    layerName = self.removeUnacceptableChars(layers[i].name())
           
                else:
                    self.postRequest(layers[i].name())
                    wmsStatus = 'PENDING'
                    j = 0
                    while ((wmsStatus == 'PENDING') and (j < 10)):
                        print("waiting")
                        print(wmsStatus)
                        print (self.URI+'/rest/'+self.laymanUsername+'/layers/'+str(layerName))
                        #response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/'+str(layerName), verify=False)
                        response = requests.get(self.URI+'/rest/'+self.laymanUsername+'/layers/'+str(layerName), headers = self.getAuthHeader(self.authCfg))
                        res = self.fromByteToJson(response.content)
                 
                        print(res)
                        try:
                            #wmsStatus = res['wms']['status']
                            wmsStatus = res['wms']['url']
                        except:
                            #wmsStatus = "done"
                            wmsStatus = "PENDING"
                        time.sleep(1)
                        j = j + 1
            

                    #print(res)
                    try:
                        wmsUrl = res['wms']['url']
                    except:
                        wmsUrl = self.URI+'/geoserver/'+layerName+'/ows'
                    #self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(layerName),"className":"HSLayers.Layer.WMS","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"url": wmsUrl ,"params":{"LAYERS": str(layers[i].name()),"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"image/png","FROMCRS":"EPSG:3857","VERSION":"1.3.0"},"ratio":1.5,"dimensions":{}})
                    if (self.dlg.radioButton_wms.isChecked()):
                        self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(layers[i].name()),"className":"HSLayers.Layer.WMS","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"opacity":1,"url": wmsUrl ,"params":{"LAYERS": str(layerName),"INFO_FORMAT":"application/vnd.ogc.gml","FORMAT":"image/png","VERSION":"1.3.0"},"ratio":1.5,"singleTile": True,"visibility": True,"dimensions":{}})
                    if (self.dlg.radioButton_wfs.isChecked()):
                        self.compositeList[x]['layers'].append({"metadata":{},"visibility":True,"opacity":1,"title":str(layers[i].name()),"className":"OpenLayers.Layer.Vector","singleTile":True,"wmsMaxScale":0,"legends":[""],"maxResolution":None,"minResolution":0,"name": str(layerName),"opacity":1 ,"protocol":{"format": "hs.format.WFS","url": wmsUrl},"ratio":1.5,"visibility": True,"dimensions":{}})
                    successful = successful + 1
                    #self.dlg.progressBar.setValue(self.dlg.progressBar.value()+step)
                    self.dlg.progressBar.show() 
                    self.dlg.label_import.show()
                    self.importMapEnvironmnet(False)
                    threading.Thread(target=lambda: self.importMap(x, "add", successful) ).start()
                    #self.importMap(x, "add", successful) 
    def getProgressBarStep(self, count):
        return (100/count)

    def deteteLayerFromComposite(self, x, position, name):   ## pro verzi s komboboxem   
        
        self.threadDelLayer = threading.Thread(target=lambda: self.deteteLayerFromCompositeThread2(x, position, name))
        self.threadDelLayer.start()   
        self.importMapEnvironmnet(False)
        self.dlg.progressBar.show() 
        self.dlg.label_import.show()
    def deteteLayerFromCompositeThread2(self, x, position, name):
        previousLayers = self.compositeList[x]['layers']       #zaloha  
        self.compositeList[x]['layers'] = []            #vymazat vsechny vrstvy
        for i in range (0,len(previousLayers)):
            
            if (i != len(previousLayers) - (position+1)):      ## kompozice je obracena oproti HSlayers proto odecist        
               self.compositeList[x]['layers'].append(previousLayers[i])        
        #self.importMap(x, "del")
        self.importMap(x, "delLay")
        done = True
        if (len(self.compositeList[x]['layers']) != 0 and len(self.compositeList[x]['layers']) != None):
            for i in range (0, len(self.compositeList[x]['layers'])):
                #if (self.compositeList[x]['layers'][i]['params']['LAYERS'] == name):
                if (self.compositeList[x]['layers'][i]['title'] == name):
                    done = False
        if (done and QgsProject.instance().mapLayersByName(name)):    ## kompozice může mít načtené vrstvy, které nejsou v canvasu
            self.deleteLayerFromCanvas(name)   
        time.sleep(1)
        QgsMessageLog.logMessage("delLayComposite")
    def deteteLayerFromCompositeThread(self, x, position, name, title):        
        previousLayers = []       
        lenBefore = len(self.compositeList[x]['layers'])
        for i in range (0, len(self.compositeList[x]['layers'])):
            if (self.compositeList[x]['layers'][i]['title'] == title):
                #print("del:" + title)
                pass
            else:
                previousLayers.append(self.compositeList[x]['layers'][i])
        #print(previousLayers)
        self.compositeList[x]['layers'] = []            #vymazat vsechny vrstvy
        for i in range (0,len(previousLayers)):         
           
            if (i != len(previousLayers) - (position+1)):      ## kompozice je obracena oproti HSlayers proto odecist   
                
                self.compositeList[x]['layers'].append(previousLayers[i])        
        #self.importMap(x, "del") 
        print(lenBefore)
        print(len(self.compositeList[x]['layers']))
        if (lenBefore - 1) ==  len(self.compositeList[x]['layers']):     
            self.importMap(x, "delLay")
            done = True
            if (len(self.compositeList[x]['layers']) != 0 and len(self.compositeList[x]['layers']) != None):
                for i in range (0, len(self.compositeList[x]['layers'])):
                    #if (self.compositeList[x]['layers'][i]['params']['LAYERS'] == name):
                    if (self.compositeList[x]['layers'][i]['title'] == title):
                        done = False
            #if (done and QgsProject.instance().mapLayersByName(title)):    ## kompozice může mít načtené vrstvy, které nejsou v canvasu
            #    self.deleteLayerFromCanvas(title)   
            #time.sleep(1)
        else:
            QgsMessageLog.logMessage("layerDeleteFromCompositeWrong")
       
        
        
    def importCleanComposite(self,x):
        tempFile = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "compsite.json"
        with open(tempFile, 'w') as outfile:  
            json.dump(self.compositeList[x], outfile)
        with open(tempFile, 'rb') as f:
            d = json.load(f)        
        files = {'file': (tempFile, open(tempFile, 'rb')),} 
        #data = { 'name' :  self.compositeList[x]['name'], 'title' : self.compositeList[x]['title'], 'description' : self.compositeList[x]['abstract']} 
        data = { 'name' :  self.compositeList[x]['name'], 'title' : self.compositeList[x]['title'], 'description' : self.compositeList[x]['abstract'], 'access_rights.read': self.laymanUsername + ', EVERYONE',   'access_rights.write': self.laymanUsername} 
        
        response = requests.post(self.URI+'/rest/'+self.laymanUsername+'/maps', files=files, data = data, headers = self.getAuthHeader(self.authCfg))
        if (response.status_code == 200):
            if self.locale == "cs":
            #    QMessageBox.information(None, "Message", "Kompozice byla úspěsně smazána.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + self.compositeList[x]['name'] + " byla úspešně vytvořena."), Qgis.Success, duration=3)
            else:
            #    QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + self.compositeList[x]['name'] + " was sucessfully created."), Qgis.Success, duration=3)
        else:
            if self.locale == "cs":
            #    QMessageBox.information(None, "Message", "Kompozice byla úspěsně smazána.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + self.compositeList[x]['name'] + " nebyla úspešně vytvořena."), Qgis.Warning, duration=3)
            else:
            #    QMessageBox.information(None, "Message", "Composition deleted sucessfully.")
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + self.compositeList[x]['name'] + " was not sucessfully created."), Qgis.Warning, duration=3)
        #print(response.content)



    def showProgressBar(self, bar):
        bar = QProgressBar() 
        bar.setRange(0,0) ## range 0,0 je nekonečný
        self.showProgressBar(bar)
        bar.show()
        iface.mainWindow().statusBar().addWidget(bar)
    def fromByteToJson(self, res):
        pom = res        
        pom = pom.decode('utf_8')
        pom = json.loads(pom)
        return pom

    def importMap(self, x, operation, s = 0): ##s je počet vrstev úspěšně nahraných na server   
        #if (s != 0):
        #    self.dlg.progressBar.show() 
        #    self.dlg.label_import.show()
        #self.importMapEnvironmnet(True)
        tempFile = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "compsite.json"
        
        try:
            existingLayers = self.isLayerInComposite(x)
        except:
            existingLayers = []        
        successful = s
        with open(tempFile, 'w') as outfile:  
            json.dump(self.compositeList[x], outfile)
        jsonPath = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "compsite.json"
        with open(jsonPath, 'rb') as f:
            d = json.load(f)

        files = {'file': (jsonPath, open(jsonPath, 'rb')),} 
        data = { 'name' :  self.compositeList[x]['name'], 'title' : self.compositeList[x]['title'], 'description' : self.compositeList[x]['abstract'], 'access_rights.read': self.laymanUsername + ', EVERYONE',   'access_rights.write': self.laymanUsername} 
        req = requests.get(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'], headers = self.getAuthHeader(self.authCfg))
        mapCode = req.status_code ## test jestli vrstva na serveru existuje. Pokud ne = error 404
        if (mapCode == 404 or operation == "mod" or operation == "del" or operation == "mov" or operation == "delLay"):
        #if(True):
            if (operation == "add"):    
                if self.locale == "cs":
                    msgbox = QMessageBox(QMessageBox.Question, "Import Map", "Chcete přidat do kompozice "+str(successful)+" vrstev?") 
                else:
                    msgbox = QMessageBox(QMessageBox.Question, "Import Map", "Do you want add into composition "+str(successful)+" layers?") 
            if (operation == "mod"): 
                
                
                self.dlg.close()
                try:
                    self.afterCloseEditMapDialog()
                except: 
                    pass
                #print(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'])       
              
                response = requests.delete(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'],headers = self.getAuthHeader(self.authCfg))
                
                response = requests.post(self.URI+'/rest/'+self.laymanUsername+'/maps', files=files, data = data, headers = self.getAuthHeader(self.authCfg))
                
                if (response.status_code == 200):
                    if self.locale == "cs":                
                        iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + self.compositeList[x]['name'] + " byla úspešně změněna."), Qgis.Success, duration=3)
                    else:              
                        iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + self.compositeList[x]['name'] + " was sucessfully modified."), Qgis.Success, duration=3)
                else:
                    if self.locale == "cs":             
                        iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Kompozice  " + self.compositeList[x]['name'] + " nebyla úspešně změněna."), Qgis.Warning, duration=3)
                    else:          
                        iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", " Composition  " + self.compositeList[x]['name'] + " was not sucessfully modified."), Qgis.Warning, duration=3)
                if (self.dlg.windowTitle() != "Manage Maps"):
                    self.dlg.show()
                return

            if (operation == "mov"):   
                
                response = requests.delete(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'],headers = self.getAuthHeader(self.authCfg))
              
                response = requests.post(self.URI+'/rest/'+self.laymanUsername+'/maps', files=files, data = data, headers = self.getAuthHeader(self.authCfg))
                
                return
            if (operation == "delLay"):                
                    
              
                response = requests.delete(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'],headers = self.getAuthHeader(self.authCfg))
           

                response = requests.post(self.URI+'/rest/'+self.laymanUsername+'/maps', files=files, data = data, headers = self.getAuthHeader(self.authCfg))
              
                             
                return
            if (operation == "del"):
                if self.locale == "cs":
                    msgbox = QMessageBox(QMessageBox.Question, "Import Map", "Chcete smazat vybranou vrstvu?")
                else:
                    msgbox = QMessageBox(QMessageBox.Question, "Import Map", "Do you want delete selected layer?")
          
            try: # jedná se o mod pokud je except
                msgbox.addButton(QMessageBox.Yes)
                msgbox.addButton(QMessageBox.No)
                msgbox.setDefaultButton(QMessageBox.No)
                reply = msgbox.exec()
            except:
                pass
                
            if (reply == QMessageBox.Yes):
                response = requests.post(self.URI+'/rest/'+self.laymanUsername+'/maps', files=files, data = data, headers = self.getAuthHeader(self.authCfg))
               
                data = response.content
               # self.dlg.progressBar.hide() 
               # self.refreshItems()## refresh formuláře
                if (operation != "mod"):
                   # self.refreshLayerList() bylo
                    self.refreshLayerListReversed()
            else:
                if (operation == "add"):
                    self.dlg.progressBar.setValue(0)                
     
        else:
            
            #self.dlg.pushButton.setEnabled(False)
                 
            files = {'file': (jsonPath, open(jsonPath, 'rb')),} 
            response = requests.patch(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name'], data = data, files=files, headers = self.getAuthHeader(self.authCfg))
            
            try: ## některé formuláře nemají progress bar
                self.dlg.progressBar.hide() 
                self.dlg.label_import.hide() 
                self.importMapEnvironmnet(True)
                pass
            except:
                pass
            try:
                row = self.dlg.listWidget_listLayers.currentRow()
               
            except:
              
                pass
            try:
                self.refreshLayerListReversed()
            except:
                ## nacházíme se v jiném formuláři, není co refreshovat
                pass
            try:                
                time.sleep(1)
                
                self.dlg.listWidget_listLayers.setCurrentRow(row)
                if (self.dlg.listWidget_listLayers.currentRow() == -1):                    
                    self.dlg.pushButton_deleteLayers.setEnabled(False)
                    self.dlg.pushButton_up.setEnabled(False)
                    self.dlg.pushButton_down.setEnabled(False)
            except:
                print("ss") 
          
        
    def deleteLayer(self, layerName):
        url = self.URI+'/rest/'+self.laymanUsername+"/layers/" + layerName
        r = requests.delete(url)
        
    def getActiveLayer(self):
        layer = self.iface.activeLayer()
        return layer
    
    def createComposite(self, name, title):
      #  if (name == "" or title == ""):
        if (title == ""):
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Není vyplněn titulek!")
            else:
                QMessageBox.information(None, "Message", "Title is not filled!")
        else:
            name = self.removeUnacceptableChars(title)
            data = self.getEmptyComposite(name,title)
         
            self.compositeList.append(data)   
            x = len(self.compositeList) - 1
            self.importCleanComposite(x)
            try:
                self.refreshCompositeList()
            except:
                pass


    def patchLayer(self, layer_name, data):
        
        #self.layerName = layer_name.lower()
        self.layerName = self.removeUnacceptableChars(layer_name)
        
        sldPath = self.getTempPath(self.layerName).replace("geojson", "sld")
        geoPath = self.getTempPath(self.layerName)
        ##self.layerName = self.layerName
      
        if(os.path.isfile(sldPath)): ## existuje sld?
            files = [('file', open(geoPath, 'rb')), ('sld', open(sldPath, 'rb'))]
            
        else:
            files = {'file': (geoPath, open(geoPath, 'rb')),}  
            
        layer_name = layer_name.lower()
        layer_name = layer_name.replace(" ", "_")
        layer_name = self.removeUnacceptableChars(layer_name)
        url = self.URI+'/rest/'+self.laymanUsername+"/layers/" + layer_name
        
        r = requests.patch(url, files=files, data = data, headers = self.getAuthHeader(self.authCfg), verify=False)
        

    def getTempPath(self, name):

        
        if type(name) is tuple:
            return (name[0] +  name[1])
        else:
            tempFile = tempfile.gettempdir() + os.sep + name +'.geojson'

            return tempFile
    def sendLayer(self):       
        layer = self.getActiveLayer()      
        if (layer == None):
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Neexistuje žádná vrstva k uložení")
            else:
                QMessageBox.information(None, "Message", "No layer to save!")
        else:
            self.json_export()
            self.postRequest()
    def getExistingLayers(self):
        url = self.URI+'/rest/'+self.laymanUsername+"/layers"
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg)) 
        data = r.json()
        for x in range(len(data)):
            print(data[x]['name'])
        return data
    def checkExistingLayer(self, layerName):
        layerName = self.removeUnacceptableChars(layerName)
        url = self.URI+'/rest/'+self.laymanUsername+"/layers"
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg)) 
        data = r.json()
        
        pom = set()
        for x in range(len(data)):
            pom.add((data[x]['name']))
        layerName = layerName.replace(" ", "_").lower()
        
        if (layerName in pom):
            return True
        else:
            return False
   
    def removeUnacceptableChars(self, input):
        input = input.lower()
        input = input.replace("ř","r")
        input = input.replace("š","s")
        input = input.replace("ž","z")
        input = input.replace("ů","u")
        input = input.replace("ú","u")
        input = input.replace(" ","_")
        input = input.replace("é","e")
        input = input.replace("í","i")
        input = input.replace("ý","y")
        input = input.replace("á","a")
        input = input.replace("ó","o")
        input = input.replace("č","c")
        input = input.replace("ď","d")
        input = input.replace("ě","e")
        input = input.replace("ť","t")
        input = input.replace("-","_")
        input = input.replace(".","_")
        input = input.replace(":","")
        input = input.replace("/","_")        
        input = input.replace("___","_")
        input = input.replace("__","_")
        input = re.sub(r'[?|$|.|!]',r'',input)

        if input[len(input) - 1] == "_":
            input = input[:-1]
        
       # iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Diacritics in name of layer was replaced."), Qgis.Success, duration=3)
        #print("name after remove: " + input)
        return input
    def removeUnacceptableChars2(self, input):
        input = input.encode('utf-8')
        input = input.hex()
        
       # iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman:", "Diacritics in name of layer was replaced."), Qgis.Success, duration=3)
        return input
    def test (self):
        item = self.dlgGetLayers.items.currentItem().text()
        #print( item)
    
    def isLayerInComposite(self, x):      
        layers =[]
        layers.append(self.dlg.mMapLayerComboBox.currentLayer())
        #print (self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name']+'/file')
        req = requests.get (self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name']+'/file', headers = self.getAuthHeader(self.authCfg))
        data = req.json()
       
        #print (data['abstract'])
        #print (len(self.compositeList[x]['layers']))
        existingLayers = []
        for i in range (0, len(data['layers'])):
            for j in range (0, len(layers)):
                if (data['layers'][i]['title'] in layers[j].name() ):
                    existingLayers.append(data['layers'][i]['title'])
                #if (data['layers'][i]['params']['LAYERS'] in layers[j].name() ):
                 #   existingLayers.append(data['layers'][i]['params']['LAYERS'])

        return existingLayers
    def getLayerInCompositePosition(self, x):      
        layers =[]
        layers.append(self.dlg.mMapLayerComboBox.currentLayer())
        #print (self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name']+'/file')
        req = requests.get (self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name']+'/file', headers = self.getAuthHeader(self.authCfg))
        data = req.json()
       
        #print (data['abstract'])
        #print (len(self.compositeList[x]['layers']))
        existingLayers = []
        j = 0
        for i in range (0, len(data['layers'])):
            for j in range (0, len(layers)):
                try:
                    print(data['layers'][i])
                    layer = data['layers'][i]['params']['LAYERS'] # wms
                except:
                    layer = data['layers'][i]['name']
                if (layer in layers[j].name() ):
                  #  existingLayers.append(data['layers'][i]['params']['LAYERS'])
                   j = i
                   #print("founded")

        return j

    def isRasterLayerInComposite(self, x, name):
        name = self.removeUnacceptableChars(name).lower()        
        req = requests.get(self.URI+'/rest/'+self.laymanUsername+'/maps/'+self.compositeList[x]['name']+'/file',headers = self.getAuthHeader(self.authCfg))
        
        data = req.json()        
        existingLayers = []       
        for i in reversed(range (0, len(data['layers']))):
            #if (data['layers'][i]['params']['LAYERS'] ==  name ):
            #    existingLayers.append(data['layers'][i]['params']['LAYERS'])
             if (data['layers'][i]['title'] ==  name ):
                existingLayers.append(data['layers'][i]['title'])
        return existingLayers
    
    def addComposite(self, data, service, groupName = ''):     
        
        
        ##for x in range(0, len(data['layers'])): 
        for x in range(len(data['layers'])- 1, -1, -1):          
          #  repairUrl = self.convertUrlFromHex(data['layers'][x]['url'])  
            repairUrl = self.URI+"/geoserver/"+self.laymanUsername+"/ows"
            layerName = data['layers'][x]['params']['LAYERS']
            format = data['layers'][x]['params']['FORMAT']
           #  epsg = str(data['groups']['projection']).upper()
            epsg = 'EPSG:4326' 
            #abstract = data['data']['layers'][x]['params']['ABSTRACT']
            wmsName = data['layers'][x]['params']['LAYERS']
            className = data['layers'][x]['className']
            
            layerNameTitle = self.getLayerTitle(layerName)           

            url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+layerName  
           
            r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
            res = r.json()
            
           
            
            if service == 'WMS':        
                
                UrlWms = data['layers'][x]['url']
                if className == 'XYZ':
                    self.loadXYZ(data['layers'][x]['url'], layerName,layerNameTitle, format,epsg, groupName)
                else:
                    self.loadWms(UrlWms, layerName,layerNameTitle, format,epsg, groupName)

            if service == 'WFS': 
                #UrlWfs = res['wfs']['url']
                UrlWms = data['layers'][x]['url']
                self.loadWfs(UrlWfs, layerName,layerNameTitle, groupName)
    def loadService(self, data, service, groupName = ''):     
        
        
        for x in range(len(data['layers'])- 1, -1, -1):       ## descending order 
        #for x in range(len(data['layers'])):       ## descending order 
            #repairUrl = self.convertUrlFromHex(data['layers'][x]['url'])  
            repairUrl = self.URI+"/geoserver/"+self.laymanUsername+"/ows"
            try:
                layerName = data['layers'][x]['params']['LAYERS']
            except:
                layerName = data['layers'][x]['name']
            format = data['layers'][x]['params']['FORMAT']
           #  epsg = str(data['groups']['projection']).upper()
            epsg = 'EPSG:4326' 
            className = data['layers'][x]['className']
            #abstract = data['data']['layers'][x]['params']['ABSTRACT']
            wmsName = data['layers'][x]['params']['LAYERS']  
            layerNameTitle = data['layers'][x]['title']
            if self.checkLayerOnLayman(layerName):
                if service == 'WMS':         
                   
                    repairUrl = data['layers'][x]['url']
                    #self.loadWms(repairUrl, layerName,layerNameTitle, format,epsg, groupName)
                    if className == 'XYZ':
                        self.loadXYZ(data['layers'][x]['url'], layerName,layerNameTitle, format,epsg, groupName)
                    else:
                        self.loadWms(repairUrl, layerName,layerNameTitle, format,epsg, groupName)
                if service == 'WFS': 
                   # repairUrl = repairUrl.replace("ows","wfs")
                    repairUrl = data['layers'][x]['url']
                    self.loadWfs(repairUrl, layerName,layerNameTitle, groupName)
            else:
                if self.locale == "cs":
                    QMessageBox.information(None, "Layman", "Vrstva: "+layerName + " je poškozena a nebude načtena.")
                else:
                    QMessageBox.information(None, "Layman", "Layer: "+layerName + " is corrupted and will not be loaded.")
    def convertUrlFromHex(self, url):
        url = url.replace('%3A',':')
        url = url.replace('%2F','/')
        url = url.replace('%3F','?')
        url = url.replace('%3D','=')
        url = url.replace('%26','&') 
        return url
    def loadService2(self, data, service, groupName = ''):   
        for x in range(len(data['layers'])- 1, -1, -1):       ## descending order
            className = data['layers'][x]['className']     
            if className == 'HSLayers.Layer.WMS':
                layerName = data['layers'][x]['params']['LAYERS']
            if className == 'OpenLayers.Layer.Vector': 
                print(data['layers'][x])
                try:
                    layerName = data['layers'][x]['name']
                except:
                    layerName = data['layers'][x]['protocol']['LAYERS']

            if self.checkLayerOnLayman(layerName):
                
                if className == 'HSLayers.Layer.WMS':        
                    repairUrl = self.URI+"/geoserver/"+self.laymanUsername+"/ows"
                    layerName = data['layers'][x]['params']['LAYERS']
                    format = data['layers'][x]['params']['FORMAT']           
                    epsg = 'EPSG:4326'             
                    wmsName = data['layers'][x]['params']['LAYERS']  
                    layerNameTitle = data['layers'][x]['title']
                    repairUrl = data['layers'][x]['url']
                    repairUrl = self.convertUrlFromHex(repairUrl)
                    #self.loadWms(repairUrl, layerName,layerNameTitle, format,epsg, groupName)
                    self.loadWms(repairUrl, layerName,layerNameTitle, format,epsg, groupName)
                if className == 'XYZ':
                    repairUrl = self.URI+"/geoserver/"+self.laymanUsername+"/ows"
                    layerName = data['layers'][x]['params']['LAYERS']
                    format = data['layers'][x]['params']['FORMAT']           
                    epsg = 'EPSG:4326'             
                    wmsName = data['layers'][x]['params']['LAYERS']  
                    layerNameTitle = data['layers'][x]['title']
                    repairUrl = data['layers'][x]['url']
                    repairUrl = self.convertUrlFromHex(repairUrl)
                    self.loadXYZ(data['layers'][x]['url'], layerName,layerNameTitle, format,epsg, groupName)
                
                    
                if className == 'OpenLayers.Layer.Vector': 
                    
                    epsg = 'EPSG:4326'            
                
                    layerNameTitle = data['layers'][x]['title']                    
                    repairUrl = data['layers'][x]['protocol']['url']
                    repairUrl = self.convertUrlFromHex(repairUrl)
                    self.loadWfs(repairUrl, layerName,layerNameTitle, groupName)
            else:
                if self.locale == "cs":
                    QMessageBox.information(None, "Layman", "Vrstva: "+layerName + " je poškozena a nebude načtena.")
                else:
                    QMessageBox.information(None, "Layman", "Layer: "+layerName + " is corrupted and will not be loaded.")
    def getLayerTitle(self, layerName):
        layerName = self.removeUnacceptableChars(layerName)
        url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+layerName
        r = requests.get(url = url, headers = self.getAuthHeader(self.authCfg))
        data = r.json()
       
        title = data['title']
        
        return title
    def parseWMSlayers(self, layerString):
        ### ocekavany string je ve formatu pole napr [vrstva1,vrstva2,...]
        if (layerString[0] == "[" and layerString[-1:] == "]"):    
            s = layerString.replace("[","").replace("]","").split(",")
            res = ""
            for i in range(0, len(s)):
              
                if (i == 0):
                    res = res+ s[i].replace(" ", "") + "&layers="
                elif (i == len(s)-1):
                    res = res+ s[i].replace(" ", "")
                else:
                    res = res+ s[i].replace(" ", "") + "&layers="


            for i in range(0, len(s)-1):
                res = res + "&styles"
            return res.replace("_","")
        else:
            return layerString

    def loadWms(self, url, layerName,layerNameTitle, format, epsg, groupName = ''):     
      
        
        #layerName = self.removeUnacceptableChars(layerName)
       
        layerName = self.parseWMSlayers(layerName)
        epsg = "EPSG:4326"
        url = url.replace("%2F", "/").replace("%3A",":")
        urlWithParams = 'contextualWMSLegend=0&crs='+epsg+'&IgnoreReportedLayerExtents=1&dpiMode=7&featureCount=10&format=image/png&layers='+layerName+'&styles=&url=' + url
     
        ### quri
        #authCfg=self.client_id[-7:]
        #authCfg = '957je05'
        quri = QgsDataSourceUri()
        quri.setParam("layers", layerName)
        quri.setParam("styles", '')
        quri.setParam("format", 'image/png')
        quri.setParam("crs", 'EPSG:4326')
        quri.setParam("dpiMode", '7')
        quri.setParam("featureCount", '10')
        quri.setParam("authcfg", self.authCfg)   # <---- here my authCfg url parameter
        quri.setParam("contextualWMSLegend", '0')
        quri.setParam("url", url)
        rlayer = QgsRasterLayer(str(quri.encodedUri(), "utf-8"), layerNameTitle, 'wms')
        #print(rlayer.isValid())
        ##quri end
       # rlayer = QgsRasterLayer(urlWithParams, layerNameTitle, 'wms')
        try:
            print("extents")
            print(rlayer.ignoreExtents())
        except:
            print("ignoreExtents works only with qgis 3.10 and higher")
            pass # pro qgis 3.10 a vys
            
        if (rlayer.isValid()):  
            if (groupName != ''):
                self.addWmsToGroup(groupName,rlayer)
            else:          
                QgsProject.instance().addMapLayer(rlayer)
        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "WMS není pro vrstu "+layerNameTitle+ " k dispozici.")
            else:
                QMessageBox.information(None, "Layman", "WMS for layer "+layerNameTitle+ " is not available.")
    def loadXYZ(self, url, layerName,layerNameTitle, format, epsg, groupName = ''):      
      
        
        layerName = self.removeUnacceptableChars(layerName)
        print("XYZ")
        
        epsg = "EPSG:4326"
        url = url.replace("%2F", "/").replace("%3A",":")    
       
    
      
        rlayer = QgsRasterLayer("type=xyz&url="+url, layerNameTitle, "wms") 
        try:
            print("extents")
            print(rlayer.ignoreExtents())
        except:
            print("ignoreExtents works only with qgis 3.10 and higher")
            pass # pro qgis 3.10 a vys
            
        if (rlayer.isValid()):  
            if (groupName != ''):
                self.addWmsToGroup(groupName,rlayer)
            else:          
                QgsProject.instance().addMapLayer(rlayer)
        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "WMS není pro vrstu "+layerNameTitle+ " k dispozici.")
            else:
                QMessageBox.information(None, "Layman", "WMS for layer "+layerNameTitle+ " is not available.")
    
    def loadWfs(self, url, layerName,layerNameTitle, groupName = ''):
        layerName = self.removeUnacceptableChars(layerName)
        epsg = 'EPSG:3857'    
        epsg = iface.mapCanvas().mapSettings().destinationCrs().authid()
        uri = self.URI+"/geoserver/"+self.laymanUsername+"/ows?srsname="+epsg+"&typename="+self.laymanUsername+":"+layerName+"&restrictToRequestBBOX=1&pagingEnabled=True&version=auto&request=GetFeature&service=WFS"
        url = url.replace("%2F", "/").replace("%3A",":").replace("/client","")
        r = url.split("/")
        acc = (r[len(r)-2])
       # print(uri)        
      #  uri = url + "?srsname="+epsg+"&typename="+self.laymanUsername+":"+layerName+"&restrictToRequestBBOX=1&pagingEnabled=True&version=auto&request=GetFeature&service=WFS"
        uri = url + "?srsname="+epsg+"&typename="+acc+":"+layerName+"&restrictToRequestBBOX=1&pagingEnabled=True&version=auto&request=GetFeature&service=WFS"
        print(epsg)
        print(acc+":"+layerName)
        print(url)
        
        quri = QgsDataSourceUri()        
        quri.setParam("srsname", epsg)
        quri.setParam("typename", acc+":"+layerName)
        quri.setParam("restrictToRequestBBOX", "1")
        quri.setParam("pagingEnabled", "true")
        quri.setParam("version", "auto")
        quri.setParam("request", "GetFeature")
        quri.setParam("service", "WFS")
        quri.setParam("authcfg", self.authCfg)
        quri.setParam("url", url)     
        vlayer = QgsVectorLayer(url+"?" + str(quri.encodedUri(), "utf-8"), layerNameTitle, "WFS")
       # print(vlayer.isValid()) 
        
        if (vlayer.isValid()):
            if (self.getTypesOfGeom(vlayer) < 2):
           # if (True):    
                if (groupName != ''):
                    self.addWmsToGroup(groupName,vlayer)
                else:            
                    QgsProject.instance().addMapLayer(vlayer)
                ## zde bude SLD kod
                code = self.getSLD(layerName)
                
                
                if (code == 200):
                    tempf = tempfile.gettempdir() + os.sep +self.removeUnacceptableChars(layerName)+ ".sld"
                    vlayer.loadSldStyle(tempf)
                    vlayer.triggerRepaint()
            else: ### cast pro slozenou geometrii
                self.mixedLayers.append(layerName)
                pointFeats = list()
                polyFeats = list()
                lineFeats = list()  
                feats = vlayer.getFeatures()
                #print(len(feats))
    
                pol = 0
                line = 0
                point = 0
                for feat in feats:
                   # print(type(feat))
                    #print(feat.geometry().type())
                    if (feat.geometry().type() == 0):
                        pointFeats.append(feat)
                        point = 1          
         
                    if (feat.geometry().type() == 2):
                        polyFeats.append(feat)        
                        pol = 1
                    if (feat.geometry().type() == 1):
                        lineFeats.append(feat) 
                        line =  1       
                if (point == 1):
                    vl = QgsVectorLayer("Point?crs="+epsg, layerName, "memory")    
                    pr = vl.dataProvider()        
                    pr.addFeatures(pointFeats)
                    vl.updateFields()
                    vl.updateExtents()         
                    vl.commitChanges()        
                    vl.nameChanged.connect(self.forbidRename)
                    if (groupName != ''):
                        self.addWmsToGroup(groupName,vl, True)
                        
                    else:      
                        self.addLayerToGroup(layerName,vl)
                        #QgsProject.instance().addMapLayer(vl)
                        ### zde bude SLD kod
                        #code = self.getSLD(layerName)
                        #if (code == 200):
                        #    tempf = tempfile.gettempdir() + os.sep +self.removeUnacceptableChars(layerName)+ ".sld"
                        #   # print(vlayer.loadSldStyle(tempf))
                        #    vlayer.triggerRepaint()   
                if (line == 1):
                    vl = QgsVectorLayer("LineString?crs="+epsg, layerName, "memory")    
                    pr = vl.dataProvider()        
                    pr.addFeatures(lineFeats)
                    vl.updateFields()
                    vl.updateExtents()         
                    vl.commitChanges()    
                    vl.nameChanged.connect(self.forbidRename)
                    if (groupName != ''):
                        self.addWmsToGroup(groupName,vl, True)
                    else:      
                        self.addLayerToGroup(layerName,vl)
                           
                if (pol == 1):
                    vl = QgsVectorLayer("Polygon?crs="+epsg, layerName, "memory")    
                    pr = vl.dataProvider()        
                    pr.addFeatures(polyFeats)
                    vl.updateExtents()         
                    vl.updateFields()
                    vl.commitChanges()    
                    vl.nameChanged.connect(self.forbidRename)
                    if (groupName != ''):
                        self.addWmsToGroup(groupName,vl, True)
                    else:      
                        self.addLayerToGroup(layerName,vl)
                         


        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "WFS není pro vrstu "+layerNameTitle+ " k dispozici.")
            else:
                QMessageBox.information(None, "Layman", "WFS for layer "+layerNameTitle+ " is not available.")
    def forbidRename(self):
        if ((int(round(time.time() * 1000)) - self.millis)  > 3000):
            self.millis = int(round(time.time() * 1000))
        
            if self.locale == "cs":
                QMessageBox.information(None, "Layman", "Vrstva s kombinovanou geometií nemůže být přejmenována.")
            else:
                QMessageBox.information(None, "Layman", "Layer with mixed geometry can´t be renamed.")
            self.focusedLayer.setName(self.layerOldName)
      

        
    def getTypesOfGeom(self, vlayer):
        feats = vlayer.getFeatures()
        
        typesL = 0
        typesP = 0
        typesPol = 0
        for feat in feats:
            if (typesL == 0):
                if (feat.geometry().type() == 0):       
                    typesL = 1
            if (typesP == 0):
                if (feat.geometry().type() == 2):             
                    typesP = 1
            if (typesPol == 0):
                if (feat.geometry().type() == 1):        
                    typesPol = 1
            if typesL+typesP+typesPol > 2:
                return typesL+typesP+typesPol
        return typesL+typesP+typesPol
    def addWmsToGroup(self, groupName, layer, subgroup = False):
        root = QgsProject.instance().layerTreeRoot()
        group = root.findGroup(groupName)
        if subgroup and group:
            group = group.findGroup(layer.name())
            #if not(sub):
            #    group.addGroup(layer.name()) 
            #    group = group.findGroup(layer.name())
        if not(group):
            group = root.addGroup(groupName)  
            if subgroup:
                sub = group.findGroup(layer.name())
                if not(sub):
                    group.addGroup(layer.name()) 
                    group = group.findGroup(layer.name())
                        
            #group = self.reorderToTop(groupName)
        time.sleep(1)
        QgsProject.instance().addMapLayer(layer,False)
        group.insertChildNode(1000,QgsLayerTreeLayer(layer))        
    def addLayerToGroup(self, groupName, layer):
        root = QgsProject.instance().layerTreeRoot()
        group = root.findGroup(groupName) 
        if not(group):
            group = root.addGroup(groupName) 
                                   
            #group = self.reorderToTop(groupName)
        time.sleep(1)
        QgsProject.instance().addMapLayer(layer,False)
        group.insertChildNode(1000,QgsLayerTreeLayer(layer))                
    def reorderToTop(self, name):
        root = QgsProject.instance().layerTreeRoot()
        for ch in root.children():
            if ch.name() == name:
                _ch = ch.clone()
                root.insertChildNode(0, _ch)
                root.removeChildNode(ch)
        return _ch
    def convertUrlFromHex(self, url):
        url = url.replace('%3A',':')
        url = url.replace('%2F','/')
        url = url.replace('%3F','?')
        url = url.replace('%3D','=')
        url = url.replace('%26','&') 
        return url

    def checkEpsg(self, name):
        ret = False
        layer = QgsProject.instance().mapLayersByName(name)
        layerCRS = layer[0].crs().authid()
        if ((layerCRS == 'EPSG:4326') or (layerCRS == 'EPSG:3857')):
            ret = True
        return ret

    def registerLayer(self, name):
        

        url = self.URI + "/rest/"+self.laymanUsername+"/layers"
        name = self.removeUnacceptableChars(name)  
        sldPath = self.getTempPath(name).replace("geojson", "sld").lower()
        geoPath = self.getTempPath(name).lower()
        files = {'sld': (sldPath, open(sldPath, 'rb')),} # nahrávám sld
        payload = {        
            'file': name.lower()+".geojson",
            'title': name
            }    
        response = requests.request("POST", url, files = files, data=payload, headers = self.getAuthHeader(self.authCfg))    
      
    def writeState(self,value):
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "state.txt" 
        if os.path.exists(path) == False:
            open(path, "w").close
        file = open(path, 'w+')
        file.write(str(value))
        file.close()
    def notifySuccess(self):
        if self.locale == "cs":
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Vrstva "+str(self.importedLayer)+" byla úspěšně importována."), Qgis.Success, duration=3)
        else:
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Layer "+str(self.importedLayer)+" was imported successfully."), Qgis.Success, duration=3)

    def read_in_chunks(self, file_object): ## cca 1MB chunk převzato z laymana test klienta
        chunk_size=self.CHUNK_SIZE
        while True:
            data = file_object.read(chunk_size)
            if not data:
                break
            yield data
    
    def postInChunks(self, layer_name, reqType):
       # print(reqType)
       # print("xxx" + layer_name)
        if (reqType == "patch"):
            #url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+layer_name.lower().replace(" ", "_")
            url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+self.removeUnacceptableChars(layer_name)
            r = requests.delete(url,headers = self.getAuthHeader(self.authCfg))
           
        
        self.registerLayer(layer_name)
        layer_name = self.removeUnacceptableChars(layer_name)
        filePath = os.path.join(tempfile.gettempdir(), "atlas_chunks" ) ## chunky se ukládají do adresáře v tempu
        
        if not (os.path.exists(filePath)):
            os.mkdir(filePath)
        file = self.getTempPath(layer_name) 
        f = open(file, 'rb')
        arr = []
        for piece in self.read_in_chunks(f):
            arr.append(piece)
       # layer_name = self.removeUnacceptableChars(layer_name)

        url = self.URI+'/rest/'+self.laymanUsername+'/layers/'+layer_name+'/chunk'     
        
        resumableFilename = layer_name+'.geojson'
        layman_original_parameter = "file"  
        resumableTotalChunks = len(arr)
        #print ("resumable" + resumableFilename)
        try:
            for i in range (1, len(arr)+1):  ##chunky jsou počítané od 1 proto +1  
                print("chunk" + str(i))
                file = arr[i-1] # rozsekaná část souboru
                resumableChunkNumber = i  # cislo casti
                payload = {
                'file' : "chunk"+str(i)+".geojson",
                'resumableFilename': resumableFilename,
                'layman_original_parameter': layman_original_parameter,
                'resumableChunkNumber': i,
                'resumableTotalChunks': resumableTotalChunks
                } 
         
                f = open(filePath + os.sep+"chunk"+str(i)+".geojson", "wb")
                f.write(bytearray(arr[i-1]))
                f.close()              
                files = {'file': (layer_name.lower().replace(" ", "_")+".geojson", open(filePath +os.sep+ "chunk"+str(i)+".geojson", 'rb')),}              
                response = requests.post(url, files = files, data=payload, headers = self.getAuthHeader(self.authCfg))

               # print(response.content)
               # print(layer_name)
            #iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Layer  " + layer_name + " was imported successfully."), Qgis.Success, duration=3)
        except:
            pass
            #iface.messageBar().pushWidget(iface.messageBar().createMessage("Import:", " Layer  " + layer_name + " was not imported successfully!"), Qgis.Warning, duration=3)


    def is_admin(self):
        try:
            return ctypes.windll.shell32.IsUserAnAdmin()
        except:
            return False
    def install(self):
        if self.locale == "cs":
            msgbox = QMessageBox(QMessageBox.Question, "Import Map", "Plugin vyžaduje instalaci následujících python modulů: \n\nFlask 1.1.1 \nWerkzeug 0.16.0 \nItsDangerous 1.1.0 \nClick 7.0 \n\nInstalace vyžaduje administrátorská práva. \nChcete provést instalaci modulů?")
        else:
            msgbox = QMessageBox(QMessageBox.Question, "Import Map", "Plugin requires installation following python modules: \n\nFlask 1.1.1 \nWerkzeug 0.16.0 \nItsDangerous 1.1.0 \nClick 7.0 \n\nInstalation requires administrator permissions. \nDo you want install the packages?")
        msgbox.addButton(QMessageBox.Yes)
        msgbox.addButton(QMessageBox.No)
        msgbox.setDefaultButton(QMessageBox.No)
        reply = msgbox.exec()
        if (reply == QMessageBox.Yes):
            path = QgsApplication.prefixPath().replace("apps/qgis","apps") + "/Python37/lib/site-packages"


            if self.is_admin():
                print("xx")# Code of your program here
            else:
                # Re-run the program with admin rights
                program = self.plugin_dir + os.sep + "dependencies" + os.sep + "LaymanDependencies.exe"
                
                if not os.path.exists(path):
                    path = path.replace("apps-ltr","apps")
               # print(path)
                print(ctypes.windll.shell32.ShellExecuteW(None, "runas", program, path, None, 1))
                self.dlg.close()
                self.disableEnvironment()
                QMessageBox.information(None, "Layman", "Layman plugin was updated. Please restart QGIS.")
              #  ctypes.windll.shell32.ShellExecuteW(None, "runas", "notepad.exe", self.plugin_dir + os.sep + "Layman.py", None, 1)
############################################# auth part############################
    def startThread(self): 
        self.thread1 = threading.Thread(target=self.refreshToken)
        self.thread1.start()

    def refreshToken(self):
        #self.expires_in = 60
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "tsts.txt" 
        i = 0
        #tokenEndpoint = "https://www."+self.liferayServer+"/o/oauth2/token"
        tokenEndpoint = self.liferayServer+"/o/oauth2/token"
        while (i < self.expires_in):        
            f = open(path, "a")
            f.write(str(i))

            f.close()            
            time.sleep(1)         
            if i == self.expires_in - 4:
            
               
                data = {'grant_type':'refresh_token',
                        'refresh_token': self.refresh_token,
                        'client_id': self.client_id,   ##'id-3462f94b-875c-9185-4ced-b69841f24b3', 
                        'redirect_uri':'http://localhost:3857/client/authn/oauth2-liferay/callback', 
                        'code_verifier':self.code_verifier  ##'test'
                        } 
                
                r = requests.post(url = tokenEndpoint, data = data, headers = self.getAuthHeader(self.authCfg)) 
                res = self.fromByteToJson(r.content)
                self.access_token = res['access_token']
                self.refresh_token = res['refresh_token']
                self.expires_in = res['expires_in']
                print(self.access_token)
                self.setAuthHeader()
                i = 0
            else:
                i += 1
        
        
        
        



    
    def authOptained (self):        
        try:
            self.dlg.pushButton_Continue.setEnabled(True)
            self.dlg.pushButton_Connect.setEnabled(False) 
        except:
            pass

        self.menu_Connection.setEnabled(True)
        self.menu_saveLocalFile.setEnabled(False)
        self.menu_loadJson.setEnabled(True)
        self.menu_ImportLayerDialog.setEnabled(True)
        self.menu_AddLayerDialog.setEnabled(True) 
        self.menu_AddMapDialog.setEnabled(True)       
        self.menu_ImportLayerDialog.setEnabled(True)
        self.menu_ImportMapDialog.setEnabled(False)       
     #   self.menu_DeleteMapDialog.setEnabled(True)
    #    self.menu_CreateCompositeDialog.setEnabled(True)
        self.menu_UserInfoDialog.setEnabled(True)
        
        #self.textbox.setText("Layman: Logged user")
    def getAuthHeader(self, authCfg):        
        config = QgsAuthMethodConfig()
        url = QUrl(self.URI+ "/rest/current-user")
        xx = QNetworkRequest(url)
        print(xx.header(QNetworkRequest.KnownHeaders(-2)))
        i = 0
        success = (QgsApplication.authManager().updateNetworkRequest(xx, authCfg))
        print(success[0])
        if success[0] == False:
            success  = (QgsApplication.authManager().updateNetworkRequest(xx, authCfg))
        #while (success[0] == False or i < 30):
        #    success  = (QgsApplication.authManager().updateNetworkRequest(xx, authCfg))
        #    time.sleep(0.5)
        #    i = i + 1
        #print(xx.header(QNetworkRequest.KnownHeaders.ContentDispositionHeader))
        if success[0] == True:
            header = (xx.rawHeader(QByteArray(b"Authorization")))
            #print(header)
            authHeader ={
              "Authorization": str(header, 'utf-8')           
            } 
            return authHeader
        else:
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Autorizace nebyla úspěšná! Prosím zkuste to znovu.")
            else:
                QMessageBox.information(None, "Message", "Autorization was not sucessfull! Please try it again.")
            return False
            
    def getCodeVerifier(self):
        code_verifier = base64.urlsafe_b64encode(os.urandom(40)).decode('utf-8')
        code_verifier = re.sub('[^a-zA-Z0-9]+', '', code_verifier)
        self.code_verifier = code_verifier
        return (code_verifier)
      
    def getCodeChallenge(self, code_verifier):
        code_challenge = hashlib.sha256(code_verifier.encode('utf-8')).digest()
        code_challenge = base64.urlsafe_b64encode(code_challenge).decode('utf-8')
        code_challenge = code_challenge.replace('=', '')
        self.code_challenge = code_challenge
        return (code_challenge)        

    def printVariables(self):
        print (self.access_token)
        print(self.refresh_token)
        print(self.getAuthHeader(self.authCfg))
        print(self.laymanUsername)

    def getAuthCode(self):
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt"        
        f = open(path, "r")
        ret =  f.read()
        f.close()
        return ret

    def getToken(self):
        self.saveIni()      
        
        #tokenEndpoint = "https://www."+self.liferayServer+"/o/oauth2/token"
        tokenEndpoint = self.liferayServer+"/o/oauth2/token"
        # data to be sent to api 
        data = {'grant_type':'authorization_code', 
                'client_id': self.client_id, 
                'redirect_uri':'http://localhost:3857/client/authn/oauth2-liferay/callback', 
                'code_verifier': self.code_verifier, 
                'code': self.getAuthCode()} 
  
        # sending post request and saving response as response object 
        print(tokenEndpoint)
        print(self.getAuthHeader(self.authCfg))
        print(data)
        r = requests.post(url = tokenEndpoint, data = data, headers = self.getAuthHeader(self.authCfg)) 
        print (r.content)
        res = self.fromByteToJson(r.content)
        print (res)
        try:
            print(res['access_token'])
            print(res['expires_in'])
            print(res['refresh_token'])
        except:
            if self.locale == "cs":
                QMessageBox.information(None, "Message", "Autorizace nebyla úspěšná! Prosím zkuste to znovu.")
            else:
                QMessageBox.information(None, "Message", "Autorization was not sucessfull! Please try it again.")
            return
        self.access_token = res['access_token']
        self.refresh_token = res['refresh_token']
        self.expires_in = res['expires_in']
        self.setAuthHeader()
        data ={
            'access_token': res['access_token'], 
            'refresh_token': res['refresh_token'],
            'expires_in':res['expires_in']
            }
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "tokens.json"        
        with open(path, 'w') as outfile:
            json.dump(data, outfile)
        #self.dlg.progressBar.show()
        self.registerUserIfNotExists()        
        self.startThread()   
        #self.loadAllCompositesT()
        threading.Thread(target=self.loadAllCompositesT).start() ## načteme kompozice do pole ve vláknu 
        ### authconfig
        authcfg_id = self.authCfg
        if authcfg_id not in QgsApplication.authManager().availableAuthMethodConfigs():
            QgsApplication.authManager().clearAllCachedConfigs()
            self.setup_oauth(self.authCfg, self.liferayServer)

        ##authconfig end
        self.dlg.close()
        
        
        
    def setAuthHeader(self):
        self.authHeader ={
          "Authorization": "Bearer " + self.access_token, 
          "AuthorizationIssUrl" : self.liferayServer+'/o/oauth2/authorize'
        } 
 
    def beforeAmp(self, s):
        ret = ""
        print(len(s))
        for i in (s):
            if i == "@":
                break
            ret = ret + i      
        print(ret)
        return ret
    def registerUserIfNotExists(self):
        print(self.URI)            
        userEndpoint = self.URI+ "/rest/current-user"   
        #self.laymanUsername = self.dlg.lineEdit_userName.text()
        print(userEndpoint)
        print(self.Agrimail)
        login = self.beforeAmp(self.Agrimail)
        print(login)
        id = self.client_id.replace('-', '')
        login = login.replace(".","_")
        self.laymanUsername = login
        user = {'username':login}  
        #user = {'username':'vrobel_hanz'}  
        #user =  self.Agrimail                
        print("authheader: "+ str(self.getAuthHeader(self.authCfg)))
       
        r = requests.patch(url = userEndpoint, data = user, headers = self.getAuthHeader(self.authCfg))
        res = r.text
        try:
            res = self.fromByteToJson(r.content)
            print (res)
            print(user)
            print(res)
        except:
            if self.locale == "cs":
                QMessageBox.information(None, "Error", "Layman server neodpověděl!") 
            else:
                QMessageBox.information(None, "Error", "Layman server not respond!")
            self.disableEnvironment()
            return
        
        
        try:
           # if res['message'] == 'User already reserved username.': # res['code'] == 34, code 35 je pokud již jiný uživatel má účet, který chceme registrovat
           if res['code'] == 34: # res['code'] == 34, code 35 je pokud již jiný uživatel má účet, který chceme registrovat (code 35 pravděpodobně nemůže nastat)

                print("user exists")
               
                self.laymanUsername = res['detail']['username']
                print("username is: " + self.laymanUsername )
                self.textbox.setOpenExternalLinks(True)
                url = self.liferayServer.replace('https:\\','').replace('.cz','').replace('http:\\','').replace('www.','').replace('.com','')
                self.textbox.setText('<a href="'+self.liferayServer+"/home"'">' + url + '</a>')
           if res['code'] == 32:
                self.disableEnvironment()
                if self.locale == "cs":
                    QMessageBox.information(None, "Error", "Oauth2 autorizace nebyla úspěšná!") 
                else:
                    QMessageBox.information(None, "Error", "Oauth2 authorization was not successfull!") 
                self.textbox.setText("Layman")
                return
            #self.laymanUsername = res['username']
            #else:
            #    self.laymanUsername =  user['username']
        except:

            print("creating new user: " + res['username'])
            self.laymanUsername =  res['username']
            url = self.liferayServer.replace('https:\\','')
            self.textbox.setText('<a href="'+self.liferayServer+"/home"'">' + url + '</a>')
            ##self.textbox.setText("Connected to: " + self.liferayServer.replace("https:\\","").replace(".cz","").replace("http:\\","").replace("www.","").replace(".com",""))
        
      
    def checkAuthChange(self):
        i = 0
        path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt" 
        #print("thread is running")
        #print(self.authFileTime)
        #print(os.path.getmtime(path))
        while(i < 500):
            if self.authFileTime == os.path.getmtime(path):
                pass
            else:
                self.authFileTime = os.path.getmtime(path)
                QgsMessageLog.logMessage("authOptained")
                #self.authOptained()
                i = i + 500
                #print("obtained code")
            i = i +1
            time.sleep(0.5)
    def openAuthLiferayUrl2(self):
        #self.authCfg = self.client_id[-7:]
        #authcfg_id = self.client_id[-7:]
        authcfg_id = self.authCfg
        #if authcfg_id not in QgsApplication.authManager().availableAuthMethodConfigs():
        self.setup_oauth(authcfg_id, self.liferayServer)
        authHeader = self.getAuthHeader(self.authCfg)
        if (authHeader):
            self.registerUserIfNotExists()
            threading.Thread(target=self.loadAllCompositesT).start() ## načteme kompozice do pole ve vláknu 
            ### authconfig
            #authcfg_id = self.client_id[-7:]
            #if authcfg_id not in QgsApplication.authManager().availableAuthMethodConfigs():
            #    self.setup_oauth(self.client_id[-7:], self.liferayServer)
            ##authconfig end
            ## check for new version
           
            versionCheck = self.checkVersion()
            if versionCheck[0] == False:
                if self.locale == "cs":
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "Nová verze pluginu Layman k dispozici."), Qgis.Success, duration=15)
                else:
                    iface.messageBar().pushWidget(iface.messageBar().createMessage("Layman", "New version of Layman plugin available."), Qgis.Success, duration=15)

            ##

            self.authHeader = authHeader
            self.authOptained()
            self.dlg.close()

        
    def openAuthLiferayUrl(self):
        self.disableEnvironment()
        self.loadedInMemory = False
        self.compositeList = []
        self.compositeListOld = []
        #self.liferayServer = self.dlg.lineEdit_server.text()
        #self.URI = self.dlg.lineEdit_serverLayman.text()
        self.getCodeChallenge(self.getCodeVerifier()) ##generování kódů
       # self.client_id = self.dlg.lineEdit_AgriID.text()
        #path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt" 
        #self.watcher = QFileSystemWatcher()
        #self.watcher.addPath(path)
        #self.watcher.fileChanged.connect(self.authOptained)
      
        
            #################       
        #path = tempfile.gettempdir() + os.sep + "atlas" + os.sep + "auth.txt" 
        #self.watcher2 = QFileSystemWatcher()
        #self.watcher2.addPath(path)
        #self.watcher2.fileChanged.connect(self.authOptained)
        threading.Thread(target=lambda: self.checkAuthChange()).start() 
        url = self.liferayServer+'/o/oauth2/authorize?response_type=code&client_id='+self.client_id+'&redirect_uri=http%3A%2F%2Flocalhost:3857%2Fclient%2Fauthn%2Foauth2-liferay%2Fcallback&code_challenge='+self.code_challenge ##n4bQgYhMfWWaL-qgxVrQFaO_TxsrC4Is0V1sFbDwCgg'  
        try:
            r = requests.get("http://127.0.0.1:3857") 
            print(r.content)
            if (r.content == b'Flask server'):
                print("flask already running")
                webbrowser.open(url, new=2)   
            else:
                self.flaskThread = StartFlaskDaemon()
                self.flaskThread.daemon = True
                self.flaskThread.start() 
                if (self.flaskThread.isAlive()):
                    print("flask is running correctly")      
                    
                    webbrowser.open(url, new=2)
                else:
                    if self.locale == "cs":
                        QMessageBox.information(None, "Error", "Flask server pravděpodobně neběží!")  
                    else:
                        QMessageBox.information(None, "Error", "Flask server is probably not running correctly!")  

        except:
            print ("##### flask server is starting #####")   
            self.flaskThread = StartFlaskDaemon()
            self.flaskThread.daemon = True
            self.flaskThread.start() 
            if (self.flaskThread.isAlive()):
                print("flask is running correctly")                 
                webbrowser.open(url, new=2)
            else:
                if self.locale == "cs":
                    QMessageBox.information(None, "Error", "Flask server pravděpodobně neběží!") 
                else:
                    QMessageBox.information(None, "Error", "Flask server is probably not running correctly!") 
    def download_url(self, url, save_path, chunk_size=128):
        r = requests.get(url, stream=True)
        with open(save_path, 'wb') as fd:
            for chunk in r.iter_content(chunk_size=chunk_size):
                fd.write(chunk)
    def copytree(self, src, dst, symlinks=False, ignore=None):      
        try:
            shutil.rmtree(dst)
            os.mkdir(dst)
        except:
            if self.locale == "cs":
                QMessageBox.information(None, "Error", "Plugin nebyl aktualizován!") 
            else:
                QMessageBox.information(None, "Error", "Plugin was not updated!") 
            return
        for item in os.listdir(src):
            
            s = os.path.join(src, item)
            d = os.path.join(dst, item)
            if os.path.isdir(s):      
                shutil.copytree(s, d, symlinks, ignore)
            else:
                shutil.copy2(s, d)
    def updatePlugin(self):
        url = "https://gitlab.com/Vrobel/layman_qgis/-/archive/master/layman_qgis-master.zip" 
        save_path = tempfile.gettempdir() + os.sep + "layman.zip"
        self.download_url(url, save_path)

        with ZipFile(save_path, 'r') as zipObj:
           # Extract all the contents of zip file in different directory
           zipObj.extractall(tempfile.gettempdir())
        src = tempfile.gettempdir() + os.sep + "layman_qgis-master"                  
       
        self.copytree(src, self.plugin_dir)
        self.dlg.close()
        self.disableEnvironment()
        QMessageBox.information(None, "Layman", "Layman plugin was updated. Please restart QGIS.")
        
    def checkVersion(self):    
        r = requests.get("https://gitlab.com/Vrobel/layman_qgis/-/raw/master/metadata.txt?inline=false") 
       
        buf = io.StringIO(r.text)
        config = configparser.ConfigParser()
        config.read_file(buf)
        version = config.get('general', 'version')
        installedVersion = self.getVersion()
       
        if installedVersion == version:
            return [True, version]
        else:
            return [False, version]
    def saveIni(self):
        file =  os.getenv("HOME") + os.sep + ".layman" + os.sep + 'layman_user.INI'  
        dir = os.getenv("HOME") + os.sep + ".layman"
        if not (os.path.isdir(dir)):
            try:  
                os.mkdir(dir)
            except OSError:  
                print ("vytváření adresáře selhalo")
        config = configparser.ConfigParser()

        config['DEFAULT']['login'] = self.Agrimail
        config['DEFAULT']['id'] = self.client_id
        print("server liferay" + self.liferayServer)
        config['DEFAULT']['server'] = self.liferayServer
        config['DEFAULT']['layman'] = self.URI
        

        with open(file, 'w') as configfile:
            config.write(configfile)        
    def loadIni(self):
        file =  os.getenv("HOME") + os.sep + ".layman" + os.sep +'layman_user.INI'        
        config = configparser.ConfigParser()
        config.read(file)
        return config   

    def layerChanged(self):  
        
      
        if (iface.activeLayer() != None and isinstance(iface.activeLayer(), QgsVectorLayer)):
            self.menu_saveLocalFile.setEnabled(True)
        else:
            self.menu_saveLocalFile.setEnabled(False)
        try:
            layer = iface.activeLayer()
            self.layerOldName = layer.name()        
            self.focusedLayer = layer
        except:
            print("group is selected")
        
     
    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING Atlas"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = AtlasDockWidget()

            
            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)     
            
            self.dockwidget.pushButton.clicked.connect(self.sendLayer)   
            self.dockwidget.pushButton_2.clicked.connect(self.loadLocalFile) 
            self.dockwidget.pushButton_3.clicked.connect(self.saveLocalFile)
            self.dockwidget.pushButton_getLayers.clicked.connect(self.run_getLayer)            
            self.dlgGetLayers.pushButtonxx.clicked.connect(lambda: print(self.dlgGetLayers.items.currentItem().text()))          
            
            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.TopDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
       

class StartFlaskDaemon(threading.Thread):    
    def run(self):
        from subprocess import Popen, PIPE
        import platform
        import sys
        import subprocess
        import time
        from pathlib import Path
        d= os.path.dirname(Path(__file__).absolute()) + os.sep+"flask_listener" + os.sep + "flask_listener.py" 
        global process
        if platform.system() == 'Windows':
            try:
                process = subprocess.call(["python", d],stdout=subprocess.PIPE, stderr=subprocess.PIPE, timeout=600, shell=True)
            except:
                #process.kill()
                print("killed")
        else:
            
            process = subprocess.Popen(["python " + d],stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
                        
               

        stdout, stderr = process.communicate()
        print (stdout, stderr)
        
    
   