# -*- coding: utf-8 -*-
"""
/***************************************************************************
 layerNameReplacer
                                 A QGIS plugin
 NameReplace
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-29
        git sha              : $Format:%H$
        copyright            : (C) 2025 by panyoricomeha
        email                : panyoricomeha
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import QgsProject
from qgis.PyQt.QtWidgets import QAction, QInputDialog, QFileDialog, QMessageBox
from qgis.utils import iface
import re
import os

class layerNameReplace:
    def __init__(self, iface):
        self.iface = iface
        self.action_custom = None
        self.action_file = None

    def initGui(self):
        # ① Rename using user input
        self.action_custom = QAction("Replace layer name manually", self.iface.mainWindow())
        self.action_custom.triggered.connect(self.rename_with_input)
        self.iface.addPluginToMenu("Layer Name Replacer", self.action_custom)

        # ② Rename using file
        self.action_file = QAction("Replace using rule file", self.iface.mainWindow())
        self.action_file.triggered.connect(self.rename_with_file)
        self.iface.addPluginToMenu("Layer Name Replacer", self.action_file)

    # Remove plugin from menu when disabled
    def unload(self):
        self.iface.removePluginMenu("Layer Name Replacer", self.action_custom)
        self.iface.removePluginMenu("Layer Name Replacer", self.action_file)

    # ① Replace by user input
    def rename_with_input(self):
        old_text, ok1 = QInputDialog.getText(iface.mainWindow(), "Target String", "Enter the string to replace:")
        if not ok1 or not old_text:
            return

        new_text, ok2 = QInputDialog.getText(iface.mainWindow(), "Replacement String", "Enter the replacement string:")
        if not ok2:
            return

        renamedCount = 0
        for layer in QgsProject.instance().mapLayers().values():
            if old_text in layer.name():
                new_name = layer.name().replace(old_text, new_text)
                layer.setName(new_name)
                renamedCount += 1

        QMessageBox.information(iface.mainWindow(), "Completed", f"Renamed {renamedCount} layer(s).")

    # ② Replace by file
    def rename_with_file(self):
        # Ask the user to select the replacement rule file
        file_path, _ = QFileDialog.getOpenFileName(self.iface.mainWindow(), "Select Replacement Rule File", "", "Text Files (*.txt);;All Files (*)")
        
        if not file_path:
            QMessageBox.warning(self.iface.mainWindow(), "Error", "No file was selected.")
            return
        
        if not os.path.exists(file_path):
            QMessageBox.warning(self.iface.mainWindow(), "Error", f"Dictionary file not found: {file_path}")
            return

        # Load dictionary from file
        replace_dict = {}
        with open(file_path, "r", encoding="utf-8") as f:
            for line in f:
                line = line.strip()
                if not line or "," not in line:
                    continue
                old, new = line.split(",", 1)
                replace_dict[old] = new

        # Confirm before execution
        reply = QMessageBox.question(self.iface.mainWindow(), "Confirmation", "Do you want to proceed with the replacement?", QMessageBox.Yes | QMessageBox.No)
        if reply == QMessageBox.No:
            return

        renamedCount = 0
        for layer in QgsProject.instance().mapLayers().values():
            new_name = layer.name()
            for old, new in replace_dict.items():
                new_name = new_name.replace(old, new)

            if new_name != layer.name():
                layer.setName(new_name)
                renamedCount += 1

        QMessageBox.information(self.iface.mainWindow(), "Completed", f"Renamed {renamedCount} layer(s).")
