import os
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import Qt
from .lat_long_dock import LatLongDock

class LatLongDigitizer:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.actions = []
        self.toolbar = None
        self.dock = None 
        self.action = None

    def initGui(self):
        self.toolbar = self.iface.addToolBar("Lat/Long Digitizer")
        self.toolbar.setObjectName("LatLongDigitizerToolbar")
        
        self.dock = LatLongDock(self.iface, self.iface.mainWindow())
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dock)
        self.dock.setVisible(False)

        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        self.action = QAction(QIcon(icon_path), 
                              "Show/Hide Lat/Long Digitizer Panel", 
                              self.iface.mainWindow())
        self.action.setCheckable(True)
        self.action.triggered.connect(self.run)
        
        self.toolbar.addAction(self.action)
        self.actions.append(self.action)

    def unload(self):
        for action in self.actions:
            self.iface.removeToolBarIcon(action)
        if self.toolbar:
            del self.toolbar
        if self.dock:
            self.iface.removeDockWidget(self.dock)
            del self.dock

    def run(self):
        if self.action.isChecked():
            self.dock.setVisible(True)
        else:
            self.dock.setVisible(False)