"""
/***************************************************************************
                                 A QGIS plugin
 This plugin allows you to easily import data from a land survey (GPS or
 total station) to draw automatically in a database using a codification
 (aka Field Codes).
                             -------------------
        begin                : 2018-04-05
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Loïc Bartoletti (Oslandia)
        email                : loic.bartoletti@oslandia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__date__ = "2018-04-05"
__copyright__ = "(C) 2018 by Loïc Bartoletti"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

import os

from qgis.core import QgsProcessingProvider  # pylint: disable=import-error
from PyQt5.QtGui import QIcon

# pylint: disable=relative-beyond-top-level
from .processing.codification.land_survey_algorithm import landsurveyAlgorithm
from .processing.export.land_survey_qlsc2csv import landsurveyQLSC2CSV
from .processing.export.land_survey_qlsc2pdf import landsurveyQLSC2PDF
from .processing.import_.trimble.land_survey_jxl2csv import landsurveyJXL2CSV


class landsurveyProvider(QgsProcessingProvider):
    """
    QGIS Provider adding all Land Survey Providers
    """

    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass  # pylint: disable=unnecessary-pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(landsurveyAlgorithm())
        self.addAlgorithm(landsurveyQLSC2PDF())
        self.addAlgorithm(landsurveyQLSC2CSV())
        self.addAlgorithm(landsurveyJXL2CSV())

    # pylint: disable=no-self-use
    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return "landsurvey"

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr("Land survey")

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()

    def icon(self):
        """Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(os.path.dirname(__file__),
                                  "resources", "images", "icon.png"))
