"""
/***************************************************************************
 LabelLayer
                                 A QGIS plugin
 Creates a shapefile with user-defined label settings ready to use.
                              -------------------
        begin                : 2012-01-23
        copyright            : (C) 2012 by Vka
        email                : -
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
import shutil
import os
# Import the code for the dialog
from labellayerdialog import LabelLayerDialog

class LabelLayer:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface
		
		self.plugin_path = os.path.abspath(__file__)
		self.plugin_dir = os.path.dirname(self.plugin_path)

	def initGui(self):
		# Create action that will start plugin configuration
		self.action = QAction(QIcon(self.plugin_dir+"/icon.png"), \
			"Create labeled layer", self.iface.mainWindow())
		# connect the action to the run method
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)

		# Add toolbar button and menu item
		self.iface.addToolBarIcon(self.action)
		self.iface.addPluginToMenu("&Create labeled layer", self.action)

	def unload(self):
		# Remove the plugin menu item and icon
		self.iface.removePluginMenu("&Create labeled layer",self.action)
		self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
	def run(self):
		
		self.savelayerPath = ""
	
		# create and show the dialog
		self.dlg = LabelLayerDialog()	
		
		QObject.connect(self.dlg.ui.outputButton, SIGNAL('clicked()'), self.createLayerPath)
		QObject.connect(self.dlg.ui.createButton, SIGNAL('clicked()'), self.createLayer)
		QObject.connect(self.dlg.ui.closeButton, SIGNAL('clicked()'), self.close)
		
		QObject.connect(self.dlg.ui.indBox, SIGNAL('stateChanged(int)'), self.changeState)
	
		# show the dialog
		self.dlg.show()

	def createLayerPath(self):
		self.dlg.ui.output.clear()
		self.savelayerPath = QFileDialog.getSaveFileName(None,QString.fromLocal8Bit("Create output shapefile:"), "", "*.shp")
		if self.savelayerPath is None:
			return
		self.dlg.ui.output.setText(self.savelayerPath)	
	
	def createLayer(self):
		if self.savelayerPath == "" or self.savelayerPath.isNull():
			QMessageBox.critical(None, "Error", "No output location!")
			return
		
		crs = self.iface.mapCanvas().mapRenderer().destinationSrs()
		
		if self.dlg.ui.indBox.isChecked():
			fields = {
			0 : QgsField("Text", QVariant.String, "text", 100),
			1 : QgsField("Size", QVariant.Int, "int", 4),
			2 : QgsField("Color", QVariant.String, "text",10),	
			3 : QgsField("Bold", QVariant.Int, "int",2),
			4 : QgsField("Italic", QVariant.Int, "int",2),
			5 : QgsField("Underline", QVariant.Int, "int",2),
			6 : QgsField("Strikeout", QVariant.Int, "int",2),
			7 : QgsField("Font", QVariant.String, "text", 50),
			8 : QgsField("X", QVariant.Double, "double", 15,3),
			9 : QgsField("Y", QVariant.Double, "double",15,3),
			10 : QgsField("Rotation", QVariant.Double, "double", 8, 3)}
		
			writer = QgsVectorFileWriter(unicode(self.savelayerPath, "Latin-1"), "utf-8", fields, QGis.WKBPoint, crs)
			
			del writer
		
			file_info = QFileInfo(self.savelayerPath)
			layer_name = unicode(file_info.completeBaseName(), "Latin-1")
			layer_dir = unicode(file_info.absolutePath(), "Latin-1")
			label_layer = QgsVectorLayer(self.savelayerPath, layer_name, "ogr" )
		

			try:
				shutil.copy(self.plugin_dir+"/editForm.ui", layer_dir)
				os.rename(layer_dir+"/editForm.ui", layer_dir +"/"+layer_name+".ui")
			except OSError:
				pass
		
			label_layer.setCustomProperty("labeling","pal")
			label_layer.setCustomProperty("labeling/enabled","true")
			label_layer.setCustomProperty("labeling/fieldName","Text")
			if self.dlg.ui.unitsBox.isChecked():
				label_layer.setCustomProperty("labeling/fontSizeInMapUnits","true")
			label_layer.setCustomProperty("labeling/dataDefinedProperty0",1)
			label_layer.setCustomProperty("labeling/dataDefinedProperty1",3)
			label_layer.setCustomProperty("labeling/dataDefinedProperty2",4)
			label_layer.setCustomProperty("labeling/dataDefinedProperty3",5)
			label_layer.setCustomProperty("labeling/dataDefinedProperty4",2)
			label_layer.setCustomProperty("labeling/dataDefinedProperty5",6)
			label_layer.setCustomProperty("labeling/dataDefinedProperty6",7)		
			label_layer.setCustomProperty("labeling/dataDefinedProperty9",8)
			label_layer.setCustomProperty("labeling/dataDefinedProperty10",9)
			label_layer.setCustomProperty("labeling/dataDefinedProperty14",10)
			label_layer.setEditForm(layer_dir+"/"+layer_name+".ui")
			QgsMapLayerRegistry.instance().addMapLayer(label_layer)
			self.close()
	
		else:
			fields = {
			0 : QgsField("Text", QVariant.String, "text", 100),
			1 : QgsField("X", QVariant.Double, "double", 15,3),
			2 : QgsField("Y", QVariant.Double, "double",15,3),
			3 : QgsField("Rotation", QVariant.Double, "double", 8, 3)}

			writer = QgsVectorFileWriter(unicode(self.savelayerPath, "Latin-1"), "utf-8", fields, QGis.WKBPoint, crs)

			del writer

			file_info = QFileInfo(self.savelayerPath)
			layer_name = unicode(file_info.completeBaseName(), "Latin-1")
			layer_dir = unicode(file_info.absolutePath(), "Latin-1")
			label_layer = QgsVectorLayer(self.savelayerPath, layer_name, "ogr")
		

			try:
				shutil.copy(self.plugin_dir+"/editForm_dis.ui", layer_dir)
				os.rename(layer_dir+"/editForm_dis.ui", layer_dir+"/"+layer_name+".ui")
			except OSError:
				pass
		
			label_layer.setCustomProperty("labeling","pal")
			label_layer.setCustomProperty("labeling/enabled","true")
			label_layer.setCustomProperty("labeling/fieldName","Text")		
			label_layer.setCustomProperty("labeling/dataDefinedProperty9",1)
			label_layer.setCustomProperty("labeling/dataDefinedProperty10",2)
			label_layer.setCustomProperty("labeling/dataDefinedProperty14",3)
			label_layer.setEditForm(layer_dir+"/"+layer_name+".ui")
			QgsMapLayerRegistry.instance().addMapLayer(label_layer)
			self.close()			
			
	def changeState(self, status):
		if status == 0:
			self.dlg.ui.unitsBox.setEnabled(False)
			self.dlg.ui.unitsBox.setCheckState(0)
		else:
			self.dlg.ui.unitsBox.setEnabled(True)
		
	def close(self):
		self.dlg.close()