# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Label2Attr
                                 A QGIS plugin
 Assign a label to an other layer's attribute
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-12-21
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Zoltan Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path

from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QMessageBox

from qgis.core import QgsProject

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .label2attr_dialog import Label2AttrDialog
from .label2attr_maptool import Label2AttrMapTool

class Label2Attr:
    """Label to attribute plugin implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Label2Attr_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = Label2AttrDialog(self)
        self.dlg.setModal(True)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Label2Attr')
        self.toolbar = self.iface.addToolBar(u'Label2Attr')
        self.toolbar.setObjectName(u'Label2Attr')
        # initialize variables
        self.labelLayer = None
        self.labelColumn = None
        self.targetLayer = None
        self.targetColumn = None
        self. tolerance = 1
        self.clickTool = Label2AttrMapTool(self)

    @staticmethod
    def tr(message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Label2Attr', message)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # config dialog
        icon = QIcon(':/plugins/label2attr/icon.png')
        action = QAction(icon, self.tr(u'Label to Attribute Settings'),
                         self.iface.mainWindow())
        action.triggered.connect(self.run)
        action.setEnabled(True)
        self.actions.append(action)
        self.toolbar.addAction(action)
        self.iface.addPluginToVectorMenu(self.menu, action)

        # map tool button
        icon1 = QIcon(':/plugins/label2attr/icon1.png')
        action1 = QAction(icon1, self.tr(u'Label to Attribute'),
                          self.iface.mainWindow())
        action1.setCheckable(True)
        action1.setEnabled(True)
        action1.triggered.connect(self.assign)
        self.clickTool.setAction(action1)
        self.toolbar.addAction(action1)
        self.actions.append(action1)

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(self.tr(u'&Label2Attr'), action)
            self.iface.removeToolBarIcon(action)
        # Unset the map tool in case it's set
        #self.canvas.unsetMapTool(self.clickTool)

        # remove the toolbar
        del self.toolbar

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # store parameters
            proj = QgsProject.instance()
            self.labelLayer = self.dlg.LabelLayerCombo.currentText()
            if proj.readEntry("Label2Attr", "labelLayer", None) != self.labelLayer:
                proj.writeEntry("Label2Attr", "labelLayer", self.labelLayer)
                proj.setDirty(True)
            self.labelColumn = self.dlg.LabelColumnCombo.currentText()
            if proj.readEntry("Label2Attr", "labelColumn", None) != self.labelColumn:
                proj.writeEntry("Label2Attr", "labelColumn", self.labelColumn)
                proj.setDirty(True)
            self. tolerance = float(self.dlg.ToleranceEdit.text())
            if proj.readEntry("Label2Attr", "tolerance", None) != self.tolerance:
                proj.writeEntry("Label2Attr", "tolerance", self.tolerance)
                proj.setDirty(True)
            self.targetLayer = self.dlg.TargetLayerCombo.currentText()
            if proj.readEntry("Label2Attr", "targetLayer", None) != self.targetLayer:
                proj.writeEntry("Label2Attr", "targetLayer", self.targetLayer)
                proj.setDirty(True)
            self.targetColumn = self.dlg.TargetColumnCombo.currentText()
            if proj.readEntry("Label2Attr", "targetColumn", None) != self.targetColumn:
                proj.writeEntry("Label2Attr", "targetColumn", self.targetColumn)
                proj.setDirty(True)

    def assign(self):
        """ set maptool active """
        if not self.labelLayer or not self.labelColumn or \
           not self.targetLayer or not self.targetColumn or \
           not QgsProject.instance().mapLayersByName(self.labelLayer) or \
           not QgsProject.instance().mapLayersByName(self.targetLayer):
            QMessageBox.warning(self.iface.mainWindow(),
                                self.tr("Warning"), 
                                self.tr("Please set config parameters!"))
            return
        self.canvas.setMapTool(self.clickTool)
