# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Label2AttrDialog
                                 A QGIS plugin
 Assign a label to an other layer's attribute
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-12-21
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Zoltan Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets
from qgis.core import QgsMapLayerProxyModel, QgsProject

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'label2attr_dialog_base.ui'))


class Label2AttrDialog(QtWidgets.QDialog, FORM_CLASS):
    """ dialog to set up parameter """
    def __init__(self, plugin, parent=None):
        super(Label2AttrDialog, self).__init__(parent)
        self.plugin = plugin
        # Set up the user interface from Designer.
        self.setupUi(self)
        self.cancelBtn.clicked.connect(self.reject)
        self.okBtn.clicked.connect(self.ok)
        self.LabelLayerCombo.currentIndexChanged.connect(self.setPCols)
        self.TargetLayerCombo.currentIndexChanged.connect(self.setTCols)

    def invisibleLayers(self):
        """ returns list of invisible layers """
        return list(set(QgsProject.instance().mapLayers().values()) -
                   set((self.plugin.canvas.layers())))

    def showEvent(self, event):
        """ initialize dialog widgets """

        # filter point layers
        self.LabelLayerCombo.setFilters(QgsMapLayerProxyModel.PointLayer)
        self.LabelLayerCombo.setExceptedLayerList(self.invisibleLayers())
        # set defaults from project variables
        proj = QgsProject.instance()
        self.plugin.labelLayer = proj.readEntry("Label2Attr", "labelLayer", None)[0]
        index = self.LabelLayerCombo.findText(self.plugin.labelLayer)
        self.LabelLayerCombo.setCurrentIndex(index)
        self.plugin.labelColumn = proj.readEntry("Label2Attr", "labelColumn", None)[0]
        index = self.LabelColumnCombo.findText(self.plugin.labelColumn)
        self.LabelColumnCombo.setCurrentIndex(index)
        self.TargetLayerCombo.setFilters(QgsMapLayerProxyModel.HasGeometry)
        self.TargetLayerCombo.setExceptedLayerList(self.invisibleLayers())
        self.plugin.targetLayer = proj.readEntry("Label2Attr", "targetLayer", None)[0]
        index = self.TargetLayerCombo.findText(self.plugin.targetLayer)
        self.TargetLayerCombo.setCurrentIndex(index)
        self.plugin.targetColumn = proj.readEntry("Label2Attr", "targetColumn", None)[0]
        index = self.TargetColumnCombo.findText(self.plugin.targetColumn)
        self.TargetColumnCombo.setCurrentIndex(index)
        self.plugin.tolerance = proj.readNumEntry("Label2Attr", "tolerance", 1)[0]
        self.ToleranceEdit.setText(str(self.plugin.tolerance))

    def setPCols(self):
        """ set point attribute list if layer changed """
        l = self.LabelLayerCombo.currentLayer()
        try:
            self.LabelColumnCombo.setLayer(l)
        except:
            pass

    def setTCols(self):
        """set point attribute list if layer changed """
        l = self.TargetLayerCombo.currentLayer()
        try:
            self.TargetColumnCombo.setLayer(l)
        except:
            pass

    def ok(self):
        """ check widgets """
        if not self.LabelLayerCombo.currentText():
            QtWidgets.QMessageBox.warning(self, self.plugin.tr("Warning"),
                self.plugin.tr("Point label layer not given"))
            return

        if not self.LabelColumnCombo.currentText():
            QtWidgets.QMessageBox.warning(self, self.plugin.tr("Warning"),
                self.plugin.tr("Label column not given"))
            return

        try:
            t = float(self.ToleranceEdit.text())
        except ValueError:
            QtWidgets.QMessageBox.warning(self, self.plugin.tr("Warning"),
                self.plugin.tr("Invalid tolerance value"))
            return

        if not self.TargetLayerCombo.currentText():
            QtWidgets.QMessageBox.warning(self, self.plugin.tr("Warning"),
                self.plugin.tr("Target layer not given"))
            return

        if not self.TargetColumnCombo.currentText():
            QtWidgets.QMessageBox.warning(self, self.plugin.tr("Warning"),
                self.plugin.tr("Target column not given"))
            return

        self.accept()
