"""
***************************************************************************
    lastools_plugin.py
    ---------------------
    Date                 : November 2023
    Copyright            : (C) 2023 by rapidlasso GmbH
    Email                : info near rapidlasso point de
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = "rapidlasso"
__date__ = "September 2023"
__copyright__ = "(C) 2023, rapidlasso GmbH"

import inspect
import os
import sys

from qgis.core import (
    Qgis,
    QgsApplication,
)

from .lastools_provider import LAStoolsProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class LAStoolsPlugin(object):

    def __init__(self, iface):
        self.provider = None

    def initProcessing(self):
        self.provider = LAStoolsProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
