DO $$
BEGIN
  CREATE ROLE qgis_admin_MUNICIPALITYCODE WITH
  NOLOGIN
  NOSUPERUSER
  INHERIT
  NOCREATEDB
  NOCREATEROLE
  NOREPLICATION;
  EXCEPTION WHEN DUPLICATE_OBJECT THEN
  RAISE NOTICE 'not creating role qgis_admin_MUNICIPALITYCODE -- it already exists';
END
$$;

DO $$
BEGIN
  CREATE ROLE qgis_editor_MUNICIPALITYCODE WITH
  NOLOGIN
  NOSUPERUSER
  INHERIT
  NOCREATEDB
  NOCREATEROLE
  NOREPLICATION
  ADMIN qgis_admin_MUNICIPALITYCODE;
  EXCEPTION WHEN DUPLICATE_OBJECT THEN
  RAISE NOTICE 'not creating role qgis_editor_MUNICIPALITYCODE -- it already exists';
END
$$;

DO $$
BEGIN
  CREATE ROLE qgis_viewer_MUNICIPALITYCODE WITH
  NOLOGIN
  NOSUPERUSER
  INHERIT
  NOCREATEDB
  NOCREATEROLE
  NOREPLICATION
  ADMIN qgis_admin_MUNICIPALITYCODE;
  EXCEPTION WHEN DUPLICATE_OBJECT THEN
  RAISE NOTICE 'not creating role qgis_editor_MUNICIPALITYCODE -- it already exists';
END
$$;

DO $$
BEGIN
  EXECUTE format('grant connect on database %I to %I', current_database(), 'qgis_admin_MUNICIPALITYCODE');
  EXECUTE format('grant connect on database %I to %I', current_database(), 'qgis_editor_MUNICIPALITYCODE');
  EXECUTE format('grant connect on database %I to %I', current_database(), 'qgis_viewer_MUNICIPALITYCODE');
END;
$$;

GRANT USAGE ON SCHEMA public TO qgis_admin_MUNICIPALITYCODE;
GRANT USAGE ON SCHEMA public TO qgis_editor_MUNICIPALITYCODE;
GRANT USAGE ON SCHEMA public TO qgis_viewer_MUNICIPALITYCODE;

GRANT SELECT, UPDATE ON TABLE public.qgis_projects TO qgis_admin_MUNICIPALITYCODE;
GRANT SELECT ON TABLE public.spatial_ref_sys TO qgis_admin_MUNICIPALITYCODE;

GRANT SELECT, UPDATE ON TABLE public.qgis_projects TO qgis_editor_MUNICIPALITYCODE;
GRANT SELECT ON TABLE public.spatial_ref_sys TO qgis_editor_MUNICIPALITYCODE;

GRANT SELECT ON TABLE public.qgis_projects TO qgis_editor_MUNICIPALITYCODE;
GRANT SELECT ON TABLE public.spatial_ref_sys TO qgis_editor_MUNICIPALITYCODE;

GRANT USAGE ON SCHEMA code_lists TO qgis_admin_MUNICIPALITYCODE;
GRANT USAGE ON SCHEMA code_lists TO qgis_editor_MUNICIPALITYCODE;
GRANT USAGE ON SCHEMA code_lists TO qgis_viewer_MUNICIPALITYCODE;

GRANT SELECT ON ALL TABLES IN SCHEMA code_lists TO qgis_admin_MUNICIPALITYCODE;
GRANT SELECT ON ALL TABLES IN SCHEMA code_lists TO qgis_editor_MUNICIPALITYCODE;
GRANT SELECT ON ALL TABLES IN SCHEMA code_lists TO qgis_viewer_MUNICIPALITYCODE;

GRANT USAGE ON SCHEMA SCHEMANAME TO qgis_admin_MUNICIPALITYCODE;
GRANT USAGE ON SCHEMA SCHEMANAME TO qgis_editor_MUNICIPALITYCODE;
GRANT USAGE ON SCHEMA SCHEMANAME TO qgis_viewer_MUNICIPALITYCODE;

ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT INSERT, SELECT, UPDATE, DELETE ON TABLES TO qgis_admin_MUNICIPALITYCODE;
ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT INSERT, SELECT, UPDATE, DELETE ON TABLES TO qgis_editor_MUNICIPALITYCODE;
ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT SELECT ON TABLES TO qgis_editor_MUNICIPALITYCODE;

ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT ALL ON SEQUENCES TO qgis_admin_MUNICIPALITYCODE;
ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT USAGE, SELECT ON SEQUENCES TO qgis_editor_MUNICIPALITYCODE;

ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT EXECUTE ON FUNCTIONS TO qgis_admin_MUNICIPALITYCODE;
ALTER DEFAULT PRIVILEGES IN SCHEMA SCHEMANAME
  GRANT EXECUTE ON FUNCTIONS TO qgis_editor_MUNICIPALITYCODE;