# -*- coding: utf-8 -*-
"""
/***************************************************************************
 JapanGSIPointCollector
                                 A QGIS plugin
 This plugin collects points from gsi website
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-04-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by GPSS
        email                : joshi.nirmalraj@gpss.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.gui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .JapanGSIPointCollector_dialog import JapanGSIPointCollectorDialog
import os.path
from qgis.core import QgsVectorLayer, QgsFeature, QgsGeometry, QgsProject, QgsCoordinateReferenceSystem
from PyQt5.QtCore import Qt
from .DrawRect import RectangleMapTool


#------------required fucntion


from math import cos, sin, asin, sqrt, radians
import numpy as np
import urllib.request, urllib.error, urllib.parse
import json
import time
print("Calculaiton started")

# function for calculating distance in lat long.
# not used in the actual code
def calc_distance(lat1, lon1, lat2, lon2):
    """
    Calculate the great circle distance between two points
    on the earth (specified in decimal degrees)
    https://gis.stackexchange.com/questions/61924/python-gdal-degrees-to-meters-without-reprojecting
    """
    # convert decimal degrees to radians
    lon1, lat1, lon2, lat2 = map(radians, [lon1, lat1, lon2, lat2])
    # haversine formula
    dlon = lon2 - lon1
    dlat = lat2 - lat1
    a = sin(dlat / 2) ** 2 + cos(lat1) * cos(lat2) * sin(dlon / 2) ** 2
    c = 2 * asin(sqrt(a))
    distance = 6371 * c*1000
    return distance
# function for elevation
#get elevation data
def get_elevation(lat,lon):
    URL = "http://cyberjapandata2.gsi.go.jp/general/dem/scripts/getelevation.php?lon=" + str(lon) + "&lat=" + str(lat) +"&outtype=JSON"
    data_all = urllib.request.urlopen(URL)
    data = json.loads(data_all.read())
    elevationall = data['elevation']
    # elevationtext = data[u'hsrc']
    return(elevationall)
def initiatePointCollection(filepath, x1y1x2y2, resolution):
    # x1y1x2y2=140.6861287665296345 35.69834753864618904, 140.68694413122099718 35.69948716941077294
    x1y1x2y2 = [part.strip() for part in x1y1x2y2.replace(',', ' ').split()]
    
    boundingBoxXmin=float(x1y1x2y2[0])
    boundingBoxXmax=float(x1y1x2y2[2])

    boundingBoxYmin=float(x1y1x2y2[1])
    boundingBoxYmax=float(x1y1x2y2[3])
    dX=calc_distance(boundingBoxXmin, boundingBoxYmin, boundingBoxXmax, boundingBoxYmin)
    dY=calc_distance(boundingBoxXmin, boundingBoxYmin, boundingBoxXmin, boundingBoxYmax)
    print("dX="+str( dX)+ " m")
    print("dY="+str( dY)+ " m")


    # d=.0001 # equivalent to 10m
    interval=float(resolution) #m
    
    nx=int(dX/interval) # interval
    ny=int(dY/interval) # interval
    print("total points="+str(nx*ny)+"  nx="+str(nx)+"  ny="+str(ny))
    print("Fetching data...")

    x=np.linspace(boundingBoxXmin,boundingBoxXmax,nx)
    y=np.linspace(boundingBoxYmin,boundingBoxYmax,ny)
    z= np.empty((nx, ny), float)
    print("-------------")
    print(filepath)
    f=open(filepath,"w")
    f.write("x longitude,y latitude,z elevation in m"+"\n")
    cnt=0
    for ix in x:
        print("working at nx="+str(cnt)+":"+str(ix))
        cnt=cnt+1
        for iy in y:
            try:
                z=get_elevation(iy,ix) 
            except:
                #error occured, mainly due to timeout
                # so wait a bit longer second and try again
                
                print("Error occured. Waiting few seconds..")
                time.sleep(10) #seconds
                print("Resuming..")
                z=get_elevation(iy,ix)   #retry    
            f.write(str(ix)+","+str(iy)+","+str(z)+"\n")
        time.sleep(1) # rest few second, for server may stop giving access
    f.close()
    print("See output data at "+ filepath)

#------------end of required fucntion



class JapanGSIPointCollector:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.x1y1x2y2=False # to be used to store coordinates
        self.filepath=False
        self.resolution='15' #meters
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'JapanGSIPointCollector_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Japan GSI Point Collector')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('JapanGSIPointCollector', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/JapanGSIPointCollector/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Japan GSI point collector'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Japan GSI Point Collector'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = JapanGSIPointCollectorDialog()
            self.dlg.tePointResolution.setPlainText(self.resolution)
            self.dlg.teCoordinates.setPlainText('')


        # show the dialog
        self.dlg.setWindowFlags(Qt.WindowStaysOnTopHint)
        self.dlg.show()

        #on click
        self.dlg.pbSelectWindow.clicked.connect(self.initiateSelectionWindow)
        # Run the dialog event loop
        self.dlg.pbOk.clicked.connect(self.crossCheckAndInitialRun)
        # See if OK was pressed

 
    def initiateSelectionWindow(self):
        self.iface.messageBar().pushMessage("Note", "Drag and select window.",  duration=5)     
        self.rect = RectangleMapTool(self.canvas, self.dlg)
        self.iface.mapCanvas().setMapTool(self.rect)

        #use the xy coordinates to 
        self.x1y1x2y2=self.dlg.teCoordinates.toPlainText()

        print(self.x1y1x2y2)
        print("Coordinates read.")

    def crossCheckAndInitialRun(self):
        # Do something useful here - delete the line containing pass and
        # substitute with your code.

        #check if filename exits
        file_path = self.dlg.mQgsFileWidget.filePath()

        if file_path: 
            print("File path ok:"+str(file_path))
            #check if coordinate exists
            self.filepath=file_path
            self.resolution=self.dlg.tePointResolution.toPlainText()
            print("Resolution ok:"+str(self.resolution))
            self.x1y1x2y2=self.dlg.teCoordinates.toPlainText()
            if self.x1y1x2y2:
                print("Rect coord:"+self.x1y1x2y2)
                self.dlg.labelStatus.setText('Running...')
                initiatePointCollection(self.filepath, self.x1y1x2y2,self.resolution)
                self.dlg.labelStatus.setText('Complete.')
            else:
                self.iface.messageBar().pushMessage("Error:", "No coordinates",  duration=20)

        else:
            self.iface.messageBar().pushMessage("Error:", "No file path",  duration=20)       # self.dlg.teCoordinates.setText("new coordinate")

            #do nothing
