# -*- coding: utf-8 -*-
"""
/***************************************************************************
 JSONEaterDialog
                                 A QGIS plugin
 This plugin imports JSON in different structures - GeoJSON format is not required
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-08-17
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Findvej
        email                : peter@findvej.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import json
import re

from qgis.PyQt.QtCore import (
    QObject,
    QTimer,
    QPoint,
    QEvent,
    QVariant,
    Qt
)

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.gui import QgsMessageBar
from qgis.core import *
from osgeo import ogr

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'json_eater_dialog_base.ui'))


class JSONEaterDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(JSONEaterDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
#        self.pushButton.clicked.connect(self.pushButton_clicked)
        self.pushButton_eatjson.clicked.connect(self.pushButton_eatjson_clicked)
        self.bar = QgsMessageBar()
        self.mylayercount = 0
        self.file = ''
        self.coordinateSwap = 0
        self.labels = ['name','title','butik','titel','navn','label','itemlabel']
        self.lats = ['lat','latitude','bredde','breddegrad']
        self.longs = ['long','lng','longitude','længde','længdegrad','laengde','laengdegrad']
        self.latlongsets = ['ll','latlng','latlong','latlng','coord','coords','coordinate','coordinates','koor','koord','koordinat','koordinater','point','points','punkt']
        self.foundPoints = []
        self.data = False
        self.repoint = 'Point *\\( *([0-9]+(?:\\.[0-9]+)) +([0-9]+(?:\\.[0-9]+)) *\\)'

    def pushButton_clicked(self):
        self.mylayercount += 1
        title = 'JSONEater_layer_' + str(self.mylayercount)
        layer = QgsVectorLayer('Point?crs=epsg:4326&index=yes', title, 'memory')
        pr = layer.dataProvider()

        layer.startEditing()

        # add fields
        pr.addAttributes(
            [QgsField("label", QVariant.String)]
        )

        for x in range(9, 13):
            for y in range (54, 59):
                feat = QgsFeature()
                feat.setAttributes(['My point'])
                feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x, y)))
                pr.addFeatures([feat])

        layer.commitChanges()

        QgsProject.instance().addMapLayer(layer)

    def pushButton_eatjson_clicked(self):
        self.file = self.mQgsFileWidget.filePath()
        if not self.file:
            return False

        # silly code for checking radio buttons
        if self.rb_swap_nothing.isChecked():
            self.coordinateSwap = 0
        if self.rb_swap_western.isChecked():
            self.coordinateSwap = 1
        if self.rb_swap_eastern.isChecked():
            self.coordinateSwap = 2
        if self.rb_swap_flip.isChecked():
            self.coordinateSwap = 3

        result = self.beginEat()
        if result:
            self.displayResult(result)

    def displayResult(self, result):
        title = os.path.basename(self.file) + ' JSONEater'

        layer = QgsVectorLayer('Point?crs=epsg:4326&index=yes', title, 'memory')
        pr = layer.dataProvider()

        layer.startEditing()

        # add fields
        pr.addAttributes(
            [
                QgsField("label", QVariant.String),
                QgsField("note", QVariant.String),
            ]
        )

        separator = ', '
        for point in result:
            method = separator.join(point['method'])
            feat = QgsFeature()
            feat.setAttributes([point['label'],method])
            feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(point['longitude'], point['latitude'])))
            pr.addFeatures([feat])

#        if self.checkBoxDisplayLabels.isChecked():
#            label = QgsPalLayerSettings()
#            label.enabled = True
#            label.fieldName = 'label'

        layer.commitChanges()

        QgsProject.instance().addMapLayer(layer)

    def checkSwapLatLng(self, latitude, longitude):
        if self.coordinateSwap == 1 and longitude > latitude: # assume swapped if longitude is larger than latitude, e.g. lng=56,lat=12 ought to be lng=12,lat=56
            latitude, longitude = longitude, latitude
        if self.coordinateSwap == 2 and latitude > longitude:
            latitude, longitude = longitude, latitude
        if self.coordinateSwap == 3:
            latitude, longitude = longitude, latitude
        return [latitude, longitude]

    def validateJSON(self, jsonData):
        try:
            self.data = json.load(jsonData)
        except ValueError as err:
            return False
        return True

    def isScalar(self, var):
        return type(var) is int or type(var) is float or type(var) is str

    def latLngFromList(self, latLng):
        latitude = longitude = False
        if type(latLng) is list:
            if len(latLng) >= 2:
                latitude = float(latLng[0])
                longitude = float(latLng[1])
#                method.append('Coordinate pair based on list')

        elif type(latLng) is dict:
            for latstr in self.lats:
                if latstr in latLng.keys() and self.isScalar(latLng[latstr]): # missing lower()
                    latitude = latLng[latstr]
#                    method.append('Latitude based on key \'' + latstr + '\'')
            for longstr in self.longs:
                if longstr in latLng.keys() and self.isScalar(latLng[longstr]):
                    longitude = latLng[longstr]
#                    method.append('Longitude based on key \'' + longstr + '\'')

        elif type(latLng) is str:
            mySet = False
            m = re.search(self.repoint, latLng, re.IGNORECASE)
            if m:
                longitude = float(m.group(1))
                latitude = float(m.group(2))
#                method.append('Coordinate pair from WKT Point string')
            elif latLng.count(',') == 1:
                mySet = latLng.split(',')
#                method.append('Coordinate pair from comma separated string')
            elif latLng.count(';') == 1:
                mySet = latLng.split(';')
#                method.append('Coordinate pair from semicolon separated string')
            elif latLng.count(' ') == 1:
                mySet = latLng.split()
#                method.append('Coordinate pair from space separated string')

            if mySet:
                latitude = float(mySet[0])
                longitude = float(mySet[1])

        if latitude and longitude:
            return {'latitude': latitude, 'longitude': longitude}
        return False

    def guessSearch(self, data):
        label = 'Point'
        latitude = longitude = False
        method = []

        for p in data:
            if type(p) is dict or type(p) is list:
                self.guessSearch(p) # recursive
            elif type(p) is str:
                l = p.lower()
                if l in self.labels:
                    label = str(data[p])
                    method.append('Label based on key \'' + p + '\'')
                elif l in self.lats:
                    latitude = float(data[p])
                    method.append('Latitude based on key \'' + p + '\'')
                elif l in self.longs:
                    longitude = float(data[p])
                    method.append('Longitude based on key \'' + p + '\'')
                elif l in self.latlongsets:
                    coordinateset = self.latLngFromList(data[p])
                    if coordinateset:
                        latitude = coordinateset['latitude']
                        longitude = coordinateset['longitude']
                        method.append('Coordinate pair based on key \'' + p + '\'')
                elif type(data[p]) is str: # More generic guesses if we don't understand the label
                    # Check for WKT Point
                    m = re.search(self.repoint, data[p], re.IGNORECASE)
                    if m:
                        longitude = float(m.group(1))
                        latitude = float(m.group(2))
                        method.append('Coordinate pair from WKT Point string')

        if latitude and longitude:
            latitude, longitude = self.checkSwapLatLng(latitude, longitude)
            self.foundPoints.append( {'label': label, 'latitude': latitude, 'longitude': longitude, 'method': method })

        return

    def beginEat(self):
        with open(self.file, "r") as json_file:
            if not self.validateJSON(json_file):
                print("JSON is not valid!")
                return False

            # Let's begin the guesswork
            if type(self.data) is dict or type(self.data) is list:
                self.guessSearch(self.data)
            foundPoints = self.foundPoints
            self.foundPoints = []
            return foundPoints
