#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IdentifProj

 This QGIS plugin is an easy way to guess which map projection has been used for a location.
 
 The plugin has 3 use cases :
 - type projected coordinates and get all thez possible points all over the world
 - click on a location on the map and find all the possible projected coordinates
 - draw a bbox and find all the projected bboxes
 
 IMPORTANT: at the first start, the plugin will build its CRS database from Qgis CRS list. 
 It can last au couple of minutes but it will only happen one time.
 This plugin has been initially developed during a third year engineering project at ENSG (https://www.ensg.eu)
 
 Licence : open licence 2.0
 
 (C) 2024 by Leonie leroux, Jacques Beilin
 leonie.leroux@ensg.eu, jacques.beilin@ensg.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import shutil
import re


def removeRes():
    fileUI = os.path.join(os.path.dirname(__file__), 'IdentifProj_dockwidget_base.ui')
    with open(fileUI, 'rt') as f:
        L = f.readlines()
        s = ""
        resourceLineFound = False
        resources = ["<resources>", '<include location="resources.qrc"/>', '</resources>']
        for l in L:
            resourceLineFoundLocal = False
            for res in resources:
                if re.search(res, l):
                    resourceLineFoundLocal = True
                    resourceLineFound = True
                    
            if resourceLineFoundLocal == False:
                s += l
                    
                
    print("resourceLineFound :", resourceLineFound)
    if resourceLineFound == True:
        shutil.copy(fileUI, fileUI + '.old')
        with open(fileUI, 'wt') as f:
            f.write(s)
            
# removeRes()