# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IdentifProj
                                 A QGIS plugin
 IdentifProj
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-12-12
        git sha              : $Format:%H$
        copyright            : (C) 2024 by leonie leroux, Jacques Beilin
        email                : leonie.leroux@ensg.eu, jacques.beilin@ensg.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json
import os

from qgis.core import QgsPoint
from qgis.core import QgsPolygon
from qgis.core import QgsLineString
from qgis.core import QgsVectorLayer
from qgis.core import QgsFeature
from qgis.core import QgsProject
from qgis.core import QgsVectorFileWriter
from qgis.core import QgsField
from PyQt5.QtCore import QVariant, QMetaType


def load_data_crs(filename):
    """

    Parameters
    ----------
    filename : str
        CRS filename.

    Returns
    -------
    data : list of dict
        CRS data

    """
    
    with open(filename, 'rt') as f:
        L = f.readlines()
        s = ""
        for l in L:
            s += l
            
    if s:
        data = json.loads(s)
        
        return data
    return None


def create_geoms(jsonCRS):
    """
    Parameters
    ----------
    jsonCRS : dictionary
        dict produced by calc_BBox.

    Returns
    -------
    PolygonWGS84 : QgsPolygon
        bbox in WGS84
    PolygonCRS : QgsPolygon
        bbox in projected coordinates
    auth_id : str
        CRS authority and id.
    name : str
        CRS name

    """
    
    auth_id = jsonCRS["auth_id"]
    name = jsonCRS["name"]
    bboxWGS84 = jsonCRS["bounding_box_WGS84"]
    bboxCRS = jsonCRS["transform_bounds"]["coordinates"][0]

    lon = [bboxWGS84["x_min"], bboxWGS84["x_max"], bboxWGS84["x_max"], bboxWGS84["x_min"], bboxWGS84["x_min"]]
    lat = [bboxWGS84["y_max"], bboxWGS84["y_max"], bboxWGS84["y_min"], bboxWGS84["y_min"], bboxWGS84["y_max"]]
    PolygonWGS84 = QgsPolygon(QgsLineString(lon, lat))
    
    P1 = QgsPoint(bboxCRS[0][0], bboxCRS[0][1])
    P2 = QgsPoint(bboxCRS[1][0], bboxCRS[1][1])
    P3 = QgsPoint(bboxCRS[2][0], bboxCRS[2][1])
    P4 = QgsPoint(bboxCRS[3][0], bboxCRS[3][1])
   
    PolygonCRS = QgsPolygon(QgsLineString([P1, P2, P3, P4, P1]))
    
    return PolygonWGS84, PolygonCRS, auth_id, name



def json2shpWGS84(fileIN, fileOUT):
    """
    
    Parameters
    ----------
    fileIN : filepath
        file path of json created by calc_BBox
    fileOUT : filepath
        shapefile file path for bboxes in WGS84

    Returns
    -------
    None.

    """
    
    data = load_data_crs(fileIN)
 
    crs = "epsg:4326"
    lyr = QgsVectorLayer('Polygon?crs=' + crs, 'CRS', "memory")
    # Prj = QgsProject.instance()  # ADD THIS LINE
    # Prj.addMapLayers([lyr])  

    lyr.startEditing()
    # Set an object for the data provider for the layer
    prv = lyr.dataProvider()
    prv.addAttributes([QgsField("auth_id",  type=QMetaType.QString, len=254), 
                       QgsField("name",  type=QMetaType.QString, len=254)]) 
    lyr.updateFields()     
    
    for jsonCRS in data:
        PolygonWGS84, PolygonCRS, auth_id, name = create_geoms(jsonCRS)

        ftr = QgsFeature()
        ftr.setGeometry(PolygonWGS84)
        ftr.setAttributes([auth_id, name])                      
    
        # Add the feature to the layer using this provider (fails)
        prv.addFeatures([ftr])
        
    lyr.updateExtents()

    commited = lyr.commitChanges()
    if commited:
        print("ok")
    else:
        print(f'{lyr.commitErrors()}')
        # return False
        
    # Write to an ESRI Shapefile format dataset using UTF-8 text encoding
    save_options = QgsVectorFileWriter.SaveVectorOptions()
    save_options.driverName = "ESRI Shapefile"
    save_options.fileEncoding = "UTF-8"
    transform_context = QgsProject.instance().transformContext()
    error = QgsVectorFileWriter.writeAsVectorFormatV3(lyr, fileOUT, transform_context, save_options)
    
    
    
def json2shpCRS(fileIN, fileOUT):
    """
    
    Parameters
    ----------
    fileIN : filepath
        file path of json created by calc_BBox
    fileOUT : filepath
        shapefile file path for bboxes in native projection

    Returns
    -------
    None.

    """
    
    data = load_data_crs(fileIN)
 
    crs = "epsg:3857"
    lyr = QgsVectorLayer('Polygon?crs=' + crs, 'CRS', "memory")
    # Prj = QgsProject.instance()  # ADD THIS LINE
    # Prj.addMapLayers([lyr])  

    lyr.startEditing()
    # Set an object for the data provider for the layer
    prv = lyr.dataProvider()
    prv.addAttributes([QgsField("auth_id",  type=QMetaType.QString, len=254), 
                       QgsField("name",  type=QMetaType.QString, len=254)]) 
    lyr.updateFields()     
    
    for jsonCRS in data:
        PolygonWGS84, PolygonCRS, auth_id, name = create_geoms(jsonCRS)

        ftr = QgsFeature()
        ftr.setGeometry(PolygonCRS)
        ftr.setAttributes([auth_id, name])                      
    
        # Add the feature to the layer using this provider (fails)
        prv.addFeatures([ftr])

    commited = lyr.commitChanges()
    if commited:
        print("ok")
    else:
        print(f'{lyr.commitErrors()}')
        # return False
        
    lyr.updateExtents()
        
    # Write to an ESRI Shapefile format dataset using UTF-8 text encoding
    save_options = QgsVectorFileWriter.SaveVectorOptions()
    save_options.driverName = "ESRI Shapefile"
    save_options.fileEncoding = "UTF-8"
    transform_context = QgsProject.instance().transformContext()
    error = QgsVectorFileWriter.writeAsVectorFormatV3(lyr, fileOUT, transform_context, save_options)
    
    
# workingdir = "/home/beilin/.local/share/QGIS/QGIS3/profiles/default/python/plugins/IdentifProj/config/"   
# fileIN = os.path.join(workingdir, "crs_with_bounds.json")

# fileOUT = os.path.join(workingdir, "bboxWGS84.shp")
# json2shpWGS84(fileIN, fileOUT)

# fileOUT2 = os.path.join(workingdir, "bboxCRS.shp")
# json2shpCRS(fileIN, fileOUT2)