# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IDECanariasDockWidget
                                 A QGIS plugin
 Este complemento permite realizar búsquedas en la toponimia de Canarias.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-03-06
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Félix José Hernández
        email                : fhernandeze@grafcan.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys
import math
import re

from PyQt5 import QtGui
from PyQt5 import QtWidgets
from PyQt5 import uic
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtCore import QUrl
from PyQt5.QtNetwork import QNetworkRequest
from PyQt5.QtNetwork import QNetworkAccessManager
from PyQt5 import QtXml
from PyQt5.QtWidgets import QTableWidgetItem
from PyQt5.QtWidgets import QApplication

from datetime import datetime

from qgis.core import *

from .utils import *

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'idecanarias_dockwidget_base.ui'))


class IDECanariasDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, iface, parent=None):
        """Constructor."""
        super(IDECanariasDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # my setup
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.setupPlug()
        self.setupEvents()

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def setupPlug(self):
        """"""
        baseDirectory = os.path.dirname(__file__)

        def fillPath(x):
            return os.path.join(baseDirectory, x)
        databasePath, filenamelog = map(
            fillPath, ['.database', 'idecanarias.log']
        )
        self.DEBUG = True
        self.filenamelog = filenamelog
        self._chkBBOX = False
        self.i = 0
        self.lid = []
        self._radio = 0
        self._point = None
        self._pointutm = None
        self.layer = None
        self.layerid = ''
        self.http = QNetworkRequest()
        self.manager_search = QNetworkAccessManager()
        self.manager_gml = QNetworkAccessManager()

        # compatibility
        self.ui = self

        self.tblResultHeader = [u'Nombre', u'Clasificación', u'Localización']
        self.ui.tblResult.setHorizontalHeaderLabels(self.tblResultHeader)

        self.Log("init app")

    def setupEvents(self):
        """"""
        self.ui.txtSearch.returnPressed.connect(self.onClick_btnSearch)
        self.ui.tblResult.cellDoubleClicked.connect(self.onDblClick_tblResult)
        self.ui.btnGo.clicked.connect(self.onClick_btnGo)
        self.ui.txtCoordinates.returnPressed.connect(self.onClick_btnGo)
        self.ui.btnClipboard.clicked.connect(self.onClick_btnClipboard)
        self.ui.radiodms.toggled.connect(self.__setRadiodms)
        self.ui.radiodm.toggled.connect(self.__setRadiodm)
        self.ui.radiod.toggled.connect(self.__setRadiod)
        self.ui.radioutm.toggled.connect(self.__setRadioutm)
        self.ui.btnGet.clicked.connect(self.onClick_btnGet)

        self.manager_search.finished.connect(self.onDone_http)
        self.manager_gml.finished.connect(self.onDone_gml)

    def Log(self, msg):
        """"""
        if self.DEBUG:
            f = open(self.filenamelog, "a")
            f.write("%s: %s\n" % (datetime.now(), msg))
            f.close()

    def alert(self, msg):
        """"""
        QtGui.QMessageBox.warning(self, u'Búsquedas IDECANARIAS', msg)

    def onClick_btnSearch(self):
        """
        TODO: 121203, limit bbox search
        /busquedas/toponimoxmlbbox/1/10/151186.2703860851,2928780.363515307,682750.3992649722,3334856.301118972/0/0/?texto=chineguas
        """
        texto = self.ui.txtSearch.text()
        if not texto:
            texto = "grafcan"

        if not self.ui.chkBBOX.isChecked():
            url = QUrl(
                'https://visor.grafcan.es/busquedas/toponimoxml/1/50/'
                '?texto=%s' % texto
            )
        else:
            self.Log("retrive bbox")
            _bbox = None
            _bbox = self.canvas.extent()
            bbox = [
                _bbox.xMinimum(), _bbox.yMinimum(),
                _bbox.xMaximum(), _bbox.yMaximum()
            ]
            url = QUrl(
                (
                    'https://visor.grafcan.es/busquedas/toponimoxmlbbox'
                    '/1/10/%s,%s,%s,%s/0/0/?texto=%s'
                ) % (
                    bbox[0], bbox[1], bbox[2], bbox[3],
                    texto
                )
            )
        req = QNetworkRequest(url)
        self.manager_search.get(req)

    def onDone_http(self, reply):
        """
        """
        error = reply.error()

        doc = QtXml.QDomDocument("IDE")
        response = reply.readAll()
        doc.setContent(response)

        id = nombre = clasificacion = localizacion = None

        if error:
            self.Log(error)

        self.ui.tblResult.clear()
        self.ui.tblResult.setRowCount(0)
        self.ui.tblResult.setHorizontalHeaderLabels(self.tblResultHeader)

        e = None
        self.lid = []
        lidd = []
        root = doc.documentElement()
        node = root.firstChild()
        self.Log(node.__dict__)
        while (not node.isNull()):

            if(node.toElement().tagName() == "row"):
                self.Log("row")
                child = node.firstChild()
                while (not child.isNull()):
                    if(child.toElement().tagName() == "id"):
                        try:
                            child2 = child.firstChild()
                            id = child2.toText().data()
                            # lidd.append(e["id"])
                        except ValueError:
                            QtGui.QMessageBox.warning(
                                self,
                                "Error",
                                "Could not parse xml file. Problem %s." % (
                                    child2.toElement().tagName()
                                )
                            )
                    elif (child.toElement().tagName() == "nombre"):
                        try:
                            child2 = child.firstChild()
                            nombre = child2.toText().data()
                            # lidd.append(e["nombre"])
                        except ValueError:
                            QtGui.QMessageBox.warning(
                                self,
                                "Error",
                                "Could not parse xml file. Problem %s." % (
                                    child2.toElement().tagName()
                                )
                            )
                    elif (child.toElement().tagName() == "clasificacion"):
                        try:
                            child2 = child.firstChild()
                            clasificacion = child2.toText().data()
                        except ValueError:
                            QtGui.QMessageBox.warning(
                                self,
                                "Error",
                                "Could not parse xml file. Problem %s." % (
                                    child2.toElement().tagName()
                                )
                            )
                    elif (child.toElement().tagName() == "localizacion"):
                        try:
                            child2 = child.firstChild()
                            localizacion = child2.toText().data()
                        except ValueError:
                            QtGui.QMessageBox.warning(
                                self,
                                "Error",
                                "Could not parse xml file. Problem %s." % (
                                    child2.toElement().tagName()
                                )
                            )
                    elif (child.toElement().tagName() == "x"):
                        try:
                            child2 = child.firstChild()
                            x = child2.toText().data()
                        except ValueError:
                            QtGui.QMessageBox.warning(
                                self,
                                "Error",
                                "Could not parse xml file. Problem %s." % (
                                    child2.toElement().tagName()
                                )
                            )
                    elif (child.toElement().tagName() == "y"):
                        try:
                            child2 = child.firstChild()
                            y = child2.toText().data()
                        except ValueError:
                            QtGui.QMessageBox.warning(
                                self,
                                "Error",
                                "Could not parse xml file. Problem %s." % (
                                    child2.toElement().tagName()
                                )
                            )
                    child = child.nextSibling()
                e = (
                    id,
                    localizacion,
                    clasificacion,
                    nombre,
                    nombre,
                    0.0, x[0], y[0]
                )
                lidd.append(
                    "%s - %s [%s]" % (clasificacion, localizacion, nombre)
                )

            self.lid.append(e)
            row = self.ui.tblResult.rowCount()
            self.ui.tblResult.insertRow(row)
            item001 = QTableWidgetItem(nombre)
            item002 = QTableWidgetItem(clasificacion)
            item003 = QTableWidgetItem(localizacion)
            self.ui.tblResult.setItem(row, 0, item001)
            self.ui.tblResult.setItem(row, 1, item002)
            self.ui.tblResult.setItem(row, 2, item003)
            node = node.nextSibling()

        self.ui.lblResult.setText(
            (
                u'%d lugar(es) encontrados '
                u'(Haz doble click para ver su localización)'
            ) % len(self.lid)
        )
        self.ui.tblResult.resizeColumnsToContents()

    def onDblClick_tblResult(self, i, j):
        """"""
        id = self.lid[i][0]
        self.i = i
        url = QUrl(
            'https://visor.grafcan.es/busquedas/toponimiagml/1/50/qgis'
            '/1/%d/' % int(id)
        )
        req = QNetworkRequest(url)
        self.manager_gml.get(req)

    def onDone_gml(self, reply):
        """
        """
        # error = reply.error()

        filename = os.path.join(
            QtCore.QDir.tempPath(), "XXXXXX.gml"
        )
        file = QtCore.QTemporaryFile(filename)
        file.setAutoRemove(False)

        if not file.open(QtCore.QFile.WriteOnly | QtCore.QFile.Text):
            self.alert(
                u"No puedo escribir en %1:\n%2." % (
                    filename, file.errorString()
                )
            )
            return False

        outstr = QtCore.QTextStream(file)
        outstr.setCodec("UTF-8")
        all = reply.readAll()
        outstr << all
        filename = file.fileName()
        file.close()
        self.Log("Save {}".format(filename))
        # basename = os.path.basename(filename)

        id = None
        nombre = None
        if self.i is not None:
            id = self.lid[self.i][0]
            nombre = self.lid[self.i][3]

            # show in qgis
            # basename = os.path.basename(filename)
            layerid = self.iface.addVectorLayer(
                filename, "%s_%s" % (nombre, id), 'ogr'
            )
            # src = QgsCoordinateReferenceSystem()
            # src.createFromSrid(32628)
            # src = self.canvas.layers()[0].crs()
            src = layerid.crs()
            dest = self.canvas.mapSettings().destinationCrs()
            coodTrans = QgsCoordinateTransform(
                src,
                dest,
                QgsProject.instance()
            )
            extent = layerid.extent()
            newextent = coodTrans.transform(extent)
            # newextent = extent.transform(coodTrans)
            # self.canvas.setExtent(layerid.extent())
            self.canvas.setExtent(newextent)
            self.canvas.refresh()

    def onClick_btnGo(self):
        """
        develop er to parse this:
        28º 07' 9.7249'' S, 15º 25' 30.9814'' O
        28º 07.16208' S, 15º 25.51637' O
        28.11936800, -15.42527283
        458232.06, 3110498.55

        Algorithm
        lat = 45 + (25 / 60) + (2.98 / 3600)
        lng = 10 + (11 / 60) + (30.29 / 3600)
        """

        lat = None
        lng = None
        x = None
        y = None

        texto = self.ui.txtCoordinates.text()
        if not texto:
            texto = "28º 07' 9.7249'' N, 15º 25' 30.9814'' O"
            texto = "28º 07' 9.7248'' N, 15º 25' 30.9822'' O"

        patterndms = (
            r"^([\d]{1,3})\º ([\d]{1,3})\'"
            r" ([\d]{1,3}(\.\d+)?)\'\'"
            r" ([NS]),\s*([\d]{1,3})\º ([\d]{1,3})\'"
            r" ([\d]{1,3}(\.\d+)?)\'\' ([EO])$"
        )
        m = re.match(patterndms, texto, re.UNICODE)
        if m:
            lat = int(m.group(1)) + \
                (float(m.group(2)) / 60) + \
                (float(m.group(3)) / 3600)
            lng = int(m.group(6)) + \
                (float(m.group(7)) / 60) + \
                (float(m.group(8)) / 3600)
            if m.group(5) == "S":
                lat = -lat
            if m.group(10) == "O":
                lng = -lng
            self.ui.radiodms.setChecked(True)

        patterndm = (
            r"^([\d]{1,3})\º ([\d]{1,3}(\.\d+)?)\'"
            r" ([NS]),\s*([\d]{1,3})\º ([\d]{1,3}(\.\d+)?)\' ([EO])$"
        )
        m = re.match(patterndm, texto, re.UNICODE)
        if m:
            lat = int(m.group(1)) + (float(m.group(2)) / 60)
            lng = int(m.group(5)) + (float(m.group(6)) / 60)
            if m.group(4) == "S":
                lat = -lat
            if m.group(8) == "O":
                lng = -lng
            self.ui.radiodm.setChecked(True)

        patterndm = r"^(\-?[\d]{1,3}(\.\d+)?),\s*(\-?[\d]{1,3}(\.\d+)?)$"
        m = re.match(patterndm, texto, re.UNICODE)
        if m:
            lat = float(m.group(1))
            lng = float(m.group(3))
            self.ui.radiod.setChecked(True)

        # convert to UTM
        self.Log("%s, %s (%s)" % (lat, lng, type(texto)))

        if lat and lng:
            point = QgsPointXY(lng, lat)
            self._point = point
            self._pointutm = pointFromWGS84(point)
            x = self._pointutm[0]
            y = self._pointutm[1]

        m = re.match(r"^(\d+(\.\d+)?),\s*(\d+(\.\d+)?)$", texto)
        if m:
            x = float(m.group(1))
            y = float(m.group(3))
            self._pointutm = QgsPointXY(x, y)
            self._point = pointToWGS84(self._pointutm)
            self.ui.radioutm.setChecked(True)

        if x and y:

            # create layer
            if not QgsProject.instance().mapLayer(self.layerid):
                self.layer = QgsVectorLayer(
                    "Point", u'Resultados de conversión', "memory"
                )
                self.provider = self.layer.dataProvider()
                self.layer.setCrs(get_dest_projection())

                # add fields
                self.provider.addAttributes([
                    QgsField("nombre", QtCore.QVariant.String),
                    QgsField("x", QtCore.QVariant.Double),
                    QgsField("y", QtCore.QVariant.Double),
                ])

                # Makes fields visible
                self.layer.updateFields()

                # Labels on
                # label = self.layer.label()
                # label.setLabelField(QgsLabel.Text, 0)
                # self.layer.enableLabels(True)

                # add layer if not already
                QgsProject.instance().addMapLayer(self.layer)

                # store layer id
                # self.layerid = QgsProject.instance(
                # ).mapLayers().keys()[-1]
                self.canvas.refresh()

            text = ""
            text, ok = QtWidgets.QInputDialog.getText(
                self, u'IDECanarias', u'Introduzca una descripción:'
            )

            # add a feature
            fields = self.layer.fields()
            fet = QgsFeature(fields)
            fet.setGeometry(QgsGeometry.fromPointXY(self._pointutm))
            fet[0] = text
            fet[1] = self._pointutm[0]
            fet[2] = self._pointutm[1]
            self.provider.addFeatures([fet])

            # update layer's extent when new features have been added
            # because change of extent in provider is not
            # propagated to the layer
            self.layer.updateExtents()

            # Get current extent
            scale = 1
            extent = self.canvas.extent()
            width = extent.width() * scale
            height = extent.height() * scale

            # Recenter
            rect = QgsRectangle(
                x - width / 2.0,
                y - height / 2.0,
                x + width / 2.0,
                y + height / 2.0
            )

            # Set the extent to our new rectangle
            self.canvas.setExtent(rect)

            # Refresh the map
            self.canvas.refresh()
        else:
            self.alert("Coordenadas incorrectas")

    def reverse_action(self, point):
        """"""
        if point and (point != self._pointutm):
            self._pointutm = point

        if self._pointutm is None:
            return

        pt = pointToWGS84(self._pointutm)
        self._point = pt

        latitude = pt[1]    # 28....
        longitude = pt[0]   # -16....

        # Convert to deg, min, secs
        latitude_sign = 0
        if latitude < 0:
            latitude_sign = -1

        longitude_sign = 0
        if longitude < 0:
            longitude_sign = -1

        latitude_deg = math.floor(math.fabs(latitude))
        latitude_min = math.floor((math.fabs(latitude) - latitude_deg) * 60)
        latitude_min_ = (math.fabs(latitude) - latitude_deg) * 60
        latitude_sec = (
            (math.fabs(latitude) - latitude_deg) * 60 - latitude_min
        ) * 60

        latitude_dir = "S"
        if latitude_sign == 0:
            latitude_dir = "N"

        longitude_deg = math.floor(math.fabs(longitude))
        longitude_min = math.floor((math.fabs(longitude) - longitude_deg) * 60)
        longitude_min_ = (math.fabs(longitude) - longitude_deg) * 60
        longitude_sec = (
            (math.fabs(longitude) - longitude_deg) * 60 - longitude_min
        ) * 60

        longitude_dir = "O"
        if longitude_sign == 0:
            longitude_dir = "E"

        data = ""
        if self._radio == 0:
            data = (
                u"%02.0fº %02.0f\'"
                u" %06.4f\'\' %s, %02.0fº %02.0f\' %06.4f\'\' %s"
            ) % (
                latitude_deg, latitude_min, latitude_sec, latitude_dir,
                longitude_deg, longitude_min, longitude_sec, longitude_dir
            )
        elif self._radio == 1:
            data = (
                u"%02.0fº %08.5f\' %s, %02.0fº %08.5f\' %s"
            ) % (
                latitude_deg, latitude_min_, latitude_dir,
                longitude_deg, longitude_min_, longitude_dir
            )
        elif self._radio == 2:
            data = u"%.8f, %.8f" % (latitude, longitude)
        elif self._radio == 3:
            data = u"%s, %s" % (
                '{0:.2f}'.format(self._pointutm[0]),
                '{0:.2f}'.format(self._pointutm[1])
            )
        else:
            data = ""
        self.ui.txtCoordinates.setText(data)

    def onClick_btnClipboard(self):
        """"""
        clipboard = QApplication.clipboard()
        clipboard.setText(self.ui.txtCoordinates.text())

    def onClick_btnGet(self):
        """"""
        ct = ClickTool(self.iface, self.reverse_action)
        self.iface.mapCanvas().setMapTool(ct)

    def __setRadiodms(self, checked):
        """
        """
        if checked:
            self._radio = 0
        self.reverse_action(None)

    def __setRadiodm(self, checked):
        """
        """
        if checked:
            self._radio = 1
        self.reverse_action(None)

    def __setRadiod(self, checked):
        """
        """
        if checked:
            self._radio = 2
        self.reverse_action(None)

    def __setRadioutm(self, checked):
        """
        """
        if checked:
            self._radio = 3
        self.reverse_action(None)


if __name__ == '__main__':
    app = QtGui.QApplication(sys.argv)
    dialog = IDECanariasDockWidget()
    app.addDockWidget(dialog)
    dialog.show()
    sys.exit(app.exec_())
