###############################################################################
# UAGRA R Scripts                                                    exporter.R
###############################################################################
# Little export function to be queued to motore.R
###############################################################################
#
# Version 1.3
#
# Description: converts homerange R objects in shapefiles
#
# Usage:
#
# Requires: package rgdal
#						accepts data in form of OutputBox (from HR_cruncher function)
#
# Returns: shapefiles
#
# References: none
#
###############################################################################
# created anne 2007-11-27
# revision history:
# anne mar nov 27 10:00:00 CEST 2007 - build the main lines of the function
# anne gio gen 24 12:05:00 CEST 2008 - adapted to motore's changements but not
#       yet perfect
# anne mar mag 27 16:09:00 CEST 2008 - hadj suits both motore's and khadj_squirrel's.
# 		also the allavailable list now picks up all items (no more .shapes selection,
# 		but .areas)
# anne gio lug 10 21:53:00 CEST 2008 - removed old code and modified MCP shape name.
# anne lun lug 28 15:50:00 CEST 2008 - added by and dir options, kept old defaults for backward
#    compatibility
# anne gio lug 31 10:20:00 CEST 2008 - added overwrite function, check adehabitat package
# anne mer ago 6 11:07:00 CEST 2008 - exporter returns list of written shapefiles
# anne mar ott 28 15:37:00 CEST 2008 - corrected list creation: no more list of lists, but
#    plain list
# anne lun feb 23 11:58:00 CEST 2009 - corrected filename construction in nooverlapname.
#    it was unable to check if a file was present, due to lack of a separator!
###############################################################################

nooverlapname <- function(name, dir=getwd(), ext) {
	tempname <- name
	num <- 0
  fullname = file.path(dir, paste(name, ext, sep=""))
	while (file.exists(fullname)) {
		num <- num+1
		tempname <- paste(name, "_", num, sep="")
    fullname = file.path(dir, paste(tempname, ext, sep=""))
	}
	return(tempname)
}

exporter <- function(x, attr, field="ID", out=allavailable, level=95, export= c("global", "separated"), shapename, dir = getwd(), owr=T) {
	namelist <- NULL
    if ((!inherits(x, "homerange")))
        stop("The object I\'m supposed to export \ndoes not come out from HR_cruncher, but if it has the same \nstructure, set its class to both list and homerange.")
    if (!require(rgdal) | !require(adehabitat)) 
		stop("This procedure requires rgdal and adehabitat to be installed.")
    rr <- attr
    allavailable <- sub("\\.areas","",agrep("areas",names(x),value=T)) #gli elementi areas senza .areas che sono presenti nell'_istanza_ outputbox. siccome i nomi delle geometrie cambiano è più sicuro usare areas, che è eseguito da tutti i metodi. anche se logicamente non è corretto.
    if ("mcp" %in% out) {
    	mcpSpol <- area2spol(x$mcp.shapes)
		rrmcp <- merge(rr, x$mcp.areas, by.x = field, by.y = field)
		row.names(rrmcp) <- rrmcp$ID
    	mcpSPDF <- SpatialPolygonsDataFrame(mcpSpol, rrmcp, match.ID = TRUE) 
       	if ("global" %in% export) {
        ## NOT SAFE! grep the level from area column.
			name <- paste(shapename, "MCP", level, "all", sep="")
			if (owr == F) {
				name <- nooverlapname(name, dir=dir, ext=".shp")
      }
# 			namelist <- as.list(c(namelist, name))
      namelist <- c(namelist, name)
      writeOGR(mcpSPDF,dir,name, "ESRI Shapefile")
    	}
    	if ("separated" %in% export) {
    		warning("The separate MCP exporting is not yet implemented.")
    	}
    }

########### GENERIC FACTORIZED EXPORTER FUNCTION FOR KERNELS. doesn't fit NNCHs. Schade!
	xport <- function(krnvol, krnarea, lev, shpname){	
		kernelist <- NULL
		khr.out <- getverticeshr(krnvol, lev=lev)
		khr.outspol <- kver2spol(khr.out)
# filter krnarea to pick up the right only column
		hacolname <- grep(lev, grep("ha_",names(krnarea),value=T), value=T)
		hcolname <- grep("h_",names(krnarea),value=T)
		filter <- subset(krnarea, select= c(field,hcolname,hacolname))
		attribs <- merge(rr, filter, by.x = field, by.y = field)
		row.names(attribs) <- attribs[,field]
		khr.polygons <- SpatialPolygonsDataFrame(khr.outspol, attribs, match.ID = TRUE)
			if ("global" %in% export) {
				name <- paste(shpname,lev, sep="-")
				if (owr == F) 
					name <- nooverlapname(name, dir=dir, ext=".shp")
				kernelist <- c(kernelist,name)
				writeOGR(khr.polygons,dir, name, "ESRI Shapefile")
			}
			if ("separated" %in% export) {
				for (k in getSpPPolygonsIDSlots(khr.polygons))  {
					name <- paste(shpname, lev ,k, sep="-")
					if (owr == F) 
						name <- nooverlapname(name, dir=dir, ext=".shp")
					kernelist <- c(kernelist, name)
					writeOGR(khr.polygons[khr.polygons$ID == k,],dir,name, "ESRI Shapefile")
				}
			}
#     print(kernelist)
#     print(is(kernelist))
# 		return(as.list(kernelist))
    return(kernelist)
    }
######### END

	if ("href" %in% out) {
		href.volumes <- x$href.volumes
		href.areas <- x$href.areas
		hrefs <- paste(shapename, "-href", sep="")
    list <- xport(href.volumes, href.areas, lev=level, shpname=hrefs)
		namelist <- c(namelist, list)
	}

	if ("lscv" %in% out) {
		lscv.volumes <- x$lscv.volumes
		lscv.areas <- x$lscv.areas
		hlscvs <- paste(shapename, "-hlscv", sep="")
		list <- xport(lscv.volumes, lscv.areas, lev=level, shpname=hlscvs)
		namelist <- c(namelist, list)
	}

	if ("hadj" %in% out) {
		hadj.volumes <- x$hadj.volumes
		hadj.areas <- x$hadj.areas
		hadjs <- paste(shapename, "-hadj", sep="")
		list <- xport(hadj.volumes, hadj.areas, lev=level, shpname=hadjs)
		namelist <- c(namelist, list)
	}
  if ("NNCH" %in% out) {
    nnch.volumes <- x$NNCH.shapes
    nnch.areas <- x$NNCH.areas
    nnch.name <- paste(shapename, "-NNCH", sep="")

    nnchlist <- NULL
    # select only the isopleth we need. If you need all isopleths use directly the HRcruncher's output.
#     nnch.shapes.one <- NNCH.select(nnch.shapes.all, lev=level)
    # pick up the right only column with area estimate - no more motore task
    filter <- subset(nnch.areas, select= c(field,level))
    attribs <- merge(rr, filter, by.x = field, by.y = field)
    row.names(attribs) <- attribs[,field]
      if ("global" %in% export) {
        name <- paste(nnch.name,level, sep="-")
        if (owr == F) 
          name <- nooverlapname(nnch.name, dir=dir, ext=".shp")
        nnchlist <- c(nnchlist,name)
        nnch.shapefile <- NNCH.shapefile(nnch.volumes, level)
        write.shapefile(nnch.shapefile, file.path(dir,name))

      }
      if ("separated" %in% export) {
        warning("The separate NNCH exporting is not yet implemented.")
#@TODO: end porting it from xport function
#         for (k in getSpPPolygonsIDSlots(khr.polygons))  {
#           name <- paste(shpname, lev ,k, sep="-")
#           if (owr == F) 
#             name <- nooverlapname(name, dir=dir, ext=".shp")
#           kernelist <- c(kernelist, name)
#           writeOGR(khr.polygons[khr.polygons$ID == k,],dir,name, "ESRI Shapefile")
#         }
}
    namelist <- c(namelist, nnchlist)

  }
#   print(namelist)
	return(namelist)
}
