###############################################################################
# UAGRA R Scripts                                                     motore.R
###############################################################################
# Generic home-range calculation function
###############################################################################
#
# Version 0.2.2
#
# Description: calculates different home range estimators
#
# Usage:
#
# Requires: adehabitat
#
# Returns: OutputBox containing the single outputs
#
# References: Wauters LA, Preatoni DG, Molinari A, Tosi G(2007) Radio-tracking
#             squirrels: Performance of home range density and inkage estimators
#             with small range and sample size.
#             Ecological Modelling, 202(3-4):333-344
#
###############################################################################
# created anne 2007-07-19
# updated prea mer ago 1 11:26:45 CEST 2007
# revision history:
# prea mer ago 1 11:26:45 CEST 2007 - reshaped and converted into sourceable
#     function.
# anne mer nov 14 17:11:00 CEST 2007 - removed the old header and think about
#     the ifs
# anne lun nov 26 20:58:00 CEST 2007 - found how to get all the output in one
#     object (not yet) and abandoned switches' idea
# anne mer nov 28 15:30:00 CEST 2007 - set the output object and start to fix
#     the first checking-ifs
# anne mer gen 23 15:07:38 CEST 2008 - added kernelUD in hadj and used the %in% 
#     selection for kernels
# anne gio gen 24 9:40:00 CEST 2008 - ended the conversion of lscv in a 
#     scope-free function and set the OutputBox names
# anne mer feb 6 16:29:30 CEST 2008 - upgraded to 0.2.0, i.e. changed the interface
# anne mar mar 11 13:54:00 CEST 2008 - corrected hadj and think about deep 
#     refactorization
# anne mar apr 22 14:35:00 CEST 2008 - created turner function and corrected hadj
# anne gio mag 29 22:25:00 CEST 2008 - let khr.area calculate ALL levels
# prea Thu Sep 25 13:32:22 CEST 2008 - added grid= as external parameter
# anne Mon Feb 2 17:10:00 CEST 2009 - added capability of reading sahrlocs' locs
#     dataframe, therefore version skip to 0.2.2
#
###############################################################################

#@TODO(anne) bisogna aggiungere una colonna al dataframe finale con il numero di punti utilizzati per ciascun 'ID'. [anne] il comando che isola la colonna col numero di punti non è in questo script, ma in lepre_periods_general, in questo va cambiata solo la parte in cui vengono riappiccicati gli attributi.
####@TODO(anne) riga 206.

#@TODO(prea) if possible, intercept somehow messages sent out when lscv is not converging and print out them along with the animal ID
#@NOTE(anne) lscv messages should be kernelUD's affair, not motore

#@TODO(anne) integrate sahrlocs' grid

HR_cruncher <- function(x, method=c("mcp","href","lscv","hadj","clusthr","NNCH"), prc=95, grid=40) {
	if (!require(adehabitat)) 
		stop("This procedure requires adehabitat to be installed")
  if (class(x) == "sahrlocs") {
    dd <- getsahrlocs(x, what="locs")
    dd$ID <- dd$Name
    dd$Name <- NULL
  }
	if ((!inherits(x, "data.frame"))) { 
    return(is(x))
		stop("x should be a dataframe") 
	}	else {
		dd <- x 
	}
#   if (names(dd) != "ID", "X","Y")
# 		stop("check the dataframe, ID, X or Y are missing.")
	if (length(dd) > 3) {
		dd <- subset(dd, select = c("ID", "X", "Y"))
	}
	if ((!inherits(dd$ID, "factor"))) {
		dd$ID <- factor(dd$ID)
	}
	# calculate location extent to size up "grid"
  Xmin <- min(dd$X)
  Xmax <- max(dd$X)	
	Ymin <- min(dd$Y)
  Ymax <- max(dd$Y)		
	
	OutputBox <- list()
  class(OutputBox) <- c("list","homerange")

############## FUNZIONI ###########################
## dichiarazione della funzione lscv, che viene usata sia da lscv che da hadj. contiene parti di dropnonconverged
    lscv.cruncher <- function(dd, grid=40) {
		khr.lscv <- kernelUD(dd[,c('X','Y')],dd[,'ID'], h="LSCV", grid=grid)
		cleankhr <- list()
		class(cleankhr) <- c("khr","khrud")
		for (i in names(khr.lscv)) {
			if (khr.lscv[[i]]$h$convergence == TRUE) {
			cleankhr[[i]] <- khr.lscv[[i]]
			}
		}
    return(cleankhr)
    }

## dichiarazione delle funzioni gira-riformatta-tabella
#@TODO(anne): refactor :)
	turner <- function(table, colname) {
		storeID <- names(table)
		table <- t(as.data.frame(table)) # convert into dataframe and transpose
		table <- data.frame(table)       # cast again as dataframe since t returns a matrix		
		colnames(table) <- c(colname)          # assign column names
		table$ID <- storeID     # better have back ID as a column
		row.names(table) <- table$ID
		return(table)
	}

	multicolturner <- function(table) {
		storeID <- names(table)
		storecols <- row.names(table)
		table <- t(as.data.frame(table)) # convert into dataframe and transpose
		table <- data.frame(table)       # cast again as dataframe since t returns a matrix		
		### colnames devono essere "20%ha".
		newnames <- list()
		counter <- 0
		for (i in storecols) {
			counter <- counter+1
			newnames[counter] <- paste("ha_", i, sep="")
		}
		colnames(table) <- newnames         # assign column names
		table$ID <- storeID     # better have back ID as a column
		row.names(table) <- table$ID
		return(table)
	}

############ PERCORSI DI ANALISI ####################
	if ("mcp" %in% method) {
        print("MCP calculation running... should be fast")
		OutputBox[["mcp.shapes"]] <- mcp(dd[,c('X','Y')],dd[,'ID'], percent = prc)
		mcpArea <- mcp.area(dd[,c('X','Y')],dd[,'ID'], percent = prc, unin = "m", unout = "ha", plotit = FALSE)
		pivot <- as.data.frame(t(mcpArea))
		pivot$ID <- row.names(pivot)
		names(pivot) <- c(paste("MCP_", prc, sep=""),"ID")
		OutputBox[["mcp.areas"]] <- pivot
        print("Done.")  
	}
	if ("href" %in% method) {
        print("Kernel href calculation...")
		OutputBox[["href.volumes"]] <- kernelUD(dd[,c('X','Y')],dd[,'ID'],grid=grid)
		khr.area <-  kernel.area(dd[,c('X','Y')],dd[,'ID'],levels=seq(10,95, by=5),unin="m",unout="ha",grid=grid)
		khr.area <- multicolturner(khr.area)
		khr.h <- list()
		for (i in names(OutputBox[["href.volumes"]])) {
			khr.h[i] <- OutputBox$href.volumes[[i]]$h
		}
		khr.h <- turner(khr.h, "h_ref")
		khr.area <- merge(khr.h, khr.area, by.x = 'ID', by.y = 'ID') 
		OutputBox[["href.areas"]] <- khr.area
        print("Done.")
		rm(khr.area)
		rm(khr.h)
	} 
    if ("lscv" %in% method) {
        print("Kernel LSCV calculation...")
        khr.vols <- lscv.cruncher(dd,grid)
		khr.area <- kernel.area(dd[,c('X','Y')], dd$ID, h="LSCV",levels=seq(10,95, by=5),unin="m",unout="ha",grid=grid)
		khr.h <- list()
    if (is.null(names(khr.vols)))
      if (length(method) == 1) {
        warning("No subset converged. Analysis unsuccessful. Output object is NULL.")
        return(NULL)
        }
      else
        warning("No subset converged. Analysis unsuccessful.")
    else {
      OutputBox[["lscv.volumes"]] <- khr.vols
      for (i in names(OutputBox[["lscv.volumes"]])) {
        khr.h[i] <- OutputBox$lscv.volumes[[i]]$h$h
#         print(OutputBox$lscv.volumes[[i]]$h$h)
      }
      khr.area <- multicolturner(khr.area)
      khr.h <- turner(khr.h, "h_LSCV")
      khr.area <- merge(khr.h, khr.area, by.x = 'ID', by.y = 'ID')
      OutputBox[["lscv.areas"]] <- khr.area
          print("Done.")
    }
	} 
    if ("hadj" %in% method) {
        print("Kernel hadj calculation...")
        if (is.null(OutputBox[["href.volumes"]])) {
    		OutputBox[["href.volumes"]] <- kernelUD(dd[,c('X','Y')],dd[,'ID'],grid=grid)
        }
        if (is.null(OutputBox[["lscv.volumes"]])) {
            OutputBox[["lscv.volumes"]] <- lscv.cruncher(dd,grid)
        }
		#@TODO(anne) calcolare hadj (vedi ecological modelling 202: 333-344). Lo mettiamo in un file a parte o lo lasciamo nella funzione?
		############ hadj ############
		# 1: calcolare hadj[i] = (hlscv[i]/href[i])

		N <- length(names(OutputBox$href.volumes))  # calcola il numero di righe necessario
		hadj <- data.frame(ID=character(N),hadj=numeric(N)) # crea un dataframe vuoto, con N righe
		row.names(hadj) <- names(OutputBox$href.volumes) # assegna i nomi alle righe
		hadj$ID <- names(OutputBox$href.volumes) # riempie la colonna ID
		
        ## if lscv is globally unsuccessful, abort execution. #@TODO find a cleaner way...
        abort <- FALSE
        for (each in row.names(hadj)) {
          if (!is.null(OutputBox$lscv.volumes[[each]]$h$convergence)) {
            abort <- FALSE
            break()
          }
          else 
            abort <- TRUE
        }
        if (abort == TRUE) {
          warning("LSCV never converge. hadj would be equal to href. Aborting. Output object is NULL.")
          return(NULL)
        }		
		
		for (i in row.names(hadj)) {
			if (is.null(OutputBox$lscv.volumes[[i]]$h$convergence)) {
				# not converged, hadj = 1
				hadj[i,'hadj'] <- 1
			}
			else {
				if (OutputBox$lscv.volumes[[i]]$h$convergence) { # paranoia!
				# converged, hadj[i] = hlscv[i]/href[i]
				hadj[i,'hadj'] <- OutputBox$lscv.volumes[[i]]$h$h/OutputBox$href.volumes[[i]]$h     
				}
				else {                             # paranoia!
				hadj[i,'hadj'] <- 1    
				}
			}
		}
		# 2: calcolare la media di hadj[i]
		hadj.mean <- mean(hadj$hadj)
		########### fine hadj ############
		# 3: ricalcolare le superfici dei kernel con h=hadj.mean * href[i]

		khr.hadjdf <- data.frame(percent=seq(10,95,by=5))
        hadj.values <- list()
        khr.geo <- list()
        class(khr.geo) <- c("khrud","khr") ## FIX! se non si assegnano _entrambe_ le classi, gerverticeshr fa casino!
		for (i in names(OutputBox$href.volumes)) {
			h <- hadj.mean*OutputBox$href.volumes[[i]]$h
			d <- subset(dd, ID == i, select = c('ID','X','Y'))
			khr.hadjdf[i] <- kernel.area(d[,c('X','Y')],d$ID,h=h,levels=seq(10,95,by=5),unin="m",unout="ha",grid=grid)
            khr.geo[i] <- kernelUD(d[,c('X','Y')], h=h, grid=grid)
            hadj.values[i] <- h
		}
		OutputBox[["hadj.volumes"]] <- khr.geo

		row.names(khr.hadjdf) <- khr.hadjdf$percent
		khr.hadjdf$percent <- NULL

		khr.hadj <- multicolturner(khr.hadjdf) # reshapes areas table
		hadj.values <- turner(hadj.values, "h_adj") # reshapes h table
		khr.hadj <- merge(hadj.values, khr.hadj, by.x = 'ID', by.y = 'ID')
		OutputBox[["hadj.areas"]] <- khr.hadj
        print("Done.")
    }
    if ("clusthr" %in% method) {
        print("clusthr option is not yet active. Tell Anne to work on it.")	
    #@TODO(anne) fare routine calcolo cluster (Kenward et al. 2001) 
    }
	if ("NNCH" %in% method) {
    print("a-NNCH calculation. Could be long. It empirically takes e^n seconds...")
    maxdistance <- sqrt((max(dd$Y) - min(dd$Y))^2 + (max(dd$X) - min(dd$X))^2) # la diagonale del rettangolo contenente tutti i punti
		nnch.shapes <- NNCH(dd[,c('X','Y')],dd[,'ID'], a=maxdistance, unin="m", unout="ha", status=FALSE, duplicates=0.2)
		nnch.area <- NNCH.area(nnch.shapes, rev(seq(10, 100, by = 5)), plotit=FALSE)
		nnch.area <- as.data.frame(t(nnch.area))
    # strip out the a and all other stuff from the animal names (damn!) 
    nnch.area$ID <- strsplit(row.names(nnch.area), '\\..*')
    row.names(nnch.area) <- nnch.area$ID
# 		names(nnch.area) <- c("NNCH95","ID")
		OutputBox[["NNCH.shapes"]] <- nnch.shapes
		OutputBox[["NNCH.areas"]] <- nnch.area
        print("Done.")
	}
## ulteriori tecniche di calcolo possono essere messe da qui in poi
	invisible(OutputBox)
}
