########################################################
#                                                                                                         HRplugin_main.py  #
########################################################
#    Home-range analyses in QGIS with R
#    Version 2.1.7
#    Anne Ghisla's Google Summer  of Code 2008 project
#    This plugin performs  home range analyses: MCP, kernel href, LSCV, hadj calling
#    R (package adehabitat). It returns shapefiles in the chosen directory.
#
#    email: a.ghisla@studenti.uninsubria.it
########################################################
# 
#    Copyright (C) 2009  Anne Ghisla
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    A copy of the GNU General Public License is available at 
#    http://www.gnu.org/licenses/gpl.txt, or can be requested to the Free
#    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#    Boston, MA 02110-1301 USA.
#
########################################################
# rewritten from scratch by anne 17 march 2009 - happy birthday Damien!
########################################################
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
import resources 
from HRplugin_dialog import Dialog

class HRPlugin:
  """ This plugin makes available R functions for home-range estimation into QGis. """
  # dictionary of methods. Add new methods here as keys, value is its full name.
  mth = {"mcp":"MCP",
         "href":"Kernel h ref",
         "lscv":"Kernel h LSCV",
         "hadj":"Kernel with adjusted h",
         "NNCH":"Nearest-Neighbour Convex Hull"}
  
  def __init__(self, iface):
    # save reference to the QGIS interface
    self.iface = iface
   
  def initGui(self):
    """ Populates toolbar and add items to Plugin menu. """
    # create action that will start plugin configuration. It's the batch analysis call.
    self.action = QAction(QIcon(":/icona.png"), "Batch Home range analysis", self.iface.mainWindow())
    QObject.connect(self.action, SIGNAL("triggered()"), lambda method="all": self.showInterface(method))
    self.iface.addToolBarIcon(self.action)
    self.iface.addPluginToMenu("Home range analysis", self.action)
    # create action and submenu for each method
    for k, v in self.mth.iteritems():
      link = "%s" % ":/" +k +".png"
      setattr(self, "action" + k, (QAction(QIcon(link), v, self.iface.mainWindow())))
      QObject.connect(getattr(self,  "action" + k), SIGNAL("triggered()"),  lambda method=k: self.showInterface(method))
      self.iface.addPluginToMenu("Home range analysis",  getattr(self,  "action" + k))
    
  def unload(self):
    """ Removes items in menu and toolbar icon. """
    self.iface.removePluginMenu("Home range analysis",self.action)
    for m in self.mth:
      self.iface.removePluginMenu("Home range analysis",  getattr(self,  "action" + m))
    self.iface.removeToolBarIcon(self.action)
    
  def showInterface(self,  method):
    """ Calls a specific analysis dialog """
    e = Dialog(self.iface, self.mth)
    e.configureWindow(method = method)
    #e.exec_()
    e.show() # seems a solution for modality, even if in ui file there is no modality setting on.
