########################################################
#                                                                                                                      __init__.py  #
########################################################
#    Home-range analyses in QGIS with R
#    Version 2.1.7
#    Anne Ghisla's Google Summer  of Code 2008 project
#    This plugin performs  home range analyses: MCP, kernel href, LSCV, hadj calling
#    R (package adehabitat). It returns shapefiles in the chosen directory.
#    Dedicated to Damien and Michele, for their kind friendship.
#    For they teach me programming and music composing, and show me how rules
#    of their elegance are astonishingly the same.
#
#    email: a.ghisla@studenti.uninsubria.it
########################################################
# 
#    Copyright (C) 2008  Anne Ghisla
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    A copy of the GNU General Public License is available at 
#    http://www.gnu.org/licenses/gpl.txt, or can be requested to the Free
#    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#    Boston, MA 02110-1301 USA.
#
########################################################
# created by anne 17 june 2008
########################################################

from HRplugin_main import HRPlugin 

def name():
  return "Home range estimation with R"

def description():
  return "Kernel, NNCH and MCP calculation with R functions. Requires R, RPy2, R packages adehabitat, rgdal, shapefiles, gpclib."

def version():
  return "Version 2.1.7"

def qgisMinimumVersion():
  return "1.0.0"

def authorName():
  return "Anne Ghisla"

def plugin_type():
  return QgisPlugin.UI # UI plugin

def classFactory(iface):
  return HRPlugin(iface)
