########################################################
#                                                                                                       HRplugin_dialog.py  #
########################################################
#    Home-range analyses in QGIS with R
#    Version 2.1.7
#    Anne Ghisla's Google Summer  of Code 2008 project
#    This plugin performs  home range analyses: MCP, kernel href, LSCV, hadj calling
#    R (package adehabitat). It returns shapefiles in the chosen directory.
#
#    email: a.ghisla@gmail.com
########################################################
# 
#    Copyright (C) 2009  Anne Ghisla
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    A copy of the GNU General Public License is available at 
#    http://www.gnu.org/licenses/gpl.txt, or can be requested to the Free
#    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#    Boston, MA 02110-1301 USA.
#
########################################################
# rewritten from scratch by anne 17 march 2009 - happy birthday Damien!
# modified anne 20090330 - commented. Most global variables are passed as parameters.
# modified anne 20090402 - recovered Add New Layers to Canvas function (2.0.1)
########################################################
import os, sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.utils import *
import interface
from tempfile import gettempdir

try:
  import rpy2
  import rpy2.robjects as robjects
except ImportError:
    QMessageBox.warning(None , "HomeRange_plugin", "Unable to load the plugin: Unable to load required package rpy2."
    + "\nPlease ensure that both R, and the corresponding version of Rpy2 are correctly installed.")
  
  
class Dialog(QDialog, interface.Ui_Dialog):
  """ Shows the dialog of one analysis, batch or single. """
  def __init__(self, iface, mth):
    QDialog.__init__(self)
    self.iface = iface
    self.mth = mth
    # store here MapCanvas object and layermap (list of layers)
    Dialog.mapCan = self.iface.mapCanvas()
    Dialog.layermap = QgsMapLayerRegistry.instance().mapLayers()
   # create a list to hold combobox indexes, and a list to hold QMapLayers pointers
    self.cmb_in_lyr_list = []
    self.cmb_in_lyr_pointerlist = []
    self.tempfolder = gettempdir()
    # Sets up the user interface from Designer (copied from Carson's manageR)
    self.setupUi(self)
    # Sets up the signal connections to watch for some actions (as above)
    QObject.connect(self.iface.mainWindow(), SIGNAL("lastWindowClosed()"), self.close)
    # load all point layers
    self.update()
    # TODO: set subset button signal/slot. Choose how. Popup window? Multiple combobox selection?
    QObject.connect(self.cmb_in_lyr,  SIGNAL("currentIndexChanged(int)"), self.listAvailableFields)
    # reload all point layers (because the first round waits for combobox change to populate list of fields.. silly)
    self.update()
    # TODO: let user follow the Yellow Rule. Something like
#    QObject.connect(self.layer_comboBox, SIGNAL("stateChanged()"), self.select) 
    # TODO: group fixes by some fields. 
    self.led_out_folder.setText(self.tempfolder)
    QObject.connect(self.tbt_out_folder, SIGNAL("clicked()"), self.choose)
    # Press OK will collect all settings
    QObject.connect(self.buttonBox, SIGNAL("accepted()"), lambda mth=mth: self.run(mth))
    QObject.connect(self.buttonBox, SIGNAL("helpRequested()"), self.raiseHelp)
    
  def raiseHelp(self):
    """ Calls help window. """
    print "Wawa!"
    showPluginHelp()
    print "Wiwi!"
    
  def choose(self):
    #TODO refactor me!
    """ Let user pick up a folder where to save output shapefiles. """
    folder = QFileDialog.getExistingDirectory(self, "Choose the destination folder", os.path.expanduser("~")) 
    self.led_out_folder.setText(folder)
    self.tempfolder = folder

  def collectData(self, opt):
    """Extracts geometries from selected layer."""
    idDict = []
    xDict = []
    yDict = []
    geomData = {'ID':  idDict, 'X': xDict,  'Y': yDict}
    # use QGis tools to extract info from layer
    provider = opt["io"]["layerpointer"].dataProvider()
    allAttrs = provider.attributeIndexes()
    fields = provider.fields()
    fieldID = None
    for (k, v) in fields.iteritems(): # TODO: use it to populate list of available fields!
      if v.name() == opt["io"]["subset"]: 
        fieldID = k 
    provider.select(allAttrs)
    feat = QgsFeature()
    while provider.nextFeature(feat):
      geom = feat.geometry()
#      print "Feature ID %d: " % feat.id() # DEBUG
      pointmp = geom.asPoint()
      xDict.append(pointmp.x())
      yDict.append(pointmp.y())
      # retrieve attributes
      attrs = feat.attributeMap()
      for (k,attr) in attrs.iteritems(): # i.e., for each pair key-value of the attributes of that feature
        if k == fieldID:
          idDict.append("%s" % attr.toString())
    return geomData
    
  def collectOptions(self):
    """ Resumes all options in the main dictionary. """
    opt = {}
    # input settings
    opt["io"] = {}
    opt["io"]["layer"] = "%s" % self.cmb_in_lyr_list[self.cmb_in_lyr.currentIndex()]
    opt["io"]["layerpointer"] = self.cmb_in_lyr_pointerlist[self.cmb_in_lyr.currentIndex()]
    opt["io"]["layername"] = "%s" % self.cmb_in_lyr_pointerlist[self.cmb_in_lyr.currentIndex()].name()
    opt["io"]["selection"] = self.chk_in_rows.checkState()
    opt["io"]["subset"] = "%s" % self.cmb_in_cols.currentText()
    # specific analysis settings.
    # for each (visible and) checked boxHRplugin_dialog.py, do analysis. Even if user doesn't touch them, a valid analysis can be run
    # using defaults.
    opt["methods"] = {}
    atleast = None
    for i in self.mth:
      if  not getattr(self,  "frm_" + i).isHidden() and  getattr(self,  "chk_" + i).isChecked():
        atleast = True
        opt["methods"][i] = {}
        opt["methods"][i]["percent"] = getattr(self, "spb_"+i+"_per").value()
    if atleast == None:
      QMessageBox.information(self, "Home range analysis",  "Error! Check at least one method. ")
      # TODO: redraw interface with the called method.
    # output settings
    opt["io"]["outputfolder"] = "%s" % self.led_out_folder.text() 
    opt["io"]["overwrite"] = self.chk_out_owr.isChecked()
    opt["io"]["outputview"] = self.chk_out_view.isChecked()
    opt["io"]["mode"] = "%s" % self.cmb_out_mod.currentText()
    print opt
    return opt
    
  def configureWindow(self, method):
    """ Enables the correct set of widgets depending on the methods to be set available. """
    # hides the widget that use only selected features. Will be available in next version.
    self.chk_in_rows.hide()
    for m in self.mth:
      if method != "all":
        a = getattr(self,  "frm_" +m)
        a.hide()
        b = getattr(self, "frm_" + method)
        b.show()
      self.adjustSize()
      
  def listAvailableFields(self):
    """ Populates the list of fields available for subsetting. """
    # the line means: catch the address of the layer which full name has the index in combobox.
    act_lyr = self.layermap[self.cmb_in_lyr_list[self.cmb_in_lyr.currentIndex()]]
    provider=act_lyr.dataProvider()
    fieldmap=provider.fields()
    self.cmb_in_cols.clear()
    for (k,attr) in fieldmap.iteritems():
      self.cmb_in_cols.addItem(attr.name())  
  
  def run(self, mth):
    """ Central function that collects data and calls R for computation """
    
    print mth
    opt = self.collectOptions()
    geomData = self.collectData(opt)
    
    rwrapper = Rwrapper(self)
    
    MissingPackageMessage = "R package(s) missing: "
    for i in ['adehabitat', 'rgdal']:
      if not robjects.r.require(i)[0]:
        MissingPackageMessage + i + ', '
    if MissingPackageMessage is not "R package(s) missing: ":
      QMessageBox.critical(self, "Home range analysis", MissingPackageMessage + 'install them and re-run.')
      return False
    
    output = rwrapper.Rcall(geomData, opt)
    
    if opt["io"]["outputview"] is True:
      for n in output:
        newlayer = QgsVectorLayer(os.path.join(opt["io"]["outputfolder"], n + ".shp"), n, 'ogr')
        QgsMapLayerRegistry.instance().addMapLayer(newlayer)

  def update(self): 
    """ Refreshes/loads layers in ComboBox, looking up in Legend NOT IN CANVAS [modified from Carson Farmer's manageR] """
    self.cmb_in_lyr.clear()
    for name, layer in self.layermap.iteritems():
      if layer.type() == layer.VectorLayer and layer.geometryType() == QGis.Point:
        self.cmb_in_lyr.addItem(layer.name()) # loads display name
        self.cmb_in_lyr_list.append(layer.getLayerID()) # fills the list with full timestamped name
        self.cmb_in_lyr_pointerlist.append(layer)
        # correspondence of display names and full timestamped names is by INDEX
    if self.cmb_in_lyr .count() == 0:
      QMessageBox.information(self, "Home range analysis plugin", "No point layers available! Load at least one and re-run.")
  
class Rwrapper():
  """ Executes R code separated by Qt interface. """
  def __init__(self, parent):
    self.parent = parent
  
  def Rcall(self, QData, opt):
    """ Calls R and execute analyses. """
    shapefiles = []
    singleshp = []
    
    try:
      ## TODO(anne) rewrite this with correct Python instruments, not these stone knives :D
      #    self.rlogfile = Dialog.opt["io"]["outputfolder"] +"/" + "%s" % Dialog.opt["io"]["layerpointer"].name() + "_r_log.txt"
      #       QMessageBox.information(self, "Home range analysis", "progress info: logfile is" + self.rlogfile)
      #r.sink(file = self.rlogfile,  append = True) ## temporary unlogging
      #QMessageBox.information(self, "Home range analysis", "progress info: logfile sinking")
      #       r.print("== R run ==")
      #       print(r.names(data))
      #       print(r.is_(data))
      QDataCopy = QData
      QDataCopy["ID"] = robjects.StrVector(QData["ID"])
      QDataCopy["X"] = robjects.FloatVector(QData["X"])
      QDataCopy["Y"] = robjects.FloatVector(QData["Y"])
      RDatatemp = robjects.r['data.frame'](**QDataCopy) 
      RData = robjects.default_ri2py(RDatatemp)
  
      path = os.path.dirname(__file__)
      
      motore = os.path.join(path,  "motore.R")
      robjects.r.source(motore)
      exporter = os.path.join(path,  "exporter.R")
      robjects.r.source(exporter)
      # TODO: check here if there is at least one checked method.
      # 1. creates a mock attribute dataframe, will become part of dbf
      # TODO: obtain an attribute table merging all attributes except the ones chosen by user
      # as subset, and the table of subsets. By rownames?
      #      newattrs = r.merge_(data,  attributes,  by = "row.names")
      mock = {}
      #mock["ID"] = robjects.StrVector(list(sets.Set(QData["ID"]))) # set() removes duplicates
      mock["ID"] = robjects.r.unique(QDataCopy["ID"])
      attributes = robjects.r['data.frame'](**mock) 
      attributes = robjects.default_ri2py(attributes) 
  
      for i in opt["methods"].keys():
        homeranges = robjects.r['HR_cruncher'](RData,  method=i, prc = opt["methods"][i]["percent"])
        #print homeranges.r_repr() commented since harmful for windows!
        if homeranges.r_repr() is not robjects.r('''NULL'''): # it can happen that lscvs don't converge, thus no output.. NON VA
          if opt["io"]["mode"] == "global" or opt["io"]["mode"] == "separated": #@TODO(anne) understand why is and is not won't work.
            singleshp = robjects.r['exporter'](homeranges, attributes, level = "%d" % opt["methods"][i]["percent"], export = robjects.r.c(opt["io"]["mode"]), shapename= opt["io"]["layername"],  dir="%s" % opt["io"]["outputfolder"],  owr= opt["io"]["overwrite"])
          else:
            singleshp = robjects.r['exporter'](homeranges, attributes, level = "%d" % opt["methods"][i]["percent"], shapename= opt["io"]["layername"],  dir="%s" % opt["io"]["outputfolder"],  owr= opt["io"]["overwrite"])
        else:
          QMessageBox.information(self, "Home range analysis", "R message (kernel LSCV): no subset converged. No output.")
        if type(singleshp) is not robjects.RObject: 
          shapefiles.extend(singleshp)
    except Exception, e: 
      QMessageBox.information(self.parent, "Home range analysis", "R error (please consult its documentation) is:\n" + str(e))
    return shapefiles
  
