# -*- coding: utf-8 -*-

"""
/***************************************************************************
 HTML_Generator
                                 A QGIS plugin
 HTML single or multi page generator
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-11-18
        copyright            : (C) 2020 by Giulio
        email                : giulio.fattori@tin.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giulio Fattori'
__date__ = '2020-11-18'
__copyright__ = '(C) 2020 by Korto19'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
					   QgsProcessingParameterField,
					   QgsProcessingParameterFile,
					   QgsProcessingParameterExpression,
					   QgsProcessingParameterDefinition,
					   QgsProcessingParameterBoolean,
					   QgsFeatureRequest,
					   QgsExpression,
					   QgsProcessingParameterFileDestination,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)
import re
import processing
from pathlib import Path

#senza questo non puoi vedere il progetto
from  qgis.core  import  QgsProject

#questo per l'icona dell'algoritmo di processing
import os
import inspect
from qgis.PyQt.QtGui import QIcon

class HTML_GeneratorAlgorithm(QgsProcessingAlgorithm):
    """
    Algorithm that make an HTML page or pages
    """
    INPUT_L   = 'INPUT_L'    #layer dati
    INPUT_F   = 'INPUT_F'    #campi per html
    GROUP_BY  = 'GROUP_BY'   #espressione filtro
    INPUT_T   = 'INPUT T'    #titolo pagina
    INPUT_I   = 'INPUT_I'    #icona
    INPUT_S   = 'INPUT_S'    #foglio di style
    INPUT_ABS = 'INPUT_ABS'  #percorso relativo si/no
    INPUT_P   = 'INPUT_P'    #pie' di pagina interattivo
    
    OUTPUT_H = 'OUTPUT_H'
    
    def tr(self, string):
        """
        Returns a translatable string with the self.tr() function.
        """
        return QCoreApplication.translate('Processing', string)
		
		#icona dell'algoritmo di processing
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'icon.png')))
        return icon

    def createInstance(self):
        return HTML_GeneratorAlgorithm()

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Html Generator'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Html Generator')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("Produce uno o più file html basati su un CSS utilizzabili in una cornice HTML del composer\n\
        <mark style='color:blue'><strong>OPZIONI</strong></mark>\n\
        <i>- Filtro sui campi\n\
        - Fogli multipli in funzione di un campo selezionato nel filtro con possibilità di intestazione e piè pagina interattivi\n\
        - Foto o icona e/o titolo nell'intestazione\n\
        - Percorsi assoluti / relativi</i>\n\
        <mark style='color:black'><strong>NOTA BENE</strong></mark>\n\
        <mark style='color:black'><strong>Le impostazioni dell'aspetto della pagina sono impostate dal foglio di stile Standard.css</strong></mark>\n\
        <mark style='color:black'><strong>I campi con immagini devono contenere il nome con estensione es: image.jpg</strong></mark>\n\
        <strong>I campi con immagini possono contenere anche il percorso relativo o assoluto\n\
        <strong>Le dimensioni delle immagini sono impostate nel file CSS\n\
        <strong>Trascinando i campi nel selettore campi per HTML è possibile riordinarli\n\
        <strong>Selezionare intestazioni / piè di pagina interattivi per navigare fra i fogli prodotti\n\
        <strong>Selezionare riferimenti relativi consente il trasferimento del progetto, in tal caso:\n\
        <mark style='color:green'><strong>LE CARTELLE ED I RELATIVI FILE DEVONO ESSERE NELLA CARTELLA DI PROGETTO</strong></mark>\n\
        <p><mark style='color:red'>E' possibile includere nel progetto il file HTML e il CSS relativo incollando il sorgente HTML\
        nella casella<i><strong>'Sorgente'</i></strong> delle proprietà della cornice HTML</mark></p>\n\
        ")

    
    def initAlgorithm(self, config=None):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        # We add the point input vector features source
        #QgsProcessingFeatureSourceDefinition 
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT_L,
                self.tr('Input sorgente dati'),
                [QgsProcessing.TypeMapLayer],
            )
        )
        
        self.addParameter(
            QgsProcessingParameterField(
                self.INPUT_F,
                self.tr('Selezionare i campi da inserire nel file Html'),
                allowMultiple = True,
                parentLayerParameterName=self.INPUT_L
            )
        )
        
        # We add the input css
        self.addParameter(
            QgsProcessingParameterFile(
                self.INPUT_S,
                'Foglio di stile CSS',
                behavior=QgsProcessingParameterFile.File, fileFilter='Css file (*.css)',
                optional = False
            )
        )
        
        GROUP_BY = QgsProcessingParameterExpression(
                self.GROUP_BY,
                self.tr('Espressione filtro'),
                optional = True,
                parentLayerParameterName=self.INPUT_L,
            )
        GROUP_BY.setFlags(GROUP_BY.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(GROUP_BY)
        
        INPUT_P = QgsProcessingParameterBoolean(
                self.INPUT_P,
                self.tr('Intestazione e pié di pagina interattivi [solo html multipli]'),
                optional = True,
                defaultValue = 0,
            )
        INPUT_P.setFlags(INPUT_P.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(INPUT_P)
        
        INPUT_T = QgsProcessingParameterExpression(
                self.INPUT_T,
                self.tr('Titolo pagina'),
                optional = True,
                parentLayerParameterName=self.INPUT_L
            )
        INPUT_T.setFlags(INPUT_T.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(INPUT_T)
        
        # We add the input icon source
        INPUT_I = QgsProcessingParameterFile(
                self.INPUT_I,
                'Icona Gruppo',
                behavior=QgsProcessingParameterFile.File, fileFilter='Image file (*.gif; *.jpeg; *.jpg; *.png; *.svg)',
                optional = True
            )
        INPUT_I.setFlags(INPUT_I.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(INPUT_I)


        # We add a file output of type HTML
        self.addParameter(
            QgsProcessingParameterFileDestination(
                self.OUTPUT_H,
                self.tr('Tabella HTML'),
                'HTML files (*.html)',
            )
        )
        
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.INPUT_ABS,
                'Percorsi file relativi [solo se  file NON temporaneo/i]',
                0
            )
        )
        

        
    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        sourceL = self.parameterAsSource(
            parameters,
            self.INPUT_L,
            context)
        
        sourceF = self.parameterAsMatrix(
            parameters,
            self.INPUT_F,
            context)
        
        filtro = self.parameterAsString(
            parameters,
            self.GROUP_BY,
            context)
        
        titolo = self.parameterAsString(
            parameters,
            self.INPUT_T,
            context)
    
        html = self.parameterAsFileOutput(
            parameters,
            self.OUTPUT_H,
            context)
         
        source_path = self.parameterAsString(
            parameters,
            self.INPUT_L,
            context)
        
        icona = self.parameterAsString(
            parameters,
            self.INPUT_I,
            context)
        
        fogliocss = self.parameterAsString(
            parameters,
            self.INPUT_S,
            context)
            
        rel_path = self.parameterAsBool(
            parameters,
            self.INPUT_ABS,
            context)
            
        pie_p = self.parameterAsBool(
            parameters,
            self.INPUT_P,
            context)
        
        def html_composer(sourceL, sourceF, filtro, titolo, html, source_path, icona, fogliocss, rel_path, partizione, values, valori):
            ''' COMPOSIZIONE PAGINA HTML '''         
            #FASE #01 - cerco la path del progetto
            if QgsProject.instance().homePath():
                path_proj = QgsProject.instance().homePath()
                #windowizzo la path quale che sia
                path_proj = str(Path(path_proj))
                #rimuovo geopakage: se presente
                path_proj = path_proj.replace('geopackage:','')
            else:
                feedback.reportError('WARNING NO PROJECT PATH: the html file may not work correctly\n')
                path_proj = ''
            #tolgo %20 e metto spazio 
            path_proj = path_proj.replace('%20',' ')
            
            #FASE #02 - cerco la path del file di input
            path_file = (self.parameterDefinition('INPUT_L').valueAsPythonString(parameters['INPUT_L'], context))
            path_file = path_file[1:path_file.rfind('/')+1]
            if 'memory' in path_file:
                file_mem = True
                path_file = ''
            else:
                file_mem = False
                #windowizzo la path quale che sia
                path_file = str(Path(path_file))

            #tolgo %20 e metto spazio 
            path_file = path_file.replace('%20',' ')
            
            #FASE #03 - scelgo la path da usare tra le due: prioritaria quella di progetto
            if path_proj:
                path_dir = path_proj
                if path_proj not in path_file and path_file != '':
                    feedback.reportError('WARNING PATH FILE ' + path_file)
                    feedback.reportError('OUTSIDE PROJECT PATH ' + path_proj)
                    feedback.reportError('MOST LIKELY IT WON''T WORK' + '\n')
                elif path_file == '':
                    feedback.reportError('WARNING TEMPORARY LAYER WITHOUT PATH\n')
            else:
                path_dir = path_file
                if path_dir:
                    feedback.reportError('WARNING use the path of the input file ' + path_dir + '\n')
                else:
                    feedback.reportError('WARNING TEMPORARY LAYER WITHOUT PATH\n')
            
            #FASE #04 - controllo se si sta salvando file con percorsi relativi nella cartella di progetto
            if path_dir not in str(Path(html)) and 'processing' not in str(Path(html)):
                 feedback.reportError('WARNING HTML WITH RELATIVE PATH SAVED OUTSIDE THE PROJECT PATH DOES NOT WORK PROPERLY\n')
            if 'processing' in str(Path(html)):
                 feedback.reportError('WARNING TEMPORARY HTML WORK PROPERLY ONLY WITH ABSOLUTE PATH\n')
                 
            #FASE #05 - controllo se icona e css sono entro la cartella progetto
            if fogliocss and (path_dir not in fogliocss):
                feedback.reportError('WARNING css PATH OUTSIDE PROJECT PATH: the html file may not work correctly\n')
            if icona and path_dir not in icona:
                feedback.reportError('WARNING icon PATH OUTSIDE PROJECT PATH: the html file may not work correctly\n')
            
            #FASE #06 - aggiungo terminatore di percorso se non è un file temporaneo
            if path_dir != '':
                path_dir = path_dir + '\\'
            
            #FASE #07 - modifica se csv in input
            if source_path.find(".csv"):
                source_path = 'file:///' + source_path[0:source_path.rfind('/')+1]
             
            #FASE #08 pulisco titolo e riordino a causa di un bug 
            titolo = titolo.replace('\"','')
            
            intestazione = titolo.replace('"','')
            intestazione = titolo.replace('\'','')
            
            #riordino campi come da selezione per bug 
            cleanlist = []
            [cleanlist.append(x) for x in sourceF if x not in cleanlist]
            sourceF = cleanlist
            
            #FASE #09 - inizializzo variabile per barra % esecuzione script
            # Compute the number of steps to display within the progress bar and
            # get features from source
            total = 100.0 / sourceL.featureCount() if sourceL.featureCount() else 0
            
            #FASE #10 - filtra dati se richiesto
            if len (filtro) > 0:
                request = QgsFeatureRequest(QgsExpression(filtro))
                features = sourceL.getFeatures(request)
            else:
                features = sourceL.getFeatures()
            
            #FASE #11 - produco il file in uscita
            with open(html, 'w') as output_file:
                # write header
                line = '<html>\r'
                output_file.write(line)
                
                #FASE #11.01 - se richiesto inserisco foglio css
                if fogliocss:
                    if not rel_path or 'processing' in html:
                        fogliocss = 'file:///' + fogliocss
                    else:
                        fogliocss = str(Path(fogliocss))
                        fogliocss = fogliocss.replace(path_dir,'')
                    line = '<head>\r<link rel="stylesheet" href="'+ fogliocss + '">\r</head>'
                    output_file.write(line)
                
                #FASE #11.02 - se richiesto inserisco icona e titolo
                if icona or titolo:
                    line = '<div>'
                    output_file.write(line)
                    if icona:
                        if not rel_path or 'processing' in html:
                            icona = 'file:///' + icona
                        else:
                            icona = str(Path(icona))
                            icona = icona.replace(path_dir,'')
                        line = '<img class="zoom" src="' + icona + '">' #'" style="width:' + wi + ';height:' + hi + ';">'
                        output_file.write(line)
                        line = ''
                    if titolo:
                        if icona:
                            line = line + '<b>' + '&nbsp&nbsp' + titolo + '</b>'
                        else:
                            line = line + '<b>' + titolo + '</b>'
                        output_file.write(line)
                    line = '</div>'
                    output_file.write(line)
                    line = None
                
                #FASE #11.03 - compongo tabella
                line = '<table class="Table">'
                output_file.write(line)
                
                #FASE #11.04 - inserisco testata pagina se ho più di una pagina
                if values and pie_p:
                    if rel_path and 'processing' not in html:
                        html = str(Path(html))
                        html = html.replace(path_dir,'')
                    feedback.pushInfo('Done: ' + html + '\n')    
                    line = '<caption>' + str(valori) + '</caption><thead id="h"><tr><td colspan="' + str(sourceL.featureCount()) + '"><div class="links">'
                    output_file.write(line)
                    for i in range (0, len(values)):
                        html = re.sub('_[0-9]{2,3}(.html)','_0' + str(i) + '.html', html)
                        if i == 0:
                            line = '<a href="' + html + '">&laquo;</a>'
                            output_file.write(line)
                        try:
                            valore_ins = values[i].toString('dd.MM.yyyy')
                        except:
                            valore_ins =  str(values[i])
                        line = '<a href="' + html + '">' + partizione + ': ' + valore_ins + '</a>'
                        output_file.write(line)
                    line = '<a href="' + html + '">&raquo;</a></div></td></tr></thead>'
                    output_file.write(line)
                
                line = '<thead>\r<tr>\r'
                output_file.write(line)
                
                #titoli colonne
                line = ''.join(('<th style="width:auto">'+ str(name)+ '</<th>\r') for name in sourceF) + '</tr>\r'
                output_file.write(line)
                
                line = '</thead>\r<tbody>\r'
                output_file.write(line)
                
                #righe tabella
                for current, f in enumerate(features):
                    line = '<tr>\r'
                    output_file.write(line)
                    
                    for name in sourceF:
                        #controllo se si tratta di una immagine
                        try:
                            img_type = f[name].split(".")
                            img_type = img_type[len(img_type)-1]
                        except:
                            img_type = ''
                            
                        #se è un'immagine e/o ha un percorso
                        if img_type in ["JPEG","jpeg","JPG","jpg","PNG","png"]:
                            #se non è un file temporaneo o non voglio riferimenti relativi
                            if not rel_path or 'processing' in html:
                                if file_mem:
                                    img_name = ''
                                else:
                                    img_name = 'file:///'
                                if path_dir not in str(Path(f[name])):
                                    img_name = img_name + path_dir
                                img_name = img_name + f[name]
                            else:
                                #se voglio riferimenti relativi
                                img_name = str(Path(f[name]))
                                img_name = img_name.replace(path_dir,'')
                            line = ''.join('<td><center><img class="zoom" src ='+ "'" + img_name + "'" + 'alt='+ "'" + img_name + "'" + '"></center></td>\r')    #+ 'width="' + wf + '" height="' + hf +
                        else:
                            try:
                                line = ''.join('<td>'+f[name].toString("dd.MM.yyyy")+ '</td>\r')
                            except:
                                line = ''.join('<td>'+ str(f[name]) + '</td>\r')
                        output_file.write(line)
                    
                    line = '</tr>\r'
                    output_file.write(line)

                    # Update the progress bar
                    feedback.setProgress(int(current * total))
                
                #FASE #11.05 - inserisco piè di pagina se ho più di una pagina
                if values and pie_p:
                    if rel_path and 'processing' not in html:
                        html = str(Path(html))
                        html = html.replace(path_dir,'')
                    feedback.pushInfo('Done: ' + html + '\n')    
                    line = '<tfoot><tr><td colspan="' + str(sourceL.featureCount()) + '"><div class="links">'
                    output_file.write(line)
                    for i in range (0, len(values)):
                        html = re.sub('_[0-9]{2,3}(.html)','_0' + str(i) + '.html', html)
                        if i == 0:
                            line = '<a href="' + html + '">&laquo;</a>'
                            output_file.write(line)
                        try:
                            valore_ins = values[i].toString('dd.MM.yyyy')
                        except:
                            valore_ins =  str(values[i])
                        line = '<a href="' + html + '">' + partizione + ': ' + valore_ins + '</a>'
                        output_file.write(line)
                    line = '<a href="' + html + '">&raquo;</a></div></td></tr></tfoot>'
                    output_file.write(line)
                
                line = '</tbody>\r</table>\r</html>'
                output_file.write(line)
            
            output_file.close()
            return {self.OUTPUT_H: html}
        
        # INIZIO ELABORAZIONE
        if filtro and "'" in filtro or not filtro:
            partizione = 0
            values = ''
            valori = ''
            risultato = html_composer(sourceL, sourceF, filtro, titolo, html, source_path, icona, fogliocss, rel_path, partizione, values, valori)
        elif filtro:
            partizione = filtro[1:len(filtro)-1]
            idx = sourceL.fields().indexOf(partizione)
            values = sourceL.uniqueValues(idx)
            pagine = len(values)
            values = sorted(values)
            for current, valori in enumerate(values):
                try:
                    valori = valori.toString("yyyy-MM-dd")
                except:
                    pass
                if valori:
                    N_Filter ="\"" + partizione + "\"" + ' = ' + "'" + str(valori) + "'"
                else:
                    N_Filter ="\"" + partizione + "\"" + " is None"
                filtro = N_Filter
                finale = html.replace(".html", "_0" + str(current)+".html")
                risultato = html_composer(sourceL, sourceF, filtro, titolo, finale, source_path, icona, fogliocss, rel_path, partizione, values, valori)
                filtro = ""
                
        return{self.OUTPUT_H: risultato['OUTPUT_H']}