# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GroupAndSortLayer
                                 A QGIS plugin
 Group and Sort Layer in TOC
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-04-20
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Giulio Fattori
        email                : giulio.fattori@tin.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QDialog

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .GroupAndSortLayer_dialog import GroupAndSortLayerDialog
import os.path

import datetime
from qgis.utils import iface
from qgis.core import QgsApplication, QgsProject, QgsMapLayerType, QgsLayerTreeGroup, QgsMessageLog, QgsExpressionContextUtils
from qgis.gui import QgsMessageBar
from collections import OrderedDict



class GroupAndSortLayer:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GroupAndSortLayer_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Group and Sort Layer')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GroupAndSortLayer', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        checkable=False,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        menu=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        #action.setCheckable(checkable)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/GroupAndSortLayer/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Layers && Group Sort'),
            callback=self.run,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/GroupAndSortLayer/group.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Group Sort Asc && Desc'),
            #checkable=True,
            callback=self.group_sort,
            parent=self.iface.mainWindow()
        )
        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Group and Sort Layer'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # ORDINAMENTO ALFANUMERICO PER TIPO E PER NOME ASCENDENTE
        # per decrescente porre reverse = True alla linea 270
        # crea i gruppi se non esistono ed elimina quelli vuoti
        # conta i layer scansionati per tipo
        # ricordarsi che è un ordinamento alfabetico !!
        # python 3 - Giulio Fattori - 02.04.2019 - Update 30.01.2020

        #funzione per la rimozione dei gruppi vuoti
        def remove_empty_groups(group):
            for child in group.children():
              if isinstance(child, QgsLayerTreeGroup):
                 remove_empty_groups(child)
            if len(group.children()) == 0:
                root.removeChildNode(group)
            else:
                group.setExpanded(False)

        #inizializzo variabile per tempo impiegato e recupero contenuto root
        current_time = datetime.datetime.now()
        root = QgsProject.instance().layerTreeRoot()
        layers = QgsProject.instance().mapLayers()

        #eseguo solo se ci son layer
        if len(layers)!=0:

            #inizializzo contatori
            count_point = 0
            count_line = 0
            count_poly = 0
            count_table = 0
            count_raster = 0
            
            #creo i gruppi destinazione
            if root.findGroup("Group Point") is None:
                        g_poi= root.insertGroup(0, "Group Point")
            if root.findGroup("Group Line") is None:
                        g_lin=root.insertGroup(1, "Group Line")
            if root.findGroup("Group Polygon") is None:
                        g_pol=root.insertGroup(2, "Group Polygon")
            if root.findGroup("Group Table") is None:
                        g_tab=root.insertGroup(3, "Group Table")
            if root.findGroup("Group Raster") is None:
                        g_ras=root.insertGroup(4, "Group Raster")
        
            #inizializzo variabili di tipo
            wkbtype_point = (1,1001,2001,3001,-2147483647,4,1004,2004,3004)
            wkbtype_line  = (2,1002,2002,3002,-2147483646,5,1005,2005,3005)
            wkbtype_poly  = (3,1003,2003,3003,-2147483645,6,1006,2006,3006)
            wkbtype_table = (0,100)

            #trovo layer e li sposto nel gruppo di destinazione
            for layer in layers.values():
                myblayer = root.findLayer(layer.id())
                myClone = myblayer.clone()
                parent = myblayer.parent()
                if layer.type() is QgsMapLayerType.VectorLayer:
                    if layer.wkbType()in wkbtype_point:
                        root.findGroup("Group Point").insertChildNode(1, myClone)
                        count_point += 1
                    if layer.wkbType()in wkbtype_line:
                        root.findGroup("Group Line").insertChildNode(2, myClone)
                        count_line += 1
                    if layer.wkbType() in wkbtype_poly:
                        root.findGroup("Group Polygon").insertChildNode(3, myClone)
                        count_poly += 1
                    if layer.wkbType() in wkbtype_table:
                        root.findGroup("Group Table").insertChildNode(4, myClone)
                        count_table += 1
                if layer.type() is QgsMapLayerType.RasterLayer:
                        root.findGroup("Group Raster").insertChildNode(5, myClone)
                        count_raster += 1
                        
                parent.removeChildNode(myblayer)
        
            #rimuovo la copia del layer fuori dal gruppo
            for child in root.children():
                if isinstance(child, QgsLayerTreeGroup):
                    lyrList = [c.layer() for c in child.children()]
                    lyrSortList = sorted(lyrList, key=lambda x: x.name(),reverse=False)
                    for idx, lyr in enumerate(lyrSortList):
                        treeLyr = child.insertLayer(idx, lyr)
                    child.removeChildren(len(lyrList),len(lyrList))

            #ripulisco se son vuoti e contraggo gruppi
            remove_empty_groups(root)

            #recupero tempo impiegato e totale layer elaborati
            current_time = datetime.datetime.now() - current_time
            totale= count_point+count_line+count_poly+count_table+count_raster

            #Messaggio di riepilogo a fine elaborazione
            msg = QMessageBox()
            msgtext= f'Done in {current_time}'
            msgtext= msgtext + f'\nSort {totale} layers'
            msg.setText(msgtext)
            msg.setWindowTitle ("Group and Sort Layer")
            string= f'Point\tlayer n :\t{count_point}'
            string= string + f'\nLine\tlayer n :\t{count_line}'
            string= string + f'\nPoly\tlayer n :\t{count_poly}'
            string= string + f'\nTable\tlayer n :\t{count_table}'
            string= string + f'\nRaster\tlayer n :\t{count_raster}'
            msg.setDetailedText(string)
            msg.setIcon(QMessageBox.Information)
            msg.exec()
            
            #Utima avvertenza
            iface.messageBar().pushMessage("WARNING", "If you save it becomes permanent",1)
            
        else:
        
            #Nessun layer o gruppo
            iface.messageBar().pushMessage("WARNING", "Empty project",2,3)
            
    def group_sort(self):
    
        project = QgsProject.instance()
        try:
            if QgsExpressionContextUtils.projectScope(project).variable('rev') == False:
                QgsExpressionContextUtils.setProjectVariable(project,'rev', True)
                sort_order = 'descending'
            else:
                QgsExpressionContextUtils.setProjectVariable(project,'rev', False)
                sort_order = 'ascending'

        except:
            QgsExpressionContextUtils.setProjectVariable(project,'rev', False)

        
        try:
            root = QgsProject.instance().layerTreeRoot()
            group_sel = iface.layerTreeView().selectedNodes()
            group = root.findGroup(group_sel[0].name())

            rev = QgsExpressionContextUtils.projectScope(project).variable('rev')

            LyrInGroup = lambda listCh:{listCh[lyr[0]].name()+str(lyr[0]):lyr[1] for lyr in enumerate(listCh)}
                
            lyr_names = LyrInGroup(group.children())
            lyr_keys = OrderedDict(sorted(LyrInGroup(group.children()).items(), reverse = rev)).keys()

            lyr_sorted = [lyr_names[k].clone() for k in lyr_keys]
            group.insertChildNodes(0,lyr_sorted)
            for n in lyr_names.values():
                group.removeChildNode(n)
            
            iface.messageBar().pushMessage("WARNING", "Group Ordered " + sort_order.upper() + " - If you save it becomes permanent",1)
            
        except:
            iface.messageBar().pushMessage("ERROR", "Empty project or Not a Group",2,3)