# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GroundwaterVulnerability
                                 A QGIS plugin
 Groundwater Vulnerability Mapping (GLA method)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-10-29
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Christian Böhnke
        email                : christian@home-boehnke.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QUrl
from PyQt5.QtGui import QIcon, QDesktopServices
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, QgsMapLayer, QgsRasterLayer

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
import os.path

from .gla_main import GLAMethod


class GroundwaterVulnerability:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GroundwaterVulnerability_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.gla = GLAMethod()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Groundwater Vulnerability')
        self.help = self.tr(u'&Help')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'GroundwaterVulnerability')
        self.toolbar.setObjectName(u'GroundwaterVulnerability')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GroundwaterVulnerability', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
        icon = QIcon(icon_path)

        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action_gla.setStatusTip(status_tip)

        if whats_this is not None:
            action_gla.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path_gla = '{}/icons/gla.png'.format(self.plugin_dir)
        icon_path_help = '{}/icons/help.png'.format(self.plugin_dir)
        
        self.add_action(
            icon_path_gla,
            text=self.tr(u'Groundwater Vulnerability'),
            callback=self.run_gla,
            parent=self.iface.mainWindow())

        self.add_action(
            icon_path_help,
            text=self.tr(u'Help'),
            callback=self.show_help,
            parent=self.iface.mainWindow())
    

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Groundwater Vulnerability'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def fill_comboboxes(self):
        """
        Populates the ComboBox with all layers of the given geometry type geom_type, and sets
        currentIndex to the entry named index.

        :param geom_type: geomTypes, valid argument is 0: point, 1: line, 2: polygon
        :type geom_type: int
        :param item: name of the ComboBox entry to set currentIndex to
        :type item: str
        :return: None
        """

        self.gla.cmb_awc.clear()
        self.gla.cmb_perc.clear()
        self.gla.cmb_perched.clear()
        self.gla.cmb_art.clear()

        self.gla.cmb_awc.addItem('', '')
        self.gla.cmb_perc.addItem('', '')
        self.gla.cmb_perched.addItem('', '')
        self.gla.cmb_art.addItem('', '')

        self.get_layers()

        if len(self.layer_dict) > 0:
            for key in self.layer_dict:
                self.gla.cmb_awc.addItem(self.layer_dict[key]['name'], self.layer_dict[key]['path'])
                self.gla.cmb_perc.addItem(self.layer_dict[key]['name'], self.layer_dict[key]['path'])
                self.gla.cmb_perched.addItem(self.layer_dict[key]['name'], self.layer_dict[key]['path'])
                self.gla.cmb_art.addItem(self.layer_dict[key]['name'], self.layer_dict[key]['path'])

    def get_layers(self):
        self.layer_dict = {}

        for tree_layer in QgsProject.instance().layerTreeRoot().findLayers():
            layer = tree_layer.layer()

            if layer.type() == QgsMapLayer.RasterLayer:
                self.layer_dict[str(layer.id())] = {'path':layer.source(), 'name':layer.name()}

    def run_gla(self):
        """Run method that performs all the real work"""
        self.fill_comboboxes()
        self.iface.mapCanvas().layersChanged.connect(self.fill_comboboxes)
        #self.gla.btn_help.connect(self.show_help)

        # show the dialog
        self.gla.show()
        # Run the dialog event loop
        result = self.gla.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def show_help(self):
        '''Display plugin help to the user.'''
        help_file = 'file:///{}/help/index.html'.format(self.plugin_dir)
        QDesktopServices.openUrl(QUrl(help_file))
