# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeopaparazziTagsDialog
                                 A QGIS plugin
 convert data from geopaparazzi
                             -------------------
        begin                : 2013-05-31
        copyright            : (C) 2013 by pierluigi de rosa
        email                : pierluigi.derosa@gfosservices.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from os import path,listdir

from datetime import datetime


class ProcessMEDIA:
    
    def __init__(self):
        '''Process Media folder from geopaparazzi'''
      

    def listMediaData(self,mediaFolder,prefix):
        mediaFolder=str(mediaFolder)
        outputList = list()
       #############
        AllPropertiesFiles = [ f for f in listdir(mediaFolder) if f.endswith('properties')]
        AllFilterFiles = [f for f in AllPropertiesFiles if f.startswith(prefix)]
        
        for fileID in AllFilterFiles:
            FileProperties = open(path.join(mediaFolder,str(fileID)),'r')
            #~ parsing file properties
            content = FileProperties.read()
            dataImage = [f.split('=')[-1] for f in content.splitlines()]
            dataImageFormat = [float(f) for f in dataImage[:-1]]
            utc = datetime.strptime(dataImage[-1], '%Y%m%d_%H%M%S')
            dataImageFormat.append(utc.strftime("%H:%M:%S %Y-%m-%d"))
            dataImageFormat.append(fileID.replace('.properties',''))
            outputList.append(dataImageFormat)
            
        return outputList 
    

      
        
        
