# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeopaparazziTagsDialog
                                 A QGIS plugin
 convert data from geopaparazzi
                             -------------------
        begin                : 2013-05-31
        copyright            : (C) 2013 by pierluigi de rosa
        email                : pierluigi.derosa@gfosservices.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from pykml import parser
import zipfile
from lxml import objectify
from lxml import etree
from lxml.html import *
from os import path,listdir
import tempfile
from datetime import datetime


class ProcessKMZ:
    
    def __init__(self):
		'''Process KMZ file, converting to KML and reading'''
    
    def parseFields(self,listString)    :
        fieldParsed=list()
        compactField = dict((i,listString.count(i)) for i in listString)
        status = dict((i,0) for i in listString)
        #~ fields control in case of duplicated (or more) attribute names
        for field in listString:
            if compactField[field] == 1:
                fieldParsed.append(field)
            else:
                newField=field[:6]+str(status[field])
                fieldParsed.append(newField)
                status[field]=status[field]+1

        return fieldParsed
                 
    
    def unzip(self,KMZfile):
        zfile = zipfile.ZipFile(KMZfile,'r')
        for zip_file in zfile.namelist():
            zfile.extract(zip_file, tempfile.gettempdir())
        zfile.close()
    
    def selPlacemark(self):
         kml_file = path.join(tempfile.gettempdir()+'/kml.kml')
         root = parser.parse(kml_file).getroot()
         # tipology is the dictionary that stores type of data into kml
         placemarkInfo = dict()
         # select id placemark corresponding to the correct type
         for id_iter in range(len(root.Document.Placemark)):
             if hasattr(root.Document.Placemark[id_iter],'LineString'):
                 placemarkInfo.setdefault('track',[]).append(id_iter)
             if hasattr(root.Document.Placemark[id_iter],'Point') and  hasattr(root.Document.Placemark[id_iter],'description') :
                 if root.Document.Placemark[id_iter].styleUrl != '#bookmark-icon' :
                     data = root.Document.Placemark[id_iter].description
                     dataList = fragments_fromstring(data.text)
                     '''check description tab content'''
                     if all(type(n) is str for n in dataList):
                         placemarkInfo.setdefault('note text',[]).append(id_iter)
                     else:
                         '''in this case description contain html fragments'''
                         if 'table' in [element.tag for element in dataList]:
                             placemarkInfo.setdefault(str(root.Document.Placemark[id_iter].name),[]).append(id_iter)
                         #~ if 'img' in [element.tag for element in dataList]:
                             #~ placemarkInfo.setdefault('note image',[]).append(id_iter)
         return placemarkInfo
        
    def grabKML(self,id_point):
         fields=list()
         coordList=list()
         kml_file = path.join(tempfile.gettempdir()+'/kml.kml')
         #~ with open(kml_file) as f:
             #~ doc = parser.parse(f)
         root = parser.parse(kml_file).getroot()
         #~ to get fieldsname we use the first value of selected placemark
         data = root.Document.Placemark[id_point[0]].description
         dataList = fragments_fromstring(data.text)
         dataTableList = []
         for element in dataList:
             if element.tag == 'table':
                 dataTableList.append(element)
         for row in dataTableList[0].xpath('//table/tbody/tr'): #row entry
                 if row[0].text != None:
                     fields.append(row[0].text)
         #~ remove the primary key field
         #~ fields=[k for k in fields if 'Primary key' not in k]
         
         #~ to get coordinates points
         for pointElem in id_point:
             coord = root.Document.Placemark[pointElem].Point.coordinates
             PointInfo =  str(coord).split(',')[0:-1]
             data = root.Document.Placemark[pointElem].description
             dataList = fragments_fromstring(data.text)
             IDtables = list()
             for IDelement in dataList:
                 if IDelement.tag == 'table':
                     IDtables.append(IDelement)
             
             AllAttr = [row[-1].text for row in IDtables[0].xpath('//table/tbody/tr')]
             PointInfo.append(AllAttr)        
             #~ PointInfo.append(filter(None, AllAttr))
             coordList.append(PointInfo)        
         
         return fields,coordList         

    def grabKMLnote(self,id_note):
         noteCoord = list()
         dateText = list()
         kml_file = path.join(tempfile.gettempdir()+'/kml.kml')
         #~ with open(kml_file) as f:
             #~ doc = parser.parse(f)
         root = parser.parse(kml_file).getroot()
         
         for noteElem in id_note:
             coord = root.Document.Placemark[noteElem].Point.coordinates
             PointInfo =  str(coord).split(',')[0:-1]
             noteCoord.append(PointInfo)
             
             dateNote=str(root.Document.Placemark[noteElem].description)
             dateNote = dateNote.strip()
             nameText = root.Document.Placemark[noteElem].name
             nameText = unicode(nameText)
             dateText.append([str(nameText.encode('latin1') ) ,dateNote])
             
         return dateText,noteCoord

    def grabKMLtrack(self,id_track):
         lineList = list()
         nameTrack = list()
         kml_file = path.join(tempfile.gettempdir()+'/kml.kml')
         #~ with open(kml_file) as f:
             #~ doc = parser.parse(f)
         root = parser.parse(kml_file).getroot()
         
         for lineElem in id_track:
             line = root.Document.Placemark[lineElem].LineString.coordinates
             lineInfo=str(line).split('\n')[1:-1]
             lineList.append(lineInfo)
             nameTrack.append(str(root.Document.Placemark[lineElem].name))
         return nameTrack,lineList             
