# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeopaparazziTagsDialog
                                 A QGIS plugin
 convert data from geopaparazzi
                             -------------------
        begin                : 2013-05-31
        copyright            : (C) 2013 by pierluigi de rosa
        email                : pierluigi.derosa@gfosservices.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.core import *
from qgis.gui import *

from ui_geopaparazzitags import Ui_GeopaparazziTags
from tool.processkmz import *
from tool.processmedia import *
import webbrowser
from os import path



class GeopaparazziTagsDialog(QDialog):
    def __init__(self,iface):
        QDialog.__init__(self)
        self.iface = iface
        self.canvas = iface.mapCanvas()
        # Set up the user interface from Designer.
        self.ui = Ui_GeopaparazziTags()
        self.ui.setupUi(self)
        
        '''some global variables'''
        self.ShpFileFolder = None
        self.outputMedia = None
        
        self.ui.kmzFileEdit.setText(str())
        self.ui.ShpLineEdit.setText(str())
        
        #~ set action to run when kml load button is pressed
        QObject.connect(self.ui.selectKmzBtn, SIGNAL( "clicked()" ), self.loadKmzLayer)
        QObject.connect(self.ui.buttonBox, SIGNAL( "accepted()" ), self.saveLayer)
        QObject.connect(self.ui.buttonBox, SIGNAL( "helpRequested()" ), self.helpMedia)
        QObject.connect(self.ui.SaveShpButton, SIGNAL( "clicked()" ), self.writeLayer)
        
        QObject.connect(self.ui.MediaFolderBtn, SIGNAL( "clicked()" ), self.loadMediaFolder)
        QObject.connect(self.ui.OutputFolderBtn, SIGNAL( "clicked()" ), self.writeMediaFolder)
        QObject.connect(self.ui.exportButton, SIGNAL( "accepted()" ), self.exportMediaFolder)
        QObject.connect(self.ui.exportButton, SIGNAL( "helpRequested()" ), self.helpMedia)

    def loadKmzLayer(self):
        '''allows to select KMZ vector file'''
        #~ set the extension for required file
        kmzFilter=str('''(*.kmz *.KMZ)''')
        # open dialog to select file
        filename = QFileDialog.getOpenFileName(self, str(QCoreApplication.translate( "dialog", "Select KMZ layer")), str(), kmzFilter)
        if not filename:
			return
        # show path to selected file
        self.ui.kmzFileEdit.setText(filename)
        ProcessKMZ().unzip(str(filename))
        tipology = ProcessKMZ().selPlacemark()
        #~ fill the qtablebox with type of elements in kml
        self.ui.tableWidget.setRowCount(len(tipology))
        #~ definisco la larghezza della colonna che sia massima
        header = self.ui.tableWidget.horizontalHeader()
        header.setStretchLastSection(True)
        indTable=0
        for k,v in tipology.items():
            chkBoxItem = QTableWidgetItem()
            ItemName = QTableWidgetItem()
            ItemName.setText(k)
            descItem= QTableWidgetItem()
            descItem.setText(str(len(v))+QCoreApplication.translate( "dialog",' elements'))
            chkBoxItem.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled)
            chkBoxItem.setCheckState(Qt.Checked) 
            chkBoxItem.setText( k )
            self.ui.tableWidget.setItem(indTable,0,chkBoxItem)
            self.ui.tableWidget.setItem(indTable,1,ItemName)
            self.ui.tableWidget.setItem(indTable,2,descItem)
            indTable=indTable+1

        
    def writeLayer(self):
        outputfolder = QFileDialog.getExistingDirectory(self,str(QCoreApplication.translate( "dialog","Select Output Directory")),str(),QFileDialog.ShowDirsOnly)
        self.ui.ShpLineEdit.setText(outputfolder)
        self.ShpFileFolder = self.ui.ShpLineEdit.text()
        
    def saveLayer(self):
        if self.ShpFileFolder == None:
            QMessageBox.critical(self.iface.mainWindow(),QCoreApplication.translate( "message","Error"), QCoreApplication.translate( "message","You have to select output folder file first"))
        else:
            #~ again I get type of placemark
            tipology = ProcessKMZ().selPlacemark()            
            for IDPmk in range(self.ui.tableWidget.rowCount()):                 
                if self.ui.tableWidget.item(IDPmk, 0).checkState()==Qt.Checked:
                    typePmk = self.ui.tableWidget.item(IDPmk, 0).text()
                    typePmk=str(typePmk)
                    if typePmk == 'track':
                        (nameTrack,lines) = ProcessKMZ().grabKMLtrack(tipology[typePmk])
                        #~ create qgis layer
                        vlName=self.ui.tableWidget.item(IDPmk, 1).text()
                        vl = QgsVectorLayer("LineString?crs=epsg:4326", str(vlName), "memory")
                        pr = vl.dataProvider()                        
                        pr.addAttributes( [QgsField('name', QVariant.String)])
                        vl.updateFields()
                        campiAtt=vl.pendingFields()
                        for line in range(len(lines)):
                            fet = QgsFeature(campiAtt)
                            QgsLine = list()
                            for vertex in lines[line]:
                                vertexList=vertex.split(',')[:-1]
                                QgsLine.append( QgsPoint( float(vertexList[0]), float(vertexList[1]) ) )
                            fet.setGeometry( QgsGeometry.fromPolyline( QgsLine ) )
                            fet['name'] = nameTrack[line]                         
                            pr.addFeatures( [ fet ] )
                        #~ update vector layer    
                        vl.updateExtents()
                        self.canvas.refresh()
                        
                        #~ save vector layer to shapefile
                        error = QgsVectorFileWriter.writeAsVectorFormat(vl, path.join(str(self.ShpFileFolder),str(vlName)), "CP1250", None, "ESRI Shapefile")
                        if error == QgsVectorFileWriter.NoError:
                            QMessageBox.information( self.iface.mainWindow(),"Info", 
                            str("File %s " %(str(vlName).upper())) + QCoreApplication.translate( "message","succesfully saved"))
                        
                        #~ add to TOC the layer, I preferred add memory layer to avoid truncated fields in attribute table
                        QgsMapLayerRegistry.instance().addMapLayer(vl)

                        
                    elif typePmk == 'note text':
                        (dateNote,coordNotes) = ProcessKMZ().grabKMLnote(tipology[typePmk])
                        vlName=self.ui.tableWidget.item(IDPmk, 1).text() 
                        vl = QgsVectorLayer("Point?crs=epsg:4326", str(vlName), "memory")
                        pr = vl.dataProvider()
                        
                        #~ add fields
                        pr.addAttributes( [QgsField('text', QVariant.String),QgsField('date', QVariant.String)]) 
                        vl.updateFields()
                        campiAtt=vl.pendingFields()
                          
                        #~ add features point
                        for pointID in range(len(coordNotes)):
                            fet = QgsFeature(campiAtt)
                            xcoor=float(coordNotes[pointID][0])
                            ycoor=float(coordNotes[pointID][1])
                            fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(xcoor,ycoor))) 
                            #~ add attribute value
                            fet['text'] = dateNote[pointID][0]
                            fet['date'] = dateNote[pointID][1]
                            pr.addFeatures( [ fet ] )
                        #~ update vector layer    
                        vl.updateExtents()
                        self.canvas.refresh()
                        
                        #~ save vector layer to shapefile
                        error = QgsVectorFileWriter.writeAsVectorFormat(vl, path.join(str(self.ShpFileFolder),str(vlName)), "CP1250", None, "ESRI Shapefile")
                        if error == QgsVectorFileWriter.NoError:
                            QMessageBox.information( self.iface.mainWindow(),"Info",
                            str("File %s " %(str(vlName).upper())) + QCoreApplication.translate( "message","succesfully saved"))
                        
                        #~ add to TOC the layer, I preferred add memory layer to avoid truncated fields in attribute table
                        QgsMapLayerRegistry.instance().addMapLayer(vl)                        
                                            
                    else:
                        #~ grab KML from processkmz for NOTE BY TAGS
                        (fields,coordinates) = ProcessKMZ().grabKML(tipology[typePmk])
                        fields=ProcessKMZ().parseFields(fields)
                        #~ create qgis layer
                        vlName=self.ui.tableWidget.item(IDPmk, 1).text()
                        vl = QgsVectorLayer("Point?crs=epsg:4326", str(vlName), "memory")
                        pr = vl.dataProvider()
                        
                        #~ add fields
                        FieldsQGS=list()
                        for fieldName in fields:
                            FieldsQGS.append(QgsField(fieldName, QVariant.String))
                        pr.addAttributes( FieldsQGS)
                        vl.updateFields()
                        campiAtt=vl.pendingFields()
                        
                        #~ add features point
                        for point in coordinates:
                            fet = QgsFeature(campiAtt)
                            fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(float(point[0]),float(point[1]))) )
                            #~ add attribute value
                            for attribute in range(len(fields)):
                                fet[fields[attribute]] = point[-1][attribute]
                            pr.addFeatures( [ fet ] )
                        
                        #~ update vector layer    
                        vl.updateExtents()
                        self.canvas.refresh()
                        
                        #~ save vector layer to shapefile
                        error = QgsVectorFileWriter.writeAsVectorFormat(vl, path.join(str(self.ShpFileFolder),str(vlName)), "CP1250", None, "ESRI Shapefile")
                        if error == QgsVectorFileWriter.NoError:
                            QMessageBox.information( self.iface.mainWindow(),"Info",
                            str("File %s " %(str(vlName).upper())) + QCoreApplication.translate( "message","succesfully saved"))
                        
                        #~ add to TOC the layer, I preferred add memory layer to avoid truncated fields in attribute table
                        QgsMapLayerRegistry.instance().addMapLayer(vl)

    def loadMediaFolder(self):
        
        mediafolder = QFileDialog.getExistingDirectory(self,str(QCoreApplication.translate( "dialog","Select Media Directory")),str(),QFileDialog.ShowDirsOnly|QFileDialog.HideNameFilterDetails)
        self.ui.MediaFolderLineEdit.setText(mediafolder)
    
    def CreateMediaLayer(self,type_layer,FieldsName,media):
        vl = QgsVectorLayer("Point?crs=epsg:4326", str(type_layer), "memory")
        pr = vl.dataProvider()
        pr.addAttributes(FieldsName)
        vl.updateFields()
        campiAtt=vl.pendingFields()
        
        for point  in media:
            fet = QgsFeature(campiAtt)
            fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(point[1],point[0])) )
            #~ add attribute value
            for IDattribute in range(len(point)):
                fet[FieldsName[IDattribute].name()] = point[IDattribute]
                #~ fet.addAttribute(IDattribute, QVariant(point[IDattribute]))
            pr.addFeatures( [ fet ] )        
        vl.updateExtents()
        self.canvas.refresh()
        QgsMapLayerRegistry.instance().addMapLayer(vl)
        return vl
            
    
    def exportMediaFolder(self):
        mediafolder = self.ui.MediaFolderLineEdit.text()
        if self.outputMedia == None:
            QMessageBox.critical(self.iface.mainWindow(),QCoreApplication.translate( "message","Error"), QCoreApplication.translate( "message","You have to select output folder first") )
        else:
            ###############################################################
            #~ export images media        
            images = ProcessMEDIA().listMediaData(mediafolder,'IMG')
            if len(images) != 0:
                FieldImage = [ QgsField("latitude", QVariant.Double), 
                                QgsField("longitude", QVariant.Double), 
                                QgsField("azimuth", QVariant.Int),
                                QgsField("elevation", QVariant.Double),
                                QgsField("time", QVariant.String),
                                QgsField("name", QVariant.String)
                                ]
                vlImage = self.CreateMediaLayer(QCoreApplication.translate( "dialog",'Image point'),FieldImage,images)
                #~ save vector layer to shapefile
                filePath = path.join(str(self.ui.OutputMediaFolder.text()),str(self.ui.prefixLineEdit.text())+'images.shp')

                error = QgsVectorFileWriter.writeAsVectorFormat(vlImage, filePath, "CP1250", None, "ESRI Shapefile")
                if error == QgsVectorFileWriter.NoError:
                    QMessageBox.information( self.iface.mainWindow(),"Info", QCoreApplication.translate( "message","Shapefile images successfully saved" ))
            else:
                QMessageBox.information( self.iface.mainWindow(),"Info", QCoreApplication.translate( "message""Media folder does not contain any images" ))
            
            ###############################################################
            #~ export audio media        
            audios = ProcessMEDIA().listMediaData(mediafolder,'AUDIO')
            if len(audios) != 0:
                FieldAudio = [ QgsField("latitude", QVariant.Double), 
                               QgsField("longitude", QVariant.Double), 
                               QgsField("elevation", QVariant.Double),
                               QgsField("time", QVariant.String),
                               QgsField("name", QVariant.String)
                               ]
                vlAudio = self.CreateMediaLayer(QCoreApplication.translate( "dialog",'Audio point'),FieldAudio,audios)
                #~ save vector layer to shapefile
                filePath = path.join(str(self.ui.OutputMediaFolder.text()),str(self.ui.prefixLineEdit.text())+'audios.shp')

                error = QgsVectorFileWriter.writeAsVectorFormat(vlAudio, filePath, "CP1250", None, "ESRI Shapefile")
                if error == QgsVectorFileWriter.NoError:
                    QMessageBox.information( self.iface.mainWindow(),"Info", QCoreApplication.translate( "message","Shapefile audios successfully saved" ))
            else:
                QMessageBox.information( self.iface.mainWindow(),"Info", QCoreApplication.translate( "message","Media folder does not contain any images" ))   

            ###############################################################
            #~ export sketch media        
            sketchs = ProcessMEDIA().listMediaData(mediafolder,'SKETCH')
            if len(sketchs) != 0:
               
                vlSketchs = self.CreateMediaLayer(QCoreApplication.translate( "dialog",'Sketchs point'),FieldAudio,sketchs)
                #~ save vector layer to shapefile
                filePath = path.join(str(self.ui.OutputMediaFolder.text()),str(self.ui.prefixLineEdit.text())+'sketchs.shp')

                error = QgsVectorFileWriter.writeAsVectorFormat(vlAudio, filePath, "CP1250", None, "ESRI Shapefile")
                if error == QgsVectorFileWriter.NoError:
                    QMessageBox.information( self.iface.mainWindow(),"Info", QCoreApplication.translate( "message","Shapefile sketchs successfully saved" ))
            else:
                QMessageBox.information( self.iface.mainWindow(),"Info", QCoreApplication.translate( "message","Media folder does not contain any sketchs" ))            



    def writeMediaFolder(self):
        
        outputfolder = QFileDialog.getExistingDirectory(self,str(QCoreApplication.translate( "dialog","Select Output Directory")),str(),QFileDialog.ShowDirsOnly)
        self.ui.OutputMediaFolder.setText(outputfolder)
        prefix = str(self.ui.prefixLineEdit.text())
        self.outputMedia = outputfolder+prefix
        
    def helpMedia(self):
        currentPath = path.dirname( __file__ )
        webbrowser.open(currentPath + "/help/help.html")
