"""
/***************************************************************************
Name		     : GeopapaTile
Description          : 
Date                 : 24/10/2012 
copyright            : (C) 2012 by Ruggero Valentinotti
email                : valruggero@gmail.com 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import * 
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from GeopapaTileDialog import GeopapaTileDialog
from Ui_GeopapaTile import Ui_GeopapaTile
import doGeopapaTile

class GeopapaTile: 

  def __init__(self, iface):
    # Save reference to the QGIS interface
    self.iface = iface

  def initGui(self):  
    # Create action that will start plugin configuration
    self.action = QAction(QIcon(":/plugins/GeopapaTile/icon.png"), \
        "GeopapaTile", self.iface.mainWindow())
    # connect the action to the run method
    QObject.connect(self.action, SIGNAL("activated()"), self.run) 

    # Add toolbar button and menu item
    self.iface.addToolBarIcon(self.action)
    self.iface.addPluginToMenu("&SBM-Tools", self.action)

  def unload(self):
    # Remove the plugin menu item and icon
    self.iface.removePluginMenu("&SBM-Tools",self.action)
    self.iface.removeToolBarIcon(self.action)

  # run method that performs all the real work
  def run(self): 
    # create and show the dialog 
#    dlg = QuantiliDialog() 
    # show the dialog
    #dlg.show()
    dlg = doGeopapaTile.GeopapaTileDialog(self.iface)
    dlg.exec_()
        
