from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
import os

from .Script.factor_landsat import FactorLandsat
from .Script.factor_sentinel2 import FactorSentinel2
from .Script.indices_espectrales import IndicesEspectrales
from .Script.random_forest import RandomForestTool
from .Script.validacion_kappa import ValidacionKappa


class GeomaticapePlugin:

    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.menu = "Geomaticape"
        self.actions = []

    def initGui(self):

        self.add_action("Factor escala Landsat",
                        "Icons/landsat.png",
                        FactorLandsat)

        self.add_action("Factor escala Sentinel2",
                        "Icons/sentinel.png",
                        FactorSentinel2)

        self.add_action("5 Índices espectrales",
                        "Icons/indices.png",
                        IndicesEspectrales)

        self.add_action("Clasificación RandomForest",
                        "Icons/rf.png",
                        RandomForestTool)

        self.add_action("Validación Kappa y Matriz",
                        "Icons/kappa.png",
                        ValidacionKappa)

    def add_action(self, text, icon_path, tool_class):

        icon = QIcon(os.path.join(self.plugin_dir, icon_path))
        action = QAction(icon, text, self.iface.mainWindow())
        action.triggered.connect(lambda: tool_class().run())

        self.iface.addPluginToMenu(self.menu, action)
        self.actions.append(action)

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(self.menu, action)
