from __future__ import print_function
from __future__ import absolute_import
#-------------------------------------------------------------------------------
# Name:        utl
# Purpose:     standaard utilities
#
# Author:      bkropf
#
# Created:     02-02-2017
# Copyright:   (c) bkropf 2017
# Licence:     <your licence>
#-------------------------------------------------------------------------------

# import system modules
from builtins import str
from builtins import zip
from builtins import range
import sys, os, logging, time
from datetime import datetime, date
from .settings import qgis_warnings_log
##import pandas ##arcpy
##import numpy as np


# QGIS
from qgis.gui import QgisInterface
from qgis.core import * #QgsMessageLog, QgsVectorJoinInfo, QgsExpression, QgsField, QgsVectorLayer, QgsFeatureRequest
from qgis.core import Qgis, QgsProject, QgsVectorLayerJoinInfo
from qgis.PyQt.QtCore import QVariant

def start_timer():
    '''Start timer'''
    fTimeStart = time.time()
    sBericht = '\nStarting ... (%s)\n' % time.asctime(time.localtime(fTimeStart))
    print_log (sBericht,"i")
    return fTimeStart

def end_timer(fTimeStart):
    '''End timer'''
    fTimeEnd = time.time()
    sBericht = '\nEnding ..... (%s)' % time.asctime(time.localtime(fTimeEnd))
    print_log (sBericht,"i")
    fTimePassed = round(fTimeEnd - fTimeStart) # in gehele secs
    tTimePassed = time.gmtime(fTimePassed) # as a tuple
    if tTimePassed.tm_hour >= 1:
        sBericht = time.strftime('(%H hrs, %M mins, %S secs have passed)\n', tTimePassed)
    elif tTimePassed.tm_min >= 1:
        sBericht = time.strftime('(%M mins, %S secs have passed)\n', tTimePassed)
    else:
        sBericht = time.strftime('(%S secs have passed)\n', tTimePassed)
    print_log (sBericht,"i")

def blokje_log(txt,logType):
    print_log("\n" + \
             "---------------------------------------------------------------------------------------------------------\n" + \
             "------ " + str(txt) + "\t\t" + time.asctime() + "\n" + \
             "---------------------------------------------------------------------------------------------------------\n" + \
             "\n", logType)

def print_log(message, logType="i", iface=False, **kwargs):

    # if args:
    #     iface = args[0] if isinstance(args[0], QgisInterface) else False
    # else:
    #     iface = False

    try:
        print (message)  # print mag niet in QGIS?
    except IOError:
        pass

    ##QgsMessageLog.logMessage("log_lvl = {}".format(logging.getLogger().getEffectiveLevel()),level=Qgis.Info)
    if logType == "d" and logging.getLogger().getEffectiveLevel() == logging.DEBUG:
        # alleen als logging level op DEBUG is ingesteld printen!
        logging.debug(message)
        QgsMessageLog.logMessage("debug: {}".format(message), level=Qgis.Info)
    elif logType == "i": # info
        QgsMessageLog.logMessage(message, level=Qgis.Info)
        logging.info(message)
    elif logType == "w": # warning
        QgsMessageLog.logMessage("WARNING: {}".format(message), level=Qgis.Warning)
        if iface: iface.messageBar().pushMessage("Warning", message, level=Qgis.Warning)
        logging.warning(message)
        with open(qgis_warnings_log, 'a') as logfile:
            logfile.write('\n({level}): {message}'.format(level="WARNING", message=message))

    elif logType == "e": # error
        logging.error(message)
        QgsMessageLog.logMessage(message, level=Qgis.Critical)
        if iface: iface.messageBar().pushMessage("Error", message, level=Qgis.Critical)
    elif logType == "c": # critical
        logging.critical(message)
        ##iface.messageBar().pushMessage("Error", txt, level=Qgis.Critical)


def fields_to_uppercase(layer):
    '''rename fields to uppercase'''
    return
    layer.startEditing()
    for idx, field in enumerate(layer.fields()):
        if field.name().upper() != field.name():
            layer.renameAttribute(idx, field.name().upper())
    layer.commitChanges()

def add_field_from_dict(fc, fld_name, d_fld):
    """add field. dict must be like
        d_fld[fld_name] = {
            'field_alias'   : 'your alias',
            'field_length'  : '50', (optional)
            'field_type'    : 'TEXT',
            } """

    print_log("veld {} toevoegen".format(fld_name), "d")
    fld = d_fld[fld_name] # dict with field parameters
    if fld in [field.name() for field in fc.fields()]:
        return
    if "field_length" in list(fld.keys()):
        field_length = fld["field_length"]
    else:
        field_length = 10
    ##print_log("veld lengte = {}".format(field_length), "i")

    if not isinstance(fc, QgsVectorLayer): fc = QgsVectorLayer(fc, "layer", "ogr")

    fldtype_mapper = {
        "TEXT" : QVariant.String,
        "LONG" : QVariant.Int,
        "SHORT": QVariant.Int,
        "DOUBLE":QVariant.Double,
        "FLOAT": QVariant.Double,
        "DATE" : QVariant.DateTime,
    }

    if fc.fields().indexFromName(fld_name) == -1:
        fc.dataProvider().addAttributes([QgsField(prec=2, name=fld_name, type=fldtype_mapper.get(fld["field_type"],QVariant.String), len=field_length)])
        fc.updateFields()

def add_field_from_dict_label(fc, add_fld_value, d_fld):
    """velden toevoegen op basis van dict.keys 'add_fld', 'order' en 'fc' in d_fld
       maakt gebuikt van functie add_field_from_dict() maar dan voor een verzameling velden
       op basis van 'add_fld'. 'order' is optioneel voor het behouden van volgorde"""
    # select dict with "order" and "add_fld" keys
    d_fld_order = {k:v for (k,v) in list(d_fld.items()) if "add_fld" in list(v.keys()) and "order" in list(v.keys())}
    # subselect with "order" == add_fld_value
    d_fld_order = {k:v for (k,v) in list(d_fld_order.items()) if v["add_fld"] == add_fld_value}
    if len(d_fld_order) > 0:
        print_log("velden met 'add_fld' : '{}' toevoegen op volgorde van 'order':".format(add_fld_value),"d")
        for fld, value in sorted(iter(d_fld_order.items()), key=lambda k_v: (k_v[1]["order"])): # sort by key "order"
            add_field_from_dict(fc, fld, d_fld)
    # select dict without "order" and "add_fld" keys
    d_fld_no_order = {k:v for (k,v) in list(d_fld.items()) if "add_fld" in list(v.keys()) and not "order" in list(v.keys())}
    # subselect with "order" == add_fld_value
    d_fld_no_order = {k:v for (k,v) in list(d_fld_no_order.items()) if v["add_fld"] == add_fld_value}
    if len (d_fld_no_order) > 0:
        print_log("geen 'order' gevonden in d_velden, velden met 'add_fld' : '{}' toevoegen in willekeurige volgorde:".format(add_fld_value),"d")
        for fld in d_fld_no_order:
            add_field_from_dict(fc, fld, d_fld)

def bereken_veld(fc, fld_name, d_fld):
    """bereken veld m.b.v. 'expression' in dict
       als dict de key 'mag_niet_0_zijn' bevat, wordt een selectie gemaakt voor het opgegeven veld"""
    try:
        expression = d_fld[fld_name]["expression"]
        expression = expression.replace("[", '"').replace("]", '"')
        print_log("calculate {} = {}".format(fld_name, expression), "i")
        print_log(d_fld[fld_name], "d")
        if "mag_niet_0_zijn" in d_fld[fld_name]:
            l_fld = d_fld[fld_name]["mag_niet_0_zijn"]
            where_clause = " and ".join(
                ['"{}" <> 0'.format(fld) for fld in l_fld])  # [FLD1,FLD2] -> "FLD1 <> 0 and FLD2 <> 0"
            expr = QgsExpression(where_clause)
            print_log(where_clause, "d")
            it = fc.getFeatures(QgsFeatureRequest(expr))  # iterator object
            fc.selectByIds([i.id() for i in it])

        # calculate field
        context = QgsExpressionContext()
        scope = QgsExpressionContextScope()
        context.appendScope(scope)
        e = QgsExpression(expression)
        ##e.prepare(fc.fields())

        fc.startEditing()
        idx = fc.fields().indexFromName(fld_name)
        for f in fc.getFeatures():
            scope.setFeature(f)
            f[idx] = e.evaluate(context)
            fc.updateFeature(f)
        fc.commitChanges()
        fc.selectByIds([])

    except Exception as e:
        print_log("probleem bij bereken veld {}! {}".format(fld_name,e),"w")

def bereken_veld_label(fc, bereken, d_fld):
    """bereken velden op basis van label 'bereken' en fc in d_fld"""
    print_log("\nvelden met label 'bereken' : '{}' uitrekenen:".format(bereken),"i")
    for fld in d_fld:
        if not "bereken" in list(d_fld[fld].keys()): continue
        if bereken == d_fld[fld]["bereken"]: bereken_veld(fc, fld, d_fld)

def join_field(input_table, join_table, field_to_calc, field_to_copy, joinfield_input_table, joinfield_join_table, inner_join=False):
    """Veld overnemen uit andere tabel o.b.v. tablejoin.
       Het veld wat gevuld moet worden (field_to_calc) moet al wel bestaan en wordt in deze functie alleen gevuld.
       Vul "pk" in bij joinfield_join_table om de primary key te laten bepalen of kies een ander veld"""
    # voorbeeld: join_field(input_table="", join_table="", field_to_calc="", field_to_copy="", joinfield_input_table="", joinfield_join_table="")
    if 1==1:

        print_log("joining field {} from {}...".format(field_to_calc, os.path.basename(join_table.name())), "d")

        input_table.selectByIds([])
        # add join old way qgis 2
        ## joinObject = QgsVectorJoinInfo()
        ## joinObject.joinLayerId = join_table.id()
        ## joinObject.joinFieldName = joinfield_join_table
        ## joinObject.joinFieldName = joinfield_join_table
        ## joinObject.targetFieldName = joinfield_input_table
        # add join qgis 3
        joinObject = QgsVectorLayerJoinInfo()  # old: QgsVectorJoinInfo()
        joinObject.setJoinLayer(join_table)
        joinObject.setJoinFieldName(joinfield_join_table)
        joinObject.setTargetFieldName(joinfield_input_table)
        if not input_table.addJoin(joinObject):
            print_log("join failed!", "w")
        # calculate field
        context = QgsExpressionContext()
        scope = QgsExpressionContextScope()
        context.appendScope(scope)
        e = QgsExpression('"{}_{}"'.format(join_table.name(),field_to_copy))
        ##e.prepare(input_table.fields()) # qgis 2
        print_log("expression = {}".format('"{}_{}"'.format(join_table.name(),field_to_copy)), "d")

        idx_field_to_copy = input_table.fields().indexFromName('{}_{}'.format(join_table.name(), field_to_copy))
        if idx_field_to_copy == -1:
            print_log("[{}] is leeg omdat [{}] ontbreekt in kaartlaag '{}'.".format(field_to_calc, field_to_copy, join_table.name()), "w")
        idx_joinfield_join_table = join_table.fields().indexFromName(joinfield_join_table)
        if idx_joinfield_join_table == -1:
            print_log("join_field [{}] ontbreekt in {}. table join mislukt.".format(joinfield_join_table, join_table.name()),"w")
        input_table.startEditing()
        idx = input_table.fields().indexFromName(field_to_calc)
        if idx == -1:
            print_log("field_to_calculate [{}] niet gevonden in kaartlaag '{}'.".format(field_to_calc, input_table.name()), "w")
        if inner_join:
            print_log("inner_join = True", 'd')
            s_expr = '"{}_{}" IS NOT NULL'.format(join_table.name(),field_to_copy)
            print_log(s_expr, 'd')
            expr = QgsExpression(s_expr)
            it = input_table.getFeatures(QgsFeatureRequest(expr))  # iterator object
            input_table.selectByIds([i.id() for i in it])
            features = input_table.selectedFeatures()
        else:
            features = input_table.getFeatures()
        for f in features:
            scope.setFeature(f)
            f[idx] = e.evaluate(context) # qgis 2: e.evaluate(f)
            input_table.updateFeature(f)
        input_table.commitChanges()

        input_table.removeJoin(joinObject.joinLayerId())

    # except Exception as e:
    #     print_log("problemen met join_field {}! {}".format(field_to_calc,e),"w")


def rename_fields(table_to_rename_field, d_rename):
    print_log("Hernoem velden van {}...".format(table_to_rename_field),"d")
    for f in d_rename:
        # f = field to rename
        try:
            in_table, new_field_name, new_field_alias = d_rename[f]
            if in_table == table_to_rename_field:
                print_log("\t{} -> {} ({})".format(f,new_field_name,new_field_alias),"d")
                # AlterField_management (in_table, field, {new_field_name}, {new_field_alias})
                arcpy.AlterField_management (in_table, f, new_field_name, new_field_alias)
        except Exception as e:
            print_log("kan veld {} niet hernoemen! {}".format(f,e),"w")


def parse_xlsx(INP_FIELDS_XLS, SHEETNR, open_workbook):

    workbook = open_workbook(INP_FIELDS_XLS)
    sheets = workbook.sheet_names()
    active_sheet = workbook.sheet_by_name(sheets[SHEETNR])
    num_rows = active_sheet.nrows
    num_cols = active_sheet.ncols
    header = [active_sheet.cell_value(0, cell).lower() for cell in range(num_cols)]
    for row_idx in range(1, num_rows):
        row_cell = [active_sheet.cell_value(row_idx, col_idx) for col_idx in range(num_cols)]
        yield dict(list(zip(header, row_cell)))


def get_d_velden(INP_FIELDS_XLS, SHEETNR, open_workbook):
    """dictionary field-info ophalen uit excel zonder pandas met xlrd"""

    d_velden = {}

    for srow in parse_xlsx(INP_FIELDS_XLS, SHEETNR, open_workbook):
        fld = {}

        # verplichte keys
        fld["order"] = srow["order"]
        fld["field_type"] = srow["type"]
        fld["field_alias"] = srow["alias"]
        fld["add_fld"] = srow["stap_toevoegen"]
        # optionele keys
        if str(srow["mag_niet_0_zijn"]) != "nan": # np.nan, df.notna() werkt niet en np.isnan() not supported
            fld["mag_niet_0_zijn"] = str(srow["mag_niet_0_zijn"]).split(";")
        else:
            # fix_print_with_import
            print((type(srow["mag_niet_0_zijn"]),srow["mag_niet_0_zijn"]))
        if str(srow["lengte"]) not in ["nan", ""," "]:
            fld["field_length"] = int(srow["lengte"])
        if str(srow["expression"]) not in ["nan", ""," "]:
            fld["expression"] = srow["expression"]
        if str(srow["stap_bereken"]) not in ["nan", ""," "]:
            fld["bereken"] = srow["stap_bereken"]
        d_velden[srow["fieldname"]] = fld

    return d_velden


def get_d_velden_csv(INP_FIELDS_CSV):
    """dictionary field-info ophalen uit excel zonder pandas met xlrd"""
    import csv
    d_velden = {}

    input_file = csv.DictReader(open(INP_FIELDS_CSV, encoding="ISO-8859-1"), delimiter=";")

    for srow in input_file:
        if not srow["fieldname"]:
            continue

        fld = {}

        # verplichte keys
        fld["order"] = int(srow["order"])
        fld["field_type"] = srow["type"]
        fld["field_alias"] = srow["alias"]
        fld["add_fld"] = srow["stap_toevoegen"]
        # optionele keys
        if str(srow["mag_niet_0_zijn"]) != "nan": # np.nan, df.notna() werkt niet en np.isnan() not supported
            fld["mag_niet_0_zijn"] = str(srow["mag_niet_0_zijn"]).split(";")
        else:
            # fix_print_with_import
            print((type(srow["mag_niet_0_zijn"]),srow["mag_niet_0_zijn"]))
        if str(srow["lengte"]) not in ["nan", ""," "]:
            fld["field_length"] = int(srow["lengte"])
        if str(srow["expression"]) not in ["nan", ""," "]:
            fld["expression"] = srow["expression"]
        if str(srow["stap_bereken"]) not in ["nan", ""," "]:
            fld["bereken"] = srow["stap_bereken"]
        d_velden[srow["fieldname"]] = fld

    return d_velden


def add_layer(layer, visible=True):
    ##ins = QgsMapLayerRegistry.instance() # Qgis 2
    ins = QgsProject.instance()
    layers = ins.mapLayersByName(layer.name())
    for old_layer in layers:
        ##return old_layer
        print_log("remove layer {}".format(old_layer),"d")
        ins.removeMapLayer(old_layer.id())
    ##layer.setVisible = visible
    ins.addMapLayer(layer)
    return layer


def update_datetime(layer, fieldname):
    if layer.fields().indexFromName(fieldname) == -1:
        layer.dataProvider().addAttributes([QgsField(name=fieldname, type=QVariant.String, len=19)])
        layer.updateFields()
    field = layer.fields().indexFromName(fieldname)
    context = QgsExpressionContext()
    scope = QgsExpressionContextScope()
    context.appendScope(scope)
    e = QgsExpression( " $now " )
    ##e.prepare( layer.fields() )
    layer.startEditing()
    for feat in layer.getFeatures():
        scope.setFeature(feat)
        feat[field] = e.evaluate(context)
        layer.updateFeature( feat )
    layer.commitChanges()

# def pandas_get_d_velden(INP_FIELDS_XLS, INP_FIELDS_XLS_SHEET):
#     """dictionary field-info ophalen uit excel met pandas"""
#     df = pandas.read_excel(INP_FIELDS_XLS, sheet_name=INP_FIELDS_XLS_SHEET, header=0, skiprows=None, skip_footer=0, index_col=None,
#                       names=None, usecols=None, parse_dates=False, date_parser=None, na_values=None, thousands=None,
#                       convert_float=True, converters=None, dtype=None, true_values=None, false_values=None, engine=None,
#                       squeeze=False)
#
#     d_velden = {}
#
#     for i, srow in df.iterrows():
#         fld = {}
#
#         # verplichte keys
#         fld["order"] = srow["order"]
#         fld["field_type"] = srow["type"]
#         fld["field_alias"] = srow["alias"]
#         fld["add_fld"] = srow["stap_toevoegen"]
#         # optionele keys
#         if str(srow["mag_niet_0_zijn"]) != "nan": # np.nan, df.notna() werkt niet en np.isnan() not supported
#             fld["mag_niet_0_zijn"] = str(srow["mag_niet_0_zijn"]).split(";")
#         else:
#             print (type(srow["mag_niet_0_zijn"]),srow["mag_niet_0_zijn"])
#         if str(srow["expression"]) != "nan":
#             fld["expression"] = srow["expression"]
#         if str(srow["stap_bereken"]) != "nan":
#             fld["bereken"] = srow["stap_bereken"]
#         d_velden[srow["fieldname"]] = fld
#
#     return d_velden

# example fast calculate
# https://gis.stackexchange.com/questions/97344/how-to-change-attributes-with-qgis-python
# from qgis.utils import iface
# from PyQt4.QtCore import *
#
# layers = iface.legendInterface().layers()
#
# for layer in layers:
#     name = layer.name()
#     if name.endswith('x'):
#         provider = layer.dataProvider()
#         updateMap = {}
#         fieldIdx = p.fields().indexFromName( 'attr' )
#         features = provider.getFeatures()
#         for feature in features:
#             updateMap[feature.id()] = { fieldIdx: 'a' }
#
#         provider.changeAttributeValues( updateMap )

if __name__ == '__main__':

    print_log("test utl","i")