# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoRondônia
                                 A QGIS plugin
 Tools for Georeferencing Rural Properties.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-13
        copyright            : (C) 2024 by GeoRondônia
        email                : lab.georondonia@ifro.edu.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Maik Rodrigues'
__date__ = '2024-11-13'
__copyright__ = '(C) 2024 by Maik Rodrigues'
__revision__ = '$Format:%H$'

import os
import sys
import inspect
from qgis.core import QgsApplication
from .Georondonia_provider import GeorondoniaProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

class GeorondoniaPlugin(object):
    def __init__(self):
        self.provider = None

    def initProcessing(self):
        self.provider = GeorondoniaProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self): # Código para inicializar a interface gráfica do plugin
        self.initProcessing()

    def unload(self):  # Código para limpar/descarregar o plugin
        QgsApplication.processingRegistry().removeProvider(self.provider) 
