# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoRondônia
                                 A QGIS plugin
 Tools for Georeferencing Rural Properties.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-13
        copyright            : (C) 2024 by GeoRondônia
        email                : lab.georondonia@ifro.edu.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Maik Rodrigues'
__date__ = '2024-11-13'
__copyright__ = '(C) 2024 by Maik Rodrigues'
__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .algoritmos.georural_GeneratorOds import GeneratorOds
from .algoritmos.tool_CheckInvalidGeometry import CheckInvalidGeometry
from .algoritmos.car_PrepareCarKml import prepareCAR
from qgis.PyQt.QtGui import QIcon
import os

class GeorondoniaProvider(QgsProcessingProvider):
    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(GeneratorOds())
        self.addAlgorithm(CheckInvalidGeometry())
        self.addAlgorithm(prepareCAR())
        

    def id(self):
        return 'GeoRondônia'

    def name(self):
        return self.tr('GeoRondônia')

    def icon(self):
        return QIcon(os.path.dirname(__file__) + '/images/georo_icone.png')

    def longName(self):
        return self.name()


