# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeoQ
                                 A QGIS plugin
 Automatización del procesamiento de cálculo de la escorrentía superficial con el método de Número de Curva 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-12-04
        copyright            : (C) 2024 by Fabio A. Montealegre M. & Fernanda J. Gaspari
        email                : fabio.montealegre@agro.unlp.edu.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Fabio A. Montealegre M. & Fernanda J. Gaspari'
__date__ = '2024-12-04'
__copyright__ = '(C) 2024 by Fabio Alejandro Montealegre Medina - Fernanda Julia Gaspari / CEIDE-UNLP-CIC'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .geoq_V2_provider import GeoQProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class GeoQPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = GeoQProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

        icon = os.path.join(os.path.join(cmd_folder, 'logo-mich.png'))
        self.action = QAction(
            QIcon(icon),
            u"GeoQ V2.8", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addPluginToMenu(u"&GeoQ", self.action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginMenu(u"&GeoQ", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        processing.execAlgorithmDialog("GeoQ:Calculo de Escorrentía Superficial")
