# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeoQ
                                 A QGIS plugin
 Automatización del procesamiento de cálculo de la escorrentía superficial con el método de Número de Curva 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-12-04
        copyright            : (C) 2024 by Fabio A. Montealegre M. & Fernanda J. Gaspari
        email                : fabio.montealegre@agro.unlp.edu.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Fabio A. Montealegre M. & Fernanda J. Gaspari'
__date__ = '2024-12-04'
__copyright__ = '(C) 2024 by Fabio Alejandro Montealegre Medina - Fernanda Julia Gaspari / CEIDE-UNLP-CIC'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import inspect
from qgis.PyQt.QtGui import QIcon
__revision__ = '$Format:%H$'
from qgis.PyQt.QtCore import QCoreApplication # type: ignore
from qgis.core import (QgsProcessing, # type: ignore
                        QgsProcessingAlgorithm,
                        QgsProcessingParameterFeatureSink,
					    QgsProcessingMultiStepFeedback,
                        QgsProcessingParameterNumber,
					    QgsProcessingParameterVectorLayer,
                        QgsVectorLayer,
                        QgsProcessingParameterRasterLayer,
                        QgsApplication,
                        QgsProcessingParameterEnum)

import processing # type: ignore
import pandas as pd # type: ignore
import tempfile


class GeoQAlgorithm(QgsProcessingAlgorithm):

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'



    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        self.addParameter(QgsProcessingParameterVectorLayer('LimiteArea', 'Limite área de estudio', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('ppmm', 'Precipitación numérica (mm)', optional=True, type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=1e+08, defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('RasterPP', 'Precipitación raster (mm)', optional=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Suelos', 'Grupo hidrológico de suelos', types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Vegetacion', 'Cobertura vegetal y uso del suelo', types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('GeoQ', 'GeoQ', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='GeoQ.shp'))
        self.addParameter(QgsProcessingParameterFeatureSink('NC', 'Número de Curva', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='NC.shp'))   
        self.addParameter(QgsProcessingParameterFeatureSink('Ce', 'Coeficiente de Escurrimiento CE (%)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='CE.shp'))
        self.addParameter(QgsProcessingParameterFeatureSink('Cf', 'Coeficiente de Infiltración CF (%)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='CF.shp'))
        self.addParameter(QgsProcessingParameterFeatureSink('Cio', 'Coeficiente de Abstracciones Iniciales CIo (%)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='CIo.shp'))
        self.addParameter(QgsProcessingParameterEnum('tabla', 'Condición de Humedad Antecedente CHA', options=['CHA I','CHA II','CHA III'], allowMultiple=False, usesStaticStrings=True, defaultValue=[]))


    def processAlgorithm(self, parameters, context, model_feedback):
        """
        Here is where the processing itself takes place.
        """
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(36, model_feedback)
        results = {}
        outputs = {}

        # Reproyectar capa cobertura del suelo o vegetación
        alg_params = {
            'INPUT': parameters['Vegetacion'],
            'OPERATION': '',
            'TARGET_CRS': parameters['LimiteArea'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Reproy_veg'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
       
        # Reproyectar capa GH suelo
        alg_params = {
            'INPUT': parameters['Suelos'],
            'OPERATION': '',
            'TARGET_CRS': parameters['LimiteArea'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Reproy_sue'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}
          
        # Convertir Límite Área a simple
        alg_params = {
            'INPUT': parameters['LimiteArea'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['LimArea_Simpl'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Vegetación_Clip
        alg_params = {
            'INPUT': outputs['Reproy_veg']['OUTPUT'],
            'MASK': outputs['LimArea_Simpl']['OUTPUT'],
            'OPTIONS': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Vegetacion_clip'] = processing.run('gdal:clipvectorbypolygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Suelos_Clip
        alg_params = {
            'INPUT': outputs['Reproy_sue']['OUTPUT'],
            'MASK': outputs['LimArea_Simpl']['OUTPUT'],
            'OPTIONS': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Suelos_clip'] = processing.run('gdal:clipvectorbypolygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Intersección
        alg_params = {
            'INPUT': outputs['Suelos_clip']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['Vegetacion_clip']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Interseccin'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # condicional para seleccionar la opcion de dato de PP o raster de PP
        if parameters.get('ppmm') is not None and parameters['RasterPP'] is None:

            # campo pp
            alg_params = {
                'FIELD_LENGTH': 0,
                'FIELD_NAME': 'PP(mm)',
                'FIELD_PRECISION': 0,
                'FIELD_TYPE': 0,  # Decimal (double)
                'FORMULA': parameters['ppmm'],
                'INPUT': outputs['Interseccin']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['CampoPp'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(11)
            if feedback.isCanceled():
                return {}
           
        elif parameters.get('ppmm') is None and parameters['RasterPP'] is not None:

        # Píxeles ráster a polígonos
            alg_params = {
                'FIELD_NAME': 'VALUE',
                'INPUT_RASTER': parameters['RasterPP'],
                'RASTER_BAND': 1,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['PxelesRsterAPolgonos'] = processing.run('native:pixelstopolygons', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(13)
            if feedback.isCanceled():
                return {}

        # Preciptación_Vector_PP
            alg_params = {
                'FIELD': 'VALUE',
                'INPUT': outputs['PxelesRsterAPolgonos']['OUTPUT'],
                'NEW_NAME': 'PP(mm)',
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['Preciptacion_vector_pp'] = processing.run('native:renametablefield', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(14)
            if feedback.isCanceled():
                return {}
        # Inter_S_PP
            alg_params = {
                'INPUT': outputs['Interseccin']['OUTPUT'],
                'INPUT_FIELDS': [''],
                'OVERLAY': outputs['Preciptacion_vector_pp']['OUTPUT'],
                'OVERLAY_FIELDS': [''],
                'OVERLAY_FIELDS_PREFIX': '',
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['CampoPp'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(15)
            if feedback.isCanceled():
                return {}

        # Cod_NC Calculadora de campos
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Cod_NC',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '\"Cod_Sue\" + \"Cod_Veg\"',
            'INPUT': outputs['CampoPp']['OUTPUT'],
            'NEW_FIELD': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Cod_ncCalculadoraDeCampos'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # Tablas para las condiciones de humedad CHA
        CHA1 = [[11,58], [21,52], [31,46], [41,49], [51,44], [61,45], [71,41], [81,44], [91,42], [101,42], [111,40], [121,40], [131,38], [141,45], [151,37], [161,43], [171,34], [181,42], [191,30], [201,28], [211,18], [221,15], [231,26], [241,19], [251,12], [261,35], [271,26], [281,19], [291,13], [301,7], [311,15], [321,47], [331,29], [341,21], [351,27], [361,12], [371,3], [381,33], [391,58], [401,95], [411,100], [421,27], [431,37], [441,40], [451,37], [461,30], [471,20], [481,22], [491,29], [501,18], [511,29], [521,42], [531,65], [541,65], [551,80], [561,77], [571,29], [581,15], [12,72], [22,64], [32,60], [42,61], [52,56], [62,54], [72,51], [82,57], [92,56], [102,54], [112,53], [122,52], [132,49], [142,58], [152,52], [162,56], [172,48], [182,53], [192,46], [202,46], [212,35], [222,28], [232,45], [242,39], [252,34], [262,56], [272,47], [282,39], [292,31], [302,25], [312,37], [322,61], [332,48], [342,40], [352,46], [362,38], [372,18], [382,49], [392,70], [402,95], [412,100], [422,45], [432,52], [442,56], [452,52], [462,47], [472,39], [482,40], [492,45], [502,38], [512,47], [522,58], [532,84], [542,84], [552,80], [562,82], [572,48], [582,37], [13,81], [23,75], [33,70], [43,69], [53,66], [63,63], [73,60], [83,69], [93,67], [103,66], [113,64], [123,61], [133,60], [143,69], [153,64], [163,67], [173,60], [183,63], [193,57], [203,58], [213,49], [223,44], [233,58], [243,53], [253,49], [263,72], [273,60], [283,49], [293,42], [303,33], [313,51], [323,72], [333,61], [343,54], [353,64], [363,56], [373,49], [383,63], [393,79], [403,95], [413,100], [423,58], [433,66], [443,67], [453,64], [463,63], [473,53], [483,57], [493,56], [503,52], [513,60], [523,70], [533,84], [543,84], [553,81], [563,88], [573,61], [583,51], [14,87], [24,81], [34,77], [44,75], [54,72], [64,66], [74,64], [84,75], [94,74], [104,70], [114,69], [124,66], [134,64], [144,75], [154,70], [164,70], [174,67], [184,67], [194,63], [204,67], [214,58], [224,53], [234,67], [244,61], [254,58], [264,81], [274,69], [284,57], [294,48], [304,40], [314,60], [324,77], [334,69], [344,63], [354,75], [364,67], [374,61], [384,70], [394,83], [404,95], [414,100], [424,67], [434,72], [444,74], [454,72], [464,69], [474,61], [484,64], [494,61], [504,61], [514,69], [524,75], [534,84], [544,84], [554,64], [564,87], [574,69], [584,60]]
        C1 = pd.DataFrame (CHA1, columns = ['Cod_NC', 'NC'])

        CHA2 = [[11,77], [21,72], [31,67], [41,70], [51,65], [61,66], [71,62], [81,65], [91,63], [101,63], [111,61], [121,61], [131,59], [141,66], [151,58], [161,64], [171,55], [181,63], [191,51], [201,48], [211,35], [221,30], [231,45], [241,36], [251,25], [261,56], [271,46], [281,36], [291,26], [301,15], [311,30], [321,68], [331,49], [341,39], [351,47], [361,25], [371,6], [381,54], [391,77], [401,98], [411,100], [421,47], [431,57], [441,61], [451,57], [461,51], [471,37], [481,42], [491,49], [501,35], [511,49], [521,63], [531,83], [541,83], [551,91], [561,89], [571,49], [581,30], [12,86], [22,81], [32,78], [42,79], [52,75], [62,74], [72,71], [82,76], [92,75], [102,74], [112,73], [122,72], [132,70], [142,77], [152,72], [162,75], [172,69], [182,73], [192,67], [202,67], [212,56], [222,48], [232,66], [242,60], [252,55], [262,75], [272,68], [282,60], [292,52], [302,44], [312,58], [322,79], [332,69], [342,61], [352,67], [362,59], [372,35], [382,70], [392,85], [402,98], [412,100], [422,66], [432,72], [442,75], [452,72], [462,68], [472,60], [482,62], [492,65], [502,59], [512,68], [522,77], [532,93], [542,93], [552,91], [562,92], [572,69], [582,58], [13,91], [23,88], [33,85], [43,84], [53,82], [63,80], [73,78], [83,84], [93,83], [103,82], [113,81], [123,79], [133,78], [143,84], [153,81], [163,83], [173,78], [183,80], [193,76], [203,77], [213,70], [223,65], [233,77], [243,73], [253,70], [263,86], [273,78], [283,70], [293,63], [303,54], [313,71], [323,86], [333,79], [343,74], [353,81], [363,75], [373,70], [383,80], [393,90], [403,98], [413,100], [423,77], [433,82], [443,83], [453,81], [463,79], [473,73], [483,75], [493,75], [503,72], [513,78], [523,85], [533,93], [543,93], [553,91], [563,94], [573,79], [583,71], [14,94], [24,91], [34,89], [44,88], [54,86], [64,82], [74,81], [84,88], [94,87], [104,85], [114,84], [124,82], [134,81], [144,88], [154,85], [164,85], [174,83], [184,83], [194,80], [204,83], [214,77], [224,73], [234,83], [244,79], [254,77], [264,91], [274,84], [284,76], [294,69], [304,61], [314,78], [324,89], [334,84], [344,80], [354,88], [364,83], [374,79], [384,85], [394,92], [404,98], [414,100], [424,83], [434,86], [444,77], [454,86], [464,84], [474,79], [484,81], [494,79], [504,79], [514,84], [524,88], [534,93], [544,93], [554,81], [564,95], [574,84], [584,78]]
        C2 = pd.DataFrame (CHA2, columns = ['Cod_NC', 'NC'])

        CHA3 = [[11,89], [21,86], [31,82], [41,84], [51,81], [61,82], [71,79], [81,81], [91,80], [101,80], [111,78], [121,78], [131,77], [141,82], [151,76], [161,80], [171,74], [181,80], [191,71], [201,68], [211,55], [221,50], [231,65], [241,56], [251,43], [261,75], [271,66], [281,56], [291,45], [301,29], [311,50], [321,83], [331,69], [341,60], [351,67], [361,43], [371,13], [381,73], [391,89], [401,99], [411,100], [421,67], [431,73], [441,78], [451,73], [461,71], [471,57], [481,61], [491,69], [501,55], [511,69], [521,80], [531,95], [541,95], [551,96], [561,97], [571,69], [581,50], [12,93], [22,91], [32,89], [42,90], [52,87], [62,87], [72,85], [82,88], [92,87], [102,87], [112,86], [122,86], [132,84], [142,89], [152,86], [162,87], [172,84], [182,86], [192,82], [202,82], [212,75], [222,68], [232,82], [242,78], [252,74], [262,87], [272,83], [282,78], [292,71], [302,64], [312,76], [322,90], [332,84], [342,78], [352,82], [362,77], [372,55], [382,84], [392,93], [402,99], [412,100], [422,82], [432,86], [442,87], [452,86], [462,83], [472,78], [482,78], [492,83], [502,77], [512,83], [522,89], [532,97], [542,97], [552,96], [562,98], [572,84], [582,76], [13,96], [23,94], [33,93], [43,92], [53,91], [63,90], [73,89], [83,92], [93,92], [103,91], [113,91], [123,90], [133,89], [143,92], [153,91], [163,92], [173,89], [183,90], [193,88], [203,89], [213,84], [223,81], [233,89], [243,86], [253,84], [263,93], [273,89], [283,84], [293,80], [303,73], [313,85], [323,93], [333,90], [343,87], [353,91], [363,87], [373,84], [383,90], [393,95], [403,99], [413,100], [423,89], [433,91], [443,91], [453,91], [463,90], [473,86], [483,91], [493,87], [503,86], [513,89], [523,93], [533,97], [543,97], [553,96], [563,98], [573,90], [583,85], [14,97], [24,96], [34,95], [44,94], [54,93], [64,91], [74,91], [84,94], [94,94], [104,93], [114,92], [124,91], [134,91], [144,94], [154,93], [164,93], [174,92], [184,92], [194,90], [204,92], [214,89], [224,86], [234,92], [244,90], [254,89], [264,96], [274,92], [284,88], [294,84], [304,78], [314,89], [324,95], [334,92], [344,90], [354,94], [364,92], [374,90], [384,93], [394,96], [404,99], [414,100], [424,92], [434,93], [444,84], [454,93], [464,92], [474,90], [484,91], [494,90], [504,90], [514,92], [524,94], [534,97], [544,97], [554,91], [564,99], [574,92], [584,89]]
        C3 = pd.DataFrame (CHA3, columns = ['Cod_NC', 'NC'])

        Valortabla = parameters['tabla']

        CHA = None

        if Valortabla == 'CHA I':
            CHA = C1
        elif Valortabla == 'CHA II':
            CHA = C2
        else:
            CHA = C3
        #Convertir la variable CHA en capa
        temp_csv_file = tempfile.NamedTemporaryFile(suffix='.csv', delete=False)
        CHA.to_csv(temp_csv_file.name, index=False)
        CHA_layer = QgsVectorLayer(temp_csv_file.name, "CHA", "ogr")

        # Cambiar el tipo de dato de la tabla CHA
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"Cod_NC"','length': 2,'name': 'Cod_NC','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'alias': '','comment': '','expression': '"NC"','length': 2,'name': 'NC','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
            'INPUT': CHA_layer,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RefactorFields'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # Union tabla NC
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'FIELD': 'Cod_NC',
            'FIELDS_TO_COPY': ['NC'],
            'FIELD_2': 'Cod_NC',
            'INPUT': outputs['Cod_ncCalculadoraDeCampos']['OUTPUT'],
            'INPUT_2': outputs['RefactorFields']['OUTPUT'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['UnionTablaNc'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Potencial Retención (S)
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'S',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': '254*((100/\"NC\")-1)',
            'INPUT': outputs['UnionTablaNc']['OUTPUT'],
            'NEW_FIELD': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PotencialRetencinS'] = processing.run('qgis:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # Abstracciones Iniciales (Io)
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Io',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': '\"S\"*0.2',
            'INPUT': outputs['PotencialRetencinS']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AbstraccionesInicialesIo'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # Coeficiente Abstracciones (CIo)
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'CIo',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': 'Case when \"Io\"<\"PP(mm)\" then ((\"Io\"/\"PP(mm)\")*100)\r\n\tWhen \"Io\">\"PP(mm)\" then 100\r\nend\r\n',
            'INPUT': outputs['AbstraccionesInicialesIo']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CIo'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # Escorrentía Q
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Q(mm)',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': '\r\nCase when \"Io\"<\"PP(mm)\" then ((\"PP(mm)\"-(0.2* \"S\"))^ 2)/(\"PP(mm)\" +(0.8* \"S\"))\r\n\tWhen \"Io\">\"PP(mm)\" then 0\r\nend\r\n',
            'INPUT': outputs['CIo']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Q'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # Coeficiente Escurrimiento CE
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'CE',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': '(\"Q(mm)\"/\"PP(mm)\")*100',
            'INPUT': outputs['Q']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CE'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Infiltración F Calculadora de campos
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'F(mm)',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': 'Case when \"Io\"<\"PP(mm)\" then (\"S\"*(\"PP(mm)\"-\"Io\")/(\"PP(mm)\"-\"Io\"+\"S\"))\r\n\tWhen \"Io\">\"PP(mm)\" then 0\r\nend\r\n\r\n',
            'INPUT': outputs['CE']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['F'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # Coeficiente Infiltración (CF)
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'CF',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': 'Case when \"Io\"<\"PP(mm)\" then ((\"F(mm)\"/\"PP(mm)\")*100)\r\n\tWhen \"Io\">\"PP(mm)\" then 0\r\nend\r\n',
            'INPUT': outputs['F']['OUTPUT'],
            'OUTPUT': parameters ['GeoQ'],
        }
        outputs['GeoQ'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GeoQ'] = outputs['GeoQ']['OUTPUT']

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # CE
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '\"CE\"','length': 5,'name': 'CE','precision': 2,'type': 6}],
            'INPUT': outputs['GeoQ']['OUTPUT'],
            'OUTPUT': parameters ['Ce'],
        }

        outputs['Ce'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Ce'] = outputs['Ce']['OUTPUT']

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # Obtener la ruta base de QGIS
        RutaDirectorio = QgsApplication.qgisSettingsDirPath()

        # Ruta del archivo QML
        QmlCE = os.path.join(RutaDirectorio, "python", "plugins", "GeoQ-main", "resourses","CE_azules.qml")
        QmlCF = os.path.join(RutaDirectorio, "python", "plugins", "GeoQ-main", "resourses","CF_marrores.qml")
        QmlCIo = os.path.join(RutaDirectorio, "python", "plugins", "GeoQ-main", "resourses","CIo_verdes.qml")
        QmlNC = os.path.join(RutaDirectorio, "python", "plugins", "GeoQ-main", "resourses","NC.qml")

        # Simbología CE
        alg_params = {
            'INPUT': outputs['Ce']['OUTPUT'],
            'STYLE': QmlCE
        }
        outputs['SimbologaCe'] = processing.run('qgis:setstyleforvectorlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # CF
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '\"CF\"','length': 5,'name': 'CF','precision': 2,'type': 6}],
            'INPUT': outputs['GeoQ']['OUTPUT'],
            'OUTPUT': parameters ['Cf'],
        }
        outputs['Cf'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Cf'] = outputs['Cf']['OUTPUT']

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Simbología CF
        alg_params = {
            'INPUT': outputs['Cf']['OUTPUT'],
            'STYLE': QmlCF
        }
        outputs['SimbologaCf'] = processing.run('qgis:setstyleforvectorlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # NC
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '\"NC\"','length': 5,'name': 'NC','precision': 2,'type': 6}],
            'INPUT': outputs['GeoQ']['OUTPUT'],
            'OUTPUT': parameters ['NC'],
        }
        outputs['NC'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['NC'] = outputs['NC']['OUTPUT']

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # Simbología NC
        alg_params = {
            'INPUT': outputs['NC']['OUTPUT'],
            'STYLE': QmlNC
        }
        outputs['SimbologaNC'] = processing.run('qgis:setstyleforvectorlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # CIo
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '\"CIo\"','length': 5,'name': 'CIo','precision': 2,'type': 6}],
            'INPUT': outputs['GeoQ']['OUTPUT'],
            'OUTPUT': parameters ['Cio'],

        }
        outputs['Cio'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Cio'] = outputs['Cio']['OUTPUT']

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # Simbología CIo
        alg_params = {
            'INPUT': outputs['Cio']['OUTPUT'],
            'STYLE': QmlCIo
        }
        outputs['SimbologaCio'] = processing.run('qgis:setstyleforvectorlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        return results


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'GeoQ V2'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
    
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo-mich.png')))
        return icon

    def createInstance(self):
        return GeoQAlgorithm()
