# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeoRural
                                 A QGIS plugin
 Georreferenciamento de Imóveis Rurais
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-13
        copyright            : (C) 2022 by Tiago Prudencio e Leandro França
        email                : contato@geoone.com.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Tiago Prudencio e Leandro França'
__date__ = '2022-02-13'
__copyright__ = '(C) 2022 by Tiago Prudencio e Leandro França'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os

from .algorithms.connectbase import ConnectBase
from .algorithms.getSpreadsheet import getSpreadsheet
from .algorithms.addFeat import addFeat
from .algorithms.createTemplate import createTemplate
from .algorithms.addWkt import addWkt
from .algorithms.toTopoGeo import ToTopoGeo
from .algorithms.fillCodes import FillCodes
from .algorithms.interpVerticeV import InterpolarVerticeV
from .algorithms.createTemplate2 import createTemplate2
from .algorithms.layersFromSheet import LayersFromSheet
from .algorithms.layersOfInterest import LayersOfInterest
from .algorithms.layersFromPDF import LayersFromPDF
from .algorithms.dividedByRoad import DividedByRoad
from .algorithms.conversorMemorial import ConversorMemorial


class GeoINCRAProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(ConnectBase())
        self.addAlgorithm(getSpreadsheet())
        self.addAlgorithm(addFeat())
        self.addAlgorithm(createTemplate())
        self.addAlgorithm(addWkt())
        self.addAlgorithm(ToTopoGeo())
        self.addAlgorithm(FillCodes())
        self.addAlgorithm(InterpolarVerticeV())
        self.addAlgorithm(createTemplate2())
        self.addAlgorithm(LayersFromSheet())
        self.addAlgorithm(LayersOfInterest())
        self.addAlgorithm(LayersFromPDF())
        self.addAlgorithm(DividedByRoad())
        self.addAlgorithm(ConversorMemorial())


    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return ''

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('GeoINCRA')

    def icon(self):
        return QIcon(os.path.dirname(__file__) + '/images/geoincra.png')

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
