# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeoINCRA
                                 A QGIS plugin
 Georreferenciamento de Imóveis Rurais
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-13
        copyright            : (C) 2022 by Tiago Prudencio e Leandro França
        email                : contato@geoone.com.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Tiago Prudencio e Leandro França'
__date__ = '2022-02-13'
__copyright__ = '(C) 2022 by Tiago Prudencio e Leandro França'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication, QVariant
from qgis.core import (QgsProcessing,
                       QgsProject,
                       QgsFeatureRequest,
                       QgsVectorLayer,
                       QgsField,
                       QgsCoordinateTransform,
                       QgsProcessingParameterExtent,
                       QgsEditorWidgetSetup,
                       QgsCoordinateReferenceSystem,
                       QgsRectangle,
                       QgsProcessingUtils,
                       QgsProcessingParameterEnum,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)

import os
from qgis.PyQt.QtGui import QIcon
from GeoINCRA.images.Imgs import *


class ConnectBase(QgsProcessingAlgorithm):

    INPUT = 'INPUT'
    OUTPUT = 'OUTPUT'
    EXTENT = 'EXTENT'
    WFS = 'WFS'

    mapping ={ 0: 'Imóveis Certificados SIGEF - Particular',
               1: 'Imóveis Certificados SIGEF - Público',
               2: 'Imóveis Certificados SNCI - Privado',
               3: 'Imóveis Certificados SNCI - Público',
               4: 'Assentamentos',
               5:'Quilombolas'
            }

    layer_name ={    0: 'ms:certificada_sigef_particular_xx',
               1: 'ms:certificada_sigef_publico_xx',
               2: 'ms:imoveiscertificados_privado_xx',
               3: 'ms:imoveiscertificados_publico_xx',
               4: 'ms:assentamentos_xx',
               5:'ms:quilombolas_xx'
            }

    links = {     'Imóveis Certificados SIGEF - Particular': 'http://acervofundiario.incra.gov.br/i3geo/ogc.php?tema=certificada_sigef_particular_xx',
                  'Imóveis Certificados SIGEF - Público': 'http://acervofundiario.incra.gov.br/i3geo/ogc.php?tema=certificada_sigef_publico_xx',
                  'Imóveis Certificados SNCI - Privado': 'http://acervofundiario.incra.gov.br/i3geo/ogc.php?tema=imoveiscertificados_privado_xx',
                  'Imóveis Certificados SNCI - Público': 'http://acervofundiario.incra.gov.br/i3geo/ogc.php?tema=imoveiscertificados_publico_xx',
                  'Assentamentos':'http://acervofundiario.incra.gov.br/i3geo/ogc.php?tema=assentamentos_xx',
                  'Quilombolas':'http://acervofundiario.incra.gov.br/i3geo/ogc.php?tema=quilombolas_xx'
            }

    def initAlgorithm(self, config):

        self.addParameter(
            QgsProcessingParameterExtent(
                self.EXTENT,
                self.tr('Retângulo de Extensão')
            )
        )

        self.addParameter(
            QgsProcessingParameterEnum(
                self.WFS,
                self.tr('Camada do acervo fundiário'),
                options = self.links.keys(),
                defaultValue= 0
            )
        )

        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Resultado da consulta ao INCRA')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):

        extensao = self.parameterAsExtent(
        parameters,
        self.EXTENT,
        context
        )
        if not extensao:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.EXTENT))

        crsSrc = QgsCoordinateReferenceSystem(QgsProject().instance().crs())
        crsDest = QgsCoordinateReferenceSystem('EPSG:4326')
        proj2geo = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
        extensao = proj2geo.transform(extensao)

        option = self.parameterAsEnum(parameters, self.WFS, context)
        layer = self.mapping[option]
        name = self.layer_name[option]
        link = self.links[layer]

        path = os.path.dirname(__file__) + "/shp" + "/BR_UF_2020.shp"
        estado = QgsVectorLayer(path, "BR_UF_2020", "ogr")

        uris = list()
        for feat in estado.getFeatures():
             if feat.geometry().intersects(extensao):

                 uri_default="""pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1'  srsname='EPSG:4326' typename='name_' url='link' version='auto'"""
                 uri_default = uri_default.replace('name_',name)
                 uri_default = uri_default.replace('link',link)
                 uri_default = uri_default.replace('xx',feat['SIGLA_UF'])
                 uris.append(uri_default)

        source = QgsVectorLayer(uris[0], "my wfs layer", "WFS")
        (sink, dest_id) = self.parameterAsSink(
            parameters,
            self.OUTPUT,
            context,
            source.fields(),
            source.wkbType(),
            source.sourceCrs()
        )
        if sink is None:
            raise QgsProcessingException(self.invalidSinkError(parameters, self.OUTPUT))

        for uri in uris:
            vlayer = QgsVectorLayer(uri, "wfs_layer", "WFS")

            request = QgsFeatureRequest().setFilterRect(extensao)

            for current, feature in enumerate(vlayer.getFeatures(request)):
                # Stop the algorithm if cancel button has been clicked
                if feedback.isCanceled():
                    break

                # Add a feature in the sink
                sink.addFeature(feature, QgsFeatureSink.FastInsert)


        layer = QgsProcessingUtils.mapLayerFromString(dest_id, context)
        self.addField(layer)

        return {self.OUTPUT: self.addField(layer)}


    def addField(self, layer):
    	config = {'IsMultiline': True, 'UseHtml': True}
    	field_type = 'TextEdit'
    	widget_setup = QgsEditorWidgetSetup(field_type,config)
    	layer.setEditorWidgetSetup(layer.fields().indexOf('base_INCRA'), widget_setup)
    	field= QgsField( 'base_INCRA', QVariant.String)
    	layer.addExpressionField(
'''replace('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
			<html>
			<head>
				<meta content="text/html; charset=ISO-8859-1"
				http-equiv="content-type">
				<title>base_INCRA</title>
			</head>
			<body>
			<a
			 href="https://sigef.incra.gov.br/geo/exportar/vertice/csv/[ID]/">Clique
			aqui para baixar CSV v&eacute;rtices (pontos)</a><br>
			<a
			 href="https://sigef.incra.gov.br/geo/exportar/limite/shp/[ID]/">Clique
			aqui para baixar Shapefile dos limites (linhas)</a><br>
			<a
			 href="https://sigef.incra.gov.br/geo/exportar/parcela/shp/[ID]/">Clique
			aqui para baixar Shapefile da parcela (&aacute;rea)</a><br><br>
            <a
			 href="https://sigef.incra.gov.br/geo/parcela/detalhe/[ID]/">Clique
			aqui para saber mais detalhes sobre a parcela (&aacute;rea)</a>
			</body>
			</html>','[ID]',  "parcela_codigo" )''', field
			)

    	return layer

    def name(self):
        return 'connectbase'

    def displayName(self):
        return self.tr('Consultar base do INCRA')

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ConnectBase()

    def icon(self):
        return QIcon(os.path.join(os.path.dirname(os.path.dirname(__file__)), 'images/geoincra_pb.png'))

    def shortHelpString(self):
        txt = "Conecta a base de dados do INCRA e carrega camada de imóveis a partir de um retângulo selecionado pelo usuário. Também é possível baixar dados dos imóveis certificados nos formatos CSV e SHP, obtendo-se mais informações complementares."

        footer = '''<div>
                      <div align="center">
                      <img style="width: 100%; height: auto;" src="data:image/jpg;base64,'''+ INCRA_GeoOne +'''
                      </div>
                      <div align="right">
                      <p align="right">
                      <a href="https://github.com/OpenGeoOne/GeoINCRA/wiki/Sobre-o-GeoINCRA#banco-de-dados-georural"><span style="font-weight: bold;">Clique aqui para conhecer o modelo GeoRural da GeoOne</span></a><br>
                      </p>
                      <p align="right">
                      <a href="https://sigef.incra.gov.br/consultar/parcelas/"><span style="font-weight: bold;">Clique aqui para consultar parcelas do SIGEF</span></a><br>
                      </p>
                      <a target="_blank" rel="noopener noreferrer" href="https://geoone.com.br/"><img title="GeoOne" src="data:image/png;base64,'''+ GeoOne +'''"></a>
                      <p><i>"Mapeamento automatizado, fácil e direto ao ponto é na GeoOne!"</i></p>
                      </div>
                    </div>'''
        return txt + footer
