# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeoDynGemGWSW
                                 A QGIS plugin
 test for multiple tabs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-07-15
        copyright            : (C) 2022 by bkgis
        email                : b.kropf@bkgis.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'bkgis'
__date__ = '2022-07-15'
__copyright__ = '(C) 2022 by bkgis'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import inspect
import os

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon

# from .custom_tools_lis2graph import CustomToolsLis2GraphAlgorithm
# from .custom_tools_add_field_from_dict_label import CustomToolsAddFieldsFromDictAlgorithm
# from .GWSW2Kikker import GwswGeodynStap1
from .custom_tools import (CustomToolsAddFieldsFromDictAlgorithm,
                           CustomToolsCalcFieldsFromDictAlgorithm,
                           CustomToolsLis2GraphAlgorithm,
                           CustomToolsBerekenOnderbemalingAlgorithm,
                           CustomToolsBerekenOnderbemalingFldsAlgorithm,
                           CustomToolsBerekenOnderbemalingFldsPOCAlgorithm,
                           CustomToolsVervangNoneDoor0Algorithm,
                           CustomToolsRetainFieldsAlgorithm,
                           CustomToolsSortByMultipleFieldsAlgorithm,
                           CustomToolsDropEmptyFieldsAlgorithm,
                           CustomToolsAddFieldAliasFromCsvAlgorithm)
from .Stap1BepalenAssetKenmerkenAfvoerpuntenRioleringsgebieden import GeodynGwswStap1BepalenAssetkenmerkenAfvoerpuntenRioleringsgebieden
from .Stap2BepalenEigenAfvalwateraanbod import GeodynGwswStap2BepalenEigenAfvalwateraanbod
from .Stap3BepalenBovenstroomseGebiedenEnAfvalwateraanbod import GeodynGwswStap3BepalenBovenstroomseGebiedenEnAfvalwateraanbod
# from .Stap1GwswToGeodyn import Stap1GwswToGeodyn
# from .Stap1KikkerToGeodyn import Stap1KikkerToGeodyn
# from .Stap2Genereer_afvoerrelaties import Stap2Genereer_afvoerrelaties
# from .Stap3BerekenAfvalwaterprognose import Stap3BerekenAfvalwaterprognose
# from .Stap3BerekenAfvalwaterprognoseAlt import Stap3BerekenAfvalwaterprognoseAlt
# from .StapAllemaal import GeodynAlleStappen
# from .StapAllemaal_Kikker import GeodynAlleStappenKikker
from .StapKoppelBgtinlooptabel import KoppelBgtinlooptabel
from .StapKoppelOverigeBronnen import KoppelOverigeBronnen


class GeoDynGemGWSWProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(GeodynGwswStap1BepalenAssetkenmerkenAfvoerpuntenRioleringsgebieden())
        self.addAlgorithm(GeodynGwswStap2BepalenEigenAfvalwateraanbod())
        self.addAlgorithm(GeodynGwswStap3BepalenBovenstroomseGebiedenEnAfvalwateraanbod())
        # self.addAlgorithm(Stap1GwswToGeodyn())
        # self.addAlgorithm(Stap1KikkerToGeodyn())
        # self.addAlgorithm(Stap2Genereer_afvoerrelaties())
        # self.addAlgorithm(Stap3BerekenAfvalwaterprognose())
        # self.addAlgorithm(Stap3BerekenAfvalwaterprognoseAlt())
        #self.addAlgorithm(GeodynAlleStappen())
        #self.addAlgorithm(GeodynAlleStappenKikker())

        # add customTools
        self.addAlgorithm(CustomToolsLis2GraphAlgorithm())
        self.addAlgorithm(CustomToolsAddFieldsFromDictAlgorithm())
        self.addAlgorithm(CustomToolsAddFieldAliasFromCsvAlgorithm())
        self.addAlgorithm(CustomToolsCalcFieldsFromDictAlgorithm())
        self.addAlgorithm(CustomToolsBerekenOnderbemalingAlgorithm())
        self.addAlgorithm(CustomToolsBerekenOnderbemalingFldsAlgorithm())
        self.addAlgorithm(CustomToolsBerekenOnderbemalingFldsPOCAlgorithm())
        self.addAlgorithm(CustomToolsVervangNoneDoor0Algorithm())
        self.addAlgorithm(CustomToolsRetainFieldsAlgorithm())
        self.addAlgorithm(CustomToolsDropEmptyFieldsAlgorithm())
        self.addAlgorithm(CustomToolsSortByMultipleFieldsAlgorithm())
        self.addAlgorithm(KoppelBgtinlooptabel())
        self.addAlgorithm(KoppelOverigeBronnen())
        ##self.addAlgorithm(GwswGeodynStap1())

        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'GeoDynTools'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('GeoDyn voor gemeenten')

    # def icon(self):
        # """
        # Should return a QIcon which is used for your provider inside
        # the Processing toolbox.
        # """
        # return QgsProcessingProvider.icon(self)

    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon   

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
