from pathlib import Path
from osgeo import gdal
import sys
from PyQt5.QtCore import QCoreApplication
import time
import os



from .utils.fauna import procesar_fauna
from .utils.flora_fustal import procesar_flora_fustal
from .utils.fauna_transecto import procesar_fauna_transecto
from .utils.flora_regeneracion import procesar_flora_regeneracion
from .utils.aprovechamiento_forestal import procesar_aprovechamiento
from .utils.muestreo_hidrobiotico import procesar_hidrobiotico
from .utils.muestreo_fisicoquimico import procesar_fisicoquimico
from .utils.agua_marino import procesar_marino
from .utils.hidrobio_marino import procesar_hidrobio
from .utils.fisicoquim_marino import procesar_fisicoquim
from .utils.mamiferos_OFM import procesar_mamiferos_OFM
from .utils.aves_OFM import procesar_aves_OFM
from .utils.peces_OFM import procesar_peces_OFM
from .utils.tortugas_OFM import procesar_tortugas_OFM
from .utils.otrafauna_OFM import procesar_otrafauna_OFM
from .utils.veda import procesar_veda
from .utils.fauna_marina import procesar_fauna_marina
from .utils.transecto_fauna_marina import procesar_transecto_fm
from .utils.flora_marina import procesar_flora_marina
from .utils import config as cfg

#from .utils_pnn import flora_restauracion_pnn
from .utils_pnn.flora_restauracion_pnn import procesar_flora_restauracion_pnn
from .utils_pnn.frailejon_PNN import procesar_frailejon_pnn
from .utils_pnn.flora_estructura_pnn import procesar_flora_estructura_pnn
from .utils_pnn.fauna_ocupacion_grandes_pnn import procesar_fauna_grandes_pnn
from .utils_pnn.fauna_caracol_pnn import procesar_fauna_caracol_pnn
from .utils_pnn.fauna_burgao_pnn import procesar_fauna_burgao_pnn
from .utils_pnn.aves_biodiversidad_pnn import procesar_aves_biodiversidad_pnn
from .utils_pnn.macroinvertebrados_pnn import procesar_macroinvertebrados_pnn
from .utils_pnn.pez_leon_pnn import procesar_pez_leon_pnn
from .utils_pnn.aves_abundancia_pnn import procesar_aves_abundancia_pnn
from .utils_pnn.ballenas_pnn import procesar_ballenas_pnn
from .utils_pnn.abundancia_tortugas_pnn import procesar_abundancia_tortugas_pnn
from .utils_pnn.flora_fenologia_pnn import procesar_flora_fenologia_pnn
from .utils_pnn.flora_regeneracion_pnn import procesar_flora_regeneracion_pnn
from .utils_pnn.aves_densidad_pnn import procesar_aves_densidad_pnn
from .utils_pnn.tortugas_anidacion_pnn import procesar_tortugas_anidacion_pnn
from .utils_pnn.fauna_ocupacion_nidos_pnn import procesar_fauna_nidos_pnn
from .utils_pnn.fauna_tamaño_pnn import procesar_fauna_tamaño_pnn
from .utils_pnn.invertebrados_marinos_pnn import procesar_invertebrados_pnn
from .utils_pnn.protistas_pnn import procesar_protistas_pnn
from .utils_pnn.flora_composicion_pnn import procesar_flora_composicion_pnn
from .utils_pnn.fauna_ocupacion_anfibios_pnn import procesar_fauna_ocupacion_anfibios_pnn
from .utils_pnn.pesca_comercial_pnn import procesar_pesca_comercial_pnn
from .utils_pnn.pesca_subsistencia_pnn import procesar_pesca_subsistencia_pnn
from .utils_pnn.fauna_fototrampeo_pnn import procesar_fauna_ft_pnn


def main(gdb_path=None, output_dir=None, progress=None, perfil="ANLA", epsg_origen=None):
    BASE_DIR = Path(__file__).resolve().parent
    ruta_gdb = Path(gdb_path)
    output_dir = Path(output_dir) if output_dir and output_dir.strip() else BASE_DIR / "output"
    output_dir.mkdir(parents=True, exist_ok=True) 
  



    # Obtener capas-tablas disponibles
    gdb = gdal.OpenEx(str(ruta_gdb), gdal.OF_VECTOR)
    capas_disponibles = set()
    if gdb:
        for i in range(gdb.GetLayerCount()):
            layer = gdb.GetLayerByIndex(i)
            capas_disponibles.add(layer.GetName())

    # Registro de módulos a ejecutar de ANLA
    modulos_disponibles_anla = {
        "fauna": {
            "func": procesar_fauna,
            "capas": ["PuntoMuestreoFauna"],
            "tablas": ["MuestreoFaunaTB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoMuestreoFauna", "MuestreoFaunaTB", "ID_MUES_PT",
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "fauna_final.xlsx"),
                epsg_origen
            ]
        },
        "flora_fustal": {
            "func": procesar_flora_fustal,
            "capas": ["PuntoMuestreoFlora"],
            "tablas": ["MuestreoFloraFustalTB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoMuestreoFlora", "MuestreoFloraFustalTB", "ID_MUEST",
                str(output_dir / "cruce_flora_fustal.xlsx"),
                str(output_dir / "cruce_flora_fustal.xlsx"),
                str(output_dir / "flora_fustal_final.xlsx"),
                epsg_origen
            ]
        },
        "fauna_transecto": {
            "func": procesar_fauna_transecto, 
            "capas": ["TransectoMuestreoFauna"],
            "tablas": ["MuestreoFaunaTB"],
            "args": lambda: [
                str(ruta_gdb), "TransectoMuestreoFauna", "MuestreoFaunaTB", "ID_MUES_TR",
                str(output_dir / "cruce_fauna_transecto.xlsx"),
                str(output_dir / "cruce_fauna_transecto.xlsx"),
                str(output_dir / "fauna_transecto_final.xlsx"),
                epsg_origen
            ]
        },
        "flora_regeneracion": {
            "func": procesar_flora_regeneracion,
            "capas": ["PuntoMuestreoFlora"],
            "tablas": ["MuestreoFloraRegeneracionTB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoMuestreoFlora", "MuestreoFloraRegeneracionTB", "ID_MUEST",
                str(output_dir / "cruce_flora_regeneracion.xlsx"),
                str(output_dir / "cruce_flora_regeneracion.xlsx"),
                str(output_dir / "flora_regeneracion_final.xlsx"),
                epsg_origen
            ]
        },
        "aprovechamiento": {
            "func": procesar_aprovechamiento,
            "capas": ["AprovechaForestalPT"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "AprovechaForestalPT",
                str(output_dir / "cruce_aprovechamiento.xlsx"),
                str(output_dir / "cruce_aprovechamiento.xlsx"),
                str(output_dir / "aprovechamiento_final.xlsx"),
                epsg_origen
            ]
        },
        "hidrobiotico": {
            "func": procesar_hidrobiotico,
            "capas": ["PuntoMuestreoAguaSuper"],
            "tablas": ["MuestreoHidrobioTB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoMuestreoAguaSuper", "MuestreoHidrobioTB", "ID_PUNTO_M",
                str(output_dir / "cruce_hidrobiotico.xlsx"),
                str(output_dir / "cruce_hidrobiotico.xlsx"),
                str(output_dir / "hidrobiotico_final.xlsx"),
                epsg_origen
            ]
        },
        "fisicoquimico": {
            "func": procesar_fisicoquimico,
            "capas": [],
            "tablas": ["MuestreoFisicoquimSuperTB", "ParamFisicoquimSuperTB"],
            "args": lambda: [
                str(ruta_gdb), "MuestreoFisicoquimSuperTB", "ParamFisicoquimSuperTB", "ID_MUESTRA",
                str(output_dir / "cruce_fisicoquimico.xlsx"),
                str(output_dir / "cruce_fisicoquimico.xlsx"),
                str(output_dir / "fisicoquimico_final.xlsx")
            ]
        },
        "agua_marino": {
            "func": procesar_marino,
            "capas": ["PuntoMuestreoAguaMarino"],
            "tablas": ["MuestreoHidrobioMarinoTB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoMuestreoAguaMarino", "MuestreoHidrobioMarinoTB", "ID_PUNTO_M",
                str(output_dir / "cruce_marino.xlsx"),
                str(output_dir / "cruce_marino.xlsx"),
                str(output_dir / "marino_evento_final.xlsx"),
                epsg_origen
            ]
        },
        "hidrobio_marino": {
            "func": procesar_hidrobio,
            "capas": [],
            "tablas": ["MuestreoHidrobioMarinoTB"],
            "args": lambda: [
                str(ruta_gdb), "MuestreoHidrobioMarinoTB",
                str(output_dir / "cruce_hidrobio_marino.xlsx"),
                str(output_dir / "cruce_hidrobio_marino.xlsx"),
                str(output_dir / "hidrobio_marino_final.xlsx")
            ]
        },
        "fisicoquim_marino": {
            "func": procesar_fisicoquim,
            "capas": [],
            "tablas": ["MuestreoFisicoquimMarinoTB"],
            "args": lambda: [
                str(ruta_gdb), "MuestreoFisicoquimMarinoTB",
                str(output_dir / "cruce_fisicoquim_marino.xlsx"),
                str(output_dir / "cruce_fisicoquim_marino.xlsx"),
                str(output_dir / "fisicoquim_marino_final.xlsx")
            ]
        },
        "mamiferos_OFM": {
            "func": procesar_mamiferos_OFM,
            "capas": ["PuntoObservacionFaunaMarina"],
            "tablas": ["MamiferosOFM_TB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoObservacionFaunaMarina", "MamiferosOFM_TB", "ID_INGRESO",
                str(output_dir / "cruce_mamiferos_OFM.xlsx"),
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "mamiferos_OFM_final.xlsx"),
                epsg_origen
            ]
        },
        "aves_OFM": {
            "func": procesar_aves_OFM,
            "capas": ["PuntoObservacionFaunaMarina"],
            "tablas": ["AvesOFM_TB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoObservacionFaunaMarina", "AvesOFM_TB", "ID_INGRESO",
                str(output_dir / "cruce_aves_OFM.xlsx"),
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "aves_OFM_final.xlsx"),
                epsg_origen
            ]
        },
        "peces_OFM": {
            "func": procesar_peces_OFM,
            "capas": ["PuntoObservacionFaunaMarina"],
            "tablas": ["PecesOFM_TB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoObservacionFaunaMarina", "PecesOFM_TB", "ID_INGRESO",
                str(output_dir / "cruce_peces_OFM.xlsx"),
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "peces_OFM_final.xlsx"),
                epsg_origen
            ]
        },
        "tortugas_OFM": {
            "func": procesar_tortugas_OFM,
            "capas": ["PuntoObservacionFaunaMarina"],
            "tablas": ["TortugasOFM_TB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoObservacionFaunaMarina", "TortugasOFM_TB", "ID_INGRESO",
                str(output_dir / "cruce_tortugas_OFM.xlsx"),
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "tortugas_OFM_final.xlsx"),
                epsg_origen
            ]
        },
        "otrafauna_OFM": {
            "func": procesar_otrafauna_OFM,
            "capas": ["PuntoObservacionFaunaMarina"],
            "tablas": ["OtraFaunaOFM_TB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoObservacionFaunaMarina", "OtraFaunaOFM_TB", "ID_INGRESO",
                str(output_dir / "cruce_otrafauna_OFM.xlsx"),
                str(output_dir / "cruce_fauna.xlsx"),
                str(output_dir / "otrafauna_OFM_final.xlsx"),
                epsg_origen
            ]
        },
        "veda": {
            "func": procesar_veda,
            "capas": ["PuntoMuestreoVeda"],
            "tablas": ["MuestreoVedaTB"],
            "args": lambda: [
                str(ruta_gdb), "PuntoMuestreoVeda", "MuestreoVedaTB", "ID_VEDA",
                str(output_dir / "cruce_veda.xlsx"),
                str(output_dir / "cruce_veda.xlsx"),
                str(output_dir / "veda_final.xlsx"),
                epsg_origen
            ]
        },
        "fauna_marina": {
            "func": procesar_fauna_marina,
            "capas": ["MuestreoFaunaMarina"],
            "tablas": ["MuestreoFaunaMarinaTB"],
            "args": lambda: [
                str(ruta_gdb), "MuestreoFaunaMarina", "MuestreoFaunaMarinaTB", "ID_MUEST_P",
                str(output_dir / "cruce_fauna_marina.xlsx"),
                str(output_dir / "cruce_fauna_marina.xlsx"),
                str(output_dir / "fauna_marina_final.xlsx"),
                epsg_origen
            ]
        },
        "transecto_fm": {
            "func": procesar_transecto_fm,
            "capas": ["TansectoFaunaMarina"],
            "tablas": ["MuestreoFaunaMarinaTB"],
            "args": lambda: [
                str(ruta_gdb), "TansectoFaunaMarina", "MuestreoFaunaMarinaTB", "ID_MUEST_T",
                str(output_dir / "cruce_transecto_fm.xlsx"),
                str(output_dir / "cruce_transecto_fm.xlsx"),
                str(output_dir / "transecto_fm_final.xlsx"),
                epsg_origen
            ]
        },
        "flora_marina": {
            "func": procesar_flora_marina,
            "capas": ["MuestreoFloraMarina"],
            "tablas": ["MuestreoFloraMarinaTB"],
            "args": lambda: [
                str(ruta_gdb), "MuestreoFloraMarina", "MuestreoFloraMarinaTB", "ID_MUEST",
                str(output_dir / "cruce_flora_marina.xlsx"),
                str(output_dir / "cruce_flora_marina.xlsx"),
                str(output_dir / "flora_marina_final.xlsx"),
                epsg_origen
            ]
        },        
    }

    # Registro de módulos a ejecutar PNN
    modulos_disponibles_pnn  = {
        "flora_restauracion_pnn": {
            "func": procesar_flora_restauracion_pnn,
            "capas": ["Flora_restauracion_supervivencia"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Flora_restauracion_supervivencia",
                str(output_dir / "cruce_flora_restauracion_pnn.xlsx"),
                str(output_dir / "cruce_flora_restauracion_pnn.xlsx"),
                str(output_dir / "flora_restauracion_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_frailejon_pnn": {
            "func": procesar_frailejon_pnn,
            "capas": ["Flora_densidad_Frailejones"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Flora_densidad_Frailejones",
                str(output_dir / "cruce_frailejon_pnn.xlsx"),
                str(output_dir / "cruce_frailejon_pnn.xlsx"),
                str(output_dir / "frailejon_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_flora_estructura_pnn": {
            "func": procesar_flora_estructura_pnn,
            "capas": ["Flora_estructura"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Flora_estructura",
                str(output_dir / "cruce_flora_estructura_pnn.xlsx"),
                str(output_dir / "cruce_flora_estructura_pnn.xlsx"),
                str(output_dir / "flora_estructura_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_grandes_pnn": {
            "func": procesar_fauna_grandes_pnn,
            "capas": ["Fauna_ocupacion_grandes_mamiferos"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_ocupacion_grandes_mamiferos",
                str(output_dir / "cruce_fauna_grandes_pnn.xlsx"),
                str(output_dir / "cruce_fauna_grandes_pnn.xlsx"),
                str(output_dir / "fauna_grandes_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_caracol_pnn": {
            "func": procesar_fauna_caracol_pnn,
            "capas": ["Fauna_densidad_Caracol_pala"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_densidad_Caracol_pala",
                str(output_dir / "cruce_fauna_caracol_pnn.xlsx"),
                str(output_dir / "cruce_fauna_caracol_pnn.xlsx"),
                str(output_dir / "fauna_caracol_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_burgao_pnn": {
            "func": procesar_fauna_burgao_pnn,
            "capas": ["Fauna_densidad_Burgao"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_densidad_Burgao",
                str(output_dir / "cruce_fauna_burgao_pnn.xlsx"),
                str(output_dir / "cruce_fauna_burgao_pnn.xlsx"),
                str(output_dir / "fauna_burgao_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_aves_biodiversidad_pnn": {
            "func": procesar_aves_biodiversidad_pnn,
            "capas": ["Fauna_aves_biodiversidad"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_aves_biodiversidad",
                str(output_dir / "cruce_aves_biodiversidad_pnn.xlsx"),
                str(output_dir / "cruce_aves_biodiversidad_pnn.xlsx"),
                str(output_dir / "aves_biodiversidad_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_macroinvertebrados_pnn": {
            "func": procesar_macroinvertebrados_pnn,
            "capas": ["Fauna_macroinvertebrados"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_macroinvertebrados",
                str(output_dir / "cruce_macroinvertebrados_pnn.xlsx"),
                str(output_dir / "cruce_macroinvertebrados_pnn.xlsx"),
                str(output_dir / "macroinvertebrados_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_pez_leon_pnn": {
            "func": procesar_pez_leon_pnn,
            "capas": ["Presion_fauna_pez_leon"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Presion_fauna_pez_leon",
                str(output_dir / "cruce_pez_leon_pnn.xlsx"),
                str(output_dir / "cruce_pez_leon_pnn.xlsx"),
                str(output_dir / "pez_leon_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_aves_abundancia_pnn": {
            "func": procesar_aves_abundancia_pnn,
            "capas": ["Fauna_aves_abundancia"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_aves_abundancia",
                str(output_dir / "cruce_aves_abundancia_pnn.xlsx"),
                str(output_dir / "cruce_aves_abundancia_pnn.xlsx"),
                str(output_dir / "aves_abundancia_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_ballenas_pnn": {
            "func": procesar_ballenas_pnn,
            "capas": ["Fauna_ballenas_abundancia"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_ballenas_abundancia",
                str(output_dir / "cruce_ballenas_pnn.xlsx"),
                str(output_dir / "cruce_ballenas_pnn.xlsx"),
                str(output_dir / "ballenas_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_abundancia_tortugas_pnn": {
            "func": procesar_abundancia_tortugas_pnn,
            "capas": ["Fauna_abundancia_tortugas"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_abundancia_tortugas",
                str(output_dir / "cruce_tortugas_abundancia_pnn.xlsx"),
                str(output_dir / "cruce_tortugas_abundancia_pnn.xlsx"),
                str(output_dir / "tortugas_abundancia_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_flora_fenologia_pnn": {
            "func": procesar_flora_fenologia_pnn,
            "capas": ["Flora_fenologia_especies_maderables"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Flora_fenologia_especies_maderables",
                str(output_dir / "cruce_flora_fenologia_pnn.xlsx"),
                str(output_dir / "cruce_flora_fenologia_pnn.xlsx"),
                str(output_dir / "flora_fenologia_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_flora_regeneracion_pnn": {
            "func": procesar_flora_regeneracion_pnn,
            "capas": ["Flora_regeneracion_natural"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Flora_regeneracion_natural",
                str(output_dir / "cruce_flora_regeneracion_pnn.xlsx"),
                str(output_dir / "cruce_flora_regeneracion_pnn.xlsx"),
                str(output_dir / "flora_regeneracion_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_aves_densidad_pnn": {
            "func": procesar_aves_densidad_pnn,
            "capas": ["Fauna_aves_densidad"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_aves_densidad",
                str(output_dir / "cruce_aves_densidad_pnn.xlsx"),
                str(output_dir / "cruce_aves_densidad_pnn.xlsx"),
                str(output_dir / "aves_densidad_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_tortugas_anidacion_pnn": {
            "func": procesar_tortugas_anidacion_pnn,
            "capas": ["Fauna_tortugas_anidacion"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_tortugas_anidacion",
                str(output_dir / "cruce_tortugas_anidacion_pnn.xlsx"),
                str(output_dir / "cruce_tortugas_anidacion_pnn.xlsx"),
                str(output_dir / "tortugas_anidacion_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_nidos_pnn": {
            "func": procesar_fauna_nidos_pnn,
            "capas": ["Fauna_ocupacion_nidos_guacharos"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_ocupacion_nidos_guacharos",
                str(output_dir / "cruce_fauna_nidos_pnn.xlsx"),
                str(output_dir / "cruce_fauna_nidos_pnn.xlsx"),
                str(output_dir / "fauna_nidos_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_tamaño_pnn": {
            "func": procesar_fauna_tamaño_pnn,
            "capas": ["Fauna_tamaño_poblacional_reptiles"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_tamaño_poblacional_reptiles",
                str(output_dir / "cruce_fauna_tamaño_pnn.xlsx"),
                str(output_dir / "cruce_fauna_tamaño_pnn.xlsx"),
                str(output_dir / "fauna_tamaño_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_invertebrados_pnn": {
            "func": procesar_invertebrados_pnn,
            "capas": ["Fauna_estado_conservacion_invertebrados_marinos"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_estado_conservacion_invertebrados_marinos",
                str(output_dir / "cruce_invertebrados_marinos_pnn.xlsx"),
                str(output_dir / "cruce_invertebrados_marinos_pnn.xlsx"),
                str(output_dir / "invertebrados_marinos_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_protistas_pnn": {
            "func": procesar_protistas_pnn,
            "capas": ["Protistas_diversidad_foraminiferos"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Protistas_diversidad_foraminiferos",
                str(output_dir / "cruce_protistas_pnn.xlsx"),
                str(output_dir / "cruce_protistas_pnn.xlsx"),
                str(output_dir / "protistas_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_ocupacion_anfibios_pnn": {
            "func": procesar_fauna_ocupacion_anfibios_pnn,
            "capas": ["Fauna_ocupacion_anfibios"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Fauna_ocupacion_anfibios",
                str(output_dir / "cruce_ocupacion_anfibios_pnn.xlsx"),
                str(output_dir / "cruce_ocupacion_anfibios_pnn.xlsx"),
                str(output_dir / "ocupacion_anfibios_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_flora_composicion_pnn": {
            "func": procesar_flora_composicion_pnn,
            "capas": ["Flora_estructura_y_composicion"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Flora_estructura_y_composicion",
                str(output_dir / "cruce_flora_composicion_pnn.xlsx"),
                str(output_dir / "cruce_flora_composicion_pnn.xlsx"),
                str(output_dir / "flora_composicion_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_pesca_comercial_pnn": {
            "func": procesar_pesca_comercial_pnn,
            "capas": ["Hidrobiologicos_pesca_comercial"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Hidrobiologicos_pesca_comercial",
                str(output_dir / "cruce_pesca_comercial_pnn.xlsx"),
                str(output_dir / "cruce_pesca_comercial_pnn.xlsx"),
                str(output_dir / "pesca_comercial_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_pesca_subsistencia_pnn": {
            "func": procesar_pesca_subsistencia_pnn,
            "capas": ["Hidrobiologicos_pesca_subsistencia"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "Hidrobiologicos_pesca_subsistencia",
                str(output_dir / "cruce_pesca_subsistencia_pnn.xlsx"),
                str(output_dir / "cruce_pesca_subsistencia_pnn.xlsx"),
                str(output_dir / "pesca_subsistencia_pnn_final.xlsx"),
                epsg_origen
            ]
        },
        "procesar_fauna_ft_pnn": {
            "func": procesar_fauna_ft_pnn,
            "capas": ["fauna_fototrampeo"],
            "tablas": [],
            "args": lambda: [
                str(ruta_gdb), "fauna_fototrampeo",
                str(output_dir / "cruce_fauna_fototrampeo_pnn.xlsx"),
                str(output_dir / "cruce_fauna_fototrampeo_pnn.xlsx"),
                str(output_dir / "fauna_fototrampeo_pnn_final.xlsx"),
                epsg_origen
            ]
        },

        
        

    }


    # Elegir qué registro usar
    if perfil == "ANLA":
        registro = modulos_disponibles_anla
    elif perfil == "PNN":
        registro = modulos_disponibles_pnn
    else:
        raise ValueError(f"Perfil no reconocido: {perfil}")

    # Se ejecutan los módulos disponibles
    archivos_eliminados = set()
    for nombre, config in registro.items():
        if all(c in capas_disponibles for c in config["capas"]) and all(t in capas_disponibles for t in config["tablas"]):
            try:
                if progress:
                    progress.setLabelText(f"Ejecutando módulo: {nombre}")
                    progress.repaint()
                    QCoreApplication.processEvents()


                config["func"](*config["args"]())
                time.sleep(5)  

                args = config["args"]()
                for arg in args:
                    if isinstance(arg, str) and "cruce_" in arg and arg.endswith(".xlsx"):
                        if arg not in archivos_eliminados:
                            try:
                                os.remove(arg)
                                archivos_eliminados.add(arg)

                            except FileNotFoundError:
                                pass  # Ya se eliminó o no existe
                            except Exception as e:
                                pass


            except Exception as e:
                pass
        


if __name__ == "__main__":
    import sys
    gdb_path_arg = sys.argv[1] if len(sys.argv) > 1 else None
    main(gdb_path_arg)

