from PyQt5.QtWidgets import QApplication, QDialog, QFileDialog, QMessageBox, QProgressDialog
from PyQt5.QtCore import Qt, QCoreApplication, QObject, pyqtSignal, QThread
import sys
from .ui_interfaz_plugin import Ui_Dialog
from pathlib import Path
import subprocess
from ..main import main  
from qgis.gui import QgsProjectionSelectionDialog
from PyQt5.QtWidgets import QLineEdit, QPushButton
from PyQt5 import QtCore
from PyQt5.QtWidgets import QGroupBox, QRadioButton, QVBoxLayout, QLabel
from PyQt5.QtGui import QPixmap





import re


class Worker(QObject):
    finished = pyqtSignal()
    error = pyqtSignal(str)

    def __init__(self, ruta_gdb, output_dir, perfil="ANLA", epsg_origen=None, parent=None):
        super().__init__(parent)
        self.ruta_gdb = ruta_gdb
        self.output_dir = output_dir
        self.perfil = perfil
        self.epsg_origen = epsg_origen

    def run(self):
        try:
            from .. import main  
            main.main(self.ruta_gdb, self.output_dir, perfil=self.perfil, epsg_origen=self.epsg_origen)
            self.finished.emit()
        except Exception as e:
            self.error.emit(str(e))


class VentanaPlugin(QDialog, Ui_Dialog):

    def on_worker_finished(self):
        self.progress.close()
        QMessageBox.information(
        self,
        "Éxito",
        f"Herramienta ejecutada correctamente"
        )   

    def on_worker_error(self, mensaje):
        self.progress.close()
        QMessageBox.critical(self, "Error", f"Ocurrió un error:\n{mensaje}")


    def __init__(self, iface):
        super().__init__()
        self.iface = iface
        self.epsg_origen = None
        self.ruta_gdb = ""
        self.setupUi(self)
        self.setWindowTitle("Herramienta SiB Colombia")  

        
        # Selector de modelo de datos (ANLA / PNN)
    
        self.label_modelo = QLabel("Seleccione el modelo de datos:", self)
        self.label_modelo.setGeometry(QtCore.QRect(20, 10, 200, 18))  # arriba

        self.radioAnla = QRadioButton("ANLA", self)
        self.radioAnla.setChecked(True)  # ANLA por defecto
        self.radioAnla.setGeometry(QtCore.QRect(20, 35, 100, 18))

        self.radioPnn = QRadioButton("PNN", self)
        self.radioPnn.setGeometry(QtCore.QRect(100, 35, 100, 18))

        # Logo SiB Colombia
        plugin_dir = Path(__file__).resolve().parent.parent
        logo_path = plugin_dir / "logo.png"

        self.logo_label = QLabel(self)
        pm = QPixmap(str(logo_path)).scaled(50, 50, Qt.KeepAspectRatio, Qt.SmoothTransformation)
        self.logo_label.setPixmap(pm)
        self.logo_label.setGeometry(300, 10, pm.width(), pm.height())

        # GDB
        self.lineEdit.setGeometry(QtCore.QRect(20, 70, 181, 20))
        self.pushButton.setGeometry(QtCore.QRect(220, 70, 75, 23))  # "Explorar GDB"

        # Proyección
        self.lineEdit_2.setGeometry(QtCore.QRect(20, 110, 181, 20))
        self.pushButton_2.setGeometry(QtCore.QRect(220, 110, 121, 23))  # "Seleccionar Proyección"

        # Carpeta de salida (estos dos los creas en Python)
        self.output_dir = ""
        self.output_dir_line = QLineEdit(self)
        self.output_dir_line.setGeometry(QtCore.QRect(20, 150, 181, 20))

        self.output_dir_button = QPushButton("Seleccionar carpeta salida", self)
        self.output_dir_button.setGeometry(QtCore.QRect(220, 150, 151, 23))
        self.output_dir_button.clicked.connect(self.seleccionar_output_dir)

        # Botones inferiores
        self.pushButton_3.setGeometry(QtCore.QRect(210, 200, 75, 23))  # "Ejecutar"
        self.pushButton_4.setGeometry(QtCore.QRect(300, 200, 75, 23))  # "Cerrar"

        # Conectar botones
        self.pushButton.clicked.connect(self.seleccionar_gdb)       # Explorar GDB
        self.pushButton_2.clicked.connect(self.seleccionar_crs)     # Seleccionar proyección
        self.pushButton_3.clicked.connect(self.ejecutar_herramienta)  # Ejecutar
        self.pushButton_4.clicked.connect(self.close)               # Cerrar

    def seleccionar_gdb(self):
        ruta = QFileDialog.getExistingDirectory(self, "Seleccionar Geodatabase (.gdb)")

        if ruta and Path(ruta).suffix == ".gdb":
            self.ruta_gdb = ruta  # guarda la ruta para usarla en el metodo ejecutar_herramienta
            self.lineEdit.setText(ruta)
        else:
            QMessageBox.warning(self, "Selección inválida", "Por favor selecciona una carpeta con extensión .gdb")


    def seleccionar_crs(self):
        dlg = QgsProjectionSelectionDialog()
        if dlg.exec_():
            crs = dlg.crs()
            self.epsg_origen = crs.authid() 
            self.lineEdit_2.setText(self.epsg_origen)


    def seleccionar_output_dir(self):
        carpeta = QFileDialog.getExistingDirectory(self, "Seleccionar carpeta de salida")
        if carpeta:
            self.output_dir = carpeta
            self.output_dir_line.setText(carpeta)


    def ejecutar_herramienta(self):
        if not self.ruta_gdb:
            QMessageBox.warning(self, "Falta GDB", "Debes seleccionar una Geodatabase antes de ejecutar.")
            return

        self.progress = QProgressDialog("Ejecutando herramienta...", None, 0, 0, self)
        self.progress.setWindowTitle("Procesando")
        self.progress.setCancelButton(None)
        self.progress.setMinimumDuration(0)
        self.progress.setWindowModality(Qt.WindowModal)
        self.progress.show()
        perfil = "PNN" if self.radioPnn.isChecked() else "ANLA"

        # Crear el hilo y el trabajador
        self.thread = QThread()
        self.worker = Worker(self.ruta_gdb, self.output_dir, perfil, self.epsg_origen)
        self.worker.moveToThread(self.thread)

        # Conectar señales
        self.thread.started.connect(self.worker.run)
        self.worker.finished.connect(self.on_worker_finished)
        self.worker.error.connect(self.on_worker_error)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)

        self.thread.start()






if __name__ == "__main__":
    app = QApplication(sys.argv)
    ventana = VentanaPlugin()
    ventana.show()
    sys.exit(app.exec_())
