# GeoDarwin
Este plugin de QGIS permite extraer y transformar al estándar para manejo de datos biológicos Darwin Core (DwC), los datos bióticos almacenados en  bases de datos geográficas estructuradas bajo el [Marco de Almacenamiento Geográfico (MAG) de la Autoridad Nacional de Licencias Ambientales de Colombia(ANLA)](https://www.anla.gov.co/01_anla/entidad/subdirecciones-y-oficinas/instrumentos-permisos-y-tramites-ambientales/sistema-de-informacion-geografica), en su versión del año 2021.

El plugin desarrollado por el Equipo Coordinador del Sistema de Información sobre Biodiversidad de Colombia (SiB Colombia) actualmente se encuentra en una versión alfa, con funcionalidades estables para conversión y exportación a Excel.

# Compatibilidad
QGIS 3.22 o superior.

Probado en Windows y macOS.

# Instalación

### Requisito especial para macOS
En sistemas macOS, es necesario instalar manualmente la librería openpyxl, ya que QGIS no la incluye por defecto:

Para esto, ejecuta el siguiente comando en la terminal de macOS:
`/Applications/QGIS.app/Contents/MacOS/bin/python3 -m pip install openpyxl`

Se recomienda hacer este paso antes de instalar el plugin y solamente es necesario hacerlo la primera vez.

## Instalación desde el repositorio oficial.

1. Abre QGIS.
2. Ve al menú `Complementos` → `Administrar e instalar complementos...`. → `Todos`
3. En la opción buscar escribe ’geodarwin’
4. Selecciona el plugin y haz clic en `Instalar complemento`.

## Instalación manual desde repositorio.
La otra opción es hacerlo directamente desde el archivo .zip del repositorio, siguiendo esta ruta:

1. Ingrese al repositorio: [https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc](https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc)
2. De clic en la opción Code y luego seleccione la opción zip en la sección Download source code. Puede descargarlo directamente en este [enlace](https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc/-/archive/main/pluginqgis-bdgeo-to-dwc-main.zip?ref_type=heads)
3. Abre QGIS.
4. Ve al menú `Complementos` → `Administrar e instalar complementos...`.
5. Haz clic en el botón `Instalar a partir de ZIP`.
6. Selecciona el archivo `.zip` del plugin.
7. Haz clic en **Instalar complemento**.

# Uso
1. Una vez instalado, encontrarás el plugin en la barra de herramientas de QGIS.
2. Haz clic en el ícono del plugin para abrir la interfaz.
3. En el botón `Explorar GDB`, selecciona el archivo .gdb que deseas convertir. En este momento, la herramienta solamente funciona con los datos que sigan el Modelo de Almacenamiento Geográfico de la ANLA en su versión  del 2021.
4. Selecciona la proyección espacial de la gdb.
4. Elige la ubicación de la carpeta de salida.
5. Haz clic en `Ejecutar`. Este proceso puede tomar hasta dos horas en caso de que sus datos tengan más de 50.000 registros.

Al ejecutar el plugin se recorren las capas y tablas de la base de datos geográfica y se generan automáticamente archivos Excel que integran la información espacial con la tabular, según la correspondencia y mapeo con el estándar Darwin Core.

Los archivos de salida en formato Excel generados por el plugin, corresponden al cruce entre una capa vectorial y la tabla asociada en la base de datos geográfica. La relación es la siguiente:

1. fauna_final → PuntoMuestreoFauna + MuestreoFaunaTB
2. flora_fustal_final → PuntoMuestreoFlora + MuestreoFloraFustalTB
3. fauna_transecto_final → TransectoMuestreoFauna + MuestreoFaunaTB
4. flora_regeneracion_final → PuntoMuestreoFlora + MuestreoFloraRegeneracionTB
5. aprovechamiento_final → AprovechaForestalPT
6. hidrobiotico_final → PuntoMuestreoAguaSuper + MuestreoHidrobioticoTB
7. * fisicoquimico_final → MuestreoFisicoquimSuperTB y ParamFisicoquimSuperTB
8. marino_evento_final → PuntoMuestreoAguaMarino + MuestreoHidrobioMarinoTB
9. hidrobio_marino_final → MuestreoHidrobioMarinoTB
10. * fisicoquim_marino_final → MuestreoFisicoquimMarinoTB
11. mamiferos_OFM_final → PuntoObservacionFaunaMarina + MamiferosOFM_TB
12. aves_OFM_final → PuntoObservacionFaunaMarina + AvesOFM_TB
13. peces_OFM_final → PuntoObservacionFaunaMarina + PecesOFM_TB
14. tortugas_OFM_final → PuntoObservacionFaunaMarina + TortugasOFM_TB
15. otrafauna_OFM_final → PuntoObservacionFaunaMarina + OtraFaunaOFM_TB
16. veda_final → PuntoMuestreoVeda + MuestreoVedaTB
17. fauna_marina_final → MuestreoFaunaMarina + MuestreoFaunaMarinaTB
18. transecto_fm_final → TransectoFaunaMarina + MuestreoFaunaMarinaTB
19. flora_marina_final → MuestreoFloraMarina + MuestreoFloraMarinaTB

* Los datos en esta capa están estructurados de acuerdo con la extensión Darwin Core de [Medidas o Hechos Extendida](https://biodiversidad.co/elementos-darwin-core#medidas-o-hechos-extendida).

Puede consultar los archivos de mapeo al estándar Darwin Core con el detalle para cada capa y tabla en los siguientes enlaces:

- [Eventos de muestreo](https://docs.google.com/spreadsheets/d/17ys5dkCNZDXpeguHbnnTI-RYiJPyMQz4HuRO-FLcaUE/edit?usp=sharing)
- [Registros biológicos](https://docs.google.com/spreadsheets/d/1cX3ayuk6A-Fq2XcsTiIrkoQ2XetU9Y9rkgy0iUjk4RY/edit?usp=sharing)
- [Medidas abióticas](https://docs.google.com/spreadsheets/d/1xS28Pwx6INx14Fag1-UXghLrvawb92KUQYcIfl4wf-M/edit?usp=sharing)
- [Capas marinas y de flora en veda](https://docs.google.com/spreadsheets/d/1hmQCX1jbAxfpfK_3Pz4fllkCzIaFc3BE7NgTMc5cfaI/edit?usp=sharing)

6. Realice una revisión de los archivos que generó la herramienta, es **indispensable** que revise y confirme que todos sus datos biológicos han sido transformados. En algunos casos, los archivos presentados a la ANLA pueden no seguir la estructura del MAG o tener capas adicionales, estas capas adicionales no son transformadas por la herramienta y las debe transformar de forma manual.

7. En estos archivos se realiza el proceso de estructuración al estándar Darwin Core y la transformación de coordenadas al formato decimal, sin embargo, no hacen más procesos de calidad, por lo que es necesario que los usuarios hagan los ajustes de calidad pertinentes. Para estos los invitamos a utilizar los [Laboratorios de validación y limpieza](https://biodiversidad.co/formacion/laboratorios/ContextoValidacionLimpieza). 
A excepción de los archivos fisicoquimico_final y fisicoquim_marino_final, se recomienda compilar todos los archivos para facilitar el proceso de calidad, puede hacer esto de forma simple en [OpenRefine](https://biodiversidad.co/formacion/laboratorios/OpenRefine#22-selecci%C3%B3n-del-archivo).

8. Luego de haber realizado los ajustes de calidad, puede ponerse en contacto con el equipo coordinador para comenzar el proceso de publicación de datos a través del SiB Colombia, siguiendo la [Guía para publicar datos, paso 4](https://biodiversidad.co/compartir/guia-para-publicar/#4-solicita-un-acompa%C3%B1amiento-para-la-publicaci%C3%B3n).

# Autor y contacto

Si encuentra algún problema o tiene algún comentario sobre la herramienta, lo invitamos a escribirnos al correo [sib@humboldt.org.co](sib@humboldt.org.co). Si encuentra alguna falla, puede crear un issue en el [repositorio de GitLab](https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc/-/issues) o escribir un correo.

**Gonzalo Cabezas** 
Desarrollador Principal:responsable del desarrollo del plugin y su integración con QGIS.
Investigador de la Gerencia de Información Científica
Instituto de Investigación de Recursos Biológicos Alexander von Humboldt

Correo: [gcabezas@humboldt.org.co]

**Esteban Marentes** 
Especialista en Modelado:responsable del mapeo de variables entre el modelo ANLA y el estándar Darwin Core.
Investigador de la Gerencia de Información Científica
Equipo Coordinador del SiB Colombia
Instituto de Investigación de Recursos Biológicos Alexander von Humboldt
Correo: [emarentes@humboldt.org.co]

# Licencia
Este proyecto está bajo la licencia MIT.
Consulta el archivo LICENCIA para más información.

## Estructura del proyecto
- `main.py`: Archivo principal  del proyecto.
- `utils/`: Módulos con funciones auxiliares.
- `tests/`: Pruebas unitarias.
- `output/`: Resultados generados.

# GeoDarwin
This plugin allows users to transform and export geoenvironmental data coming from the [MAG format (Modelo de Almacenamiento Geográfico) of ANLA 2021(https://www.anla.gov.co/01_anla/entidad/subdirecciones-y-oficinas/instrumentos-permisos-y-tramites-ambientales/sistema-de-informacion-geografica), into the Darwin Core Standard (DwC) directly from QGIS instead of doing it manually.

Currently it is in an alpha version, with stable functionalities to convert and export data to excel files.

# Compatibility
QGIS 3.22 o higher.

Tested on Windows and macOS.

# Installation

### Special prerequisite for macOS
If you are using a macOS system, it is necessary to manually install the python library openpyxl, because QGIS does not have it natively.

For this, execute the following command on the macOS terminal:
`/Applications/QGIS.app/Contents/MacOS/bin/python3 -m pip install openpyxl`

You have to do this before installing the plugin and only one time.

## Installation from the official repository

1. Open QGIS
2. Go to menu `Plugins` → `Manage and Install plugins`.
3. In the search option, write ’geodarwin’
4. Select the plugin and click on `Install plugin`.

## Manual installation from the GitLab repository

You can install this plugin directly from the GitLab repository using a .zip file, following these steps:

1. Go to the repository: [https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc](https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc)
2. Click the Code option and select zip in the Download source code. You can download directly from this [link](https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc/-/archive/main/pluginqgis-bdgeo-to-dwc-main.zip?ref_type=heads)
3. Open QGIS.
4. Go to menu `Plugins` → `Manage and Install plugins`.
5. Click the button **Install from ZIP**.
6. Select the `.zip` file of the plugin geo2dwc.
7. Click in **Install Plugin**.

# Use the plugin
1. Once installed, you will find the plugin at the toolbar section on QGIS.
2. Click the plugin icon to open the interface.
3. In the `Explorar GDB` button, select the .gdb file that you wish to transform. At this time, the plugin only works with MAG 2021.
4. Select the adequate projection for your file.
4. Select a folder in which your transformed data will be stored.
5. Click `Ejecutar`, this process can take up to 2 hours, especially if you have more than 50.000 biological records.

Plugin will export your data in several excel files, following this structure:

1. fauna_final → PuntoMuestreoFauna + MuestreoFaunaTB
2. flora_fustal_final → PuntoMuestreoFlora + MuestreoFloraFustalTB
3. fauna_transecto_final → TransectoMuestreoFauna + MuestreoFaunaTB
4. flora_regeneracion_final → PuntoMuestreoFlora + MuestreoFloraRegeneracionTB
5. aprovechamiento_final → AprovechaForestalPT
6. hidrobiotico_final → PuntoMuestreoAguaSuper + MuestreoHidrobioticoTB
7. fisicoquimico_final → MuestreoFisicoquimSuperTB y ParamFisicoquimSuperTB
8. marino_evento_final → PuntoMuestreoAguaMarino + MuestreoHidrobioMarinoTB
9. hidrobio_marino_final → MuestreoHidrobioMarinoTB
10. fisicoquim_marino_final → MuestreoFisicoquimMarinoTB
11. mamiferos_OFM_final → PuntoObservacionFaunaMarina + MamiferosOFM_TB
12. aves_OFM_final → PuntoObservacionFaunaMarina + AvesOFM_TB
13. peces_OFM_final → PuntoObservacionFaunaMarina + PecesOFM_TB
14. tortugas_OFM_final → PuntoObservacionFaunaMarina + TortugasOFM_TB
15. otrafauna_OFM_final → PuntoObservacionFaunaMarina + OtraFaunaOFM_TB
16. veda_final → PuntoMuestreoVeda + MuestreoVedaTB
17. fauna_marina_final → MuestreoFaunaMarina + MuestreoFaunaMarinaTB
18. transecto_fm_final → TransectoFaunaMarina + MuestreoFaunaMarinaTB
19. flora_marina_final → MuestreoFloraMarina + MuestreoFloraMarinaTB

* Data in those layers are restructured following [Extend Measurement or Facts](https://biodiversidad.co/elementos-darwin-core#medidas-o-hechos-extendida).

You can check the mapping to DarwinCore in detail for every layer and table in the following files:

- [Darwin Core Event](https://docs.google.com/spreadsheets/d/17ys5dkCNZDXpeguHbnnTI-RYiJPyMQz4HuRO-FLcaUE/edit?usp=sharing)
- [Darwin Core Occurrence](https://docs.google.com/spreadsheets/d/1cX3ayuk6A-Fq2XcsTiIrkoQ2XetU9Y9rkgy0iUjk4RY/edit?usp=sharing)
- [Abiotic measurements](https://docs.google.com/spreadsheets/d/1xS28Pwx6INx14Fag1-UXghLrvawb92KUQYcIfl4wf-M/edit?usp=sharing)
- [Marine and protected flora](https://docs.google.com/spreadsheets/d/1hmQCX1jbAxfpfK_3Pz4fllkCzIaFc3BE7NgTMc5cfaI/edit?usp=sharing)

# Author and contact

If you have any comment, advice or issue, you can write to our email [sib@humboldt.org.co](sib@humboldt.org.co). If you find a technical problem, you can log an issue in our [GitLab repository](https://gitlab.com/sib-colombia/pluginqgis-bdgeo-to-dwc/-/issues).

**Gonzalo Cabezas**
Main developer:responsible for plugin development and QGIS integration.
Researcher at Instituto de Investigación de Recursos Biológicos Alexander von Humboldt - Scientific Information Office

Email: [gcabezas@humboldt.org.co]

**Esteban Marentes**
Model specialist:responsible for mapping variables between ANLA model and Darwin Core (DwC) standard.
Researcher at Equipo Coordinador del Sistema de Información sobre Biodiversidad de Colombia (SiB Colombia)
Email: [emarentes@humboldt.org.co]

# license
This project is under a MIT license.
Read the LICENSE file for more information.

## Project structure
- `main.py`: Main project file.
- `utils/`: Auxiliary modules.
- `tests/`: Unitary tests.
- `output/`: Output files.
