from shapely.geometry import shape
import pandas as pd
from osgeo import gdal, ogr


# Diccionario de mapeo de atributos para muestreo fisicoquimico
mapeo = {
    #"ID_PUNTO_M": "id",
    #"PARAMETRO": "measurementType",
    "VALOR_MED": "measurementValue",
    "LIM_DETECC": "measurementAccuracy",
    "LABORAT": "measurementDeterminedBy",
    "MET_DETERM": "measurementMethod",
    "OBSERV": "measurementRemarks",
    "DENS_CANTI": "organismQuantity",
    "ID_MUESTRA": "materialSampleID",
    
}

# Valores constantes para muestreo fisicoquimico
valores_constantes = {
   
}

# Lista completa de atributos en el archivo final
lista_atributos = [
    "id", "measurementType", "measurementValue", "measurementAccuracy", "measurementDeterminedDate", "materialSampleID",  "eventID",
    "measurementDeterminedBy", "measurementMethod", "measurementRemarks",
    "measurementValue_1", "measurementType_1", "measurementUnit_1",
    "measurementValue_2", "measurementType_2", "measurementUnit_2",
    "measurementValue_3", "measurementType_3", "measurementUnit_3",
    "measurementValue_4", "measurementType_4", "measurementUnit_4",
    "measurementValue_5", "measurementType_5", "measurementUnit_5",
    "measurementValue_6", "measurementType_6", "measurementUnit_6",
    "measurementValue_7", "measurementType_7", "measurementUnit_7",
    "measurementValue_8", "measurementType_8", "measurementUnit_8",
    "measurementValue_9", "measurementType_9", "measurementUnit_9",
    "measurementValue_10", "measurementType_10", "measurementUnit_10", "measurementMethod_10",
    "measurementValue_11", "measurementType_11", "measurementUnit_11", "measurementMethod_11", "measurementRemarks_11",
    "measurementValue_12", "measurementType_12", "measurementUnit_12",
    "measurementValue_13", "measurementType_13", "measurementUnit_13",
    "measurementValue_14", "measurementType_14", "measurementUnit_14",
    "measurementValue_15", "measurementType_15", "measurementUnit_15",
    "measurementValue_16", "measurementType_16", "measurementUnit_16"
    ]




# Función para realizar el join
def realizar_join(capa, tabla, enlace_fisicoquimico):
    try:


        capa_df = pd.DataFrame(capa)
        tabla_df = pd.DataFrame(tabla)

        if capa_df.empty or tabla_df.empty:

            return None

        resultado_df = pd.merge(capa_df, tabla_df, on=enlace_fisicoquimico, how="inner")

        if resultado_df.empty:

            return None

        return resultado_df

    except Exception as e:

        return None

# Función para exportar a Excel
def exportar_excel(dataframe, ruta_salida):
    try:

        dataframe.to_excel(ruta_salida, index=False)

    except Exception as e:
        return None



# Función para procesar campos específicos
def procesar_campos_especificos(df):
    """Calcula los campos en orden secuencial asegurando que cada campo esté disponible antes de ser usado."""

    if df is None or df.empty:

        return df  

    # Mapear ID_PUNTO_M a id y eventID
    if "ID_PUNTO_M" in df.columns:
        df["id"] = df["ID_PUNTO_M"]
        df["eventID"] = df["ID_PUNTO_M"]
    else:

        df["id"] = df["eventID"] = None
        df["eventID"] = None

    # Mapear FEC_MUEST a verbatimEventDate
    if "FEC_TOM" in df.columns:
        df["measurementDeterminedDate"] = df["FEC_TOM"]
    else:

        df["measurementDeterminedDate"] = None
    


    # Mapeo de PARAMETRO a "measurementType"
    if "PARAMETRO" in df.columns:
        df["PARAMETRO"] = df["PARAMETRO"].fillna(0).astype(float).astype(int).astype(str).replace({"0", ""})
    else:

        df["PARAMETRO"] = None

    if "PARAMETRO" in df.columns:
        mapeo_type = {
            "1001": "Acidez Total en mg/L CaCO3",
            "1002": "Alcalinidad Total en mg/L CaCO3",
            "1003": "Aluminio en mg/L",
            "1004": "Arsénico en mg/L",
            "1005": "Bario en mg/L",
            "1006": "Berilio en mg/L",
            "1007": "Bicarbonato en mg/L",
            "1008": "Boro en mg/L",
            "1009": "BTEX de los compuestos orgánicos volátiles en µg/L",
            "1010": "Cadmio en mg/L",
            "1011": "Calcio en mg/L",
            "1012": "Carbonato en mg/L",
            "1013": "Carbono Orgánico en mg/L",
            "1014": "Carbono Orgánico Total en mg/L",
            "1015": "Cianuro en mg/L",
            "1016": "Clorofila-A en µg/L",
            "1017": "Clorofila-B en µg/L",
            "1018": "Cloruros en mg/L",
            "1019": "Cobalto en mg/L",
            "1020": "Cobre en mg/L",
            "1021": "Coliformes Fecales en NMP/100ml",
            "1022": "Coliformes Totales en NMP/100ml",
            "1023": "Color de la descarga en UPC",
            "1024": "Compuestos Orgánicos Halogenados Adsorbibles en mg/L",
            "1025": "Conductividad en µS/cm",
            "1026": "Cromo en mg/L",
            "1027": "Cromo Hexavalente en mg/L",
            "1028": "Demanda Bioquímica de Oxígeno en mg/L",
            "1029": "Demanda Química de Oxígeno en mg/L",
            "1030": "Dureza Cálcica de la descarga en mg/L",
            "1031": "Dureza Total de la descarga en mg/L",
            "1032": "E. Coli en NMP/100ml",
            "1033": "Estaño en mg/L",
            "1034": "Fenoles en mg/L",
            "1035": "Fosfato en mg/L",
            "1036": "Fósforo Inorgánico en mg/L",
            "1037": "Fósforo Orgánico en mg/L",
            "1038": "Fósforo Total en mg/L",
            "1039": "Grasas y Aceites en mg/L",
            "1040": "Hidrocarburos Aromáticos Polinucleares en mg/L",
            "1041": "Hidrocarburos Totales en mg/L",
            "1042": "Hidrocarburos Totales Petrolígenos en mg/L",
            "1043": "Hierro en mg/L",
            "1044": "Litio en mg/L",
            "1045": "Magnesio en mg/L",
            "1046": "Manganeso en mg/L",
            "1047": "Mercurio en mg/L",
            "1048": "Molibdeno en mg/L",
            "1049": "Níquel en mg/L",
            "1050": "Nitratos en mg/L",
            "1051": "Nitritos en mg/L",
            "1052": "Nitrógeno Amoniacal en mg/L",
            "1053": "Nitrógeno Amoniacal en mg/L",
            "1054": "Nitrógeno Inorgánico en mg/L",
            "1055": "Nitrógeno Orgánico en mg/L",
            "1056": "Nitrógeno Total (nit. orgánico, nit. amoniacal, nitritos y nitratos) en mg/L",
            "1057": "Nitrógeno Total Kjeldahl en mg/L",
            "1058": "Ortofosfatos en mg/L",
            "1059": "Oxígeno Disuelto en mg/L",
            "1060": "Plata en mg/L",
            "1061": "Plomo en mg/L",
            "1062": "Porcentaje de Sodio Intercambiable",
            "1063": "Potasio en mg/L",
            "1064": "Potencial Redox en mV",
            "1065": "Salinidad en mg/L",
            "1066": "Selenio en mg/L",
            "1067": "Sodio en mg/L",
            "1068": "Sólidos Disueltos en mg/L",
            "1069": "Sólidos sedimentables en mg/L",
            "1070": "Sólidos suspendidos totales en mg/L",
            "1071": "Sólidos Totales en mg/L",
            "1072": "Sulfatos en mg/L",
            "1073": "Sustancias activas al azul de metileno en mg/L",
            "1074": "Temperatura en °C",
            "1075": "Tensioactivos en mg/L",
            "1076": "Turbidez en NTU",
            "1077": "Valor de pH",
            "1078": "Valor del índice de Relación de Absorción de Sodio",
            "1079": "Vanadio en mg/L",
            "1080": "Zinc en mg/L",
            "1081": "Otro"
        }
        df["measurementType"] = df["PARAMETRO"].map(mapeo_type).fillna("")
        df.loc[df["measurementType"] == "Otro", "measurementType"] = df["OT_PARAM"]


    # Mapeo temporal de los dominios de los metodos

    # Convertir los valores NaN a 0 y luego a enteros antes de mapearlos
    if "MET_ME_NIV" in df.columns:
        df["MET_ME_NIV"] = df["MET_ME_NIV"].fillna(0).astype(float).astype(int).astype(str).replace({"0", ""})
    else:

        df["MET_ME_NIV"] = None

    if "ME_MED_OF" in df.columns:
        df["ME_MED_OF"] = df["ME_MED_OF"].fillna(0).astype(float).astype(int).astype(str).replace({"0", ""})
    else:

        df["ME_MED_OF"] = None

    if "MATE_FLOT" in df.columns:
        df["MATE_FLOT"] = df["MATE_FLOT"].fillna(0).astype(float).astype(int).astype(str).replace({"0", ""})
    else:

        df["MATE_FLOT"] = None


    mapa_met_me_niv = {
        "110101": "Maxímetro",
        "110102": "Limnicontacto",
        "110103": "Limnicontacto tipo sonda luminosa",
        "110104": "Sonda de presión con o sin terminal de datos",
        "110105": "Limnígrafo mecánico",
        "110106": "Limnígrafo digital",
        "110107": "Instalaciones de tubo",
        "110108": "Instalaciones de pozo",
        "110109": "Neumático",
        "110110": "Cinta métrica"
    }

    df["temp_measurementMethod_10"] = df["MET_ME_NIV"].map(mapa_met_me_niv).fillna("")

    mapa_me_med_of = {
        "110201": "Volumétrico",
        "110202": "Área y Velocidad",
        "110203": "Dilución",
        "110204": "Trazadores",
        "110205": "Estructuras aforadas",
        "110206": "Contador",
        "110207": "Estimado"
    }

    df["temp_measurementMethod_11"] = df["ME_MED_OF"].map(mapa_me_med_of).fillna("")
    
    mapa_mate_flot = {
        "110401": "Si",
        "110402": "No"        
    }

    df["temp_measurementValue_12"] = df["MATE_FLOT"].map(mapa_mate_flot).fillna("")


    # Verificar si "NUBOSIDAD" existe y tiene al menos un valor no vacío
    if "NUBOSIDAD" in df.columns and df["NUBOSIDAD"].dropna().empty is False:
        df["measurementValue_1"] = df["NUBOSIDAD"]
        df["measurementType_1"] = df["measurementValue_1"].apply(lambda x: "Nubosidad" if pd.notna(x) else None)
        df["measurementUnit_1"] = df["measurementValue_1"].apply(lambda x: "octas" if pd.notna(x) else None)
    else:
        df["measurementValue_1"] = df["measurementType_1"] = df["measurementUnit_1"] = None

    # Verificar si "TEMP_AIRE" existe y tiene al menos un valor no vacío
    if "TEMP_AIRE" in df.columns and df["TEMP_AIRE"].dropna().empty is False:
        df["measurementValue_2"] = df["TEMP_AIRE"]
        df["measurementType_2"] = df["measurementValue_2"].apply(lambda x: "Temperatura del Aire" if pd.notna(x) else None)
        df["measurementUnit_2"] = df["measurementValue_2"].apply(lambda x: "°C" if pd.notna(x) else None)
    else:
        df["measurementValue_2"] = df["measurementType_2"] = df["measurementUnit_2"] = None

    # Verificar si "VEL_VIENTO" existe y tiene al menos un valor no vacío
    if "VEL_VIENTO" in df.columns and df["VEL_VIENTO"].dropna().empty is False:
        df["measurementValue_3"] = df["VEL_VIENTO"]
        df["measurementType_3"] = df["measurementValue_3"].apply(lambda x: "Velocidad del Viento" if pd.notna(x) else None)
        df["measurementUnit_3"] = df["measurementValue_3"].apply(lambda x: "m/s" if pd.notna(x) else None)
    else:
        df["measurementValue_3"] = df["measurementType_3"] = df["measurementUnit_3"] = None

    # Verificar si "HUM_REL" existe y tiene al menos un valor no vacío
    if "HUM_REL" in df.columns and df["HUM_REL"].dropna().empty is False:
        df["measurementValue_4"] = df["HUM_REL"]
        df["measurementType_4"] = df["measurementValue_4"].apply(lambda x: "Humedad Relativa" if pd.notna(x) else None)
        df["measurementUnit_4"] = df["measurementValue_4"].apply(lambda x: "Porcentaje" if pd.notna(x) else None)
    else:
        df["measurementValue_4"] = df["measurementType_4"] = df["measurementUnit_4"] = None

    # Verificar si "TEMP_ROC" existe y tiene al menos un valor no vacío
    if "TEMP_ROC" in df.columns and df["TEMP_ROC"].dropna().empty is False:
        df["measurementValue_5"] = df["TEMP_ROC"]
        df["measurementType_5"] = df["measurementValue_5"].apply(lambda x: "Temperatura de Rocío" if pd.notna(x) else None)
        df["measurementUnit_5"] = df["measurementValue_5"].apply(lambda x: "°C" if pd.notna(x) else None)
    else:
        df["measurementValue_5"] = df["measurementType_5"] = df["measurementUnit_5"] = None

    # Verificar si "PRESIO_ATM" existe y tiene al menos un valor no vacío
    if "PRESIO_ATM" in df.columns and df["PRESIO_ATM"].dropna().empty is False:
        df["measurementValue_6"] = df["PRESIO_ATM"]
        df["measurementType_6"] = df["measurementValue_6"].apply(lambda x: "Presión Atmosférica" if pd.notna(x) else None)
        df["measurementUnit_6"] = df["measurementValue_6"].apply(lambda x: "mmHg" if pd.notna(x) else None)
    else:
        df["measurementValue_6"] = df["measurementType_6"] = df["measurementUnit_6"] = None

    # Verificar si "PROF_MUES" existe y tiene al menos un valor no vacío
    if "PROF_MUES" in df.columns and df["PROF_MUES"].dropna().empty is False:
        df["measurementValue_7"] = df["PROF_MUES"]
        df["measurementType_7"] = df["measurementValue_7"].apply(lambda x: "Profundidad de muestreo" if pd.notna(x) else None)
        df["measurementUnit_7"] = df["measurementValue_7"].apply(lambda x: "m" if pd.notna(x) else None)
    else:
        df["measurementValue_7"] = df["measurementType_7"] = df["measurementUnit_7"] = None

    # Verificar si "AREA_EST" existe y tiene al menos un valor no vacío
    if "AREA_EST" in df.columns and df["AREA_EST"].dropna().empty is False:
        df["measurementValue_8"] = df["AREA_EST"]
        df["measurementType_8"] = df["measurementValue_8"].apply(lambda x: "Área estimada del cuerpo de agua" if pd.notna(x) else None)
        df["measurementUnit_8"] = df["measurementValue_8"].apply(lambda x: "m2" if pd.notna(x) else None)
    else:
        df["measurementValue_8"] = df["measurementType_8"] = df["measurementUnit_8"] = None

    # Verificar si "COT_MAX_IN" existe y tiene al menos un valor no vacío
    if "COT_MAX_IN" in df.columns and df["COT_MAX_IN"].dropna().empty is False:
        df["measurementValue_9"] = df["COT_MAX_IN"]
        df["measurementType_9"] = df["measurementValue_9"].apply(lambda x: "Cota máxima de inundación" if pd.notna(x) else None)
        df["measurementUnit_9"] = df["measurementValue_9"].apply(lambda x: "m" if pd.notna(x) else None)
    else:
        df["measurementValue_9"] = df["measurementType_9"] = df["measurementUnit_9"] = None

   # Verificar si "NIV_AGUA" existe y tiene al menos un valor no vacío
    if "NIV_AGUA" in df.columns and df["NIV_AGUA"].dropna().empty is False:
        df["measurementValue_10"] = df["NIV_AGUA"]
        df["measurementType_10"] = df["measurementValue_10"].apply(lambda x: "Nivel del cuerpo de agua" if pd.notna(x) else None)
        df["measurementUnit_10"] = df["measurementValue_10"].apply(lambda x: "m" if pd.notna(x) else None)
        df["measurementMethod_10"] = df.apply(lambda row: row["temp_measurementMethod_10"] if pd.notna(row["measurementValue_10"]) else None, axis=1)

    else:
        df["measurementValue_10"] = df["measurementType_10"] = df["measurementUnit_10"] = df["measurementMethod_10"] = None

    # Verificar si "CAUDAL" existe y tiene al menos un valor no vacío
    if "CAUDAL" in df.columns and df["CAUDAL"].dropna().empty is False:
        df["measurementValue_11"] = df["CAUDAL"]
        df["measurementType_11"] = df["measurementValue_11"].apply(lambda x: "Caudal de la fuente" if pd.notna(x) else None)
        df["measurementUnit_11"] = df["measurementValue_11"].apply(lambda x: "l/s" if pd.notna(x) else None)
        df["measurementMethod_11"] = df.apply(lambda row: row["temp_measurementMethod_11"] if pd.notna(row["measurementValue_11"]) else None, axis=1)
        df["measurementRemarks_11"] = df.apply(lambda row: row["OB_NIV_OF"] if pd.notna(row["measurementValue_11"]) else None, axis=1)

    else:
        df["measurementValue_11"] = df["measurementType_11"] = df["measurementUnit_11"] = df["measurementMethod_11"] = df["measurementRemarks_11"] = None



    # Verificar si "MATE_FLOT" existe y tiene al menos un valor no vacío
    if "MATE_FLOT" in df.columns and df["MATE_FLOT"].dropna().empty is False:
        df["measurementValue_12"] = df["temp_measurementValue_12"]
        df["measurementType_12"] = df["measurementValue_12"].apply(lambda x: "Presencia de Material Flotante" if pd.notna(x) else None)
        df["measurementUnit_12"] = None
    else:
        df["measurementValue_12"] = df["measurementType_12"] = df["measurementUnit_12"] = None

    # Verificar si "INDICE_ICA" existe y tiene al menos un valor no vacío
    if "INDICE_ICA" in df.columns and df["INDICE_ICA"].dropna().empty is False:
        df["measurementValue_13"] = df["INDICE_ICA"]
        df["measurementType_13"] = df["measurementValue_13"].apply(lambda x: "Índice de calidad del agua - ICA" if pd.notna(x) else None)
        df["measurementUnit_13"] = None
    else:
        df["measurementValue_13"] = df["measurementType_13"] = df["measurementUnit_13"] = None

    # Verificar si "ICOMO" existe y tiene al menos un valor no vacío
    if "ICOMO" in df.columns and df["ICOMO"].dropna().empty is False:
        df["measurementValue_14"] = df["ICOMO"]
        df["measurementType_14"] = df["measurementValue_14"].apply(lambda x: "Índice de contaminación asociada a materia orgánica - ICOMO" if pd.notna(x) else None)
        df["measurementUnit_14"] = None
    else:
        df["measurementValue_14"] = df["measurementType_14"] = df["measurementUnit_14"] = None

    # Verificar si "ICOMI" existe y tiene al menos un valor no vacío
    if "ICOMI" in df.columns and df["ICOMI"].dropna().empty is False:
        df["measurementValue_15"] = df["ICOMI"]
        df["measurementType_15"] = df["measurementValue_15"].apply(lambda x: "Índice de contaminación asociada a mineralización - ICOMI" if pd.notna(x) else None)
        df["measurementUnit_15"] = None
    else:
        df["measurementValue_15"] = df["measurementType_15"] = df["measurementUnit_15"] = None

    # Verificar si "ICOSUS" existe y tiene al menos un valor no vacío
    if "ICOSUS" in df.columns and df["ICOSUS"].dropna().empty is False:
        df["measurementValue_16"] = df["ICOSUS"]
        df["measurementType_16"] = df["measurementValue_16"].apply(lambda x: "Índice de contaminación asociada a material en suspensión - ICOSUS" if pd.notna(x) else None)
        df["measurementUnit_16"] = None
    else:
        df["measurementValue_16"] = df["measurementType_16"] = df["measurementUnit_16"] = None




    return df



# Función principal para procesar muestreio fisicoquimico
def procesar_fisicoquimico(ruta_gdb, tabla_fisicoquimico_1, tabla_fisicoquimico_2, enlace_fisicoquimico, ruta_excel_fisicoquimico, archivo_entrada_fisicoquimico, archivo_salida_fisicoquimico):
    try:
        # Abrir la Geodatabase
        gdb = gdal.OpenEx(ruta_gdb, gdal.OF_VECTOR)
        if not gdb:
            raise RuntimeError(f"❌ No se pudo abrir la GDB en {ruta_gdb}")


        # Extraer atributos de la primera tabla
        datos_tabla_1 = []
        layer_1 = gdb.GetLayerByName(tabla_fisicoquimico_1)
        for feature in layer_1:
            datos_tabla_1.append(feature.items())  
        # Extraer atributos de la segunda tabla
        datos_tabla_2 = []
        layer_2 = gdb.GetLayerByName(tabla_fisicoquimico_2)
        for feature in layer_2:
            datos_tabla_2.append(feature.items())  

        # Realizar el join entre ambas tablas
        resultado = realizar_join(datos_tabla_1, datos_tabla_2, enlace_fisicoquimico)

        if resultado is None or resultado.empty:

            return


        # Exportar el resultado del join a un archivo Excel intermedio
        exportar_excel(resultado, ruta_excel_fisicoquimico)

       
        # Procesar campos específicos
        df_intermedio = procesar_campos_especificos(resultado)

        # Crear DataFrame final con todos los atributos de lista_atributos
        df_final = pd.DataFrame(columns=lista_atributos)

        # Mapear los datos del DataFrame intermedio al DataFrame final
        for columna_intermedia, columna_final in mapeo.items():
            if columna_intermedia in df_intermedio.columns:
                df_final[columna_final] = df_intermedio[columna_intermedia]

        # Agregar valores constantes
        for clave, valor in valores_constantes.items():
            df_final[clave] = valor

        # Agregar los campos calculados
       
        df_final["id"] = df_intermedio["id"]
        df_final["eventID"] = df_intermedio["eventID"]
        df_final["measurementDeterminedDate"] = df_intermedio["measurementDeterminedDate"]
        df_final["measurementType"] = df_intermedio["measurementType"]

        df_final["measurementValue_1"] = df_intermedio["measurementValue_1"]
        df_final["measurementType_1"] = df_intermedio["measurementType_1"]
        df_final["measurementUnit_1"] = df_intermedio["measurementUnit_1"]

        df_final["measurementValue_2"] = df_intermedio["measurementValue_2"]
        df_final["measurementType_2"] = df_intermedio["measurementType_2"]
        df_final["measurementUnit_2"] = df_intermedio["measurementUnit_2"]

        df_final["measurementValue_3"] = df_intermedio["measurementValue_3"]
        df_final["measurementType_3"] = df_intermedio["measurementType_3"]
        df_final["measurementUnit_3"] = df_intermedio["measurementUnit_3"]

        df_final["measurementValue_4"] = df_intermedio["measurementValue_4"]
        df_final["measurementType_4"] = df_intermedio["measurementType_4"]
        df_final["measurementUnit_4"] = df_intermedio["measurementUnit_4"]

        df_final["measurementValue_5"] = df_intermedio["measurementValue_5"]
        df_final["measurementType_5"] = df_intermedio["measurementType_5"]
        df_final["measurementUnit_5"] = df_intermedio["measurementUnit_5"]

        df_final["measurementValue_6"] = df_intermedio["measurementValue_6"]
        df_final["measurementType_6"] = df_intermedio["measurementType_6"]
        df_final["measurementUnit_6"] = df_intermedio["measurementUnit_6"]

        df_final["measurementValue_7"] = df_intermedio["measurementValue_7"]
        df_final["measurementType_7"] = df_intermedio["measurementType_7"]
        df_final["measurementUnit_7"] = df_intermedio["measurementUnit_7"]

        df_final["measurementValue_8"] = df_intermedio["measurementValue_8"]
        df_final["measurementType_8"] = df_intermedio["measurementType_8"]
        df_final["measurementUnit_8"] = df_intermedio["measurementUnit_8"]

        df_final["measurementValue_9"] = df_intermedio["measurementValue_9"]
        df_final["measurementType_9"] = df_intermedio["measurementType_9"]
        df_final["measurementUnit_9"] = df_intermedio["measurementUnit_9"]

        df_final["measurementValue_10"] = df_intermedio["measurementValue_10"]
        df_final["measurementType_10"] = df_intermedio["measurementType_10"]
        df_final["measurementUnit_10"] = df_intermedio["measurementUnit_10"]
        df_final["measurementMethod_10"] = df_intermedio["measurementMethod_10"]

        df_final["measurementValue_11"] = df_intermedio["measurementValue_11"]
        df_final["measurementType_11"] = df_intermedio["measurementType_11"]
        df_final["measurementUnit_11"] = df_intermedio["measurementUnit_11"]
        df_final["measurementMethod_11"] = df_intermedio["measurementMethod_11"]
        df_final["measurementRemarks_11"] = df_intermedio["measurementRemarks_11"]

        df_final["measurementValue_12"] = df_intermedio["measurementValue_12"]
        df_final["measurementType_12"] = df_intermedio["measurementType_12"]
        df_final["measurementUnit_12"] = df_intermedio["measurementUnit_12"]

        df_final["measurementValue_13"] = df_intermedio["measurementValue_13"]
        df_final["measurementType_13"] = df_intermedio["measurementType_13"]
        df_final["measurementUnit_13"] = df_intermedio["measurementUnit_13"]

        df_final["measurementValue_14"] = df_intermedio["measurementValue_14"]
        df_final["measurementType_14"] = df_intermedio["measurementType_14"]
        df_final["measurementUnit_14"] = df_intermedio["measurementUnit_14"]

        df_final["measurementValue_15"] = df_intermedio["measurementValue_15"]
        df_final["measurementType_15"] = df_intermedio["measurementType_15"]
        df_final["measurementUnit_15"] = df_intermedio["measurementUnit_15"]

        df_final["measurementValue_16"] = df_intermedio["measurementValue_16"]
        df_final["measurementType_16"] = df_intermedio["measurementType_16"]
        df_final["measurementUnit_16"] = df_intermedio["measurementUnit_16"]


        # Transformar df_final a filas
        mediciones = []

        for i in range(1, 102):
            col_valor = f"measurementValue_{i}"
            col_tipo = f"measurementType_{i}"
            col_unidad = f"measurementUnit_{i}"
            col_metodo = f"measurementMethod_{i}"

            if col_valor in df_final.columns:
                bloque = df_final[[
                    "id", "eventID", "materialSampleID",
                    "measurementDeterminedBy", "measurementDeterminedDate", "measurementRemarks",
                    col_valor, col_tipo, col_unidad
                ]].copy()

                bloque["measurementIndex"] = i
                bloque["measurementValue"] = bloque[col_valor]
                bloque["measurementType"] = bloque[col_tipo] if col_tipo in df_final.columns else None
                bloque["measurementUnit"] = bloque[col_unidad] if col_unidad in df_final.columns else None
                bloque["measurementMethod"] = df_final[col_metodo] if col_metodo in df_final.columns else None

                bloque = bloque.drop(columns=[col_valor, col_tipo, col_unidad], errors="ignore")
                mediciones.append(bloque)

        # Concatenar todo
        df_largo = pd.concat(mediciones, ignore_index=True)
        df_resultado = pd.concat([df_final, df_largo], ignore_index=True)

        # Mantener solo las columnas deseadas
        columnas_exportar = [
            "id", "measurementType", "measurementValue", "measurementAccuracy",
            "measurementDeterminedDate", "materialSampleID", "eventID",
            "measurementDeterminedBy", "measurementMethod", "measurementRemarks"
        ]

        df_resultado = df_resultado[columnas_exportar]
        df_resultado = df_resultado[df_resultado["measurementValue"].notna()]
        df_resultado = df_resultado[df_resultado["measurementValue"].astype(str).str.strip() != ""]

        # Exportar el DataFrame final a un archivo Excel
        exportar_excel(df_resultado, archivo_salida_fisicoquimico)

    except Exception as e:
        return None