from qgis.PyQt.QtWidgets import QAction
from PyQt5.QtGui import QIcon
from pathlib import Path
from .UI_Plugin.test_plugin_ui import VentanaPlugin




class Procesador:
    def __init__(self, iface):
        self.iface = iface
        self.action = None
        self.icon_path = str(Path(__file__).resolve().parent / "logo.png")

    def initGui(self):
        icon = QIcon(self.icon_path)

        self.action = QAction(icon, "SiB Colombia", self.iface.mainWindow())
        self.action.triggered.connect(self.run)

        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&SiB Colombia", self.action)

    def unload(self):
        self.iface.removeToolBarIcon(self.action)
        self.iface.removePluginMenu("&SiB Colombia", self.action)

    def run(self):
        ventana = VentanaPlugin(self.iface)
        ventana.exec_()  
