from shapely.geometry import shape
import pandas as pd
from osgeo import gdal, ogr


# Diccionario de mapeo de atributos para muestreo fisicoquim marino
mapeo = {
    "ID_MUESTRA": "materialSampleID",
    "LABORAT": "measurementDeterminedBy"
   
}

# Valores constantes para muestreo fisicoquim marino
valores_constantes = {
  
}

# Lista completa de atributos en el archivo final
lista_atributos = [
    "id",  "eventID", "measurementDeterminedBy", 
    "measurementDeterminedDate", "measurementRemarks",
    "measurementValue_1", "measurementType_1", "measurementUnit_1",
    "measurementValue_2", "measurementType_2", "measurementUnit_2", "measurementMethod_2",
    "measurementValue_4", "measurementType_4", "measurementUnit_4",
    "measurementValue_5", "measurementType_5", "measurementUnit_5",
    "measurementValue_6", "measurementType_6", "measurementUnit_6",
    "measurementValue_7", "measurementType_7", "measurementUnit_7",
    "measurementValue_8", "measurementType_8", "measurementUnit_8",
    "measurementValue_9", "measurementType_9", "measurementUnit_9",
    "measurementValue_10", "measurementType_10", "measurementUnit_10",
    "measurementValue_11", "measurementType_11", "measurementUnit_11",
    "measurementValue_12", "measurementType_12", "measurementUnit_12",
    "measurementValue_13", "measurementType_13", "measurementUnit_13",
    "measurementValue_14", "measurementType_14", "measurementUnit_14",
    "measurementValue_15", "measurementType_15", "measurementUnit_15",
    "measurementValue_16", "measurementType_16", "measurementUnit_16",
    "measurementValue_17", "measurementType_17", "measurementUnit_17",
    "measurementValue_18", "measurementType_18", "measurementUnit_18",
    "measurementValue_19", "measurementType_19", "measurementUnit_19",
    "measurementValue_20", "measurementType_20", "measurementUnit_20",
    "measurementValue_21", "measurementType_21", "measurementUnit_21",
    "measurementValue_22", "measurementType_22", "measurementUnit_22",
    "measurementValue_23", "measurementType_23", "measurementUnit_23",
    "measurementValue_24", "measurementType_24", "measurementUnit_24",
    "measurementValue_25", "measurementType_25", "measurementUnit_25",
    "measurementValue_26", "measurementType_26", "measurementUnit_26",
    "measurementValue_27", "measurementType_27", "measurementUnit_27",
    "measurementValue_28", "measurementType_28", "measurementUnit_28",
    "measurementValue_29", "measurementType_29", "measurementUnit_29",
    "measurementValue_30", "measurementType_30", "measurementUnit_30",
    "measurementValue_31", "measurementType_31", "measurementUnit_31",
    "measurementValue_32", "measurementType_32", "measurementUnit_32",
    "measurementValue_33", "measurementType_33", "measurementUnit_33",
    "measurementValue_34", "measurementType_34", "measurementUnit_34",
    "measurementValue_35", "measurementType_35", "measurementUnit_35",
    "measurementValue_36", "measurementType_36", "measurementUnit_36",
    "measurementValue_37", "measurementType_37", "measurementUnit_37",
    "measurementValue_38", "measurementType_38", "measurementUnit_38",
    "measurementValue_39", "measurementType_39", "measurementUnit_39",
    "measurementValue_40", "measurementType_40", "measurementUnit_40",
    "measurementValue_41", "measurementType_41", "measurementUnit_41",
    "measurementValue_42", "measurementType_42", "measurementUnit_42",
    "measurementValue_43", "measurementType_43", "measurementUnit_43",
    "measurementValue_44", "measurementType_44", "measurementUnit_44",
    "measurementValue_45", "measurementType_45", "measurementUnit_45",
    "measurementValue_46", "measurementType_46", "measurementUnit_46",
    "measurementValue_47", "measurementType_47", "measurementUnit_47",
    "measurementValue_48", "measurementType_48", "measurementUnit_48",
    "measurementValue_49", "measurementType_49", "measurementUnit_49",
    "measurementValue_50", "measurementType_50", "measurementUnit_50",
    "measurementValue_51", "measurementType_51", "measurementUnit_51",
    "measurementValue_52", "measurementType_52", "measurementUnit_52",
    "measurementValue_53", "measurementType_53", "measurementUnit_53",
    "measurementValue_54", "measurementType_54", "measurementUnit_54",
    "measurementValue_55", "measurementType_55", "measurementUnit_55",
    "measurementValue_56", "measurementType_56", "measurementUnit_56",
    "measurementValue_57", "measurementType_57", "measurementUnit_57",
    "measurementValue_58", "measurementType_58", "measurementUnit_58",
    "measurementValue_59", "measurementType_59", "measurementUnit_59",
    "measurementValue_60", "measurementType_60", "measurementUnit_60",
    "measurementValue_61", "measurementType_61", "measurementUnit_61",
    "measurementValue_62", "measurementType_62", "measurementUnit_62",
    "measurementValue_63", "measurementType_63", "measurementUnit_63",
    "measurementValue_64", "measurementType_64", "measurementUnit_64",
    "measurementValue_65", "measurementType_65", "measurementUnit_65",
    "measurementValue_66", "measurementType_66", "measurementUnit_66",
    "measurementValue_67", "measurementType_67", "measurementUnit_67",
    "measurementValue_68", "measurementType_68", "measurementUnit_68",
    "measurementValue_69", "measurementType_69", "measurementUnit_69",
    "measurementValue_70", "measurementType_70", "measurementUnit_70",
    "measurementValue_71", "measurementType_71", "measurementUnit_71",
    "measurementValue_72", "measurementType_72", "measurementUnit_72",
    "measurementValue_73", "measurementType_73", "measurementUnit_73",
    "measurementValue_74", "measurementType_74", "measurementUnit_74",
    "measurementValue_75", "measurementType_75", "measurementUnit_75",
    "measurementValue_76", "measurementType_76", "measurementUnit_76",
    "measurementValue_77", "measurementType_77", "measurementUnit_77",
    "measurementValue_78", "measurementType_78", "measurementUnit_78",
    "measurementValue_79", "measurementType_79", "measurementUnit_79",
    "measurementValue_80", "measurementType_80", "measurementUnit_80",
    "measurementValue_81", "measurementType_81", "measurementUnit_81",
    "measurementValue_82", "measurementType_82", "measurementUnit_82",
    "measurementValue_83", "measurementType_83", "measurementUnit_83",
    "measurementValue_84", "measurementType_84", "measurementUnit_84",
    "measurementValue_85", "measurementType_85", "measurementUnit_85",
    "measurementValue_86", "measurementType_86", "measurementUnit_86",
    "measurementValue_87", "measurementType_87", "measurementUnit_87",
    "measurementValue_88", "measurementType_88", "measurementUnit_88",
    "measurementValue_89", "measurementType_89", "measurementUnit_89",
    "measurementValue_90", "measurementType_90", "measurementUnit_90",
    "measurementValue_91", "measurementType_91", "measurementUnit_91",
    "measurementValue_92", "measurementType_92", "measurementUnit_92",
    "measurementValue_93", "measurementType_93", "measurementUnit_93",
    "measurementValue_94", "measurementType_94", "measurementUnit_94",
    "measurementValue_95", "measurementType_95", "measurementUnit_95",
    "measurementValue_96", "measurementType_96", "measurementUnit_96",
    "measurementValue_97", "measurementType_97", "measurementUnit_97",
    "measurementValue_98", "measurementType_98", "measurementUnit_98",
    "measurementValue_99", "measurementType_99", "measurementUnit_99",
    "measurementValue_100", "measurementType_100", "measurementUnit_100",
    "measurementValue_101", "measurementType_101", "measurementUnit_101"
    ]


# Función para exportar a Excel
def exportar_excel(dataframe, ruta_salida):
    try:

        dataframe.to_excel(ruta_salida, index=False)

    except Exception as e:
        return None



# Función para procesar campos específicos
def procesar_campos_especificos(df):
    """Calcula los campos en orden secuencial asegurando que cada campo esté disponible antes de ser usado."""

    if df is None or df.empty:

        return df  

    # Mapear ID_PUNTO_M a id y eventID
    if "ID_PUNTO_M" in df.columns:
        df["id"] = df["ID_PUNTO_M"]
        df["eventID"] = df["ID_PUNTO_M"]
    else:
        df["id"] = None
        df["eventID"] = None


     # Mapear FEC_TOM a verbatimEventDate
    if "FEC_TOM" in df.columns:
        df["measurementDeterminedDate"] = df["FEC_TOM"]
    else:
        df["measurementDeterminedDate"] = None


    # Agregar la HORA al campo measurementDeterminedDate en formato ISO (YYYY-MM-DDTHH:MM:SS)
    if "HORA" in df.columns and "measurementDeterminedDate" in df.columns:
        df["measurementDeterminedDate"] = pd.to_datetime(df["measurementDeterminedDate"], errors="coerce")
        df["measurementDeterminedDate"] = df["measurementDeterminedDate"].dt.strftime("%Y-%m-%d T ") + \
            pd.to_timedelta(df["HORA"], unit="h").dt.components.apply(
                lambda x: f"{int(x.hours):02}:{int(x.minutes):02}:{int(x.seconds):02}", axis=1
            )
    else:
        df["measurementDeterminedDate"] = None


    # Mapeo  ESTACIONAL y INTERV_h a measurementRemarks
    if "ESTACIONAL" in df.columns:   
        df["ESTACIONAL"] = df["ESTACIONAL"].astype(str)     
        mapa_estacional = {
            "401": "Seca",
            "402": "Lluvias",
            "403": "Transición",
            "404": "Veranillo de San Juan"
        }
        df["temp_ESTACIONAL"] = df["ESTACIONAL"].map(mapa_estacional).fillna("")


    if "temp_ESTACIONAL" in df.columns and "INTERV_h" in df.columns:
        df["measurementRemarks"] = df.apply(
            lambda row: (
                str(row["temp_ESTACIONAL"]) if pd.notna(row["temp_ESTACIONAL"]) and pd.isna(row["INTERV_h"]) else
                str(row["INTERV_h"]) if pd.notna(row["INTERV_h"]) and pd.isna(row["temp_ESTACIONAL"]) else
                f"{row['temp_ESTACIONAL']} | {row['INTERV_h']}" if pd.notna(row["temp_ESTACIONAL"]) and pd.notna(row["INTERV_h"]) else
                None
            ),
            axis=1
        )

    # Mapeo temporal de los domuinios de los metodos 
    if "INS_MUEST" in df.columns:
        df["INS_MUEST"] = df["INS_MUEST"].fillna(0).astype(float).astype(int).astype(str).replace({"0": ""})
        mapa_ins_muest = {
            "501": "ADCP",
            "502": "Botella Go Flo",
            "503": "Botella Nansen",
            "504": "Botella Niskin",
            "505": "Botella Routner",
            "506": "Box corer",
            "507": "Censo visual",
            "508": "CTD",
            "509": "CTDO",
            "510": "Cuadrante",
            "511": "Draga",
            "512": "Draga Van Veen",
            "513": "HADCP",
            "514": "LADCP",
            "515": "Nasas",
            "516": "Nucleador (Corazonador)",
            "517": "Observación",
            "518": "Otro",
            "519": "Palangre horizontal",
            "520": "Palangre vertical",
            "521": "Piston corer",
            "522": "Recolección directa",
            "523": "Red cónica",
            "524": "Red de arrastre",
            "525": "Red de encierro",
            "526": "Red de enmalle",
            "527": "Transecto con punto intercepto",
            "528": "Transectos con cadena intercepto",
            "529": "Transectos en línea"
        }
        df["temp_measurementMethod_2"] = df["INS_MUEST"].map(mapa_ins_muest).fillna("")

    # Mapeo de dominios VIENT_FUER 
    if "VIENT_FUER" in df.columns:
        df["VIENT_FUER"] = df["VIENT_FUER"].fillna(0).astype(float).astype(int).astype(str).replace({"0": ""})
        mapa_vient = {
            "7201": "1 (Calma)",
            "7202": "2 (Ventolina)",
            "7203": "3 (Brisa suave)",
            "7204": "4 (Brisa leve)",
            "7205": "5 (Brisa moderada)",
            "7206": "6 (Brisa fresca)",
            "7207": "7 (Brisa fuerte)",
            "7208": "8 (Temporal)",
            "7209": "9 (Temporal fuerte)",
            "7210": "10 (Temporal violento)",
            "7211": "11 (Temporal muy violento)",
            "7212": "12 (Huracán)"
        }
        df["temp_VIENT_FUER"] = df["VIENT_FUER"].map(mapa_vient).fillna("")

    # Verificar si "NUBOSIDAD" existe y tiene al menos un valor no vacío
    if "NUBOSIDAD" in df.columns and df["NUBOSIDAD"].dropna().empty is False:
        df["measurementValue_1"] = df["NUBOSIDAD"]
        df["measurementType_1"] = df["measurementValue_1"].apply(lambda x: "Nubosidad" if pd.notna(x) else None)
        df["measurementUnit_1"] = df["measurementValue_1"].apply(lambda x: "octas" if pd.notna(x) else None)
    else:
        df["measurementValue_1"] = df["measurementType_1"] = df["measurementUnit_1"] = None

    # Verificar si "VIENT_FUER" existe y tiene al menos un valor no vacío
    if "temp_VIENT_FUER" in df.columns and df["temp_VIENT_FUER"].dropna().empty is False:
        df["measurementValue_2"] = df["temp_VIENT_FUER"]
        df["measurementType_2"] = df["measurementValue_2"].apply(lambda x: "Intensidad del viento" if pd.notna(x) else None)
        df["measurementUnit_2"] = None
        df["measurementMethod_2"] = df.apply(lambda row: row["temp_measurementMethod_2"] if pd.notna(row["measurementValue_2"]) else None, axis=1)
    else:
        df["measurementValue_2"] = df["measurementType_2"] = df["measurementUnit_2"] = df["temp_measurementMethod_2"] = None

    # Verificar si "TAM_MUES_L" existe y tiene al menos un valor no vacío
    if "TAM_MUES_L" in df.columns and df["TAM_MUES_L"].dropna().empty is False:
        df["measurementValue_4"] = df["TAM_MUES_L"]
        df["measurementType_4"] = df["measurementValue_4"].apply(lambda x: "Tamaño de la muestra" if pd.notna(x) else None)
        df["measurementUnit_4"] = df["measurementValue_4"].apply(lambda x: "L" if pd.notna(x) else None)
    else:
        df["measurementValue_4"] = df["measurementType_4"] = df["measurementUnit_4"] = None

    # Verificar si "PROFUND_m" existe y tiene al menos un valor no vacío
    if "PROFUND_m" in df.columns and df["PROFUND_m"].dropna().empty is False:
        df["measurementValue_5"] = df["PROFUND_m"]
        df["measurementType_5"] = df["measurementValue_5"].apply(lambda x: "Profundidad a la que se toma la muestra" if pd.notna(x) else None)
        df["measurementUnit_5"] = df["measurementValue_5"].apply(lambda x: "m" if pd.notna(x) else None)
    else:
        df["measurementValue_5"] = df["measurementType_5"] = df["measurementUnit_5"] = None

    # Verificar si "INDICE_ICA" existe y tiene al menos un valor no vacío
    if "INDICE_ICA" in df.columns and df["INDICE_ICA"].dropna().empty is False:
        df["measurementValue_6"] = df["INDICE_ICA"]
        df["measurementType_6"] = df["measurementValue_6"].apply(lambda x: "Índice de calidad del agua - ICA" if pd.notna(x) else None)
        df["measurementUnit_6"] = None
    else:
        df["measurementValue_6"] = df["measurementType_6"] = df["measurementUnit_6"] = None

    # Verificar si "ICOMO" existe y tiene al menos un valor no vacío
    if "ICOMO" in df.columns and df["ICOMO"].dropna().empty is False:
        df["measurementValue_7"] = df["ICOMO"]
        df["measurementType_7"] = df["measurementValue_7"].apply(lambda x: "Índice de contaminación asociada a materia orgánica - ICOMO" if pd.notna(x) else None)
        df["measurementUnit_7"] = None
    else:
        df["measurementValue_7"] = df["measurementType_7"] = df["measurementUnit_7"] = None

    # Verificar si "ICOMI" existe y tiene al menos un valor no vacío
    if "ICOMI" in df.columns and df["ICOMI"].dropna().empty is False:
        df["measurementValue_8"] = df["ICOMI"]
        df["measurementType_8"] = df["measurementValue_8"].apply(lambda x: "Índice de contaminación asociada a mineralización - ICOMI" if pd.notna(x) else None)
        df["measurementUnit_8"] = None
    else:
        df["measurementValue_8"] = df["measurementType_8"] = df["measurementUnit_8"] = None

    # Verificar si "ICOSUS" existe y tiene al menos un valor no vacío
    if "ICOSUS" in df.columns and df["ICOSUS"].dropna().empty is False:
        df["measurementValue_9"] = df["ICOSUS"]
        df["measurementType_9"] = df["measurementValue_9"].apply(lambda x: "Índice de contaminación asociada a material en suspensión - ICOSUS" if pd.notna(x) else None)
        df["measurementUnit_9"] = None
    else:
        df["measurementValue_9"] = df["measurementType_9"] = df["measurementUnit_9"] = None

    # Verificar si "ACID_TOT" existe y tiene al menos un valor no vacío
    if "ACID_TOT" in df.columns and df["ACID_TOT"].dropna().empty is False:
        df["measurementValue_10"] = df["ACID_TOT"]
        df["measurementType_10"] = df["measurementValue_10"].apply(lambda x: "Acidez Total" if pd.notna(x) else None)
        df["measurementUnit_10"] = df["measurementValue_10"].apply(lambda x: "mg/L CaCO3" if pd.notna(x) else None)
    else:
        df["measurementValue_10"] = df["measurementType_10"] = df["measurementUnit_10"] = None

    # Verificar si "ACNAFTENO" existe y tiene al menos un valor no vacío
    if "ACNAFTENO" in df.columns and df["ACNAFTENO"].dropna().empty is False:
        df["measurementValue_11"] = df["ACNAFTENO"]
        df["measurementType_11"] = df["measurementValue_11"].apply(lambda x: "Acenafteno" if pd.notna(x) else None)
        df["measurementUnit_11"] = df["measurementValue_11"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_11"] = df["measurementType_11"] = df["measurementUnit_11"] = None

    # Verificar si "ACNAFTILEN" existe y tiene al menos un valor no vacío
    if "ACNAFTILEN" in df.columns and df["ACNAFTILEN"].dropna().empty is False:
        df["measurementValue_12"] = df["ACNAFTILEN"]
        df["measurementType_12"] = df["measurementValue_12"].apply(lambda x: "Acenaftileno" if pd.notna(x) else None)
        df["measurementUnit_12"] = df["measurementValue_12"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_12"] = df["measurementType_12"] = df["measurementUnit_12"] = None

    # Verificar si "ALC_TOT" existe y tiene al menos un valor no vacío
    if "ALC_TOT" in df.columns and df["ALC_TOT"].dropna().empty is False:
        df["measurementValue_13"] = df["ALC_TOT"]
        df["measurementType_13"] = df["measurementValue_13"].apply(lambda x: "Alcalinidad Total" if pd.notna(x) else None)
        df["measurementUnit_13"] = df["measurementValue_13"].apply(lambda x: "mg/L CaCO3" if pd.notna(x) else None)
    else:
        df["measurementValue_13"] = df["measurementType_13"] = df["measurementUnit_13"] = None

    # Verificar si "ALUMINIO" existe y tiene al menos un valor no vacío
    if "ALUMINIO" in df.columns and df["ALUMINIO"].dropna().empty is False:
        df["measurementValue_14"] = df["ALUMINIO"]
        df["measurementType_14"] = df["measurementValue_14"].apply(lambda x: "Aluminio" if pd.notna(x) else None)
        df["measurementUnit_14"] = df["measurementValue_14"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_14"] = df["measurementType_14"] = df["measurementUnit_14"] = None

    # Verificar si "AMONIO" existe y tiene al menos un valor no vacío
    if "AMONIO" in df.columns and df["AMONIO"].dropna().empty is False:
        df["measurementValue_15"] = df["AMONIO"]
        df["measurementType_15"] = df["measurementValue_15"].apply(lambda x: "Amonio" if pd.notna(x) else None)
        df["measurementUnit_15"] = df["measurementValue_15"].apply(lambda x: "mg/L, N-NH4" if pd.notna(x) else None)
    else:
        df["measurementValue_15"] = df["measurementType_15"] = df["measurementUnit_15"] = None

    # Verificar si "ANTRACENO" existe y tiene al menos un valor no vacío
    if "ANTRACENO" in df.columns and df["ANTRACENO"].dropna().empty is False:
        df["measurementValue_16"] = df["ANTRACENO"]
        df["measurementType_16"] = df["measurementValue_16"].apply(lambda x: "Antraceno" if pd.notna(x) else None)
        df["measurementUnit_16"] = df["measurementValue_16"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_16"] = df["measurementType_16"] = df["measurementUnit_16"] = None

    # Verificar si "ARSENICO" existe y tiene al menos un valor no vacío
    if "ARSENICO" in df.columns and df["ARSENICO"].dropna().empty is False:
        df["measurementValue_17"] = df["ARSENICO"]
        df["measurementType_17"] = df["measurementValue_17"].apply(lambda x: "Arsénico" if pd.notna(x) else None)
        df["measurementUnit_17"] = df["measurementValue_17"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_17"] = df["measurementType_17"] = df["measurementUnit_17"] = None

    # Verificar si "BARIO" existe y tiene al menos un valor no vacío
    if "BARIO" in df.columns and df["BARIO"].dropna().empty is False:
        df["measurementValue_18"] = df["BARIO"]
        df["measurementType_18"] = df["measurementValue_18"].apply(lambda x: "Bario" if pd.notna(x) else None)
        df["measurementUnit_18"] = df["measurementValue_18"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_18"] = df["measurementType_18"] = df["measurementUnit_18"] = None

    # Verificar si "BERILIO" existe y tiene al menos un valor no vacío
    if "BERILIO" in df.columns and df["BERILIO"].dropna().empty is False:
        df["measurementValue_19"] = df["BERILIO"]
        df["measurementType_19"] = df["measurementValue_19"].apply(lambda x: "Berilio" if pd.notna(x) else None)
        df["measurementUnit_19"] = df["measurementValue_19"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_19"] = df["measurementType_19"] = df["measurementUnit_19"] = None

    # Verificar si "BORO" existe y tiene al menos un valor no vacío
    if "BORO" in df.columns and df["BORO"].dropna().empty is False:
        df["measurementValue_20"] = df["BORO"]
        df["measurementType_20"] = df["measurementValue_20"].apply(lambda x: "Boro" if pd.notna(x) else None)
        df["measurementUnit_20"] = df["measurementValue_20"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_20"] = df["measurementType_20"] = df["measurementUnit_20"] = None

    # Verificar si "BTEX" existe y tiene al menos un valor no vacío
    if "BTEX" in df.columns and df["BTEX"].dropna().empty is False:
        df["measurementValue_21"] = df["BTEX"]
        df["measurementType_21"] = df["measurementValue_21"].apply(lambda x: "Compuestos orgánicos volátiles" if pd.notna(x) else None)
        df["measurementUnit_21"] = df["measurementValue_21"].apply(lambda x: "µg/l" if pd.notna(x) else None)
    else:
        df["measurementValue_21"] = df["measurementType_21"] = df["measurementUnit_21"] = None

    # Verificar si "BzANTRACEN" existe y tiene al menos un valor no vacío
    if "BzANTRACEN" in df.columns and df["BzANTRACEN"].dropna().empty is False:
        df["measurementValue_22"] = df["BzANTRACEN"]
        df["measurementType_22"] = df["measurementValue_22"].apply(lambda x: "Benzo(a) Antraceno" if pd.notna(x) else None)
        df["measurementUnit_22"] = df["measurementValue_22"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_22"] = df["measurementType_22"] = df["measurementUnit_22"] = None

    # Verificar si "BzPIRENO" existe y tiene al menos un valor no vacío
    if "BzPIRENO" in df.columns and df["BzPIRENO"].dropna().empty is False:
        df["measurementValue_23"] = df["BzPIRENO"]
        df["measurementType_23"] = df["measurementValue_23"].apply(lambda x: "Benzo(a) Pireno" if pd.notna(x) else None)
        df["measurementUnit_23"] = df["measurementValue_23"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_23"] = df["measurementType_23"] = df["measurementUnit_23"] = None

    # Verificar si "BzbFLRANTE" existe y tiene al menos un valor no vacío
    if "BzbFLRANTE" in df.columns and df["BzbFLRANTE"].dropna().empty is False:
        df["measurementValue_24"] = df["BzbFLRANTE"]
        df["measurementType_24"] = df["measurementValue_24"].apply(lambda x: "Benzo(b) Fluoranteno" if pd.notna(x) else None)
        df["measurementUnit_24"] = df["measurementValue_24"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_24"] = df["measurementType_24"] = df["measurementUnit_24"] = None

    # Verificar si "BzkFLRANTE" existe y tiene al menos un valor no vacío
    if "BzkFLRANTE" in df.columns and df["BzkFLRANTE"].dropna().empty is False:
        df["measurementValue_25"] = df["BzkFLRANTE"]
        df["measurementType_25"] = df["measurementValue_25"].apply(lambda x: "Benzo(k) Fluoranteno" if pd.notna(x) else None)
        df["measurementUnit_25"] = df["measurementValue_25"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_25"] = df["measurementType_25"] = df["measurementUnit_25"] = None

    # Verificar si "BzPERILENE" existe y tiene al menos un valor no vacío
    if "BzPERILENE" in df.columns and df["BzPERILENE"].dropna().empty is False:
        df["measurementValue_26"] = df["BzPERILENE"]
        df["measurementType_26"] = df["measurementValue_26"].apply(lambda x: "Benzo(ghi) Perilene" if pd.notna(x) else None)
        df["measurementUnit_26"] = df["measurementValue_26"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_26"] = df["measurementType_26"] = df["measurementUnit_26"] = None

    # Verificar si "CADMIO" existe y tiene al menos un valor no vacío
    if "CADMIO" in df.columns and df["CADMIO"].dropna().empty is False:
        df["measurementValue_27"] = df["CADMIO"]
        df["measurementType_27"] = df["measurementValue_27"].apply(lambda x: "Cadmio" if pd.notna(x) else None)
        df["measurementUnit_27"] = df["measurementValue_27"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_27"] = df["measurementType_27"] = df["measurementUnit_27"] = None

    # Verificar si "CALCIO" existe y tiene al menos un valor no vacío
    if "CALCIO" in df.columns and df["CALCIO"].dropna().empty is False:
        df["measurementValue_28"] = df["CALCIO"]
        df["measurementType_28"] = df["measurementValue_28"].apply(lambda x: "Calcio" if pd.notna(x) else None)
        df["measurementUnit_28"] = df["measurementValue_28"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_28"] = df["measurementType_28"] = df["measurementUnit_28"] = None

    # Verificar si "CIANURO" existe y tiene al menos un valor no vacío
    if "CIANURO" in df.columns and df["CIANURO"].dropna().empty is False:
        df["measurementValue_29"] = df["CIANURO"]
        df["measurementType_29"] = df["measurementValue_29"].apply(lambda x: "Cianuro" if pd.notna(x) else None)
        df["measurementUnit_29"] = df["measurementValue_29"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_29"] = df["measurementType_29"] = df["measurementUnit_29"] = None

    # Verificar si "CLORO_RES" existe y tiene al menos un valor no vacío
    if "CLORO_RES" in df.columns and df["CLORO_RES"].dropna().empty is False:
        df["measurementValue_30"] = df["CLORO_RES"]
        df["measurementType_30"] = df["measurementValue_30"].apply(lambda x: "Cloro residual" if pd.notna(x) else None)
        df["measurementUnit_30"] = df["measurementValue_30"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_30"] = df["measurementType_30"] = df["measurementUnit_30"] = None

    # Verificar si "CLOROF_A" existe y tiene al menos un valor no vacío
    if "CLOROF_A" in df.columns and df["CLOROF_A"].dropna().empty is False:
        df["measurementValue_31"] = df["CLOROF_A"]
        df["measurementType_31"] = df["measurementValue_31"].apply(lambda x: "Clorofila-A" if pd.notna(x) else None)
        df["measurementUnit_31"] = df["measurementValue_31"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_31"] = df["measurementType_31"] = df["measurementUnit_31"] = None

    # Verificar si "CLORUROS" existe y tiene al menos un valor no vacío
    if "CLORUROS" in df.columns and df["CLORUROS"].dropna().empty is False:
        df["measurementValue_32"] = df["CLORUROS"]
        df["measurementType_32"] = df["measurementValue_32"].apply(lambda x: "Cloruros" if pd.notna(x) else None)
        df["measurementUnit_32"] = df["measurementValue_32"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_32"] = df["measurementType_32"] = df["measurementUnit_32"] = None

    # Verificar si "COBALTO" existe y tiene al menos un valor no vacío
    if "COBALTO" in df.columns and df["COBALTO"].dropna().empty is False:
        df["measurementValue_33"] = df["COBALTO"]
        df["measurementType_33"] = df["measurementValue_33"].apply(lambda x: "Cobalto" if pd.notna(x) else None)
        df["measurementUnit_33"] = df["measurementValue_33"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_33"] = df["measurementType_33"] = df["measurementUnit_33"] = None

    # Verificar si "COBRE" existe y tiene al menos un valor no vacío
    if "COBRE" in df.columns and df["COBRE"].dropna().empty is False:
        df["measurementValue_34"] = df["COBRE"]
        df["measurementType_34"] = df["measurementValue_34"].apply(lambda x: "Cobre" if pd.notna(x) else None)
        df["measurementUnit_34"] = df["measurementValue_34"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_34"] = df["measurementType_34"] = df["measurementUnit_34"] = None

    # Verificar si "COLIF_FEC" existe y tiene al menos un valor no vacío
    if "COLIF_FEC" in df.columns and df["COLIF_FEC"].dropna().empty is False:
        df["measurementValue_35"] = df["COLIF_FEC"]
        df["measurementType_35"] = df["measurementValue_35"].apply(lambda x: "Coliformes Fecales" if pd.notna(x) else None)
        df["measurementUnit_35"] = df["measurementValue_35"].apply(lambda x: "NMP/100ml" if pd.notna(x) else None)
    else:
        df["measurementValue_35"] = df["measurementType_35"] = df["measurementUnit_35"] = None

    # Verificar si "COLIF_TOT" existe y tiene al menos un valor no vacío
    if "COLIF_TOT" in df.columns and df["COLIF_TOT"].dropna().empty is False:
        df["measurementValue_36"] = df["COLIF_TOT"]
        df["measurementType_36"] = df["measurementValue_36"].apply(lambda x: "Coliformes Totales" if pd.notna(x) else None)
        df["measurementUnit_36"] = df["measurementValue_36"].apply(lambda x: "NMP/100ml" if pd.notna(x) else None)
    else:
        df["measurementValue_36"] = df["measurementType_36"] = df["measurementUnit_36"] = None

    # Verificar si "COLOR" existe y tiene al menos un valor no vacío
    if "COLOR" in df.columns and df["COLOR"].dropna().empty is False:
        df["measurementValue_37"] = df["COLOR"]
        df["measurementType_37"] = df["measurementValue_37"].apply(lambda x: "Color de la descarga" if pd.notna(x) else None)
        df["measurementUnit_37"] = df["measurementValue_37"].apply(lambda x: "UPC" if pd.notna(x) else None)
    else:
        df["measurementValue_37"] = df["measurementType_37"] = df["measurementUnit_37"] = None

    # Verificar si "CONDUCT" existe y tiene al menos un valor no vacío
    if "CONDUCT" in df.columns and df["CONDUCT"].dropna().empty is False:
        df["measurementValue_38"] = df["CONDUCT"]
        df["measurementType_38"] = df["measurementValue_38"].apply(lambda x: "Conductividad" if pd.notna(x) else None)
        df["measurementUnit_38"] = df["measurementValue_38"].apply(lambda x: "μS/cm" if pd.notna(x) else None)
    else:
        df["measurementValue_38"] = df["measurementType_38"] = df["measurementUnit_38"] = None

    # Verificar si "COT" existe y tiene al menos un valor no vacío
    if "COT" in df.columns and df["COT"].dropna().empty is False:
        df["measurementValue_39"] = df["COT"]
        df["measurementType_39"] = df["measurementValue_39"].apply(lambda x: "Carbono Orgánico Total" if pd.notna(x) else None)
        df["measurementUnit_39"] = df["measurementValue_39"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_39"] = df["measurementType_39"] = df["measurementUnit_39"] = None

    # Verificar si "CRISENO" existe y tiene al menos un valor no vacío
    if "CRISENO" in df.columns and df["CRISENO"].dropna().empty is False:
        df["measurementValue_40"] = df["CRISENO"]
        df["measurementType_40"] = df["measurementValue_40"].apply(lambda x: "Criseno" if pd.notna(x) else None)
        df["measurementUnit_40"] = df["measurementValue_40"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_40"] = df["measurementType_40"] = df["measurementUnit_40"] = None

    # Verificar si "CROMO" existe y tiene al menos un valor no vacío
    if "CROMO" in df.columns and df["CROMO"].dropna().empty is False:
        df["measurementValue_41"] = df["CROMO"]
        df["measurementType_41"] = df["measurementValue_41"].apply(lambda x: "Cromo" if pd.notna(x) else None)
        df["measurementUnit_41"] = df["measurementValue_41"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_41"] = df["measurementType_41"] = df["measurementUnit_41"] = None

    # Verificar si "CROMO_HEX" existe y tiene al menos un valor no vacío
    if "CROMO_HEX" in df.columns and df["CROMO_HEX"].dropna().empty is False:
        df["measurementValue_42"] = df["CROMO_HEX"]
        df["measurementType_42"] = df["measurementValue_42"].apply(lambda x: "Cromo Hexavalente" if pd.notna(x) else None)
        df["measurementUnit_42"] = df["measurementValue_42"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_42"] = df["measurementType_42"] = df["measurementUnit_42"] = None

    # Verificar si "DBO5" existe y tiene al menos un valor no vacío
    if "DBO5" in df.columns and df["DBO5"].dropna().empty is False:
        df["measurementValue_43"] = df["DBO5"]
        df["measurementType_43"] = df["measurementValue_43"].apply(lambda x: "Demanda Bioquímica de Oxígeno" if pd.notna(x) else None)
        df["measurementUnit_43"] = df["measurementValue_43"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_43"] = df["measurementType_43"] = df["measurementUnit_43"] = None

    # Verificar si "DBzANTRACE" existe y tiene al menos un valor no vacío
    if "DBzANTRACE" in df.columns and df["DBzANTRACE"].dropna().empty is False:
        df["measurementValue_44"] = df["DBzANTRACE"]
        df["measurementType_44"] = df["measurementValue_44"].apply(lambda x: "Dibenzo(a,h) antraceno" if pd.notna(x) else None)
        df["measurementUnit_44"] = df["measurementValue_44"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_44"] = df["measurementType_44"] = df["measurementUnit_44"] = None

    # Verificar si "DQO" existe y tiene al menos un valor no vacío
    if "DQO" in df.columns and df["DQO"].dropna().empty is False:
        df["measurementValue_45"] = df["DQO"]
        df["measurementType_45"] = df["measurementValue_45"].apply(lambda x: "Demanda Química de Oxígeno" if pd.notna(x) else None)
        df["measurementUnit_45"] = df["measurementValue_45"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_45"] = df["measurementType_45"] = df["measurementUnit_45"] = None

    # Verificar si "DUR_CALC" existe y tiene al menos un valor no vacío
    if "DUR_CALC" in df.columns and df["DUR_CALC"].dropna().empty is False:
        df["measurementValue_46"] = df["DUR_CALC"]
        df["measurementType_46"] = df["measurementValue_46"].apply(lambda x: "Dureza Cálcica de la descarga" if pd.notna(x) else None)
        df["measurementUnit_46"] = df["measurementValue_46"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_46"] = df["measurementType_46"] = df["measurementUnit_46"] = None

    # Verificar si "DURE_TOT" existe y tiene al menos un valor no vacío
    if "DURE_TOT" in df.columns and df["DURE_TOT"].dropna().empty is False:
        df["measurementValue_47"] = df["DURE_TOT"]
        df["measurementType_47"] = df["measurementValue_47"].apply(lambda x: "Dureza Total de la descarga" if pd.notna(x) else None)
        df["measurementUnit_47"] = df["measurementValue_47"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_47"] = df["measurementType_47"] = df["measurementUnit_47"] = None

    # Verificar si "ESTANO" existe y tiene al menos un valor no vacío
    if "ESTANO" in df.columns and df["ESTANO"].dropna().empty is False:
        df["measurementValue_48"] = df["ESTANO"]
        df["measurementType_48"] = df["measurementValue_48"].apply(lambda x: "Estaño" if pd.notna(x) else None)
        df["measurementUnit_48"] = df["measurementValue_48"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_48"] = df["measurementType_48"] = df["measurementUnit_48"] = None

    # Verificar si "FENANTRENO" existe y tiene al menos un valor no vacío
    if "FENANTRENO" in df.columns and df["FENANTRENO"].dropna().empty is False:
        df["measurementValue_49"] = df["FENANTRENO"]
        df["measurementType_49"] = df["measurementValue_49"].apply(lambda x: "Fenantreno" if pd.notna(x) else None)
        df["measurementUnit_49"] = df["measurementValue_49"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_49"] = df["measurementType_49"] = df["measurementUnit_49"] = None

    # Verificar si "FENOL" existe y tiene al menos un valor no vacío
    if "FENOL" in df.columns and df["FENOL"].dropna().empty is False:
        df["measurementValue_50"] = df["FENOL"]
        df["measurementType_50"] = df["measurementValue_50"].apply(lambda x: "Fenoles" if pd.notna(x) else None)
        df["measurementUnit_50"] = df["measurementValue_50"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_50"] = df["measurementType_50"] = df["measurementUnit_50"] = None

    # Verificar si "FLRANTENO" existe y tiene al menos un valor no vacío
    if "FLRANTENO" in df.columns and df["FLRANTENO"].dropna().empty is False:
        df["measurementValue_51"] = df["FLRANTENO"]
        df["measurementType_51"] = df["measurementValue_51"].apply(lambda x: "Fluoranteno" if pd.notna(x) else None)
        df["measurementUnit_51"] = df["measurementValue_51"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_51"] = df["measurementType_51"] = df["measurementUnit_51"] = None

    # Verificar si "FLUORENO" existe y tiene al menos un valor no vacío
    if "FLUORENO" in df.columns and df["FLUORENO"].dropna().empty is False:
        df["measurementValue_52"] = df["FLUORENO"]
        df["measurementType_52"] = df["measurementValue_52"].apply(lambda x: "Fluoreno" if pd.notna(x) else None)
        df["measurementUnit_52"] = df["measurementValue_52"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_52"] = df["measurementType_52"] = df["measurementUnit_52"] = None

    # Verificar si "FOSF_INORG" existe y tiene al menos un valor no vacío
    if "FOSF_INORG" in df.columns and df["FOSF_INORG"].dropna().empty is False:
        df["measurementValue_53"] = df["FOSF_INORG"]
        df["measurementType_53"] = df["measurementValue_53"].apply(lambda x: "Fósforo Inorgánico" if pd.notna(x) else None)
        df["measurementUnit_53"] = df["measurementValue_53"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_53"] = df["measurementType_53"] = df["measurementUnit_53"] = None

    # Verificar si "FOSF_ORG" existe y tiene al menos un valor no vacío
    if "FOSF_ORG" in df.columns and df["FOSF_ORG"].dropna().empty is False:
        df["measurementValue_54"] = df["FOSF_ORG"]
        df["measurementType_54"] = df["measurementValue_54"].apply(lambda x: "Fósforo Orgánico" if pd.notna(x) else None)
        df["measurementUnit_54"] = df["measurementValue_54"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_54"] = df["measurementType_54"] = df["measurementUnit_54"] = None

    # Verificar si "FOSF_TOTAL" existe y tiene al menos un valor no vacío
    if "FOSF_TOTAL" in df.columns and df["FOSF_TOTAL"].dropna().empty is False:
        df["measurementValue_55"] = df["FOSF_TOTAL"]
        df["measurementType_55"] = df["measurementValue_55"].apply(lambda x: "Fósforo Total" if pd.notna(x) else None)
        df["measurementUnit_55"] = df["measurementValue_55"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_55"] = df["measurementType_55"] = df["measurementUnit_55"] = None

    # Verificar si "FOSFATOS" existe y tiene al menos un valor no vacío
    if "FOSFATOS" in df.columns and df["FOSFATOS"].dropna().empty is False:
        df["measurementValue_56"] = df["FOSFATOS"]
        df["measurementType_56"] = df["measurementValue_56"].apply(lambda x: "Fosfato" if pd.notna(x) else None)
        df["measurementUnit_56"] = df["measurementValue_56"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_56"] = df["measurementType_56"] = df["measurementUnit_56"] = None

    # Verificar si "GR_ACEIT" existe y tiene al menos un valor no vacío
    if "GR_ACEIT" in df.columns and df["GR_ACEIT"].dropna().empty is False:
        df["measurementValue_57"] = df["GR_ACEIT"]
        df["measurementType_57"] = df["measurementValue_57"].apply(lambda x: "Grasas y Aceites" if pd.notna(x) else None)
        df["measurementUnit_57"] = df["measurementValue_57"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_57"] = df["measurementType_57"] = df["measurementUnit_57"] = None

    # Verificar si "HAP" existe y tiene al menos un valor no vacío
    if "HAP" in df.columns and df["HAP"].dropna().empty is False:
        df["measurementValue_58"] = df["HAP"]
        df["measurementType_58"] = df["measurementValue_58"].apply(lambda x: "Hidrocarburos Aromáticos Polinucleares (policíclicos) Totales" if pd.notna(x) else None)
        df["measurementUnit_58"] = df["measurementValue_58"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_58"] = df["measurementType_58"] = df["measurementUnit_58"] = None

    # Verificar si "HDD" existe y tiene al menos un valor no vacío
    if "HDD" in df.columns and df["HDD"].dropna().empty is False:
        df["measurementValue_59"] = df["HDD"]
        df["measurementType_59"] = df["measurementValue_59"].apply(lambda x: "Hidrocarburos Disueltos y Dispersos (Hidrocarburos Aromáticos Totales-HAT)" if pd.notna(x) else None)
        df["measurementUnit_59"] = df["measurementValue_59"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_59"] = df["measurementType_59"] = df["measurementUnit_59"] = None

    # Verificar si "HIERRO" existe y tiene al menos un valor no vacío
    if "HIERRO" in df.columns and df["HIERRO"].dropna().empty is False:
        df["measurementValue_60"] = df["HIERRO"]
        df["measurementType_60"] = df["measurementValue_60"].apply(lambda x: "Hierro" if pd.notna(x) else None)
        df["measurementUnit_60"] = df["measurementValue_60"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_60"] = df["measurementType_60"] = df["measurementUnit_60"] = None

    # Verificar si "INDENOPIRE" existe y tiene al menos un valor no vacío
    if "INDENOPIRE" in df.columns and df["INDENOPIRE"].dropna().empty is False:
        df["measurementValue_61"] = df["INDENOPIRE"]
        df["measurementType_61"] = df["measurementValue_61"].apply(lambda x: "Indeno(1,2,3-cd) Pireno" if pd.notna(x) else None)
        df["measurementUnit_61"] = df["measurementValue_61"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_61"] = df["measurementType_61"] = df["measurementUnit_61"] = None

    # Verificar si "LITIO" existe y tiene al menos un valor no vacío
    if "LITIO" in df.columns and df["LITIO"].dropna().empty is False:
        df["measurementValue_62"] = df["LITIO"]
        df["measurementType_62"] = df["measurementValue_62"].apply(lambda x: "Litio" if pd.notna(x) else None)
        df["measurementUnit_62"] = df["measurementValue_62"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_62"] = df["measurementType_62"] = df["measurementUnit_62"] = None

    # Verificar si "MAGNESIO" existe y tiene al menos un valor no vacío
    if "MAGNESIO" in df.columns and df["MAGNESIO"].dropna().empty is False:
        df["measurementValue_63"] = df["MAGNESIO"]
        df["measurementType_63"] = df["measurementValue_63"].apply(lambda x: "Magnesio" if pd.notna(x) else None)
        df["measurementUnit_63"] = df["measurementValue_63"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_63"] = df["measurementType_63"] = df["measurementUnit_63"] = None

    # Verificar si "MANGANESO" existe y tiene al menos un valor no vacío
    if "MANGANESO" in df.columns and df["MANGANESO"].dropna().empty is False:
        df["measurementValue_64"] = df["MANGANESO"]
        df["measurementType_64"] = df["measurementValue_64"].apply(lambda x: "Manganeso" if pd.notna(x) else None)
        df["measurementUnit_64"] = df["measurementValue_64"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_64"] = df["measurementType_64"] = df["measurementUnit_64"] = None

    # Verificar si "MERCURIO" existe y tiene al menos un valor no vacío
    if "MERCURIO" in df.columns and df["MERCURIO"].dropna().empty is False:
        df["measurementValue_65"] = df["MERCURIO"]
        df["measurementType_65"] = df["measurementValue_65"].apply(lambda x: "Mercurio" if pd.notna(x) else None)
        df["measurementUnit_65"] = df["measurementValue_65"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_65"] = df["measurementType_65"] = df["measurementUnit_65"] = None

    # Verificar si "MOLIBDENO" existe y tiene al menos un valor no vacío
    if "MOLIBDENO" in df.columns and df["MOLIBDENO"].dropna().empty is False:
        df["measurementValue_66"] = df["MOLIBDENO"]
        df["measurementType_66"] = df["measurementValue_66"].apply(lambda x: "Molibdeno" if pd.notna(x) else None)
        df["measurementUnit_66"] = df["measurementValue_66"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_66"] = df["measurementType_66"] = df["measurementUnit_66"] = None

    # Verificar si "MOO_AGU" existe y tiene al menos un valor no vacío
    if "MOO_AGU" in df.columns and df["MOO_AGU"].dropna().empty is False:
        df["measurementValue_67"] = df["MOO_AGU"]
        df["measurementType_67"] = df["measurementValue_67"].apply(lambda x: "Materia orgánica oxidable en aguas" if pd.notna(x) else None)
        df["measurementUnit_67"] = df["measurementValue_67"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_67"] = df["measurementType_67"] = df["measurementUnit_67"] = None

    # Verificar si "NAFTALENO" existe y tiene al menos un valor no vacío
    if "NAFTALENO" in df.columns and df["NAFTALENO"].dropna().empty is False:
        df["measurementValue_68"] = df["NAFTALENO"]
        df["measurementType_68"] = df["measurementValue_68"].apply(lambda x: "Naftaleno" if pd.notna(x) else None)
        df["measurementUnit_68"] = df["measurementValue_68"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_68"] = df["measurementType_68"] = df["measurementUnit_68"] = None

    # Verificar si "NAMON" existe y tiene al menos un valor no vacío
    if "NAMON" in df.columns and df["NAMON"].dropna().empty is False:
        df["measurementValue_69"] = df["NAMON"]
        df["measurementType_69"] = df["measurementValue_69"].apply(lambda x: "Nitrógeno Amoniacal" if pd.notna(x) else None)
        df["measurementUnit_69"] = df["measurementValue_69"].apply(lambda x: "mg/L N-NH3" if pd.notna(x) else None)
    else:
        df["measurementValue_69"] = df["measurementType_69"] = df["measurementUnit_69"] = None

    # Verificar si "NIQUEL" existe y tiene al menos un valor no vacío
    if "NIQUEL" in df.columns and df["NIQUEL"].dropna().empty is False:
        df["measurementValue_70"] = df["NIQUEL"]
        df["measurementType_70"] = df["measurementValue_70"].apply(lambda x: "Níquel" if pd.notna(x) else None)
        df["measurementUnit_70"] = df["measurementValue_70"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_70"] = df["measurementType_70"] = df["measurementUnit_70"] = None

    # Verificar si "NITR_INORG" existe y tiene al menos un valor no vacío
    if "NITR_INORG" in df.columns and df["NITR_INORG"].dropna().empty is False:
        df["measurementValue_71"] = df["NITR_INORG"]
        df["measurementType_71"] = df["measurementValue_71"].apply(lambda x: "Nitrógeno Inorgánico" if pd.notna(x) else None)
        df["measurementUnit_71"] = df["measurementValue_71"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_71"] = df["measurementType_71"] = df["measurementUnit_71"] = None

    # Verificar si "NITR_ORG" existe y tiene al menos un valor no vacío
    if "NITR_ORG" in df.columns and df["NITR_ORG"].dropna().empty is False:
        df["measurementValue_72"] = df["NITR_ORG"]
        df["measurementType_72"] = df["measurementValue_72"].apply(lambda x: "Nitrógeno Orgánico" if pd.notna(x) else None)
        df["measurementUnit_72"] = df["measurementValue_72"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_72"] = df["measurementType_72"] = df["measurementUnit_72"] = None

    # Verificar si "NITRATOS" existe y tiene al menos un valor no vacío
    if "NITRATOS" in df.columns and df["NITRATOS"].dropna().empty is False:
        df["measurementValue_73"] = df["NITRATOS"]
        df["measurementType_73"] = df["measurementValue_73"].apply(lambda x: "Nitratos" if pd.notna(x) else None)
        df["measurementUnit_73"] = df["measurementValue_73"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_73"] = df["measurementType_73"] = df["measurementUnit_73"] = None

    # Verificar si "NITRITOS" existe y tiene al menos un valor no vacío
    if "NITRITOS" in df.columns and df["NITRITOS"].dropna().empty is False:
        df["measurementValue_74"] = df["NITRITOS"]
        df["measurementType_74"] = df["measurementValue_74"].apply(lambda x: "Nitritos" if pd.notna(x) else None)
        df["measurementUnit_74"] = df["measurementValue_74"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_74"] = df["measurementType_74"] = df["measurementUnit_74"] = None

    # Verificar si "NTK" existe y tiene al menos un valor no vacío
    if "NTK" in df.columns and df["NTK"].dropna().empty is False:
        df["measurementValue_75"] = df["NTK"]
        df["measurementType_75"] = df["measurementValue_75"].apply(lambda x: "Nitrógeno Total" if pd.notna(x) else None)
        df["measurementUnit_75"] = df["measurementValue_75"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_75"] = df["measurementType_75"] = df["measurementUnit_75"] = None

    # Verificar si "OXIG_DISUE" existe y tiene al menos un valor no vacío
    if "OXIG_DISUE" in df.columns and df["OXIG_DISUE"].dropna().empty is False:
        df["measurementValue_76"] = df["OXIG_DISUE"]
        df["measurementType_76"] = df["measurementValue_76"].apply(lambda x: "Oxígeno Disuelto" if pd.notna(x) else None)
        df["measurementUnit_76"] = df["measurementValue_76"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_76"] = df["measurementType_76"] = df["measurementUnit_76"] = None

    # Verificar si "P_SOD_INT" existe y tiene al menos un valor no vacío
    if "P_SOD_INT" in df.columns and df["P_SOD_INT"].dropna().empty is False:
        df["measurementValue_77"] = df["P_SOD_INT"]
        df["measurementType_77"] = df["measurementValue_77"].apply(lambda x: "Sodio Intercambiable" if pd.notna(x) else None)
        df["measurementUnit_77"] = df["measurementValue_77"].apply(lambda x: "porcentaje" if pd.notna(x) else None)
    else:
        df["measurementValue_77"] = df["measurementType_77"] = df["measurementUnit_77"] = None

    # Verificar si "PH" existe y tiene al menos un valor no vacío
    if "PH" in df.columns and df["PH"].dropna().empty is False:
        df["measurementValue_78"] = df["PH"]
        df["measurementType_78"] = df["measurementValue_78"].apply(lambda x: "pH" if pd.notna(x) else None)
        df["measurementUnit_78"] = None
    else:
        df["measurementValue_78"] = df["measurementType_78"] = df["measurementUnit_78"] = None

    # Verificar si "PIRENO" existe y tiene al menos un valor no vacío
    if "PIRENO" in df.columns and df["PIRENO"].dropna().empty is False:
        df["measurementValue_79"] = df["PIRENO"]
        df["measurementType_79"] = df["measurementValue_79"].apply(lambda x: "Pireno" if pd.notna(x) else None)
        df["measurementUnit_79"] = df["measurementValue_79"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_79"] = df["measurementType_79"] = df["measurementUnit_79"] = None

    # Verificar si "PLATA" existe y tiene al menos un valor no vacío
    if "PLATA" in df.columns and df["PLATA"].dropna().empty is False:
        df["measurementValue_80"] = df["PLATA"]
        df["measurementType_80"] = df["measurementValue_80"].apply(lambda x: "Plata" if pd.notna(x) else None)
        df["measurementUnit_80"] = df["measurementValue_80"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_80"] = df["measurementType_80"] = df["measurementUnit_80"] = None

    # Verificar si "PLOMO" existe y tiene al menos un valor no vacío
    if "PLOMO" in df.columns and df["PLOMO"].dropna().empty is False:
        df["measurementValue_81"] = df["PLOMO"]
        df["measurementType_81"] = df["measurementValue_81"].apply(lambda x: "Plomo" if pd.notna(x) else None)
        df["measurementUnit_81"] = df["measurementValue_81"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_81"] = df["measurementType_81"] = df["measurementUnit_81"] = None

    # Verificar si "POTASIO" existe y tiene al menos un valor no vacío
    if "POTASIO" in df.columns and df["POTASIO"].dropna().empty is False:
        df["measurementValue_82"] = df["POTASIO"]
        df["measurementType_82"] = df["measurementValue_82"].apply(lambda x: "Potasio" if pd.notna(x) else None)
        df["measurementUnit_82"] = df["measurementValue_82"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_82"] = df["measurementType_82"] = df["measurementUnit_82"] = None

    # Verificar si "PROF_SECCH" existe y tiene al menos un valor no vacío
    if "PROF_SECCH" in df.columns and df["PROF_SECCH"].dropna().empty is False:
        df["measurementValue_83"] = df["PROF_SECCH"]
        df["measurementType_83"] = df["measurementValue_83"].apply(lambda x: "Profundidad de disco secchi" if pd.notna(x) else None)
        df["measurementUnit_83"] = df["measurementValue_83"].apply(lambda x: "m" if pd.notna(x) else None)
    else:
        df["measurementValue_83"] = df["measurementType_83"] = df["measurementUnit_83"] = None

    # Verificar si "RAS" existe y tiene al menos un valor no vacío
    if "RAS" in df.columns and df["RAS"].dropna().empty is False:
        df["measurementValue_84"] = df["RAS"]
        df["measurementType_84"] = df["measurementValue_84"].apply(lambda x: "índice de Relación de Absorción de Sodio" if pd.notna(x) else None)
        df["measurementUnit_84"] = None
    else:
        df["measurementValue_84"] = df["measurementType_84"] = df["measurementUnit_84"] = None

    # Verificar si "SAAM" existe y tiene al menos un valor no vacío
    if "SAAM" in df.columns and df["SAAM"].dropna().empty is False:
        df["measurementValue_85"] = df["SAAM"]
        df["measurementType_85"] = df["measurementValue_85"].apply(lambda x: "Sustancias activas al azul de metileno" if pd.notna(x) else None)
        df["measurementUnit_85"] = df["measurementValue_85"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_85"] = df["measurementType_85"] = df["measurementUnit_85"] = None

    # Verificar si "SALINIDAD" existe y tiene al menos un valor no vacío
    if "SALINIDAD" in df.columns and df["SALINIDAD"].dropna().empty is False:
        df["measurementValue_86"] = df["SALINIDAD"]
        df["measurementType_86"] = df["measurementValue_86"].apply(lambda x: "Salinidad" if pd.notna(x) else None)
        df["measurementUnit_86"] = None
    else:
        df["measurementValue_86"] = df["measurementType_86"] = df["measurementUnit_86"] = None

    # Verificar si "SELENIO" existe y tiene al menos un valor no vacío
    if "SELENIO" in df.columns and df["SELENIO"].dropna().empty is False:
        df["measurementValue_87"] = df["SELENIO"]
        df["measurementType_87"] = df["measurementValue_87"].apply(lambda x: "Selenio" if pd.notna(x) else None)
        df["measurementUnit_87"] = df["measurementValue_87"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_87"] = df["measurementType_87"] = df["measurementUnit_87"] = None

    # Verificar si "SILICATOS" existe y tiene al menos un valor no vacío
    if "SILICATOS" in df.columns and df["SILICATOS"].dropna().empty is False:
        df["measurementValue_88"] = df["SILICATOS"]
        df["measurementType_88"] = df["measurementValue_88"].apply(lambda x: "Silicatos" if pd.notna(x) else None)
        df["measurementUnit_88"] = df["measurementValue_88"].apply(lambda x: "µg/l SIO4" if pd.notna(x) else None)
    else:
        df["measurementValue_88"] = df["measurementType_88"] = df["measurementUnit_88"] = None

    # Verificar si "SO" existe y tiene al menos un valor no vacío
    if "SO" in df.columns and df["SO"].dropna().empty is False:
        df["measurementValue_89"] = df["SO"]
        df["measurementType_89"] = df["measurementValue_89"].apply(lambda x: "Saturación de oxígeno" if pd.notna(x) else None)
        df["measurementUnit_89"] = df["measurementValue_89"].apply(lambda x: "porcentaje" if pd.notna(x) else None)
    else:
        df["measurementValue_89"] = df["measurementType_89"] = df["measurementUnit_89"] = None

    # Verificar si "SODIO" existe y tiene al menos un valor no vacío
    if "SODIO" in df.columns and df["SODIO"].dropna().empty is False:
        df["measurementValue_90"] = df["SODIO"]
        df["measurementType_90"] = df["measurementValue_90"].apply(lambda x: "Sodio" if pd.notna(x) else None)
        df["measurementUnit_90"] = df["measurementValue_90"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_90"] = df["measurementType_90"] = df["measurementUnit_90"] = None

    # Verificar si "SOL_DISUEL" existe y tiene al menos un valor no vacío
    if "SOL_DISUEL" in df.columns and df["SOL_DISUEL"].dropna().empty is False:
        df["measurementValue_91"] = df["SOL_DISUEL"]
        df["measurementType_91"] = df["measurementValue_91"].apply(lambda x: "Sólidos Disueltos" if pd.notna(x) else None)
        df["measurementUnit_91"] = df["measurementValue_91"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_91"] = df["measurementType_91"] = df["measurementUnit_91"] = None

    # Verificar si "SOL_TOT" existe y tiene al menos un valor no vacío
    if "SOL_TOT" in df.columns and df["SOL_TOT"].dropna().empty is False:
        df["measurementValue_92"] = df["SOL_TOT"]
        df["measurementType_92"] = df["measurementValue_92"].apply(lambda x: "Sólidos Totales" if pd.notna(x) else None)
        df["measurementUnit_92"] = df["measurementValue_92"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_92"] = df["measurementType_92"] = df["measurementUnit_92"] = None

    # Verificar si "SSED" existe y tiene al menos un valor no vacío
    if "SSED" in df.columns and df["SSED"].dropna().empty is False:
        df["measurementValue_93"] = df["SSED"]
        df["measurementType_93"] = df["measurementValue_93"].apply(lambda x: "Sólidos sedimentables" if pd.notna(x) else None)
        df["measurementUnit_93"] = df["measurementValue_93"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_93"] = df["measurementType_93"] = df["measurementUnit_93"] = None

    # Verificar si "SST" existe y tiene al menos un valor no vacío
    if "SST" in df.columns and df["SST"].dropna().empty is False:
        df["measurementValue_94"] = df["SST"]
        df["measurementType_94"] = df["measurementValue_94"].apply(lambda x: "Sólidos suspendidos totales" if pd.notna(x) else None)
        df["measurementUnit_94"] = df["measurementValue_94"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_94"] = df["measurementType_94"] = df["measurementUnit_94"] = None

    # Verificar si "SULFATOS" existe y tiene al menos un valor no vacío
    if "SULFATOS" in df.columns and df["SULFATOS"].dropna().empty is False:
        df["measurementValue_95"] = df["SULFATOS"]
        df["measurementType_95"] = df["measurementValue_95"].apply(lambda x: "Sulfatos" if pd.notna(x) else None)
        df["measurementUnit_95"] = df["measurementValue_95"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_95"] = df["measurementType_95"] = df["measurementUnit_95"] = None

    # Verificar si "TEMPERAT" existe y tiene al menos un valor no vacío
    if "TEMPERAT" in df.columns and df["TEMPERAT"].dropna().empty is False:
        df["measurementValue_96"] = df["TEMPERAT"]
        df["measurementType_96"] = df["measurementValue_96"].apply(lambda x: "Temperatura" if pd.notna(x) else None)
        df["measurementUnit_96"] = df["measurementValue_96"].apply(lambda x: "°C" if pd.notna(x) else None)
    else:
        df["measurementValue_96"] = df["measurementType_96"] = df["measurementUnit_96"] = None

    # Verificar si "THC" existe y tiene al menos un valor no vacío
    if "THC" in df.columns and df["THC"].dropna().empty is False:
        df["measurementValue_97"] = df["THC"]
        df["measurementType_97"] = df["measurementValue_97"].apply(lambda x: "Hidrocarburos Totales" if pd.notna(x) else None)
        df["measurementUnit_97"] = df["measurementValue_97"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_97"] = df["measurementType_97"] = df["measurementUnit_97"] = None

    # Verificar si "TPH" existe y tiene al menos un valor no vacío
    if "TPH" in df.columns and df["TPH"].dropna().empty is False:
        df["measurementValue_98"] = df["TPH"]
        df["measurementType_98"] = df["measurementValue_98"].apply(lambda x: "Hidrocarburos Totales Petrológicos" if pd.notna(x) else None)
        df["measurementUnit_98"] = df["measurementValue_98"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_98"] = df["measurementType_98"] = df["measurementUnit_98"] = None

    # Verificar si "TURBIDEZ" existe y tiene al menos un valor no vacío
    if "TURBIDEZ" in df.columns and df["TURBIDEZ"].dropna().empty is False:
        df["measurementValue_99"] = df["TURBIDEZ"]
        df["measurementType_99"] = df["measurementValue_99"].apply(lambda x: "Turbidez" if pd.notna(x) else None)
        df["measurementUnit_99"] = df["measurementValue_99"].apply(lambda x: "NTU" if pd.notna(x) else None)
    else:
        df["measurementValue_99"] = df["measurementType_99"] = df["measurementUnit_99"] = None

    # Verificar si "VANADIO" existe y tiene al menos un valor no vacío
    if "VANADIO" in df.columns and df["VANADIO"].dropna().empty is False:
        df["measurementValue_100"] = df["VANADIO"]
        df["measurementType_100"] = df["measurementValue_100"].apply(lambda x: "Vanadio" if pd.notna(x) else None)
        df["measurementUnit_100"] = df["measurementValue_100"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_100"] = df["measurementType_100"] = df["measurementUnit_100"] = None

    # Verificar si "ZINC" existe y tiene al menos un valor no vacío
    if "ZINC" in df.columns and df["ZINC"].dropna().empty is False:
        df["measurementValue_101"] = df["ZINC"]
        df["measurementType_101"] = df["measurementValue_101"].apply(lambda x: "Zinc" if pd.notna(x) else None)
        df["measurementUnit_101"] = df["measurementValue_101"].apply(lambda x: "mg/L" if pd.notna(x) else None)
    else:
        df["measurementValue_101"] = df["measurementType_101"] = df["measurementUnit_101"] = None



    return df






# Función principal para procesar muestreio fisicoquim marino
def procesar_fisicoquim(ruta_gdb, tabla_fisicoquim,  ruta_excel_fisicoquim, archivo_entrada_fisicoquim, archivo_salida_fisicoquim):
    try:
        # Abrir la Geodatabase
        gdb = gdal.OpenEx(ruta_gdb, gdal.OF_VECTOR)
        if not gdb:
            raise RuntimeError(f"❌ No se pudo abrir la GDB en {ruta_gdb}")


        # Extraer atributos de la primera tabla
        datos_tabla = []
        layer_1 = gdb.GetLayerByName(tabla_fisicoquim)
        for feature in layer_1:
            datos_tabla.append(feature.items())  

        resultado = pd.DataFrame(datos_tabla).replace("<Null>", "")

        # Exportar el resultado del join a un archivo Excel intermedio
        exportar_excel(resultado, ruta_excel_fisicoquim)

        # Leer el archivo Excel con taxonRank agregado
        df_intermedio = pd.read_excel(ruta_excel_fisicoquim)
       
        # Procesar campos específicos
        df_intermedio = procesar_campos_especificos(df_intermedio)


        # Crear DataFrame final con todos los atributos de lista_atributos
        df_final = pd.DataFrame(columns=lista_atributos)

        # Mapear los datos del DataFrame intermedio al DataFrame final
        for columna_intermedia, columna_final in mapeo.items():
            if columna_intermedia in df_intermedio.columns:
                df_final[columna_final] = df_intermedio[columna_intermedia]

        # Agregar valores constantes
        for clave, valor in valores_constantes.items():
            df_final[clave] = valor

        # Agregar los campos calculados
       
        df_final["id"] = df_intermedio["id"]
        df_final["eventID"] = df_intermedio["eventID"]
        df_final["measurementDeterminedDate"] = df_intermedio["measurementDeterminedDate"]
        df_final["measurementRemarks"] = df_intermedio["measurementRemarks"]

        df_final["measurementValue_1"] = df_intermedio["measurementValue_1"]
        df_final["measurementType_1"] = df_intermedio["measurementType_1"]
        df_final["measurementUnit_1"] = df_intermedio["measurementUnit_1"]

        df_final["measurementValue_2"] = df_intermedio["measurementValue_2"]
        df_final["measurementType_2"] = df_intermedio["measurementType_2"]
        df_final["measurementUnit_2"] = df_intermedio["measurementUnit_2"]
        df_final["measurementMethod_2"] = df_intermedio["measurementMethod_2"]

        df_final["measurementValue_4"] = df_intermedio["measurementValue_4"]
        df_final["measurementType_4"] = df_intermedio["measurementType_4"]
        df_final["measurementUnit_4"] = df_intermedio["measurementUnit_4"]

        df_final["measurementValue_5"] = df_intermedio["measurementValue_5"]
        df_final["measurementType_5"] = df_intermedio["measurementType_5"]
        df_final["measurementUnit_5"] = df_intermedio["measurementUnit_5"]

        df_final["measurementValue_6"] = df_intermedio["measurementValue_6"]
        df_final["measurementType_6"] = df_intermedio["measurementType_6"]
        df_final["measurementUnit_6"] = df_intermedio["measurementUnit_6"]

        df_final["measurementValue_7"] = df_intermedio["measurementValue_7"]
        df_final["measurementType_7"] = df_intermedio["measurementType_7"]
        df_final["measurementUnit_7"] = df_intermedio["measurementUnit_7"]

        df_final["measurementValue_8"] = df_intermedio["measurementValue_8"]
        df_final["measurementType_8"] = df_intermedio["measurementType_8"]
        df_final["measurementUnit_8"] = df_intermedio["measurementUnit_8"]

        df_final["measurementValue_9"] = df_intermedio["measurementValue_9"]
        df_final["measurementType_9"] = df_intermedio["measurementType_9"]
        df_final["measurementUnit_9"] = df_intermedio["measurementUnit_9"]

        df_final["measurementValue_10"] = df_intermedio["measurementValue_10"]
        df_final["measurementType_10"] = df_intermedio["measurementType_10"]
        df_final["measurementUnit_10"] = df_intermedio["measurementUnit_10"]

        df_final["measurementValue_11"] = df_intermedio["measurementValue_11"]
        df_final["measurementType_11"] = df_intermedio["measurementType_11"]
        df_final["measurementUnit_11"] = df_intermedio["measurementUnit_11"]

        df_final["measurementValue_12"] = df_intermedio["measurementValue_12"]
        df_final["measurementType_12"] = df_intermedio["measurementType_12"]
        df_final["measurementUnit_12"] = df_intermedio["measurementUnit_12"]

        df_final["measurementValue_13"] = df_intermedio["measurementValue_13"]
        df_final["measurementType_13"] = df_intermedio["measurementType_13"]
        df_final["measurementUnit_13"] = df_intermedio["measurementUnit_13"]

        df_final["measurementValue_14"] = df_intermedio["measurementValue_14"]
        df_final["measurementType_14"] = df_intermedio["measurementType_14"]
        df_final["measurementUnit_14"] = df_intermedio["measurementUnit_14"]

        df_final["measurementValue_15"] = df_intermedio["measurementValue_15"]
        df_final["measurementType_15"] = df_intermedio["measurementType_15"]
        df_final["measurementUnit_15"] = df_intermedio["measurementUnit_15"]

        df_final["measurementValue_16"] = df_intermedio["measurementValue_16"]
        df_final["measurementType_16"] = df_intermedio["measurementType_16"]
        df_final["measurementUnit_16"] = df_intermedio["measurementUnit_16"]

        df_final["measurementValue_17"] = df_intermedio["measurementValue_17"]
        df_final["measurementType_17"] = df_intermedio["measurementType_17"]
        df_final["measurementUnit_17"] = df_intermedio["measurementUnit_17"]

        df_final["measurementValue_18"] = df_intermedio["measurementValue_18"]
        df_final["measurementType_18"] = df_intermedio["measurementType_18"]
        df_final["measurementUnit_18"] = df_intermedio["measurementUnit_18"]

        df_final["measurementValue_19"] = df_intermedio["measurementValue_19"]
        df_final["measurementType_19"] = df_intermedio["measurementType_19"]
        df_final["measurementUnit_19"] = df_intermedio["measurementUnit_19"]

        df_final["measurementValue_20"] = df_intermedio["measurementValue_20"]
        df_final["measurementType_20"] = df_intermedio["measurementType_20"]
        df_final["measurementUnit_20"] = df_intermedio["measurementUnit_20"]

        df_final["measurementValue_21"] = df_intermedio["measurementValue_21"]
        df_final["measurementType_21"] = df_intermedio["measurementType_21"]
        df_final["measurementUnit_21"] = df_intermedio["measurementUnit_21"]

        df_final["measurementValue_22"] = df_intermedio["measurementValue_22"]
        df_final["measurementType_22"] = df_intermedio["measurementType_22"]
        df_final["measurementUnit_22"] = df_intermedio["measurementUnit_22"]

        df_final["measurementValue_23"] = df_intermedio["measurementValue_23"]
        df_final["measurementType_23"] = df_intermedio["measurementType_23"]
        df_final["measurementUnit_23"] = df_intermedio["measurementUnit_23"]

        df_final["measurementValue_24"] = df_intermedio["measurementValue_24"]
        df_final["measurementType_24"] = df_intermedio["measurementType_24"]
        df_final["measurementUnit_24"] = df_intermedio["measurementUnit_24"]

        df_final["measurementValue_25"] = df_intermedio["measurementValue_25"]
        df_final["measurementType_25"] = df_intermedio["measurementType_25"]
        df_final["measurementUnit_25"] = df_intermedio["measurementUnit_25"]

        df_final["measurementValue_26"] = df_intermedio["measurementValue_26"]
        df_final["measurementType_26"] = df_intermedio["measurementType_26"]
        df_final["measurementUnit_26"] = df_intermedio["measurementUnit_26"]

        df_final["measurementValue_27"] = df_intermedio["measurementValue_27"]
        df_final["measurementType_27"] = df_intermedio["measurementType_27"]
        df_final["measurementUnit_27"] = df_intermedio["measurementUnit_27"]

        df_final["measurementValue_28"] = df_intermedio["measurementValue_28"]
        df_final["measurementType_28"] = df_intermedio["measurementType_28"]
        df_final["measurementUnit_28"] = df_intermedio["measurementUnit_28"]

        df_final["measurementValue_29"] = df_intermedio["measurementValue_29"]
        df_final["measurementType_29"] = df_intermedio["measurementType_29"]
        df_final["measurementUnit_29"] = df_intermedio["measurementUnit_29"]

        df_final["measurementValue_30"] = df_intermedio["measurementValue_30"]
        df_final["measurementType_30"] = df_intermedio["measurementType_30"]
        df_final["measurementUnit_30"] = df_intermedio["measurementUnit_30"]

        df_final["measurementValue_31"] = df_intermedio["measurementValue_31"]
        df_final["measurementType_31"] = df_intermedio["measurementType_31"]
        df_final["measurementUnit_31"] = df_intermedio["measurementUnit_31"]

        df_final["measurementValue_32"] = df_intermedio["measurementValue_32"]
        df_final["measurementType_32"] = df_intermedio["measurementType_32"]
        df_final["measurementUnit_32"] = df_intermedio["measurementUnit_32"]

        df_final["measurementValue_33"] = df_intermedio["measurementValue_33"]
        df_final["measurementType_33"] = df_intermedio["measurementType_33"]
        df_final["measurementUnit_33"] = df_intermedio["measurementUnit_33"]

        df_final["measurementValue_34"] = df_intermedio["measurementValue_34"]
        df_final["measurementType_34"] = df_intermedio["measurementType_34"]
        df_final["measurementUnit_34"] = df_intermedio["measurementUnit_34"]

        df_final["measurementValue_35"] = df_intermedio["measurementValue_35"]
        df_final["measurementType_35"] = df_intermedio["measurementType_35"]
        df_final["measurementUnit_35"] = df_intermedio["measurementUnit_35"]

        df_final["measurementValue_36"] = df_intermedio["measurementValue_36"]
        df_final["measurementType_36"] = df_intermedio["measurementType_36"]
        df_final["measurementUnit_36"] = df_intermedio["measurementUnit_36"]

        df_final["measurementValue_37"] = df_intermedio["measurementValue_37"]
        df_final["measurementType_37"] = df_intermedio["measurementType_37"]
        df_final["measurementUnit_37"] = df_intermedio["measurementUnit_37"]

        df_final["measurementValue_38"] = df_intermedio["measurementValue_38"]
        df_final["measurementType_38"] = df_intermedio["measurementType_38"]
        df_final["measurementUnit_38"] = df_intermedio["measurementUnit_38"]

        df_final["measurementValue_39"] = df_intermedio["measurementValue_39"]
        df_final["measurementType_39"] = df_intermedio["measurementType_39"]
        df_final["measurementUnit_39"] = df_intermedio["measurementUnit_39"]

        df_final["measurementValue_40"] = df_intermedio["measurementValue_40"]
        df_final["measurementType_40"] = df_intermedio["measurementType_40"]
        df_final["measurementUnit_40"] = df_intermedio["measurementUnit_40"]

        df_final["measurementValue_41"] = df_intermedio["measurementValue_41"]
        df_final["measurementType_41"] = df_intermedio["measurementType_41"]
        df_final["measurementUnit_41"] = df_intermedio["measurementUnit_41"]

        df_final["measurementValue_42"] = df_intermedio["measurementValue_42"]
        df_final["measurementType_42"] = df_intermedio["measurementType_42"]
        df_final["measurementUnit_42"] = df_intermedio["measurementUnit_42"]

        df_final["measurementValue_43"] = df_intermedio["measurementValue_43"]
        df_final["measurementType_43"] = df_intermedio["measurementType_43"]
        df_final["measurementUnit_43"] = df_intermedio["measurementUnit_43"]

        df_final["measurementValue_44"] = df_intermedio["measurementValue_44"]
        df_final["measurementType_44"] = df_intermedio["measurementType_44"]
        df_final["measurementUnit_44"] = df_intermedio["measurementUnit_44"]

        df_final["measurementValue_45"] = df_intermedio["measurementValue_45"]
        df_final["measurementType_45"] = df_intermedio["measurementType_45"]
        df_final["measurementUnit_45"] = df_intermedio["measurementUnit_45"]

        df_final["measurementValue_46"] = df_intermedio["measurementValue_46"]
        df_final["measurementType_46"] = df_intermedio["measurementType_46"]
        df_final["measurementUnit_46"] = df_intermedio["measurementUnit_46"]

        df_final["measurementValue_47"] = df_intermedio["measurementValue_47"]
        df_final["measurementType_47"] = df_intermedio["measurementType_47"]
        df_final["measurementUnit_47"] = df_intermedio["measurementUnit_47"]

        df_final["measurementValue_48"] = df_intermedio["measurementValue_48"]
        df_final["measurementType_48"] = df_intermedio["measurementType_48"]
        df_final["measurementUnit_48"] = df_intermedio["measurementUnit_48"]

        df_final["measurementValue_49"] = df_intermedio["measurementValue_49"]
        df_final["measurementType_49"] = df_intermedio["measurementType_49"]
        df_final["measurementUnit_49"] = df_intermedio["measurementUnit_49"]

        df_final["measurementValue_50"] = df_intermedio["measurementValue_50"]
        df_final["measurementType_50"] = df_intermedio["measurementType_50"]
        df_final["measurementUnit_50"] = df_intermedio["measurementUnit_50"]

        df_final["measurementValue_51"] = df_intermedio["measurementValue_51"]
        df_final["measurementType_51"] = df_intermedio["measurementType_51"]
        df_final["measurementUnit_51"] = df_intermedio["measurementUnit_51"]

        df_final["measurementValue_52"] = df_intermedio["measurementValue_52"]
        df_final["measurementType_52"] = df_intermedio["measurementType_52"]
        df_final["measurementUnit_52"] = df_intermedio["measurementUnit_52"]

        df_final["measurementValue_53"] = df_intermedio["measurementValue_53"]
        df_final["measurementType_53"] = df_intermedio["measurementType_53"]
        df_final["measurementUnit_53"] = df_intermedio["measurementUnit_53"]

        df_final["measurementValue_54"] = df_intermedio["measurementValue_54"]
        df_final["measurementType_54"] = df_intermedio["measurementType_54"]
        df_final["measurementUnit_54"] = df_intermedio["measurementUnit_54"]

        df_final["measurementValue_55"] = df_intermedio["measurementValue_55"]
        df_final["measurementType_55"] = df_intermedio["measurementType_55"]
        df_final["measurementUnit_55"] = df_intermedio["measurementUnit_55"]

        df_final["measurementValue_56"] = df_intermedio["measurementValue_56"]
        df_final["measurementType_56"] = df_intermedio["measurementType_56"]
        df_final["measurementUnit_56"] = df_intermedio["measurementUnit_56"]

        df_final["measurementValue_57"] = df_intermedio["measurementValue_57"]
        df_final["measurementType_57"] = df_intermedio["measurementType_57"]
        df_final["measurementUnit_57"] = df_intermedio["measurementUnit_57"]

        df_final["measurementValue_58"] = df_intermedio["measurementValue_58"]
        df_final["measurementType_58"] = df_intermedio["measurementType_58"]
        df_final["measurementUnit_58"] = df_intermedio["measurementUnit_58"]

        df_final["measurementValue_59"] = df_intermedio["measurementValue_59"]
        df_final["measurementType_59"] = df_intermedio["measurementType_59"]
        df_final["measurementUnit_59"] = df_intermedio["measurementUnit_59"]

        df_final["measurementValue_60"] = df_intermedio["measurementValue_60"]
        df_final["measurementType_60"] = df_intermedio["measurementType_60"]
        df_final["measurementUnit_60"] = df_intermedio["measurementUnit_60"]

        df_final["measurementValue_61"] = df_intermedio["measurementValue_61"]
        df_final["measurementType_61"] = df_intermedio["measurementType_61"]
        df_final["measurementUnit_61"] = df_intermedio["measurementUnit_61"]

        df_final["measurementValue_62"] = df_intermedio["measurementValue_62"]
        df_final["measurementType_62"] = df_intermedio["measurementType_62"]
        df_final["measurementUnit_62"] = df_intermedio["measurementUnit_62"]

        df_final["measurementValue_63"] = df_intermedio["measurementValue_63"]
        df_final["measurementType_63"] = df_intermedio["measurementType_63"]
        df_final["measurementUnit_63"] = df_intermedio["measurementUnit_63"]

        df_final["measurementValue_64"] = df_intermedio["measurementValue_64"]
        df_final["measurementType_64"] = df_intermedio["measurementType_64"]
        df_final["measurementUnit_64"] = df_intermedio["measurementUnit_64"]

        df_final["measurementValue_65"] = df_intermedio["measurementValue_65"]
        df_final["measurementType_65"] = df_intermedio["measurementType_65"]
        df_final["measurementUnit_65"] = df_intermedio["measurementUnit_65"]

        df_final["measurementValue_66"] = df_intermedio["measurementValue_66"]
        df_final["measurementType_66"] = df_intermedio["measurementType_66"]
        df_final["measurementUnit_66"] = df_intermedio["measurementUnit_66"]

        df_final["measurementValue_67"] = df_intermedio["measurementValue_67"]
        df_final["measurementType_67"] = df_intermedio["measurementType_67"]
        df_final["measurementUnit_67"] = df_intermedio["measurementUnit_67"]

        df_final["measurementValue_68"] = df_intermedio["measurementValue_68"]
        df_final["measurementType_68"] = df_intermedio["measurementType_68"]
        df_final["measurementUnit_68"] = df_intermedio["measurementUnit_68"]

        df_final["measurementValue_69"] = df_intermedio["measurementValue_69"]
        df_final["measurementType_69"] = df_intermedio["measurementType_69"]
        df_final["measurementUnit_69"] = df_intermedio["measurementUnit_69"]

        df_final["measurementValue_70"] = df_intermedio["measurementValue_70"]
        df_final["measurementType_70"] = df_intermedio["measurementType_70"]
        df_final["measurementUnit_70"] = df_intermedio["measurementUnit_70"]

        df_final["measurementValue_71"] = df_intermedio["measurementValue_71"]
        df_final["measurementType_71"] = df_intermedio["measurementType_71"]
        df_final["measurementUnit_71"] = df_intermedio["measurementUnit_71"]

        df_final["measurementValue_72"] = df_intermedio["measurementValue_72"]
        df_final["measurementType_72"] = df_intermedio["measurementType_72"]
        df_final["measurementUnit_72"] = df_intermedio["measurementUnit_72"]

        df_final["measurementValue_73"] = df_intermedio["measurementValue_73"]
        df_final["measurementType_73"] = df_intermedio["measurementType_73"]
        df_final["measurementUnit_73"] = df_intermedio["measurementUnit_73"]

        df_final["measurementValue_74"] = df_intermedio["measurementValue_74"]
        df_final["measurementType_74"] = df_intermedio["measurementType_74"]
        df_final["measurementUnit_74"] = df_intermedio["measurementUnit_74"]

        df_final["measurementValue_75"] = df_intermedio["measurementValue_75"]
        df_final["measurementType_75"] = df_intermedio["measurementType_75"]
        df_final["measurementUnit_75"] = df_intermedio["measurementUnit_75"]

        df_final["measurementValue_76"] = df_intermedio["measurementValue_76"]
        df_final["measurementType_76"] = df_intermedio["measurementType_76"]
        df_final["measurementUnit_76"] = df_intermedio["measurementUnit_76"]

        df_final["measurementValue_77"] = df_intermedio["measurementValue_77"]
        df_final["measurementType_77"] = df_intermedio["measurementType_77"]
        df_final["measurementUnit_77"] = df_intermedio["measurementUnit_77"]

        df_final["measurementValue_78"] = df_intermedio["measurementValue_78"]
        df_final["measurementType_78"] = df_intermedio["measurementType_78"]
        df_final["measurementUnit_78"] = df_intermedio["measurementUnit_78"]

        df_final["measurementValue_79"] = df_intermedio["measurementValue_79"]
        df_final["measurementType_79"] = df_intermedio["measurementType_79"]
        df_final["measurementUnit_79"] = df_intermedio["measurementUnit_79"]

        df_final["measurementValue_80"] = df_intermedio["measurementValue_80"]
        df_final["measurementType_80"] = df_intermedio["measurementType_80"]
        df_final["measurementUnit_80"] = df_intermedio["measurementUnit_80"]

        df_final["measurementValue_81"] = df_intermedio["measurementValue_81"]
        df_final["measurementType_81"] = df_intermedio["measurementType_81"]
        df_final["measurementUnit_81"] = df_intermedio["measurementUnit_81"]

        df_final["measurementValue_82"] = df_intermedio["measurementValue_82"]
        df_final["measurementType_82"] = df_intermedio["measurementType_82"]
        df_final["measurementUnit_82"] = df_intermedio["measurementUnit_82"]

        df_final["measurementValue_83"] = df_intermedio["measurementValue_83"]
        df_final["measurementType_83"] = df_intermedio["measurementType_83"]
        df_final["measurementUnit_83"] = df_intermedio["measurementUnit_83"]

        df_final["measurementValue_84"] = df_intermedio["measurementValue_84"]
        df_final["measurementType_84"] = df_intermedio["measurementType_84"]
        df_final["measurementUnit_84"] = df_intermedio["measurementUnit_84"]

        df_final["measurementValue_85"] = df_intermedio["measurementValue_85"]
        df_final["measurementType_85"] = df_intermedio["measurementType_85"]
        df_final["measurementUnit_85"] = df_intermedio["measurementUnit_85"]

        df_final["measurementValue_86"] = df_intermedio["measurementValue_86"]
        df_final["measurementType_86"] = df_intermedio["measurementType_86"]
        df_final["measurementUnit_86"] = df_intermedio["measurementUnit_86"]

        df_final["measurementValue_87"] = df_intermedio["measurementValue_87"]
        df_final["measurementType_87"] = df_intermedio["measurementType_87"]
        df_final["measurementUnit_87"] = df_intermedio["measurementUnit_87"]

        df_final["measurementValue_88"] = df_intermedio["measurementValue_88"]
        df_final["measurementType_88"] = df_intermedio["measurementType_88"]
        df_final["measurementUnit_88"] = df_intermedio["measurementUnit_88"]

        df_final["measurementValue_89"] = df_intermedio["measurementValue_89"]
        df_final["measurementType_89"] = df_intermedio["measurementType_89"]
        df_final["measurementUnit_89"] = df_intermedio["measurementUnit_89"]

        df_final["measurementValue_90"] = df_intermedio["measurementValue_90"]
        df_final["measurementType_90"] = df_intermedio["measurementType_90"]
        df_final["measurementUnit_90"] = df_intermedio["measurementUnit_90"]

        df_final["measurementValue_91"] = df_intermedio["measurementValue_91"]
        df_final["measurementType_91"] = df_intermedio["measurementType_91"]
        df_final["measurementUnit_91"] = df_intermedio["measurementUnit_91"]

        df_final["measurementValue_92"] = df_intermedio["measurementValue_92"]
        df_final["measurementType_92"] = df_intermedio["measurementType_92"]
        df_final["measurementUnit_92"] = df_intermedio["measurementUnit_92"]

        df_final["measurementValue_93"] = df_intermedio["measurementValue_93"]
        df_final["measurementType_93"] = df_intermedio["measurementType_93"]
        df_final["measurementUnit_93"] = df_intermedio["measurementUnit_93"]

        df_final["measurementValue_94"] = df_intermedio["measurementValue_94"]
        df_final["measurementType_94"] = df_intermedio["measurementType_94"]
        df_final["measurementUnit_94"] = df_intermedio["measurementUnit_94"]

        df_final["measurementValue_95"] = df_intermedio["measurementValue_95"]
        df_final["measurementType_95"] = df_intermedio["measurementType_95"]
        df_final["measurementUnit_95"] = df_intermedio["measurementUnit_95"]

        df_final["measurementValue_96"] = df_intermedio["measurementValue_96"]
        df_final["measurementType_96"] = df_intermedio["measurementType_96"]
        df_final["measurementUnit_96"] = df_intermedio["measurementUnit_96"]

        df_final["measurementValue_97"] = df_intermedio["measurementValue_97"]
        df_final["measurementType_97"] = df_intermedio["measurementType_97"]
        df_final["measurementUnit_97"] = df_intermedio["measurementUnit_97"]

        df_final["measurementValue_98"] = df_intermedio["measurementValue_98"]
        df_final["measurementType_98"] = df_intermedio["measurementType_98"]
        df_final["measurementUnit_98"] = df_intermedio["measurementUnit_98"]

        df_final["measurementValue_99"] = df_intermedio["measurementValue_99"]
        df_final["measurementType_99"] = df_intermedio["measurementType_99"]
        df_final["measurementUnit_99"] = df_intermedio["measurementUnit_99"]

        df_final["measurementValue_100"] = df_intermedio["measurementValue_100"]
        df_final["measurementType_100"] = df_intermedio["measurementType_100"]
        df_final["measurementUnit_100"] = df_intermedio["measurementUnit_100"]

        df_final["measurementValue_101"] = df_intermedio["measurementValue_101"]
        df_final["measurementType_101"] = df_intermedio["measurementType_101"]
        df_final["measurementUnit_101"] = df_intermedio["measurementUnit_101"]
     

        # Transformar df_final a filas
        mediciones = []

        for i in range(1, 102):
            col_valor = f"measurementValue_{i}"
            col_tipo = f"measurementType_{i}"
            col_unidad = f"measurementUnit_{i}"
            col_metodo = f"measurementMethod_{i}"

            if col_valor in df_final.columns:
                bloque = df_final[[
                    "id", "eventID", "materialSampleID",
                    "measurementDeterminedBy", "measurementDeterminedDate", "measurementRemarks",
                    col_valor, col_tipo, col_unidad
                ]].copy()

                bloque["measurementIndex"] = i
                bloque["measurementValue"] = bloque[col_valor]
                bloque["measurementType"] = bloque[col_tipo] if col_tipo in df_final.columns else None
                bloque["measurementUnit"] = bloque[col_unidad] if col_unidad in df_final.columns else None
                bloque["measurementMethod"] = df_final[col_metodo] if col_metodo in df_final.columns else None

                bloque = bloque.drop(columns=[col_valor, col_tipo, col_unidad], errors="ignore")
                mediciones.append(bloque)

        # Concatenar todo
        df_largo = pd.concat(mediciones, ignore_index=True)

        # Eliminar filas vacías en measurementValue
        df_largo = df_largo[df_largo["measurementValue"].notna()]
        df_largo = df_largo[df_largo["measurementValue"].astype(str).str.strip() != ""]


        # Exportar
        exportar_excel(df_largo, archivo_salida_fisicoquim)


    except Exception as e:
        return None