# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoQGISDialog
                                 A QGIS plugin
 GeoQGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-01-21
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Geo
        email                : hmd@geo.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtGui import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'virtualBoring_dialog_base.ui'))


class VirtualBoringDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, mainPlugin, parent=None):
        self.mainPlugin = mainPlugin
        """Constructor."""
        super(VirtualBoringDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
    def updateImage(self, img):
        qp = QPixmap()
        qp.loadFromData(img)
        self.image.setPixmap(qp)

    def getDepth(self):
        return self.depth.value()

    def setModels(self, models):
        #TODO: Add Terræn 0.4m to the models.
        current = self.ModelComboBox.currentText()
        self.ModelComboBox.clear()
        for name in models:
            self.ModelComboBox.addItem(name)
        index = self.ModelComboBox.findText(current)
        if index >= 0:
            self.ModelComboBox.setCurrentIndex(index)

    def getModelChoice(self):
        return self.ModelComboBox.currentText()

    def setUpdateFunction(self, function):
        self.ModelComboBox.activated.connect(function)
        self.depth.valueChanged.connect(function)
        

