# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeODinQGIS
                                 A QGIS plugin
 This plugin connects GeODin with QGIS
                             -------------------
        begin                : 2015-02-16
        copyright            : (C) 2021 by Fugro Germany Land GmbH
        email                : www.fugro.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""
__version__ = '3.0.22xx'
__licens__ = '<your licence>'
__maintainer_email__ = 'support@geodin.com'
__url__ = 'www.geodin.com'
import logging
print("import GeODinQGIS Modul")
##from fw.fg_logging import LogConfigurator
##LogConfigurator.config()

from pathlib import Path
# Achtung, Reihenfolge beachten!!!
#   1a) fw.fg_env und fw.fg_res importieren
#   1b) globals env und res instanziieren
#   2a) gqgis_app importieren
#   2b) globlas app instanziieren
from GeODinQGIS.fw.fg_logging import (
    LogFormatterTrace
)
from GeODinQGIS.gqgis_config import (
    LogFilterCOM,
    LogFilterSQL,
    LogFilterTRACE
)
from .fw import (
    env,
    res
)
from .gqgis_app import GQgis_App
app = GQgis_App()

from qgis import utils

# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load GeODinQGIS class from file GeODinQGIS.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    print(__name__, 'importing...')
    from .fw import LogConfigurator
    LogConfigurator.config()
    log = logging.getLogger('GeODinQGIS')
    log.info('GeODinQGIS load')

##    from .GeODinQGIS import GeODinQGIS
##    return GeODinQGIS(iface)
    from .gqgis import GQgis
    return GQgis(iface)

def name():
    """Plugin name

    27.04.2023 j.ebert
    """
    # __file__      <QGIS_PLUGINPATH>/<Plugin/Modul>/__init__.py
    # __name__                        <Plugin/Modul>
    return __name__

def plugin():
    """Plugin instance

    exception:
        KeyError                if GeODinQGIS Plugin ist not installed

    27.04.2023 j.ebert
    """
    # __file__      <QGIS_PLUGINPATH>/<Plugin/Modul>/__init__.py
    # __name__                        <Plugin/Modul>
    return utils.plugins[__name__]
