# -*- coding: utf-8 -*-
"""
/***************************************************************************
                                 A QGIS GTFS plugin

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-03-26
        git sha              : $Format:%H$
        copyright            : (C) 2020-2021 by CTU GeoForAll Lab
        email                : martin.kouba97@gmail.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QDialog, QProgressBar
# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .GTFS_dockwidget import GTFSDockWidget
import os.path

from PyQt5 import QtGui, QtCore
from PyQt5.QtGui import QColor
from PyQt5.QtWidgets import *
from qgis.utils import iface
from qgis.core import *
from qgis.gui import *

from zipfile import ZipFile, BadZipFile
import sqlite3

from .gtfs_reader import GtfsReader, GtfsError
from .gtfs_reader.shapes import GtfsShapes

class GTFS:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.
        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GTFS_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GTFS Loader')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'GTFS')
        self.toolbar.setObjectName(u'GTFS')

        #print "** INITIALIZING GTFS"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.
        We implement this ourselves since we do not inherit QObject.
        :param message: String for translation.
        :type message: str, QString
        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GTFS', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.
        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str
        :param text: Text that should be shown in menu items for this action.
        :type text: str
        :param callback: Function to be called when the action is triggered.
        :type callback: function
        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool
        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool
        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool
        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str
        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget
        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.
        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/GTFS/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'GTFS Loader'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING GTFS"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD GTFS"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&GTFS Loader'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING GTFS"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                self.browsePathSetting="/plugins/qgis-gtfs-plugin"
                self._home = QSettings().value(self.browsePathSetting,'')
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = GTFSDockWidget()
                self.dockwidget.input_dir.setDialogTitle("Select GTFS")
                self.dockwidget.input_dir.setFilter("GTFS *.zip")
                self.dockwidget.input_dir.setStorageMode(QgsFileWidget.GetFile)
                self.dockwidget.submit.clicked.connect(self.onSubmit)

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

    def onSubmit(self):
        progressMessageBar = iface.messageBar().createMessage("")

        self.process_info = QLabel()
        progressMessageBar.layout().addWidget(self.process_info)

        progress = QProgressBar()
        progress.setMaximum(100)
        progress.setAlignment(Qt.AlignVCenter)
        progressMessageBar.layout().addWidget(progress)

        iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)

        task = LoadTask(self.dockwidget.input_dir.filePath())
        task.progressChanged.connect(lambda: progress.setValue(task.progress()))
        task.progressChanged.connect(lambda: self.info(task.progress()))

        QgsApplication.taskManager().addTask(task)

    def info(self, value):
        if value == 10:
            self.process_info.setText("Unzipping file... ")

        elif value == 60:
            self.process_info.setText("Saving layers into GeoPackage... ")

        elif value == 70:
            self.process_info.setText("Loading layers from GeoPackage... ")

        elif value == 80:
            self.process_info.setText("Deleting unzipped folder... ")

        elif value == 85:
            self.process_info.setText("Connecting shapes... ")

        elif value == 95:
            self.process_info.setText("Coloring of line layers... ")

class LoadTask(QgsTask):

    def __init__(self, GTFS_folder):
        super().__init__(GTFS_folder)
        self.reader = GtfsReader(GTFS_folder)
        self.error = None

    def finished(self, result):
        if self.error:
            iface.messageBar().pushMessage('Error! {}'.format(self.error), duration=3, level=Qgis.Critical)
        else:
            iface.messageBar().pushMessage('Task completed! For more information, see Messages.', duration=3)

    # The function that restricts the input file to a zip file
    def run(self):
        gpkg_path = str(self.reader.dir_path) + '.gpkg'

        # store layers into target GPKG
        try:
            self.setProgress(10)
            layer_names = self.reader.write(gpkg_path)
        except GtfsError as e:
            self.error = e

        # load layers from GPKG into map canvas
        self.setProgress(70)
        self.load_layers_from_gpkg(gpkg_path, layer_names)

        self.shapes = GtfsShapes(gpkg_path)

        self.shapes.shapes_method()

        self.setProgress(100)

        # insert shapes_layer to gtfs import group
        root = QgsProject.instance().layerTreeRoot()
        if len(self.groupName) != 0:
            group_gtfs = root.findGroup("GTFS import (" + self.reader.dir_name + ") " + str(len(self.groupName)))
        else:
            group_gtfs = root.findGroup("GTFS import (" + self.reader.dir_name + ")")

        group_gtfs.insertChildNode(0, QgsLayerTreeLayer(self.shapes.shapes_layer))

    # The function create index on assigned field
    def index(self,path,fields,layer):
        with sqlite3.connect(path) as connection:
            cursor = connection.cursor()
            for field in fields:
                cursor.execute("CREATE INDEX {0}_index ON {1}({0})".format(field,layer))
            cursor.close()

    # The function load layers from geopackage to the layer tree
    def load_layers_from_gpkg(self,GPKG_path,layer_names):
        # # Create groups
        #GTFS_name=os.path.splitext(os.path.basename(GPKG_path))[0]
        root=QgsProject.instance().layerTreeRoot()
        self.groupName=[]
        for groups in root.children():
            if "GTFS import (" + self.reader.dir_name + ")" in groups.name():
                self.groupName.append(groups.name())
        if len(self.groupName) != 0:
            group_gtfs = root.addGroup("GTFS import (" + self.reader.dir_name + ") " + str(len(self.groupName)))
        else:
            group_gtfs = root.addGroup("GTFS import (" + self.reader.dir_name + ")")
        g_trans = group_gtfs.addGroup("transfer")
        g_time = group_gtfs.addGroup("time management")
        g_service = group_gtfs.addGroup("service info")
        for layer_name in layer_names:
            if layer_name != 'shapes_point':
                path_to_layer = GPKG_path + "|layername=" + layer_name
                layer = QgsVectorLayer(path_to_layer, layer_name, "ogr")
                QgsProject.instance().addMapLayer(layer, False)
                if layer_name in ['trips','transfers','stops','routes', 'lines']:
                    group_gtfs.insertChildNode(0,QgsLayerTreeLayer(layer))
                if layer_name in ['levels','pathways']:
                    g_trans.insertChildNode(0,QgsLayerTreeLayer(layer))
                if layer_name in ['stop_times','calendar','calendar_dates','frequencies']:
                    g_time.insertChildNode(0,QgsLayerTreeLayer(layer))
                if layer_name in ['agency','feed_info','route_sub_agencies', 'fare_rules','fare_attributes','attributions','translations']:
                    g_service.insertChildNode(0,QgsLayerTreeLayer(layer))

        # create index on on route_id,shape_id, shape_pt_sequence
        self.index(GPKG_path,['shape_id', 'shape_pt_sequence'],'shapes_point')
        self.index(GPKG_path,['route_id'],'routes')
